/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.httpclient;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BI\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\tH\u0002R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00030\u0003 \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/httpclient/BackOffHttpRequestRetryHandler;", "Lorg/apache/http/impl/client/DefaultHttpRequestRetryHandler;", "retryCount", "", "requestSentRetryEnabled", "", "nonRetriableClasses", "", "Ljava/lang/Class;", "Ljava/io/IOException;", "factor", "", "baseMs", "offsetMs", "(IZLjava/util/Set;DII)V", "executionCountThreadLocal", "Ljava/lang/ThreadLocal;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "getRetryInterval", "", "executionCount", "introduceDelay", "", "request", "Lorg/apache/http/HttpRequest;", "retryRequest", "exception", "context", "Lorg/apache/http/protocol/HttpContext;", "shouldNotRetry", "jira-migration-plugin"})
@Contract(threading=ThreadingBehavior.IMMUTABLE)
@SourceDebugExtension(value={"SMAP\nBackOffHttpRequestRetryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackOffHttpRequestRetryHandler.kt\ncom/atlassian/jira/migration/httpclient/BackOffHttpRequestRetryHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1747#2,3:87\n*S KotlinDebug\n*F\n+ 1 BackOffHttpRequestRetryHandler.kt\ncom/atlassian/jira/migration/httpclient/BackOffHttpRequestRetryHandler\n*L\n68#1:87,3\n*E\n"})
public class BackOffHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    private final int retryCount;
    private final boolean requestSentRetryEnabled;
    @NotNull
    private final Set<Class<? extends IOException>> nonRetriableClasses;
    private final double factor;
    private final int baseMs;
    private final int offsetMs;
    private final Logger log;
    private final ThreadLocal<Integer> executionCountThreadLocal;

    public BackOffHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled, @NotNull Set<? extends Class<? extends IOException>> nonRetriableClasses, double factor, int baseMs, int offsetMs) {
        Intrinsics.checkNotNullParameter(nonRetriableClasses, (String)"nonRetriableClasses");
        this.retryCount = retryCount;
        this.requestSentRetryEnabled = requestSentRetryEnabled;
        this.nonRetriableClasses = nonRetriableClasses;
        this.factor = factor;
        this.baseMs = baseMs;
        this.offsetMs = offsetMs;
        this.log = LoggerFactory.getLogger(BackOffHttpRequestRetryHandler.class);
        this.executionCountThreadLocal = ThreadLocal.withInitial(BackOffHttpRequestRetryHandler::executionCountThreadLocal$lambda$0);
    }

    public /* synthetic */ BackOffHttpRequestRetryHandler(int n, boolean bl, Set set, double d, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 3;
        }
        if ((n4 & 2) != 0) {
            bl = false;
        }
        if ((n4 & 4) != 0) {
            set = SetsKt.emptySet();
        }
        this(n, bl, set, d, n2, n3);
    }

    public boolean retryRequest(@NotNull IOException exception, int executionCount, @NotNull HttpContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Args.notNull((Object)exception, (String)"Exception parameter");
        Args.notNull((Object)context, (String)"HTTP context");
        if (this.shouldNotRetry(executionCount, exception)) {
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        if (this.handleAsIdempotent(request) || this.requestSentRetryEnabled || !clientContext.isRequestSent()) {
            Intrinsics.checkNotNull((Object)request);
            this.introduceDelay(request, executionCount);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void introduceDelay(HttpRequest request, int executionCount) {
        this.log.warn("Retrying " + request.getRequestLine() + ", " + executionCount + ", " + LocalDateTime.now());
        this.executionCountThreadLocal.set(executionCount);
        Thread.sleep(this.getRetryInterval(executionCount, this.baseMs, this.offsetMs, this.factor));
    }

    private final boolean shouldNotRetry(int executionCount, IOException exception) {
        if (executionCount > this.retryCount) {
            this.log.error("Will not retry. Exceeds maximum retry count of " + this.retryCount + " of " + exception.getClass().getCanonicalName());
        } else {
            if (!this.nonRetriableClasses.contains(exception.getClass())) {
                boolean bl;
                block8: {
                    Iterable $this$any$iv = this.nonRetriableClasses;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Class it = (Class)element$iv;
                            boolean bl2 = false;
                            if (!it.isInstance(exception)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    return false;
                }
            }
            this.log.error("Will not retry exception of type " + exception.getClass().getCanonicalName());
        }
        return true;
    }

    private final long getRetryInterval(int executionCount, int baseMs, int offsetMs, double factor) {
        long l;
        long lower = (long)((double)offsetMs + (double)baseMs * Math.pow(factor, executionCount));
        long upper = (long)((double)offsetMs + (double)baseMs * Math.pow(factor, executionCount + 1));
        long it = l = ThreadLocalRandom.current().nextLong(lower, upper);
        boolean bl = false;
        this.log.warn("Next retry in " + it);
        return l;
    }

    private static final Integer executionCountThreadLocal$lambda$0() {
        return 1;
    }
}

