/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.httpclient;

import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.exceptions.ExceptionsKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J)\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/httpclient/Fx3HttpClient;", "Lcom/atlassian/jira/migration/httpclient/AbstractPluginHttpClient;", "gson", "Lcom/google/gson/Gson;", "(Lcom/google/gson/Gson;)V", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "(Lorg/apache/http/impl/client/CloseableHttpClient;Lcom/google/gson/Gson;)V", "getBodyBytes", "", "body", "", "injectBody", "", "request", "Lorg/apache/http/HttpEntityEnclosingRequest;", "requestConfig", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "parseResponse", "T", "response", "", "returnType", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "jira-migration-plugin"})
public final class Fx3HttpClient
extends AbstractPluginHttpClient {
    @NotNull
    private final Gson gson;

    @VisibleForTesting
    public Fx3HttpClient(@NotNull CloseableHttpClient httpClient, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        super(httpClient);
        this.gson = gson;
    }

    public Fx3HttpClient(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this(AbstractPluginHttpClient.Companion.createHttpClient$default(AbstractPluginHttpClient.Companion, null, 1, null), gson);
    }

    @Override
    public <T> T parseResponse(@NotNull String response2, @NotNull TypeReference<T> returnType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        try {
            Object object2 = this.gson.fromJson(response2, returnType.getType());
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        }
        catch (JsonParseException e) {
            throw ExceptionsKt.protocolError("An error occurred attempting to deserialize to " + returnType.getType());
        }
        return (T)object;
    }

    @Override
    @NotNull
    public byte[] getBodyBytes(@Nullable Object body) {
        String string = this.gson.toJson(body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void injectBody(@NotNull HttpEntityEnclosingRequest request, @NotNull MigrationPluginHttpRequest requestConfig) {
        void $this$injectBody_u24lambda_u240;
        StringEntity stringEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        if (requestConfig.getBody() == null) {
            throw ExceptionsKt.protocolError("Body is not specified.");
        }
        if (requestConfig.getContentType() == null) {
            throw ExceptionsKt.protocolError("Content type is not specified.");
        }
        if (!Intrinsics.areEqual((Object)requestConfig.getContentType(), (Object)"application/json")) {
            throw ExceptionsKt.protocolError("Content type is not valid for fx3");
        }
        if (!(requestConfig.getBody() instanceof String)) {
            throw ExceptionsKt.protocolError("Failed to inject body for fx3");
        }
        StringEntity stringEntity2 = stringEntity = new StringEntity((String)requestConfig.getBody());
        HttpEntityEnclosingRequest httpEntityEnclosingRequest = request;
        boolean bl = false;
        $this$injectBody_u24lambda_u240.setChunked(false);
        $this$injectBody_u24lambda_u240.setContentType(requestConfig.getContentType());
        httpEntityEnclosingRequest.setEntity((HttpEntity)stringEntity);
    }
}

