/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.httpclient;

import com.atlassian.jira.migration.httpclient.ListenableInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.entity.FileEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/httpclient/ListenableFileEntity;", "Lorg/apache/http/entity/FileEntity;", "file", "Ljava/io/File;", "onProgressUpdate", "Lkotlin/Function0;", "", "updateProgressWhenBytesRead", "", "(Ljava/io/File;Lkotlin/jvm/functions/Function0;J)V", "getContent", "Ljava/io/InputStream;", "writeTo", "outstream", "Ljava/io/OutputStream;", "jira-migration-plugin"})
public final class ListenableFileEntity
extends FileEntity {
    @NotNull
    private final Function0<Unit> onProgressUpdate;
    private final long updateProgressWhenBytesRead;

    public ListenableFileEntity(@NotNull File file2, @NotNull Function0<Unit> onProgressUpdate2, long updateProgressWhenBytesRead) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        super(file2);
        this.onProgressUpdate = onProgressUpdate2;
        this.updateProgressWhenBytesRead = updateProgressWhenBytesRead;
    }

    public /* synthetic */ ListenableFileEntity(File file2, Function0 function0, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            l = 0x100000L;
        }
        this(file2, (Function0<Unit>)function0, l);
    }

    @NotNull
    public InputStream getContent() {
        InputStream inputStream = super.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getContent(...)");
        return (InputStream)((Object)new ListenableInputStream(inputStream, this.onProgressUpdate, this.updateProgressWhenBytesRead));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(@Nullable OutputStream outstream) {
        Closeable closeable = this.getContent();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            OutputStream outputStream = outstream;
            if (outputStream == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)outputStream, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

