/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.httpclient;

import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.httpclient.exceptions.ExceptionsKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0007\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J)\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;", "Lcom/atlassian/jira/migration/httpclient/AbstractPluginHttpClient;", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "(Lorg/apache/http/impl/client/CloseableHttpClient;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getBodyBytes", "", "body", "", "parseResponse", "T", "response", "", "returnType", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "jira-migration-plugin"})
public class MigrationPluginHttpClient
extends AbstractPluginHttpClient {
    @NotNull
    private final ObjectMapper objectMapper;

    @VisibleForTesting
    public MigrationPluginHttpClient(@NotNull CloseableHttpClient httpClient, @NotNull ObjectMapper objectMapper2) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        super(httpClient);
        this.objectMapper = objectMapper2;
    }

    public MigrationPluginHttpClient(@NotNull MigrationUserAgentProvider userAgentProvider, @NotNull ObjectMapper objectMapper2) {
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        CloseableHttpClient closeableHttpClient = AbstractPluginHttpClient.Companion.httpClientBuilder$default(AbstractPluginHttpClient.Companion, null, null, 3, null).setUserAgent(userAgentProvider.getUserAgent()).build();
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"build(...)");
        this(closeableHttpClient, objectMapper2);
    }

    @Override
    public <T> T parseResponse(@NotNull String response2, @NotNull TypeReference<T> returnType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        try {
            object = this.objectMapper.readValue(response2, returnType);
        }
        catch (IOException e) {
            throw ExceptionsKt.protocolError("An error occurred attempting to deserialize to " + returnType.getType(), e);
        }
        return (T)object;
    }

    @Override
    @NotNull
    public byte[] getBodyBytes(@Nullable Object body) {
        byte[] byArray = this.objectMapper.writeValueAsBytes(body);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writeValueAsBytes(...)");
        return byArray;
    }
}

