/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.httpclient;

import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClient;
import com.atlassian.jira.migration.httpclient.AppMigrationBackOffRequestSentEnabledRetryHandler;
import com.atlassian.jira.migration.httpclient.AppMigrationServiceUnavailableBackoffRetryStrategy;
import com.atlassian.jira.migration.httpclient.exceptions.ExceptionsKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J)\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClientGson;", "Lcom/atlassian/jira/migration/httpclient/AbstractPluginHttpClient;", "gson", "Lcom/google/gson/Gson;", "(Lcom/google/gson/Gson;)V", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "(Lorg/apache/http/impl/client/CloseableHttpClient;Lcom/google/gson/Gson;)V", "getBodyBytes", "", "body", "", "parseResponse", "T", "response", "", "returnType", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "jira-migration-plugin"})
public class MigrationPluginHttpClientGson
extends AbstractPluginHttpClient {
    @NotNull
    private final Gson gson;

    @VisibleForTesting
    public MigrationPluginHttpClientGson(@NotNull CloseableHttpClient httpClient, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        super(httpClient);
        this.gson = gson;
    }

    public MigrationPluginHttpClientGson(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this(AbstractPluginHttpClient.Companion.createHttpClient(AbstractPluginHttpClient.Companion.httpClientBuilder(AppMigrationBackOffRequestSentEnabledRetryHandler.INSTANCE, AppMigrationServiceUnavailableBackoffRetryStrategy.INSTANCE)), gson);
    }

    @Override
    public <T> T parseResponse(@NotNull String response2, @NotNull TypeReference<T> returnType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        try {
            Object object2 = this.gson.fromJson(response2, returnType.getType());
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        }
        catch (JsonIOException e) {
            throw ExceptionsKt.protocolError("An error occurred attempting to deserialize to " + returnType.getType(), e);
        }
        return (T)object;
    }

    @Override
    @NotNull
    public byte[] getBodyBytes(@Nullable Object body) {
        byte[] byArray;
        String string = this.gson.toJson(body);
        if (string != null) {
            String string2 = string;
            byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        } else {
            byArray = null;
        }
        Intrinsics.checkNotNull(byArray);
        return byArray;
    }
}

