/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.httpclient;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b-\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0001\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010%\u001a\u00020\u0000J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0003J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0003J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0005H\u00c6\u0003J\u000f\u00102\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u000f\u00104\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0006\u00106\u001a\u00020\u0000J\u0006\u00107\u001a\u00020\u0000JU\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010<\u001a\u00020\bH\u00d6\u0001J\u0010\u0010=\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003H\u0002J\t\u0010>\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006?"}, d2={"Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "", "method", "", "uri", "Ljava/net/URI;", "expectedStatusCodes", "", "", "body", "headers", "", "Lorg/apache/http/Header;", "contentType", "(Ljava/lang/String;Ljava/net/URI;Ljava/util/Set;Ljava/lang/Object;Ljava/util/List;Ljava/lang/String;)V", "getBody", "()Ljava/lang/Object;", "getContentType", "()Ljava/lang/String;", "setContentType", "(Ljava/lang/String;)V", "getExpectedStatusCodes", "()Ljava/util/Set;", "getHeaders", "()Ljava/util/List;", "getMethod", "getUri", "()Ljava/net/URI;", "acceptsJson", "addCloudRegion", "cloudRegion", "addCloudRegionForShadow", "addHeader", "name", "value", "addMigrationScopeId", "migrationScopeId", "addMigrationType", "addOriginalMigrationId", "migrationId", "addOriginalMigrationScopeId", "addShadowMigrationId", "shadowMigrationId", "addShadowMigrationScopeId", "shadowMigrationScopeId", "addUserAgent", "userAgentValue", "authorization", "component1", "component2", "component3", "component4", "component5", "component6", "contentTypeJson", "contentTypeOctetStream", "copy", "equals", "", "other", "hashCode", "sanitizeUserAgentHeader", "toString", "jira-migration-plugin"})
public final class MigrationPluginHttpRequest {
    @NotNull
    private final String method;
    @NotNull
    private final URI uri;
    @NotNull
    private final Set<Integer> expectedStatusCodes;
    @Nullable
    private final Object body;
    @NotNull
    private final List<Header> headers;
    @Nullable
    private String contentType;

    public MigrationPluginHttpRequest(@NotNull String method, @NotNull URI uri, @NotNull Set<Integer> expectedStatusCodes, @Nullable Object body, @NotNull List<Header> headers, @Nullable String contentType) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(expectedStatusCodes, (String)"expectedStatusCodes");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.method = method;
        this.uri = uri;
        this.expectedStatusCodes = expectedStatusCodes;
        this.body = body;
        this.headers = headers;
        this.contentType = contentType;
    }

    public /* synthetic */ MigrationPluginHttpRequest(String string, URI uRI, Set set, Object object, List list, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            set = SetsKt.setOf((Object)200);
        }
        if ((n & 8) != 0) {
            object = null;
        }
        if ((n & 0x10) != 0) {
            list = new ArrayList();
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        this(string, uRI, set, object, list, string2);
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final URI getUri() {
        return this.uri;
    }

    @NotNull
    public final Set<Integer> getExpectedStatusCodes() {
        return this.expectedStatusCodes;
    }

    @Nullable
    public final Object getBody() {
        return this.body;
    }

    @NotNull
    public final List<Header> getHeaders() {
        return this.headers;
    }

    @Nullable
    public final String getContentType() {
        return this.contentType;
    }

    public final void setContentType(@Nullable String string) {
        this.contentType = string;
    }

    @NotNull
    public final MigrationPluginHttpRequest addHeader(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.headers.add((Header)new BasicHeader(name, value));
        return this;
    }

    @NotNull
    public final MigrationPluginHttpRequest addUserAgent(@NotNull String userAgentValue) {
        Intrinsics.checkNotNullParameter((Object)userAgentValue, (String)"userAgentValue");
        return this.addHeader("User-Agent", this.sanitizeUserAgentHeader(userAgentValue));
    }

    private final String sanitizeUserAgentHeader(String userAgentValue) {
        return StringsKt.replace$default((String)userAgentValue, (String)"\n", (String)" ", (boolean)false, (int)4, null);
    }

    @NotNull
    public final MigrationPluginHttpRequest acceptsJson() {
        return this.addHeader("Accept", "application/json");
    }

    @NotNull
    public final MigrationPluginHttpRequest contentTypeJson() {
        this.contentType = "application/json";
        return this;
    }

    @NotNull
    public final MigrationPluginHttpRequest authorization(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.addHeader("Authorization", value);
    }

    @NotNull
    public final MigrationPluginHttpRequest contentTypeOctetStream() {
        this.contentType = "application/octet-stream";
        return this;
    }

    @NotNull
    public final MigrationPluginHttpRequest addCloudRegion(@NotNull String cloudRegion) {
        Intrinsics.checkNotNullParameter((Object)cloudRegion, (String)"cloudRegion");
        return this.addHeader("Cloud-Region", cloudRegion);
    }

    @NotNull
    public final MigrationPluginHttpRequest addCloudRegionForShadow(@NotNull String cloudRegion) {
        Intrinsics.checkNotNullParameter((Object)cloudRegion, (String)"cloudRegion");
        return this.addHeader("CloudRegion", cloudRegion);
    }

    @NotNull
    public final MigrationPluginHttpRequest addMigrationScopeId(@NotNull String migrationScopeId2) {
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        return this.addHeader("MigrationScopeId", migrationScopeId2);
    }

    @NotNull
    public final MigrationPluginHttpRequest addOriginalMigrationId(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        return this.addHeader("OriginalMigrationId", migrationId);
    }

    @NotNull
    public final MigrationPluginHttpRequest addShadowMigrationScopeId(@NotNull String shadowMigrationScopeId) {
        Intrinsics.checkNotNullParameter((Object)shadowMigrationScopeId, (String)"shadowMigrationScopeId");
        return this.addHeader("ShadowMigrationScopeId", shadowMigrationScopeId);
    }

    @NotNull
    public final MigrationPluginHttpRequest addShadowMigrationId(@NotNull String shadowMigrationId) {
        Intrinsics.checkNotNullParameter((Object)shadowMigrationId, (String)"shadowMigrationId");
        return this.addHeader("ShadowMigrationId", shadowMigrationId);
    }

    @NotNull
    public final MigrationPluginHttpRequest addOriginalMigrationScopeId(@NotNull String migrationScopeId2) {
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        return this.addHeader("OriginalMigrationScopeId", migrationScopeId2);
    }

    @NotNull
    public final MigrationPluginHttpRequest addMigrationType() {
        return this.addHeader("MigrationType", "S2C_MIGRATION");
    }

    @NotNull
    public final String component1() {
        return this.method;
    }

    @NotNull
    public final URI component2() {
        return this.uri;
    }

    @NotNull
    public final Set<Integer> component3() {
        return this.expectedStatusCodes;
    }

    @Nullable
    public final Object component4() {
        return this.body;
    }

    @NotNull
    public final List<Header> component5() {
        return this.headers;
    }

    @Nullable
    public final String component6() {
        return this.contentType;
    }

    @NotNull
    public final MigrationPluginHttpRequest copy(@NotNull String method, @NotNull URI uri, @NotNull Set<Integer> expectedStatusCodes, @Nullable Object body, @NotNull List<Header> headers, @Nullable String contentType) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(expectedStatusCodes, (String)"expectedStatusCodes");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return new MigrationPluginHttpRequest(method, uri, expectedStatusCodes, body, headers, contentType);
    }

    public static /* synthetic */ MigrationPluginHttpRequest copy$default(MigrationPluginHttpRequest migrationPluginHttpRequest, String string, URI uRI, Set set, Object object, List list, String string2, int n, Object object2) {
        if ((n & 1) != 0) {
            string = migrationPluginHttpRequest.method;
        }
        if ((n & 2) != 0) {
            uRI = migrationPluginHttpRequest.uri;
        }
        if ((n & 4) != 0) {
            set = migrationPluginHttpRequest.expectedStatusCodes;
        }
        if ((n & 8) != 0) {
            object = migrationPluginHttpRequest.body;
        }
        if ((n & 0x10) != 0) {
            list = migrationPluginHttpRequest.headers;
        }
        if ((n & 0x20) != 0) {
            string2 = migrationPluginHttpRequest.contentType;
        }
        return migrationPluginHttpRequest.copy(string, uRI, set, object, list, string2);
    }

    @NotNull
    public String toString() {
        return "MigrationPluginHttpRequest(method=" + this.method + ", uri=" + this.uri + ", expectedStatusCodes=" + this.expectedStatusCodes + ", body=" + this.body + ", headers=" + this.headers + ", contentType=" + this.contentType + ')';
    }

    public int hashCode() {
        int result2 = this.method.hashCode();
        result2 = result2 * 31 + this.uri.hashCode();
        result2 = result2 * 31 + ((Object)this.expectedStatusCodes).hashCode();
        result2 = result2 * 31 + (this.body == null ? 0 : this.body.hashCode());
        result2 = result2 * 31 + ((Object)this.headers).hashCode();
        result2 = result2 * 31 + (this.contentType == null ? 0 : this.contentType.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MigrationPluginHttpRequest)) {
            return false;
        }
        MigrationPluginHttpRequest migrationPluginHttpRequest = (MigrationPluginHttpRequest)other;
        if (!Intrinsics.areEqual((Object)this.method, (Object)migrationPluginHttpRequest.method)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.uri, (Object)migrationPluginHttpRequest.uri)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.expectedStatusCodes, migrationPluginHttpRequest.expectedStatusCodes)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)migrationPluginHttpRequest.body)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, migrationPluginHttpRequest.headers)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.contentType, (Object)migrationPluginHttpRequest.contentType);
    }
}

