/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.httpclient;

import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClient;
import com.atlassian.jira.migration.httpclient.BackOffRequestSentEnabledRetryHandler;
import com.atlassian.jira.migration.httpclient.DefaultServiceUnavailableBackoffRetryStrategy;
import com.atlassian.jira.migration.httpclient.TooManyRequestsConnectionBackoffStrategy;
import com.atlassian.jira.migration.httpclient.exceptions.ExceptionsKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J)\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/httpclient/S3UploadHttpClient;", "Lcom/atlassian/jira/migration/httpclient/AbstractPluginHttpClient;", "gson", "Lcom/google/gson/Gson;", "(Lcom/google/gson/Gson;)V", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "(Lorg/apache/http/impl/client/CloseableHttpClient;Lcom/google/gson/Gson;)V", "getBodyBytes", "", "body", "", "parseResponse", "T", "response", "", "returnType", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "Companion", "jira-migration-plugin"})
public class S3UploadHttpClient
extends AbstractPluginHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Gson gson;
    private static final int ONE_MINUTE_AND_HALF_MS = (int)Duration.ofSeconds(90L).toMillis();

    public S3UploadHttpClient(@NotNull CloseableHttpClient httpClient, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        super(httpClient);
        this.gson = gson;
    }

    public S3UploadHttpClient(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        CloseableHttpClient closeableHttpClient = AbstractPluginHttpClient.Companion.httpClientBuilder$default(AbstractPluginHttpClient.Companion, null, null, 3, null).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(ONE_MINUTE_AND_HALF_MS).setSocketTimeout(ONE_MINUTE_AND_HALF_MS).build()).setRetryHandler((HttpRequestRetryHandler)BackOffRequestSentEnabledRetryHandler.INSTANCE).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)DefaultServiceUnavailableBackoffRetryStrategy.INSTANCE).setConnectionBackoffStrategy((ConnectionBackoffStrategy)TooManyRequestsConnectionBackoffStrategy.INSTANCE).build();
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"build(...)");
        this(closeableHttpClient, gson);
    }

    public /* synthetic */ S3UploadHttpClient(Gson gson, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Gson gson2 = new GsonBuilder().create();
            Intrinsics.checkNotNullExpressionValue((Object)gson2, (String)"create(...)");
            gson = gson2;
        }
        this(gson);
    }

    @Override
    public <T> T parseResponse(@NotNull String response2, @NotNull TypeReference<T> returnType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        try {
            Object object2 = this.gson.fromJson(response2, returnType.getType());
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        }
        catch (JsonIOException e) {
            throw ExceptionsKt.protocolError("An error occurred attempting to deserialize to " + returnType.getType(), e);
        }
        return (T)object;
    }

    @Override
    @NotNull
    public byte[] getBodyBytes(@Nullable Object body) {
        byte[] byArray;
        String string = this.gson.toJson(body);
        if (string != null) {
            String string2 = string;
            byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        } else {
            byArray = null;
        }
        Intrinsics.checkNotNull(byArray);
        return byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/httpclient/S3UploadHttpClient$Companion;", "", "()V", "ONE_MINUTE_AND_HALF_MS", "", "getONE_MINUTE_AND_HALF_MS", "()I", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final int getONE_MINUTE_AND_HALF_MS() {
            return ONE_MINUTE_AND_HALF_MS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

