/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.httpclient;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.S3UploadHttpClient;
import com.atlassian.jira.migration.httpclient.S3UploadHttpClientWithInterceptor;
import com.google.common.annotations.VisibleForTesting;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u0006H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/httpclient/S3UploadHttpClientWrapper;", "", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "s3UploadHttpClient", "Lcom/atlassian/jira/migration/httpclient/S3UploadHttpClient;", "s3UploadHttpClientWithInterceptor", "Lcom/atlassian/jira/migration/httpclient/S3UploadHttpClientWithInterceptor;", "getResponse", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "requestConfig", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "getS3UploadHttpClient", "jira-migration-plugin"})
public final class S3UploadHttpClientWrapper {
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final S3UploadHttpClient s3UploadHttpClient;
    @NotNull
    private final S3UploadHttpClientWithInterceptor s3UploadHttpClientWithInterceptor;

    public S3UploadHttpClientWrapper(@NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationFeatures = migrationFeatures;
        this.s3UploadHttpClient = new S3UploadHttpClient(null, 1, null);
        this.s3UploadHttpClientWithInterceptor = new S3UploadHttpClientWithInterceptor(null, 1, null);
    }

    @NotNull
    public final CloseableHttpResponse getResponse(@NotNull MigrationPluginHttpRequest requestConfig) {
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        return this.getS3UploadHttpClient().getResponse(requestConfig);
    }

    @VisibleForTesting
    @NotNull
    public final S3UploadHttpClient getS3UploadHttpClient() {
        return this.migrationFeatures.getEnableS3UploadHttpInterceptor() ? (S3UploadHttpClient)this.s3UploadHttpClientWithInterceptor : this.s3UploadHttpClient;
    }
}

