/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.httpclient;

import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR2\u0010\u000b\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u0003 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \r*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0005\u001f !\"#\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/httpclient/ServiceUnavailableBackoffRetryStrategy;", "Lorg/apache/http/client/ServiceUnavailableRetryStrategy;", "maxRetries", "", "factor", "", "baseMs", "offsetMs", "(IDII)V", "getBaseMs", "()I", "executionCountThreadLocal", "Ljava/lang/ThreadLocal;", "kotlin.jvm.PlatformType", "getFactor", "()D", "log", "Lorg/slf4j/Logger;", "getMaxRetries", "getOffsetMs", "retryableCodes", "", "getRetryInterval", "", "retryRequest", "", "response", "Lorg/apache/http/HttpResponse;", "executionCount", "context", "Lorg/apache/http/protocol/HttpContext;", "Lcom/atlassian/jira/migration/httpclient/AppMigrationServiceUnavailableBackoffRetryStrategy;", "Lcom/atlassian/jira/migration/httpclient/DefaultServiceUnavailableBackoffRetryStrategy;", "Lcom/atlassian/jira/migration/httpclient/MediaServiceUnavailableBackoffRetryStrategy;", "Lcom/atlassian/jira/migration/httpclient/MrcServiceUnavailableBackoffRetryStrategy;", "Lcom/atlassian/jira/migration/httpclient/ServiceUnavailableQuickBackoffRetryStrategy;", "jira-migration-plugin"})
public abstract class ServiceUnavailableBackoffRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final double factor;
    private final int baseMs;
    private final int offsetMs;
    private final Logger log;
    @NotNull
    private final Set<Integer> retryableCodes;
    private final ThreadLocal<Integer> executionCountThreadLocal;

    private ServiceUnavailableBackoffRetryStrategy(int maxRetries, double factor, int baseMs, int offsetMs) {
        this.maxRetries = maxRetries;
        this.factor = factor;
        this.baseMs = baseMs;
        this.offsetMs = offsetMs;
        this.log = LoggerFactory.getLogger(ServiceUnavailableBackoffRetryStrategy.class);
        Object[] objectArray = new Integer[]{429, 503, 504, 500, 502};
        this.retryableCodes = SetsKt.setOf((Object[])objectArray);
        this.executionCountThreadLocal = ThreadLocal.withInitial(ServiceUnavailableBackoffRetryStrategy::executionCountThreadLocal$lambda$0);
    }

    public final int getMaxRetries() {
        return this.maxRetries;
    }

    public final double getFactor() {
        return this.factor;
    }

    public final int getBaseMs() {
        return this.baseMs;
    }

    public final int getOffsetMs() {
        return this.offsetMs;
    }

    public boolean retryRequest(@NotNull HttpResponse response2, int executionCount, @NotNull HttpContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int statusCode = response2.getStatusLine().getStatusCode();
        if (this.retryableCodes.contains(statusCode)) {
            Header header = response2.getFirstHeader("X-Failure-Category");
            String failureCategory = header != null ? header.getValue() : null;
            Object object = context.getAttribute("http.request");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.apache.http.HttpRequest");
            HttpRequest httpRequest = (HttpRequest)object;
            String string = httpRequest.getFirstHeader("Host").getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            String host = string;
            String string2 = httpRequest.getRequestLine().getUri();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUri(...)");
            String uri = string2;
            this.log.error("Request Host=" + host + " Path=" + uri + " failed with executionCount=" + executionCount + ", maxRetries=" + this.maxRetries + ", statusCode=" + statusCode + ", xFailureCategory=" + failureCategory);
            this.executionCountThreadLocal.set(executionCount);
            bl = executionCount <= this.maxRetries;
        } else {
            bl = false;
        }
        return bl;
    }

    public long getRetryInterval() {
        long l;
        Integer executionCount = this.executionCountThreadLocal.get();
        double d = this.offsetMs;
        double d2 = this.baseMs;
        Intrinsics.checkNotNull((Object)executionCount);
        long lower = (long)(d + d2 * Math.pow(this.factor, executionCount.intValue()));
        long upper = (long)((double)this.offsetMs + (double)this.baseMs * Math.pow(this.factor, executionCount + 1));
        long it = l = ThreadLocalRandom.current().nextLong(lower, upper);
        boolean bl = false;
        this.log.error("Next retry in " + it);
        return l;
    }

    private static final Integer executionCountThreadLocal$lambda$0() {
        return 1;
    }

    public /* synthetic */ ServiceUnavailableBackoffRetryStrategy(int maxRetries, double factor, int baseMs, int offsetMs, DefaultConstructorMarker $constructor_marker) {
        this(maxRetries, factor, baseMs, offsetMs);
    }
}

