/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.idMappings;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.crypto.EncryptionService;
import com.atlassian.jira.migration.scope.MigrationScope;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/idMappings/IdMappingsHelper;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "encryptionService", "Lcom/atlassian/jira/migration/crypto/EncryptionService;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;Lcom/atlassian/jira/migration/crypto/EncryptionService;)V", "getCloudIdByMigrationScopeId", "", "migrationScopeId", "getContainerTokenByCloudId", "cloudId", "getContainerTokenByMigrationScopeId", "getMigrationScopeIdByCloudSiteUrl", "cloudSiteUrl", "jira-migration-plugin"})
public final class IdMappingsHelper {
    @NotNull
    private final ActiveObjects ao;
    @NotNull
    private final EncryptionService encryptionService;

    @Inject
    public IdMappingsHelper(@NotNull ActiveObjects ao, @NotNull EncryptionService encryptionService) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        Intrinsics.checkNotNullParameter((Object)encryptionService, (String)"encryptionService");
        this.ao = ao;
        this.encryptionService = encryptionService;
    }

    @Nullable
    public final String getMigrationScopeIdByCloudSiteUrl(@Nullable String cloudSiteUrl) {
        Object[] objectArray = new Object[]{cloudSiteUrl};
        RawEntity[] rawEntityArray = this.ao.find(CloudSite.class, Query.select().where("CLOUD_URL = ?", objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        CloudSite cloudSite2 = (CloudSite)ArraysKt.firstOrNull((Object[])rawEntityArray);
        String cloudId2 = cloudSite2 != null ? cloudSite2.getCloudId() : null;
        objectArray = new Object[]{cloudId2};
        RawEntity[] rawEntityArray2 = this.ao.find(MigrationScope.class, Query.select().where("CLOUD_ID = ?", objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray2, (String)"find(...)");
        MigrationScope migrationScope = (MigrationScope)ArraysKt.firstOrNull((Object[])rawEntityArray2);
        return migrationScope != null ? migrationScope.getScopeId() : null;
    }

    @Nullable
    public final String getContainerTokenByMigrationScopeId(@Nullable String migrationScopeId2) {
        String cloudId2 = this.getCloudIdByMigrationScopeId(migrationScopeId2);
        String string = this.getContainerTokenByCloudId(cloudId2);
        if (string == null) {
            return null;
        }
        String containerToken = string;
        return this.encryptionService.decrypt(containerToken);
    }

    @Nullable
    public final String getCloudIdByMigrationScopeId(@Nullable String migrationScopeId2) {
        Object[] objectArray = new Object[]{migrationScopeId2};
        RawEntity[] rawEntityArray = this.ao.find(MigrationScope.class, Query.select().where("SCOPE_ID = ?", objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        MigrationScope migrationScope = (MigrationScope)ArraysKt.firstOrNull((Object[])rawEntityArray);
        return migrationScope != null ? migrationScope.getCloudId() : null;
    }

    @Nullable
    public final String getContainerTokenByCloudId(@Nullable String cloudId2) {
        Object[] objectArray = new Object[]{cloudId2};
        RawEntity[] rawEntityArray = this.ao.find(CloudSite.class, Query.select().where("CLOUD_ID = ?", objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        CloudSite cloudSite2 = (CloudSite)ArraysKt.firstOrNull((Object[])rawEntityArray);
        return cloudSite2 != null ? cloudSite2.getContainerToken() : null;
    }
}

