/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.infrastructure.rest;

import com.google.common.annotations.VisibleForTesting;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0019\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004J\u0012\u0010\r\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0006J\u0019\u0010\u0012\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\tJ&\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0004J\u0019\u0010\u0017\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\u0018\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/infrastructure/rest/ResponseUtils;", "", "()V", "HEADER_CONTENT_DISPOSITION", "", "accepted", "Ljavax/ws/rs/core/Response;", "T", "entity", "(Ljava/lang/Object;)Ljavax/ws/rs/core/Response;", "badRequest", "message", "conflict", "created", "forbidden", "internalServerError", "noContent", "notFound", "ok", "file", "Ljava/nio/file/Path;", "filename", "contentType", "okOrNotFound", "maybe", "FileStreamingOutput", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nResponseUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseUtils.kt\ncom/atlassian/jira/migration/infrastructure/rest/ResponseUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class ResponseUtils {
    @NotNull
    public static final ResponseUtils INSTANCE = new ResponseUtils();
    @NotNull
    private static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";

    private ResponseUtils() {
    }

    @NotNull
    public final <T> Response okOrNotFound(T maybe) {
        Object object;
        block3: {
            block2: {
                object = maybe;
                if (object == null) break block2;
                T it = object;
                boolean bl = false;
                Response response2 = INSTANCE.ok(it);
                object = response2;
                if (response2 != null) break block3;
            }
            object = this.notFound();
        }
        return object;
    }

    @NotNull
    public final <T> Response ok(T entity) {
        Response response2 = Response.ok(entity).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @NotNull
    public final Response ok(@NotNull Path file2, @Nullable String filename, @Nullable String contentType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string2 = filename;
        Comparable resolvedFileName = string2 != null ? (Comparable)((Object)string2) : (Comparable)file2.getFileName();
        String string3 = contentType;
        if (string3 == null) {
            string3 = Files.probeContentType(file2);
        }
        String resolvedContentType = (string = string3) == null ? "application/octet-stream" : string;
        Response response2 = Response.ok((Object)new FileStreamingOutput(file2), (String)resolvedContentType).header(HEADER_CONTENT_DISPOSITION, (Object)("attachment; filename=\"" + resolvedFileName + '\"')).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    public static /* synthetic */ Response ok$default(ResponseUtils responseUtils, Path path, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return responseUtils.ok(path, string, string2);
    }

    @NotNull
    public final Response noContent() {
        Response response2 = Response.status((int)204).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @NotNull
    public final Response forbidden() {
        Response response2 = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @NotNull
    public final Response notFound() {
        Response response2 = Response.status((int)404).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @NotNull
    public final <T> Response accepted(T entity) {
        Response response2 = Response.status((Response.Status)Response.Status.ACCEPTED).entity(entity).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @NotNull
    public final Response accepted() {
        Response response2 = Response.status((Response.Status)Response.Status.ACCEPTED).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @NotNull
    public final Response created(@Nullable String message) {
        Response response2 = Response.status((Response.Status)Response.Status.CREATED).entity((Object)message).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    public static /* synthetic */ Response created$default(ResponseUtils responseUtils, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return responseUtils.created(string);
    }

    @NotNull
    public final Response internalServerError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Response response2 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    public static /* synthetic */ Response internalServerError$default(ResponseUtils responseUtils, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return responseUtils.internalServerError(string);
    }

    @NotNull
    public final Response badRequest(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Response response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @NotNull
    public final Response conflict(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Response response2 = Response.status((int)409).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @VisibleForTesting
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/infrastructure/rest/ResponseUtils$FileStreamingOutput;", "Ljavax/ws/rs/core/StreamingOutput;", "file", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getFile", "()Ljava/nio/file/Path;", "write", "", "output", "Ljava/io/OutputStream;", "jira-migration-plugin"})
    public static final class FileStreamingOutput
    implements StreamingOutput {
        @NotNull
        private final Path file;

        public FileStreamingOutput(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.file = file2;
        }

        @NotNull
        public final Path getFile() {
            return this.file;
        }

        public void write(@NotNull OutputStream output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Files.copy(this.file, output);
        }
    }
}

