/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.jdmccservice;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.jdmccservice.DeregisterDataMovementRequest;
import com.atlassian.jira.migration.jdmccservice.DeregisterDataMovementResponse;
import com.atlassian.jira.migration.jdmccservice.GetProjectConcurrencyResponse;
import com.atlassian.jira.migration.jdmccservice.GetSpecProviderRequest;
import com.atlassian.jira.migration.jdmccservice.RegisterDataMovementRequest;
import com.atlassian.jira.migration.jdmccservice.RegisterDataMovementResponse;
import com.atlassian.jira.migration.jdmccservice.ResourceOptimisationResponse;
import com.atlassian.jira.migration.jdmccservice.V3RegisterDataMovementResponse;
import com.atlassian.jira.migration.jiracloudservice.JiraCloudClient;
import com.atlassian.migration.api.ContainerToken;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000fJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010!\u001a\u00020\"*\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/jdmccservice/JdmccClient;", "", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "httpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;", "(Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;)V", "deregisterDataMovement", "", "dataMovementId", "", "deregisterDataMovementRequest", "Lcom/atlassian/jira/migration/jdmccservice/DeregisterDataMovementRequest;", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "getProjectConcurrencyResponse", "", "cloudId", "getRdsScalingStatus", "Lcom/atlassian/jira/migration/jdmccservice/ResourceOptimisationResponse;", "getV3ProjectConcurrencyViaRegister", "Lcom/atlassian/jira/migration/jdmccservice/V3RegisterDataMovementResponse;", "registerDataMovementRequest", "Lcom/atlassian/jira/migration/jdmccservice/RegisterDataMovementRequest;", "prepareSpecProviderRequest", "Lcom/atlassian/jira/migration/jdmccservice/GetSpecProviderRequest;", "registerDataMovement", "Lcom/atlassian/jira/migration/jdmccservice/RegisterDataMovementResponse;", "withDefaultHeaders", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "Companion", "jira-migration-plugin"})
public final class JdmccClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationPluginHttpClient httpClient;
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    private static final Logger log = LoggerFactory.getLogger(JiraCloudClient.class);
    @NotNull
    private static final String IMPORT = "IMPORT";
    @NotNull
    private static final String JCMA = "JCMA";
    @NotNull
    private static final String DataMovementConfig = "dataMovementConfig";
    @NotNull
    private static final String ProjectConcurrency = "projectConcurrency";
    @NotNull
    private static final String REGISTER_DATA_MOVEMENT = "/v1/data-movement/register";
    @NotNull
    private static final String DEREGISTER_DATA_MOVEMENT = "/v1/data-movement/{dataMovementId}/status";
    @NotNull
    private static final String SCALING_STATUS = "/v1/data-movement/{dataMovementId}/resource-optimisation/status";

    public JdmccClient(@NotNull MigrationPluginHttpClient httpClient, @NotNull MigrationServicesConfiguration migrationServicesConfiguration) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        this.httpClient = httpClient;
        this.migrationServicesConfiguration = migrationServicesConfiguration;
    }

    @Inject
    public JdmccClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationUserAgentProvider userAgentProvider, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this(new MigrationPluginHttpClient(userAgentProvider, objectMapperFactory.createObjectMapper()), migrationServicesConfiguration);
    }

    public final int getProjectConcurrencyResponse(@NotNull ContainerToken containerToken, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        GetSpecProviderRequest getSpecProviderRequest = this.prepareSpecProviderRequest(cloudId2);
        try {
            int n;
            Set set = SetsKt.setOf((Object)200);
            URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.migrationServicesConfiguration.getEnterpriseGatekeeperJDMCCBaseURI(), "v1/data-movement/spec-provider", new String[0], null, 8, null);
            GetProjectConcurrencyResponse specProviderResponse = this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", uRI, set, getSpecProviderRequest, null, null, 48, null), containerToken), GetProjectConcurrencyResponse.class);
            Integer n2 = specProviderResponse.getStatusCode();
            if (n2 != null && 200 == n2) {
                Map<String, Object> map = specProviderResponse.getResponseData();
                Object object = map != null ? map.get(DataMovementConfig) : null;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                Map migrationConfig = (Map)object;
                Object v = migrationConfig.get(ProjectConcurrency);
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Int");
                n = (Integer)v;
            } else {
                log.warn("Fall back to default as response is non-200");
                n = 8;
            }
            return n;
        }
        catch (Exception e) {
            log.warn("Unable to get successful response for project concurrency " + e);
            return 8;
        }
    }

    @NotNull
    public final V3RegisterDataMovementResponse getV3ProjectConcurrencyViaRegister(@NotNull RegisterDataMovementRequest registerDataMovementRequest, @NotNull ContainerToken containerToken) {
        Intrinsics.checkNotNullParameter((Object)registerDataMovementRequest, (String)"registerDataMovementRequest");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        try {
            Set set = SetsKt.setOf((Object)200);
            URI uRI = AbstractPluginHttpClientKt.buildURI(this.migrationServicesConfiguration.getEnterpriseGatekeeperJDMCCBaseURI(), REGISTER_DATA_MOVEMENT, new String[0], CollectionsKt.listOfNotNull((Object)TuplesKt.to((Object)"includeConfig", (Object)"true")));
            return this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", uRI, set, registerDataMovementRequest, null, null, 48, null), containerToken), V3RegisterDataMovementResponse.class);
        }
        catch (Exception e) {
            log.warn("Unable to get successful response for project concurrency " + e);
            throw e;
        }
    }

    @NotNull
    public final RegisterDataMovementResponse registerDataMovement(@NotNull RegisterDataMovementRequest registerDataMovementRequest, @NotNull ContainerToken containerToken) {
        Intrinsics.checkNotNullParameter((Object)registerDataMovementRequest, (String)"registerDataMovementRequest");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        try {
            Set set = SetsKt.setOf((Object)200);
            URI uRI = AbstractPluginHttpClientKt.buildURI(this.migrationServicesConfiguration.getEnterpriseGatekeeperJDMCCBaseURI(), REGISTER_DATA_MOVEMENT, new String[0], CollectionsKt.listOfNotNull((Object)TuplesKt.to((Object)"includeConfig", (Object)"true")));
            return this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", uRI, set, registerDataMovementRequest, null, null, 48, null), containerToken), RegisterDataMovementResponse.class);
        }
        catch (Exception e) {
            log.warn("Unable to register data movement " + e);
            throw e;
        }
    }

    public final void deregisterDataMovement(@NotNull String dataMovementId, @NotNull DeregisterDataMovementRequest deregisterDataMovementRequest, @NotNull ContainerToken containerToken) {
        Intrinsics.checkNotNullParameter((Object)dataMovementId, (String)"dataMovementId");
        Intrinsics.checkNotNullParameter((Object)deregisterDataMovementRequest, (String)"deregisterDataMovementRequest");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        try {
            Set set = SetsKt.setOf((Object)200);
            String[] stringArray = new String[]{dataMovementId};
            URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.migrationServicesConfiguration.getEnterpriseGatekeeperJDMCCBaseURI(), DEREGISTER_DATA_MOVEMENT, stringArray, null, 8, null);
            this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", uRI, set, deregisterDataMovementRequest, null, null, 48, null), containerToken), DeregisterDataMovementResponse.class);
        }
        catch (Exception e) {
            log.warn("Unable to de-register migration for dataMovementId: " + dataMovementId + ' ' + e);
        }
    }

    @NotNull
    public final ResourceOptimisationResponse getRdsScalingStatus(@NotNull String dataMovementId, @NotNull ContainerToken containerToken) {
        Intrinsics.checkNotNullParameter((Object)dataMovementId, (String)"dataMovementId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        try {
            Set set = SetsKt.setOf((Object)200);
            String[] stringArray = new String[]{dataMovementId};
            URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.migrationServicesConfiguration.getEnterpriseGatekeeperJDMCCBaseURI(), SCALING_STATUS, stringArray, null, 8, null);
            return this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("GET", uRI, set, null, null, null, 56, null), containerToken), ResourceOptimisationResponse.class);
        }
        catch (Exception e) {
            log.warn("Unable to get RDS scaling status for dataMovementId: " + dataMovementId + ' ' + e);
            return new ResourceOptimisationResponse(500, "Unable to get RDS scaling status for dataMovementId: " + dataMovementId, "INTERNAL_SERVER_ERROR", null);
        }
    }

    private final GetSpecProviderRequest prepareSpecProviderRequest(String cloudId2) {
        return new GetSpecProviderRequest(IMPORT, JCMA, cloudId2);
    }

    private final MigrationPluginHttpRequest withDefaultHeaders(MigrationPluginHttpRequest $this$withDefaultHeaders, ContainerToken containerToken) {
        MigrationPluginHttpRequest migrationPluginHttpRequest;
        MigrationPluginHttpRequest $this$withDefaultHeaders_u24lambda_u240 = migrationPluginHttpRequest = $this$withDefaultHeaders;
        boolean bl = false;
        $this$withDefaultHeaders_u24lambda_u240.authorization("Bearer " + (String)((Object)containerToken.getValue()));
        $this$withDefaultHeaders_u24lambda_u240.contentTypeJson();
        $this$withDefaultHeaders_u24lambda_u240.acceptsJson();
        return migrationPluginHttpRequest;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/jdmccservice/JdmccClient$Companion;", "", "()V", "DEREGISTER_DATA_MOVEMENT", "", "DataMovementConfig", "IMPORT", "JCMA", "ProjectConcurrency", "REGISTER_DATA_MOVEMENT", "SCALING_STATUS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

