/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.jdmccservice;

import com.atlassian.jira.migration.analytics.RdsScalingEventHandler;
import com.atlassian.jira.migration.events.RdsScalingEvent;
import com.atlassian.jira.migration.execution.model.V3Config;
import com.atlassian.jira.migration.export.db.core.JiraIssueReader;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jdmccservice.DataMovementConfig;
import com.atlassian.jira.migration.jdmccservice.DataMovementMetaData;
import com.atlassian.jira.migration.jdmccservice.DataMovementResponse;
import com.atlassian.jira.migration.jdmccservice.DeregisterDataMovementRequest;
import com.atlassian.jira.migration.jdmccservice.Destination;
import com.atlassian.jira.migration.jdmccservice.JdmccClient;
import com.atlassian.jira.migration.jdmccservice.ProjectDetail;
import com.atlassian.jira.migration.jdmccservice.RegisterDataMovementRequest;
import com.atlassian.jira.migration.jdmccservice.RegisterDataMovementResponse;
import com.atlassian.jira.migration.jdmccservice.ResourceOptimisationResponse;
import com.atlassian.jira.migration.jdmccservice.SiteInfo;
import com.atlassian.jira.migration.jdmccservice.V3DataMovementConfig;
import com.atlassian.jira.migration.jdmccservice.V3ProjectConcurrencyDataMovement;
import com.atlassian.jira.migration.jdmccservice.V3RegisterDataMovementResponse;
import com.atlassian.jira.migration.plan.MigrationTag;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.progress.InfraStatus;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.api.ContainerToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010,\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010-\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/atlassian/jira/migration/jdmccservice/JdmccService;", "", "jdmccClient", "Lcom/atlassian/jira/migration/jdmccservice/JdmccClient;", "jiraIssueReader", "Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "rdsScalingEventHandler", "Lcom/atlassian/jira/migration/analytics/RdsScalingEventHandler;", "(Lcom/atlassian/jira/migration/jdmccservice/JdmccClient;Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/analytics/RdsScalingEventHandler;)V", "awaitInfraScaling", "", "infraScaling", "dataMovementId", "", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "createRegisterDataMovementRequest", "Lcom/atlassian/jira/migration/jdmccservice/RegisterDataMovementRequest;", "createV3RegisterDataMovementRequest", "deregisterDataMovement", "", "status", "getSinkConfig", "Lcom/atlassian/jira/migration/jdmccservice/DataMovementResponse;", "getV3ProjectConcurrency", "Lcom/atlassian/jira/migration/execution/model/V3Config;", "getV3RegisterResponse", "Lcom/atlassian/jira/migration/jdmccservice/V3ProjectConcurrencyDataMovement;", "registerDataMovementRequest", "isResourceOptimisationDone", "resourceOptimisationResponse", "Lcom/atlassian/jira/migration/jdmccservice/ResourceOptimisationResponse;", "isTestMigration", "isTimeElapsedGreaterThanThreshold", "startTime", "", "registerDataMovement", "shouldRetryRdsScaling", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJdmccService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdmccService.kt\ncom/atlassian/jira/migration/jdmccservice/JdmccService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1549#2:227\n1620#2,3:228\n1179#2,2:231\n1253#2,4:233\n*S KotlinDebug\n*F\n+ 1 JdmccService.kt\ncom/atlassian/jira/migration/jdmccservice/JdmccService\n*L\n56#1:227\n56#1:228,3\n57#1:231,2\n57#1:233,4\n*E\n"})
public final class JdmccService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JdmccClient jdmccClient;
    @NotNull
    private final JiraIssueReader jiraIssueReader;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final RdsScalingEventHandler rdsScalingEventHandler;
    private static final Logger log = LoggerFactory.getLogger(JdmccService.class);
    @NotNull
    private static final String IMPORT = "IMPORT";
    @NotNull
    private static final String JCMA_V4_STREAMING = "JCMA_V4_STREAMING";
    @NotNull
    private static final String JCMA = "JCMA";
    private static final long testMigrationTimeoutRetry = 2700000L;
    private static final long prodMigrationTimeoutRetry = 2700000L;
    private static final long waitTime = 300000L;
    @NotNull
    private static final String INPROGRESS = "IN_PROGRESS";
    @NotNull
    private static final String resourceOptimisationStatus = "resourceOptimisationStatus";

    @Inject
    public JdmccService(@NotNull JdmccClient jdmccClient, @NotNull JiraIssueReader jiraIssueReader, @NotNull ProjectManager projectManager, @NotNull MigrationFeatures migrationFeatures, @NotNull PlanRepository planRepository, @NotNull RdsScalingEventHandler rdsScalingEventHandler) {
        Intrinsics.checkNotNullParameter((Object)jdmccClient, (String)"jdmccClient");
        Intrinsics.checkNotNullParameter((Object)jiraIssueReader, (String)"jiraIssueReader");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)rdsScalingEventHandler, (String)"rdsScalingEventHandler");
        this.jdmccClient = jdmccClient;
        this.jiraIssueReader = jiraIssueReader;
        this.projectManager = projectManager;
        this.migrationFeatures = migrationFeatures;
        this.planRepository = planRepository;
        this.rdsScalingEventHandler = rdsScalingEventHandler;
    }

    @NotNull
    public final DataMovementResponse getSinkConfig(@NotNull Plan plan2, @NotNull ContainerToken containerToken) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        DataMovementResponse response2 = this.registerDataMovement(plan2, containerToken);
        log.info("Registered data movement: " + response2.getDataMovementId() + " for cloudId: " + plan2.getCloudId());
        boolean isScalingThresholdTimeoutOrFailure = this.awaitInfraScaling(response2.getInfraScaling(), response2.getDataMovementId(), containerToken, plan2);
        if (isScalingThresholdTimeoutOrFailure) {
            DataMovementConfig dataMovementConfig = response2.getDataMovementConfig();
            if (dataMovementConfig != null) {
                dataMovementConfig.setRecommendedProjectsConcurrency(8);
            }
            log.warn("Unable to get successful response for project concurrency for cloudId: " + plan2.getCloudId() + ". Setting default project concurrency to 8");
        }
        return response2;
    }

    public final void deregisterDataMovement(@NotNull String dataMovementId, @NotNull String status, @NotNull ContainerToken containerToken) {
        Intrinsics.checkNotNullParameter((Object)dataMovementId, (String)"dataMovementId");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        DeregisterDataMovementRequest deregisterDataMovementRequest = new DeregisterDataMovementRequest(status);
        this.jdmccClient.deregisterDataMovement(dataMovementId, deregisterDataMovementRequest, containerToken);
    }

    private final DataMovementResponse registerDataMovement(Plan plan2, ContainerToken containerToken) {
        RegisterDataMovementRequest registerDataMovementRequest = this.createRegisterDataMovementRequest(plan2);
        RegisterDataMovementResponse response2 = this.jdmccClient.registerDataMovement(registerDataMovementRequest, containerToken);
        return response2.getResponseData();
    }

    /*
     * WARNING - void declaration
     */
    private final RegisterDataMovementRequest createRegisterDataMovementRequest(Plan plan2) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = plan2.getProjectKeys();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.projectManager.getProjectByCurrentKey((String)it).getId());
        }
        List projectIds = (List)destination$iv$iv;
        Iterable $this$associate$iv = projectIds;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo22 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Long it = (Long)element$iv$iv;
            boolean bl = false;
            String string = String.valueOf(it);
            Intrinsics.checkNotNull((Object)it);
            Boolean bl2 = plan2.getMigrateArchivedIssues();
            Pair pair = TuplesKt.to((Object)string, (Object)new ProjectDetail(this.jiraIssueReader.getIssueCountForProject(it, bl2 != null ? bl2 : false), null, null, 6, null));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map projectDetails = destination$iv$iv2;
        if (this.migrationFeatures.getEnableScaleRDS()) {
            return new RegisterDataMovementRequest(IMPORT, JCMA_V4_STREAMING, new Destination(new SiteInfo(plan2.getCloudId())), "SERVER", new DataMovementMetaData(plan2.getProjectKeys().size(), projectDetails), String.valueOf((Object)plan2.getMigrationTag()), true);
        }
        return new RegisterDataMovementRequest(IMPORT, JCMA_V4_STREAMING, new Destination(new SiteInfo(plan2.getCloudId())), "SERVER", new DataMovementMetaData(plan2.getProjectKeys().size(), projectDetails), null, null, 96, null);
    }

    private final RegisterDataMovementRequest createV3RegisterDataMovementRequest(Plan plan2) {
        Destination destination = new Destination(new SiteInfo(plan2.getCloudId()));
        String string = String.valueOf((Object)plan2.getMigrationTag());
        DataMovementMetaData dataMovementMetaData = new DataMovementMetaData(plan2.getProjectKeys().size(), MapsKt.emptyMap());
        return new RegisterDataMovementRequest(IMPORT, JCMA, destination, "SERVER", dataMovementMetaData, string, true);
    }

    @NotNull
    public final V3Config getV3ProjectConcurrency(@NotNull ContainerToken containerToken, @NotNull Plan plan2) {
        V3Config v3Config;
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        if (this.migrationFeatures.getEnableScaleRDS()) {
            RegisterDataMovementRequest registerDataMovementRequest = this.createV3RegisterDataMovementRequest(plan2);
            V3ProjectConcurrencyDataMovement concurrencyDataMovement = this.getV3RegisterResponse(registerDataMovementRequest, containerToken, plan2);
            if (((CharSequence)concurrencyDataMovement.getDataMovementId()).length() == 0) {
                log.warn("Unable to get successful response for project concurrency {}", (Object)plan2.getCloudId());
                return new V3Config(concurrencyDataMovement.getProjectConcurrency(), null);
            }
            boolean isScalingThresholdTimeoutOrFailure = this.awaitInfraScaling(concurrencyDataMovement.getInfraScaling(), concurrencyDataMovement.getDataMovementId(), containerToken, plan2);
            if (isScalingThresholdTimeoutOrFailure) {
                log.warn("Unable to get successful response for project concurrency for cloudId: " + plan2.getCloudId() + ". Setting default project concurrency to 8");
                return new V3Config(8, concurrencyDataMovement.getDataMovementId());
            }
            v3Config = new V3Config(concurrencyDataMovement.getProjectConcurrency(), concurrencyDataMovement.getDataMovementId());
        } else {
            v3Config = new V3Config(this.jdmccClient.getProjectConcurrencyResponse(containerToken, plan2.getCloudId()), null);
        }
        return v3Config;
    }

    public final boolean awaitInfraScaling(boolean infraScaling, @NotNull String dataMovementId, @NotNull ContainerToken containerToken, @NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)dataMovementId, (String)"dataMovementId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        boolean isScalingThresholdTimeoutOrFailure = false;
        if (!this.migrationFeatures.getEnableScaleRDS()) {
            return isScalingThresholdTimeoutOrFailure;
        }
        if (!infraScaling) {
            log.info("Infra scaling is not enabled for data movement: " + dataMovementId + ", cloudId: " + plan2.getCloudId());
            return isScalingThresholdTimeoutOrFailure;
        }
        this.rdsScalingEventHandler.sendRdsScalingEvent(new RdsScalingEvent(dataMovementId, plan2.getCloudId(), plan2.getId(), RdsScalingEvent.STATE.START.getValue(), 0L, 16, null));
        plan2.setInfraOptimisationStatus(InfraStatus.RUNNING);
        this.planRepository.update(plan2);
        long startTime = System.currentTimeMillis();
        while (this.migrationFeatures.getEnableScaleRDS()) {
            ResourceOptimisationResponse resourceOptimisationResponse = this.jdmccClient.getRdsScalingStatus(dataMovementId, containerToken);
            Integer n = resourceOptimisationResponse.getStatusCode();
            int n2 = 200;
            if (n == null || n != n2 || this.isTimeElapsedGreaterThanThreshold(startTime, plan2, dataMovementId)) {
                log.warn("Unable to get RDS scaling status for dataMovementId: " + dataMovementId);
                isScalingThresholdTimeoutOrFailure = true;
                break;
            }
            if (!this.shouldRetryRdsScaling(resourceOptimisationResponse, dataMovementId)) {
                log.info("RDS scaling done for data movement: " + dataMovementId + ", cloudId: " + plan2.getCloudId());
                break;
            }
            log.info("Retrying RDS scaling for data movement: " + dataMovementId);
            Thread.sleep(300000L);
        }
        plan2.setInfraOptimisationStatus(InfraStatus.NOT_RUNNING);
        this.planRepository.update(plan2);
        this.rdsScalingEventHandler.sendRdsScalingEvent(new RdsScalingEvent(dataMovementId, plan2.getCloudId(), plan2.getId(), RdsScalingEvent.STATE.END.getValue(), 0L, 16, null));
        return isScalingThresholdTimeoutOrFailure;
    }

    private final boolean shouldRetryRdsScaling(ResourceOptimisationResponse resourceOptimisationResponse, String dataMovementId) {
        return !this.isResourceOptimisationDone(resourceOptimisationResponse, dataMovementId);
    }

    private final boolean isResourceOptimisationDone(ResourceOptimisationResponse resourceOptimisationResponse, String dataMovementId) {
        boolean isOptimisationDone = resourceOptimisationResponse.getResponseData() != null && !Intrinsics.areEqual((Object)resourceOptimisationResponse.getResponseData().get(resourceOptimisationStatus), (Object)INPROGRESS);
        Integer n = resourceOptimisationResponse.getStatusCode();
        int n2 = 200;
        if (n != null && n == n2 && isOptimisationDone) {
            log.info("Resource optimisation done. Should not retry RDS scaling for " + dataMovementId);
            return true;
        }
        return false;
    }

    private final boolean isTimeElapsedGreaterThanThreshold(long startTime, Plan plan2, String dataMovementId) {
        boolean isTestMigration = this.isTestMigration(plan2);
        long timeDiffThreshold = this.isTestMigration(plan2) ? 2700000L : 2700000L;
        long currentTime = System.currentTimeMillis();
        long timeDiff = currentTime - startTime;
        if (timeDiff > timeDiffThreshold) {
            log.info("Time elapsed " + timeDiffThreshold + " is more than threshold for " + dataMovementId + " for isTestMigration " + isTestMigration + " . No need to retry for RDS scaling");
            return true;
        }
        return false;
    }

    private final boolean isTestMigration(Plan plan2) {
        return MigrationTag.TEST.equals((Object)plan2.getMigrationTag());
    }

    private final V3ProjectConcurrencyDataMovement getV3RegisterResponse(RegisterDataMovementRequest registerDataMovementRequest, ContainerToken containerToken, Plan plan2) {
        try {
            V3RegisterDataMovementResponse registerResponse = this.jdmccClient.getV3ProjectConcurrencyViaRegister(registerDataMovementRequest, containerToken);
            V3DataMovementConfig v3DataMovementConfig = registerResponse.getResponseData().getDataMovementConfig();
            int projectConcurrency = v3DataMovementConfig != null ? v3DataMovementConfig.getProjectConcurrency() : 8;
            return new V3ProjectConcurrencyDataMovement(projectConcurrency, registerResponse.getResponseData().getDataMovementId(), registerResponse.getResponseData().getInfraScaling(), registerResponse.getStatusCode());
        }
        catch (Exception e) {
            log.warn("Unable to register data movement " + e + " for cloudId: " + plan2.getCloudId());
            return new V3ProjectConcurrencyDataMovement(8, "", false, 500);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/jdmccservice/JdmccService$Companion;", "", "()V", "IMPORT", "", "INPROGRESS", "JCMA", "JCMA_V4_STREAMING", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "prodMigrationTimeoutRetry", "", "resourceOptimisationStatus", "testMigrationTimeoutRetry", "waitTime", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

