/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.jiracloudservice;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.jiracloudservice.CloudEntityCreationLimitRequest;
import com.atlassian.jira.migration.jiracloudservice.GetCloudEntityCreationLimitResponse;
import com.atlassian.jira.migration.jiracloudservice.GetJiraCloudBackupInformationResponse;
import com.atlassian.jira.migration.jiracloudservice.GetJiraCloudProjectsResponse;
import com.atlassian.jira.migration.jiracloudservice.GetJiraCloudTenantInformationResponse;
import com.atlassian.migration.api.ContainerToken;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;", "", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "httpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;", "(Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;)V", "getCloudBackupInformation", "Lcom/atlassian/jira/migration/jiracloudservice/GetJiraCloudBackupInformationResponse;", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "cloudId", "", "getCloudEntityCreationLimitForSite", "", "request", "Lcom/atlassian/jira/migration/jiracloudservice/CloudEntityCreationLimitRequest;", "getProjectsForSite", "Lcom/atlassian/jira/migration/jiracloudservice/GetJiraCloudProjectsResponse;", "getTenantInformation", "Lcom/atlassian/jira/migration/jiracloudservice/GetJiraCloudTenantInformationResponse;", "withDefaultHeaders", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "jira-migration-plugin"})
public final class JiraCloudClient {
    @NotNull
    private final MigrationPluginHttpClient httpClient;
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;

    public JiraCloudClient(@NotNull MigrationPluginHttpClient httpClient, @NotNull MigrationServicesConfiguration migrationServicesConfiguration) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        this.httpClient = httpClient;
        this.migrationServicesConfiguration = migrationServicesConfiguration;
    }

    @Inject
    public JiraCloudClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationUserAgentProvider userAgentProvider, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this(new MigrationPluginHttpClient(userAgentProvider, objectMapperFactory.createObjectMapper()), migrationServicesConfiguration);
    }

    @NotNull
    public final GetJiraCloudProjectsResponse getProjectsForSite(@NotNull ContainerToken containerToken, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Object object = new Pair[]{new Pair((Object)"startAt", (Object)"0"), new Pair((Object)"maxResults", (Object)"2147483647"), new Pair((Object)"type", (Object)"ALL"), new Pair((Object)"status", (Object)"DEFAULT,ACTIVE,ARCHIVED,DELETED")};
        List queryParams = CollectionsKt.listOfNotNull((Object[])object);
        object = SetsKt.setOf((Object)200);
        String[] stringArray = new String[]{cloudId2};
        URI uRI = AbstractPluginHttpClientKt.buildURI(this.migrationServicesConfiguration.getEnterpriseGatewayJiraS2CBaseURI(), "cloudid/{cloudId}/export/projects", stringArray, queryParams);
        return this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("GET", uRI, (Set)object, null, null, null, 56, null), containerToken), GetJiraCloudProjectsResponse.class);
    }

    public final long getCloudEntityCreationLimitForSite(@Nullable CloudEntityCreationLimitRequest request) {
        Set set = SetsKt.setOf((Object)200);
        URI uRI = this.migrationServicesConfiguration.getEnterpriseGatewayJiraS2CBaseURI();
        String[] stringArray = new String[2];
        CloudEntityCreationLimitRequest cloudEntityCreationLimitRequest = request;
        Intrinsics.checkNotNull((Object)cloudEntityCreationLimitRequest);
        stringArray[0] = cloudEntityCreationLimitRequest.getCloudId();
        stringArray[1] = request.getCloudLimitPropertyName();
        URI uRI2 = AbstractPluginHttpClientKt.buildURI$default(uRI, "cloudid/{cloudId}/resource/limit/{propertyName}", stringArray, null, 8, null);
        return this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("GET", uRI2, set, null, null, null, 56, null), request.getContainerToken()), GetCloudEntityCreationLimitResponse.class).getLimit();
    }

    private final MigrationPluginHttpRequest withDefaultHeaders(MigrationPluginHttpRequest $this$withDefaultHeaders, ContainerToken containerToken) {
        MigrationPluginHttpRequest migrationPluginHttpRequest;
        MigrationPluginHttpRequest $this$withDefaultHeaders_u24lambda_u240 = migrationPluginHttpRequest = $this$withDefaultHeaders;
        boolean bl = false;
        $this$withDefaultHeaders_u24lambda_u240.authorization("Bearer " + (String)((Object)containerToken.getValue()));
        $this$withDefaultHeaders_u24lambda_u240.contentTypeJson();
        $this$withDefaultHeaders_u24lambda_u240.acceptsJson();
        return migrationPluginHttpRequest;
    }

    @NotNull
    public final GetJiraCloudTenantInformationResponse getTenantInformation(@NotNull ContainerToken containerToken, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Set set = SetsKt.setOf((Object)200);
        String[] stringArray = new String[]{cloudId2};
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.migrationServicesConfiguration.getEnterpriseGatewayJiraS2CBaseURI(), "cloudid/{cloudId}/backup/latest/import/migrationCheck", stringArray, null, 8, null);
        return this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("GET", uRI, set, null, null, null, 56, null), containerToken), GetJiraCloudTenantInformationResponse.class);
    }

    @NotNull
    public final GetJiraCloudBackupInformationResponse getCloudBackupInformation(@NotNull ContainerToken containerToken, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Set set = SetsKt.setOf((Object)200);
        String[] stringArray = new String[]{cloudId2};
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.migrationServicesConfiguration.getEnterpriseGatewayJiraBIBaseURI(), "cloudid/{cloudId}/preflight/cloudBackupInfo", stringArray, null, 8, null);
        return this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("GET", uRI, set, null, null, null, 56, null), containerToken), GetJiraCloudBackupInformationResponse.class);
    }
}

