/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.jiraservice;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.migration.sen.JiraSenInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\rJ\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;", "", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "(Lcom/atlassian/sal/api/ApplicationProperties;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/security/JiraAuthenticationContext;)V", "getJiraServerId", "", "getLoggedUserKey", "getSens", "", "getServerUrl", "isTestSite", "", "cloudUrl", "translateSens", "sens", "Lcom/atlassian/jira/migration/sen/JiraSenInfo;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJiraMetadataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraMetadataService.kt\ncom/atlassian/jira/migration/jiraservice/JiraMetadataService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class JiraMetadataService {
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Inject
    public JiraMetadataService(@NotNull ApplicationProperties applicationProperties, @NotNull SENSupplier senSupplier, @NotNull JiraAuthenticationContext jiraAuthenticationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        this.applicationProperties = applicationProperties;
        this.senSupplier = senSupplier;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @NotNull
    public final String getJiraServerId() {
        String string = ComponentAccessor.getApplicationProperties().getString("jira.sid.key");
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    @NotNull
    public final String getServerUrl() {
        String string = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseUrl(...)");
        return string;
    }

    @NotNull
    public final Map<String, String> getSens() {
        return this.translateSens(this.senSupplier.getSens());
    }

    private final Map<String, String> translateSens(JiraSenInfo sens) {
        HashMap hashMap;
        block2: {
            String it;
            HashMap $this$translateSens_u24lambda_u243 = hashMap = new HashMap();
            boolean bl = false;
            String string = sens.getJiraSoftwareSen();
            if (string != null) {
                it = string;
                boolean bl2 = false;
                ((Map)$this$translateSens_u24lambda_u243).put("JIRA_SOFTWARE", it);
            }
            String string2 = sens.getJiraCoreSen();
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                ((Map)$this$translateSens_u24lambda_u243).put("JIRA_CORE", it);
            }
            String string3 = sens.getJiraServicedeskSen();
            if (string3 == null) break block2;
            it = string3;
            boolean bl4 = false;
            ((Map)$this$translateSens_u24lambda_u243).put("JIRA_SERVICE_DESK", it);
        }
        return hashMap;
    }

    @Nullable
    public final String getLoggedUserKey() {
        return this.jiraAuthenticationContext.getLoggedInUser().getKey();
    }

    public final boolean isTestSite(@NotNull String cloudUrl) {
        Intrinsics.checkNotNullParameter((Object)cloudUrl, (String)"cloudUrl");
        return StringsKt.startsWith$default((String)cloudUrl, (String)"https://mpt-test", (boolean)false, (int)2, null) | StringsKt.startsWith$default((String)cloudUrl, (String)"http://mpt-test", (boolean)false, (int)2, null);
    }
}

