/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.jiraservice;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.jira.migration.jiraservice.JswService;
import com.atlassian.jira.migration.jiraservice.OsgiUtil;
import com.atlassian.jira.migration.jiraservice.ProjectRapidViewServiceException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J0\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/jiraservice/JswServiceImpl;", "Lcom/atlassian/jira/migration/jiraservice/JswService;", "()V", "rapidViewService", "Lcom/atlassian/greenhopper/service/rapid/view/RapidViewService;", "(Lcom/atlassian/greenhopper/service/rapid/view/RapidViewService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "boardBelongsToProjects", "", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "projects", "", "Lcom/atlassian/jira/project/Project;", "rapidView", "Lcom/atlassian/greenhopper/model/rapid/RapidView;", "projectRapidViewService", "Lcom/atlassian/greenhopper/service/rapid/ProjectRapidViewService;", "sharedFiltersByProjects", "", "", "projectKeys", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJswServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JswServiceImpl.kt\ncom/atlassian/jira/migration/jiraservice/JswServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n766#2:75\n857#2,2:76\n1549#2:78\n1620#2,3:79\n1747#2,3:82\n*S KotlinDebug\n*F\n+ 1 JswServiceImpl.kt\ncom/atlassian/jira/migration/jiraservice/JswServiceImpl\n*L\n39#1:75\n39#1:76,2\n40#1:78\n40#1:79,3\n66#1:82,3\n*E\n"})
public final class JswServiceImpl
implements JswService {
    @NotNull
    private final RapidViewService rapidViewService;
    private final Logger log;

    public JswServiceImpl(@NotNull RapidViewService rapidViewService) {
        Intrinsics.checkNotNullParameter((Object)rapidViewService, (String)"rapidViewService");
        this.rapidViewService = rapidViewService;
        this.log = LoggerFactory.getLogger(JswServiceImpl.class);
    }

    public JswServiceImpl() {
        Object object = OsgiServices.importOsgiService(RapidViewService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"importOsgiService(...)");
        this((RapidViewService)object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Long> sharedFiltersByProjects(@NotNull ApplicationUser user, @NotNull List<? extends Project> projectKeys) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        RapidView it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        ProjectRapidViewService projectRapidViewService = OsgiUtil.INSTANCE.lazyGetProjectRapidViewService();
        if (projectRapidViewService == null) {
            throw new ProjectRapidViewServiceException("projectRapidViewService failed to initialise");
        }
        ProjectRapidViewService projectRapidViewService2 = projectRapidViewService;
        this.log.info("number of projects=" + projectKeys.size());
        long start = System.currentTimeMillis();
        Object object = this.rapidViewService.getRapidViews(user).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        List rapidViews = (List)object;
        this.log.info("number of rapid views " + rapidViews.size());
        Iterable iterable = rapidViews;
        boolean $i$f$filter = false;
        void var10_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (RapidView)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this.boardBelongsToProjects(user, projectKeys, it, projectRapidViewService2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RapidView)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSavedFilterId());
        }
        HashSet sharedFilters = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        long end = System.currentTimeMillis();
        this.log.info("shared filters loaded - count=" + sharedFilters.size() + " time taken=" + (end - start) + " ms");
        return sharedFilters;
    }

    private final boolean boardBelongsToProjects(ApplicationUser user, List<? extends Project> projects, RapidView rapidView, ProjectRapidViewService projectRapidViewService) {
        ServiceOutcome serviceOutcome = projectRapidViewService.findProjectsByRapidView(user, rapidView);
        Intrinsics.checkNotNullExpressionValue((Object)serviceOutcome, (String)"findProjectsByRapidView(...)");
        ServiceOutcome projectsByRapidView = serviceOutcome;
        if (!projectsByRapidView.isInvalid()) {
            boolean bl;
            block4: {
                Object object = projectsByRapidView.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Project it = (Project)element$iv;
                        boolean bl2 = false;
                        if (!projects.contains(it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }
}

