/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.jiraservice;

import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.google.common.annotations.VisibleForTesting;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002J!\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0007\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/jiraservice/OsgiUtil;", "", "()V", "ISSUE_DATA_SERVICE_IMPL_BEAN", "", "PROJECT_RAPID_VIEW_SERVICE_IMPL_BEAN", "PYXIS_BUNDLE_CLASS", "RAPID_VIEW_MANAGER_IMPL_BEAN", "SPRING_FRAMEWORK_CONTEXT_PROPERTY", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getGreenHopperAppCtx", "getOsgiService", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "lazyGetIssueDataService", "Lcom/atlassian/greenhopper/service/issue/IssueDataService;", "lazyGetProjectRapidViewService", "Lcom/atlassian/greenhopper/service/rapid/ProjectRapidViewService;", "lazyGetRapidViewManager", "Lcom/atlassian/greenhopper/manager/rapidview/RapidViewManager;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nOsgiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OsgiUtil.kt\ncom/atlassian/jira/migration/jiraservice/OsgiUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1282#2,2:117\n1282#2,2:119\n1#3:121\n*S KotlinDebug\n*F\n+ 1 OsgiUtil.kt\ncom/atlassian/jira/migration/jiraservice/OsgiUtil\n*L\n30#1:117,2\n33#1:119,2\n*E\n"})
public final class OsgiUtil {
    @NotNull
    public static final OsgiUtil INSTANCE = new OsgiUtil();
    private static final Logger log = LoggerFactory.getLogger(OsgiUtil.class);
    @NotNull
    private static final String PYXIS_BUNDLE_CLASS = "com.pyxis.greenhopper.jira";
    @NotNull
    private static final String SPRING_FRAMEWORK_CONTEXT_PROPERTY = "org.springframework.context.service.name";
    @NotNull
    private static final String PROJECT_RAPID_VIEW_SERVICE_IMPL_BEAN = "projectRapidViewServiceImpl";
    @NotNull
    private static final String RAPID_VIEW_MANAGER_IMPL_BEAN = "rapidViewManagerImpl";
    @NotNull
    private static final String ISSUE_DATA_SERVICE_IMPL_BEAN = "issueDataServiceImpl";

    private OsgiUtil() {
    }

    /*
     * WARNING - void declaration
     */
    private final Object getGreenHopperAppCtx() {
        Object object;
        Object serviceRef;
        Object v2;
        Bundle matchingBundle;
        block8: {
            ServiceReference[] serviceReferenceArray;
            BundleContext bundleContext;
            Object object2;
            block7: {
                OsgiContainerManager osgi = (OsgiContainerManager)ComponentAccessor.getComponentOfType(OsgiContainerManager.class);
                if (osgi == null) {
                    log.warn("OSGI Not Found");
                    return null;
                }
                Bundle[] bundleArray = osgi.getBundles();
                Intrinsics.checkNotNullExpressionValue((Object)bundleArray, (String)"getBundles(...)");
                Object[] $this$firstOrNull$iv = bundleArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Bundle it = (Bundle)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSymbolicName(), (Object)PYXIS_BUNDLE_CLASS)) continue;
                    object2 = element$iv;
                    break block7;
                }
                object2 = null;
            }
            matchingBundle = (Bundle)object2;
            log.info("matchingBundle is " + matchingBundle);
            if (matchingBundle != null && (bundleContext = matchingBundle.getBundleContext()) != null && (serviceReferenceArray = bundleContext.getAllServiceReferences(null, null)) != null) {
                void $this$firstOrNull$iv;
                ServiceReference[] serviceReferenceArray2 = serviceReferenceArray;
                boolean $i$f$firstOrNull = false;
                int n = ((void)$this$firstOrNull$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getProperty(SPRING_FRAMEWORK_CONTEXT_PROPERTY), (Object)PYXIS_BUNDLE_CLASS)) continue;
                    v2 = element$iv;
                    break block8;
                }
                v2 = null;
            } else {
                v2 = null;
            }
        }
        Object v3 = serviceRef = v2;
        if (v3 != null) {
            Object it = v3;
            boolean bl = false;
            object = matchingBundle.getBundleContext().getService(it);
        } else {
            object = null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @Nullable
    public final IssueDataService lazyGetIssueDataService() {
        try {
            IssueDataService issueDataService2;
            IssueDataService it = issueDataService2 = this.getOsgiService(IssueDataService.class);
            boolean bl = false;
            log.info("loading IssueDataService - service " + it + " found");
            return issueDataService2;
        }
        catch (Exception e) {
            ApplicationContext applicationContext;
            log.warn("failed to get service IssueDataService");
            Object ctx = this.getGreenHopperAppCtx();
            if (!(ctx instanceof ApplicationContext)) return null;
            ApplicationContext applicationContext3 = (ApplicationContext)ctx;
            applicationContext3 = applicationContext3;
            if (applicationContext2 == null) return null;
            ApplicationContext it = applicationContext = applicationContext3;
            boolean bl = false;
            if (!it.containsBean(ISSUE_DATA_SERVICE_IMPL_BEAN)) return null;
            ApplicationContext applicationContext3 = applicationContext;
            applicationContext3 = applicationContext3;
            if (applicationContext4 == null) return null;
            ApplicationContext $this$lazyGetIssueDataService_u24lambda_u245 = applicationContext3;
            boolean bl2 = false;
            log.info("IssueDataService found in application context");
            Object object = $this$lazyGetIssueDataService_u24lambda_u245.getBean(ISSUE_DATA_SERVICE_IMPL_BEAN);
            if (!(object instanceof IssueDataService)) return null;
            IssueDataService issueDataService3 = (IssueDataService)object;
            return issueDataService3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @Nullable
    public final ProjectRapidViewService lazyGetProjectRapidViewService() {
        try {
            ProjectRapidViewService projectRapidViewService;
            ProjectRapidViewService it = projectRapidViewService = this.getOsgiService(ProjectRapidViewService.class);
            boolean bl = false;
            log.info("loading ProjectRapidViewService - service " + it + " found");
            return projectRapidViewService;
        }
        catch (Exception e) {
            ApplicationContext applicationContext;
            log.warn("failed to get service ProjectRapidViewService");
            Object ctx = this.getGreenHopperAppCtx();
            if (!(ctx instanceof ApplicationContext)) return null;
            ApplicationContext applicationContext3 = (ApplicationContext)ctx;
            applicationContext3 = applicationContext3;
            if (applicationContext2 == null) return null;
            ApplicationContext it = applicationContext = applicationContext3;
            boolean bl = false;
            if (!it.containsBean(PROJECT_RAPID_VIEW_SERVICE_IMPL_BEAN)) return null;
            ApplicationContext applicationContext3 = applicationContext;
            applicationContext3 = applicationContext3;
            if (applicationContext4 == null) return null;
            ApplicationContext $this$lazyGetProjectRapidViewService_u24lambda_u248 = applicationContext3;
            boolean bl2 = false;
            log.info("ProjectRapidViewService found in application context");
            Object object = $this$lazyGetProjectRapidViewService_u24lambda_u248.getBean(PROJECT_RAPID_VIEW_SERVICE_IMPL_BEAN);
            if (!(object instanceof ProjectRapidViewService)) return null;
            ProjectRapidViewService projectRapidViewService = (ProjectRapidViewService)object;
            return projectRapidViewService;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @Nullable
    public final RapidViewManager lazyGetRapidViewManager() {
        try {
            RapidViewManager rapidViewManager;
            RapidViewManager it = rapidViewManager = this.getOsgiService(RapidViewManager.class);
            boolean bl = false;
            log.info("service " + it + " found");
            return rapidViewManager;
        }
        catch (Exception e) {
            ApplicationContext applicationContext;
            log.warn("failed to get service RapidViewManager");
            Object ctx = this.getGreenHopperAppCtx();
            if (!(ctx instanceof ApplicationContext)) return null;
            ApplicationContext applicationContext3 = (ApplicationContext)ctx;
            applicationContext3 = applicationContext3;
            if (applicationContext2 == null) return null;
            ApplicationContext it = applicationContext = applicationContext3;
            boolean bl = false;
            if (!it.containsBean(RAPID_VIEW_MANAGER_IMPL_BEAN)) return null;
            ApplicationContext applicationContext3 = applicationContext;
            applicationContext3 = applicationContext3;
            if (applicationContext4 == null) return null;
            ApplicationContext $this$lazyGetRapidViewManager_u24lambda_u2411 = applicationContext3;
            boolean bl2 = false;
            log.info("RapidViewManager found in application context");
            Object object = $this$lazyGetRapidViewManager_u24lambda_u2411.getBean(RAPID_VIEW_MANAGER_IMPL_BEAN);
            if (!(object instanceof RapidViewManager)) return null;
            RapidViewManager rapidViewManager = (RapidViewManager)object;
            return rapidViewManager;
        }
    }

    @VisibleForTesting
    public final <T> T getOsgiService(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)OsgiServices.importOsgiService(clazz);
    }
}

