/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.jql;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.jql.clause.DeMorgansVisitor;
import com.atlassian.jira.migration.jql.JqlParserService;
import com.atlassian.jira.migration.jql.JqlParsingException;
import com.atlassian.jira.migration.jql.JqlProjectIdentifier;
import com.atlassian.jira.migration.jql.JqlProjectVisitor;
import com.atlassian.jira.migration.jql.ProjectInfo;
import com.atlassian.jira.migration.jql.ProjectSatisfiesQueryVisitor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\tH\u0007J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aR'\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR'\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/jql/JqlParserService;", "", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "(Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/cache/CacheManager;)V", "cacheLoader", "Lcom/atlassian/cache/CacheLoader;", "Lcom/atlassian/jira/migration/jql/JqlProjectIdentifier;", "Lcom/atlassian/jira/migration/jql/ProjectInfo;", "getCacheLoader", "()Lcom/atlassian/cache/CacheLoader;", "cacheLoader$delegate", "Lkotlin/Lazy;", "projectInfoToIdCache", "Lcom/atlassian/cache/Cache;", "getProjectInfoToIdCache", "()Lcom/atlassian/cache/Cache;", "projectInfoToIdCache$delegate", "getProjectId", "jqlProjectIdentifier", "getProjectIdsForQuery", "", "Lcom/atlassian/jira/migration/jql/ProjectInfo$ProjectId;", "query", "Lcom/atlassian/query/Query;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJqlParserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JqlParserService.kt\ncom/atlassian/jira/migration/jql/JqlParserService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n766#2:104\n857#2,2:105\n1549#2:107\n1620#2,3:108\n800#2,11:111\n*S KotlinDebug\n*F\n+ 1 JqlParserService.kt\ncom/atlassian/jira/migration/jql/JqlParserService\n*L\n58#1:104\n58#1:105,2\n59#1:107\n59#1:108,3\n60#1:111,11\n*E\n"})
public final class JqlParserService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final Lazy cacheLoader$delegate;
    @NotNull
    private final Lazy projectInfoToIdCache$delegate;
    private static final Logger log = LoggerFactory.getLogger(JqlParserService.class);
    @NotNull
    private static final String CACHE_NAME = "JqlProjectIdentifier-To-Id-Cache";
    private static final long CACHE_EXPIRY_TIME = 15L;

    @Inject
    public JqlParserService(@NotNull ProjectManager projectManager, @NotNull CacheManager cacheManager) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        this.projectManager = projectManager;
        this.cacheLoader$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CacheLoader<JqlProjectIdentifier, ProjectInfo>>(this){
            final /* synthetic */ JqlParserService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CacheLoader<JqlProjectIdentifier, ProjectInfo> invoke() {
                return arg_0 -> cacheLoader.2.invoke$lambda$0(this.this$0, arg_0);
            }

            private static final ProjectInfo invoke$lambda$0(JqlParserService this$0, JqlProjectIdentifier jqlProjectIdentifier) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)jqlProjectIdentifier, (String)"jqlProjectIdentifier");
                return this$0.getProjectId(jqlProjectIdentifier);
            }
        }));
        this.projectInfoToIdCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Cache<JqlProjectIdentifier, ProjectInfo>>(cacheManager, this){
            final /* synthetic */ CacheManager $cacheManager;
            final /* synthetic */ JqlParserService this$0;
            {
                this.$cacheManager = $cacheManager;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Cache<JqlProjectIdentifier, ProjectInfo> invoke() {
                return this.$cacheManager.getCache("JqlProjectIdentifier-To-Id-Cache", JqlParserService.access$getCacheLoader(this.this$0), new CacheSettingsBuilder().local().expireAfterAccess(15L, TimeUnit.MINUTES).build());
            }
        }));
    }

    private final CacheLoader<JqlProjectIdentifier, ProjectInfo> getCacheLoader() {
        Lazy lazy = this.cacheLoader$delegate;
        return (CacheLoader)lazy.getValue();
    }

    private final Cache<JqlProjectIdentifier, ProjectInfo> getProjectInfoToIdCache() {
        Lazy lazy = this.projectInfoToIdCache$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Cache)object;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<ProjectInfo.ProjectId> getProjectIdsForQuery(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        try {
            if (query.getWhereClause() == null || (var2_2 = (CharSequence)query.getQueryString()) == null || var2_2.length() == 0) {
                return CollectionsKt.emptyList();
            }
            normaliseClause = (Clause)query.getWhereClause().accept((ClauseVisitor)new DeMorgansVisitor());
            var4_5 = (Clause)normaliseClause.accept((ClauseVisitor)(jqlProjectVisitor = new JqlProjectVisitor()));
            if (var4_5 == null) ** GOTO lbl-1000
            projectTerminalClause = var4_5;
            $i$a$-let-JqlParserService$getProjectIdsForQuery$1 = false;
            var8_8 = jqlProjectVisitor.getProjects();
            $i$f$filter = false;
            var10_10 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (JqlProjectIdentifier)element$iv$iv;
                $i$a$-filter-JqlParserService$getProjectIdsForQuery$1$1 = false;
                v0 = projectTerminalClause.accept((ClauseVisitor)new ProjectSatisfiesQueryVisitor(it));
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"accept(...)");
                if (!((Boolean)v0).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (JqlProjectIdentifier)item$iv$iv;
                var17_17 = destination$iv$iv;
                $i$a$-map-JqlParserService$getProjectIdsForQuery$1$2 = false;
                var17_17.add((ProjectInfo)this.getProjectInfoToIdCache().get((Object)jqlProjectIdentifier));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterIsInstanceTo = false;
            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProjectInfo.ProjectId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            var5_18 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            if (var5_18 != null) {
                v1 = var5_18;
            } else lbl-1000:
            // 2 sources

            {
                v1 = CollectionsKt.emptyList();
            }
            var2_2 = v1;
        }
        catch (Throwable e) {
            JqlParserService.log.error("Error while parsing JQL query: " + query.getQueryString(), e);
            throw new JqlParsingException("Error while parsing JQL query: " + query.getQueryString(), e);
        }
        return var2_2;
    }

    @VisibleForTesting
    @NotNull
    public final ProjectInfo getProjectId(@NotNull JqlProjectIdentifier jqlProjectIdentifier) {
        ProjectInfo projectInfo;
        Intrinsics.checkNotNullParameter((Object)jqlProjectIdentifier, (String)"jqlProjectIdentifier");
        JqlProjectIdentifier jqlProjectIdentifier2 = jqlProjectIdentifier;
        if (jqlProjectIdentifier2 instanceof JqlProjectIdentifier.ProjectReferenceKeyOrName) {
            Project project;
            Project project2 = this.projectManager.getProjectObjByKeyIgnoreCase(((JqlProjectIdentifier.ProjectReferenceKeyOrName)jqlProjectIdentifier).getValue());
            if (project2 == null) {
                project2 = this.projectManager.getProjectObjByName(((JqlProjectIdentifier.ProjectReferenceKeyOrName)jqlProjectIdentifier).getValue());
            }
            if ((project = project2) != null) {
                Long l = project.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                projectInfo = new ProjectInfo.ProjectId(((Number)l).longValue());
            } else {
                log.info("No project found for " + ((JqlProjectIdentifier.ProjectReferenceKeyOrName)jqlProjectIdentifier).getValue() + " as key or name");
                projectInfo = ProjectInfo.NotFound.INSTANCE;
            }
        } else if (jqlProjectIdentifier2 instanceof JqlProjectIdentifier.ProjectReferenceId) {
            Project project = this.projectManager.getProjectObj(Long.valueOf(((JqlProjectIdentifier.ProjectReferenceId)jqlProjectIdentifier).getValue()));
            if (project != null) {
                Long l = project.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                projectInfo = new ProjectInfo.ProjectId(((Number)l).longValue());
            } else {
                log.info("No project found for " + ((JqlProjectIdentifier.ProjectReferenceId)jqlProjectIdentifier).getValue() + " as id");
                projectInfo = ProjectInfo.NotFound.INSTANCE;
            }
        } else if (jqlProjectIdentifier2 instanceof JqlProjectIdentifier.EmptyValue) {
            projectInfo = ProjectInfo.NotFound.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return projectInfo;
    }

    public static final /* synthetic */ CacheLoader access$getCacheLoader(JqlParserService $this) {
        return $this.getCacheLoader();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/jql/JqlParserService$Companion;", "", "()V", "CACHE_EXPIRY_TIME", "", "CACHE_NAME", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

