/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.jql.rest;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentServiceKt;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.jiraservice.JiraSearchService;
import com.atlassian.jira.migration.jql.rest.FilterResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="filter")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/jql/rest/FilterResource;", "", "searchRequestManager", "Lcom/atlassian/jira/issue/search/SearchRequestManager;", "jiraSearchService", "Lcom/atlassian/jira/migration/jiraservice/JiraSearchService;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "(Lcom/atlassian/jira/issue/search/SearchRequestManager;Lcom/atlassian/jira/migration/jiraservice/JiraSearchService;Lcom/atlassian/jira/cluster/ClusterManager;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "compareSingleFilter", "Ljavax/ws/rs/core/Response;", "id", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFilterResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterResource.kt\ncom/atlassian/jira/migration/jql/rest/FilterResource\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,63:1\n31#2,6:64\n31#2,6:70\n*S KotlinDebug\n*F\n+ 1 FilterResource.kt\ncom/atlassian/jira/migration/jql/rest/FilterResource\n*L\n40#1:64,6\n48#1:70,6\n*E\n"})
public final class FilterResource {
    @NotNull
    private final SearchRequestManager searchRequestManager;
    @NotNull
    private final JiraSearchService jiraSearchService;
    @NotNull
    private final ClusterManager clusterManager;
    private final Logger log;

    @Inject
    public FilterResource(@NotNull SearchRequestManager searchRequestManager, @NotNull JiraSearchService jiraSearchService, @NotNull ClusterManager clusterManager) {
        Intrinsics.checkNotNullParameter((Object)searchRequestManager, (String)"searchRequestManager");
        Intrinsics.checkNotNullParameter((Object)jiraSearchService, (String)"jiraSearchService");
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        this.searchRequestManager = searchRequestManager;
        this.jiraSearchService = jiraSearchService;
        this.clusterManager = clusterManager;
        this.log = LoggerFactory.getLogger(FilterResource.class);
    }

    public final Logger getLog() {
        return this.log;
    }

    @GET
    @Path(value="debug/{id}")
    @NotNull
    public final Response compareSingleFilter(@PathParam(value="id") @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SearchRequest filter = this.searchRequestManager.getSearchRequestById(Long.valueOf(Long.parseLong(id)));
        Set projectsOldVersion = new LinkedHashSet();
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)filter);
        CollectionsKt.toCollection((Iterable)this.jiraSearchService.getReferencedProjectIdsForSearchRequest(filter, (Function0<Boolean>)((Function0)compareSingleFilter.timeTaken.1.1.INSTANCE)), (Collection)projectsOldVersion);
        long timeTaken2 = System.nanoTime() - start$iv;
        Set projectNewVersion = null;
        boolean $i$f$measureNanoTime2 = false;
        long start$iv2 = System.nanoTime();
        boolean bl2 = false;
        projectNewVersion = CollectionsKt.toSet((Iterable)this.jiraSearchService.getReferencedProjectIdsForSearchRequest(filter, (Function0<Boolean>)((Function0)compareSingleFilter.timeTakenNew.1.1.INSTANCE)));
        long timeTakenNew2 = System.nanoTime() - start$iv2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n            Filter ").append(id).append(" taken: (").append(timeTaken2).append(", ").append(timeTakenNew2).append(") and project size: (").append(projectsOldVersion.size()).append(", ").append(projectNewVersion.size()).append(")\n            Filter ").append(id).append(" projects old : (").append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)projectsOldVersion), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append(")\n            Filter ").append(id).append(" projects new : (").append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)projectNewVersion), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append(")\n            Started ").append(InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager)).append(" processing filter with id: ").append(id).append("\"\n        ");
        return ResponseUtils.INSTANCE.ok(StringsKt.trimIndent((String)stringBuilder.toString()));
    }
}

