/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.lio.recipe;

import com.atlassian.jira.migration.execution.LithiumMigrationsHelper;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraMetadataService;
import com.atlassian.jira.migration.lio.model.Destination;
import com.atlassian.jira.migration.lio.model.Migration;
import com.atlassian.jira.migration.lio.model.MigrationRecipeInput;
import com.atlassian.jira.migration.lio.model.PbPCommonContext;
import com.atlassian.jira.migration.lio.model.RecipeExecutionRequest;
import com.atlassian.jira.migration.lio.model.Source;
import com.atlassian.jira.migration.lio.recipe.RecipeService;
import com.atlassian.jira.migration.plan.AssetsDataMigrationMode;
import com.atlassian.jira.migration.plan.AssetsDataMigrationOption;
import com.atlassian.jira.migration.plan.AssetsSchemaKey;
import com.atlassian.jira.migration.plan.CrossProjectDataMigrationOption;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.migration.plan.ExecutionType;
import com.atlassian.jira.migration.plan.MigrationTag;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.platform.ShadowMigrationProperties;
import com.atlassian.migration.api.MigrationChainId;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.MigrationScopeId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="This service is deprecated, please make your changes in Flow Adaptor - https://bitbucket.org/atlassian/migration-api/src/main/flow-adapter/")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b'\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H&J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\f\u001a\u00020\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/lio/recipe/AbstractPbPRecipeService;", "Lcom/atlassian/jira/migration/lio/recipe/RecipeService;", "Lcom/atlassian/jira/migration/lio/model/MigrationRecipeInput;", "jiraMetadataService", "Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "lithiumMigrationsHelper", "Lcom/atlassian/jira/migration/execution/LithiumMigrationsHelper;", "(Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/execution/LithiumMigrationsHelper;)V", "createCommonContext", "Lcom/atlassian/jira/migration/lio/model/PbPCommonContext;", "migrationRecipeInput", "createRecipeExecutionRequest", "Lcom/atlassian/jira/migration/lio/model/RecipeExecutionRequest;", "recipeInput", "getDestination", "Lcom/atlassian/jira/migration/lio/model/Destination;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "getMigrationProperties", "", "", "", "getMigrationTags", "Lcom/google/common/collect/ImmutableList;", "getSource", "Lcom/atlassian/jira/migration/lio/model/Source;", "isSyntheticCheck", "", "Companion", "jira-migration-plugin"})
public abstract class AbstractPbPRecipeService
implements RecipeService<MigrationRecipeInput> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraMetadataService jiraMetadataService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final LithiumMigrationsHelper lithiumMigrationsHelper;
    @NotNull
    private static final String APP_MIGRATIONS_OPTION = "appsMigrationOption";
    @NotNull
    private static final String CROSS_PROJECT_DATA_MIGRATION_OPTION = "crossProjectDataMigrationOption";
    @NotNull
    private static final String PROJECT_DATA_MIGRATION_MODE = "projectDataMigrationMode";
    @NotNull
    private static final String USERS_GROUPS_MIGRATIONS_OPTION = "usersGroupsMigrationOption";
    @NotNull
    private static final String USER_PRE_MIGRATION = "userPreMigration";
    @NotNull
    private static final String ASSETS_DATA_MIGRATION_OPTION = "assetsDataMigrationOption";
    @NotNull
    private static final String DASHBOARDS_MIGRATION_MODE = "dashboardsMigrationMode";
    @NotNull
    private static final String SHADOW = "shadow";
    @NotNull
    private static final String IMPORT_MODE = "importMode";
    @NotNull
    private static final String ENABLE_APPS_PROCESSING = "enableAppsProcessing";

    public AbstractPbPRecipeService(@NotNull JiraMetadataService jiraMetadataService, @NotNull MigrationFeatures migrationFeatures, @NotNull LithiumMigrationsHelper lithiumMigrationsHelper) {
        Intrinsics.checkNotNullParameter((Object)jiraMetadataService, (String)"jiraMetadataService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)lithiumMigrationsHelper, (String)"lithiumMigrationsHelper");
        this.jiraMetadataService = jiraMetadataService;
        this.migrationFeatures = migrationFeatures;
        this.lithiumMigrationsHelper = lithiumMigrationsHelper;
    }

    @Override
    @NotNull
    public abstract RecipeExecutionRequest createRecipeExecutionRequest(@NotNull MigrationRecipeInput var1);

    @NotNull
    public final ImmutableList<String> getMigrationTags() {
        ImmutableList immutableList = ImmutableList.of((Object)"migration", (Object)"jira-server-to-cloud");
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
        return immutableList;
    }

    @NotNull
    public final Map<String, Object> getMigrationProperties(@NotNull MigrationRecipeInput migrationRecipeInput) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)migrationRecipeInput, (String)"migrationRecipeInput");
        Plan plan2 = migrationRecipeInput.getPlan();
        Object[] objectArray = new Pair[10];
        objectArray[0] = TuplesKt.to((Object)APP_MIGRATIONS_OPTION, (Object)plan2.getAppsMigrationOption());
        List<Long> list = plan2.getAdvancedRoadmapsPlanIds();
        objectArray[1] = TuplesKt.to((Object)CROSS_PROJECT_DATA_MIGRATION_OPTION, (Object)new CrossProjectDataMigrationOption(list != null ? list.size() : 0, plan2.isCrossDataEnabled()));
        objectArray[2] = TuplesKt.to((Object)PROJECT_DATA_MIGRATION_MODE, (Object)((Object)(plan2.isUsersOnly() || plan2.getProjectKeys().isEmpty() ? ProjectDataMigrationMode.NONE : plan2.getProjectDataMigrationMode())));
        objectArray[3] = TuplesKt.to((Object)USERS_GROUPS_MIGRATIONS_OPTION, (Object)plan2.getUsersGroupsMigrationOption());
        if (this.migrationFeatures.getEnableAssetsMigration()) {
            List<AssetsSchemaKey> list2 = plan2.getAssetsSchemaKeys();
            pair = TuplesKt.to((Object)ASSETS_DATA_MIGRATION_OPTION, (Object)new AssetsDataMigrationOption(list2 != null ? list2.size() : 0, plan2.getAssetsDataMigrationMode() != null && plan2.getAssetsDataMigrationMode() != AssetsDataMigrationMode.NONE));
        } else {
            pair = null;
        }
        objectArray[4] = pair;
        Boolean bl = plan2.getUserPreMigration();
        objectArray[5] = TuplesKt.to((Object)USER_PRE_MIGRATION, (Object)(bl != null ? bl : false));
        DashboardsMigrationMode dashboardsMigrationMode = plan2.getDashboardsMigrationMode();
        if (dashboardsMigrationMode == null) {
            dashboardsMigrationMode = DashboardsMigrationMode.NONE;
        }
        objectArray[6] = TuplesKt.to((Object)DASHBOARDS_MIGRATION_MODE, (Object)dashboardsMigrationMode.toString());
        Boolean bl2 = plan2.getCanBeShadowed();
        Boolean bl3 = plan2.isShadowPlan();
        objectArray[7] = TuplesKt.to((Object)SHADOW, (Object)new ShadowMigrationProperties(bl2 != null ? bl2 : false, bl3 != null ? bl3 : false, plan2.getOriginalMigrationId()));
        String string = this.lithiumMigrationsHelper.getImportMode(plan2, true);
        Intrinsics.checkNotNull((Object)string);
        objectArray[8] = TuplesKt.to((Object)IMPORT_MODE, (Object)string);
        objectArray[9] = TuplesKt.to((Object)ENABLE_APPS_PROCESSING, (Object)migrationRecipeInput.getEnableAppsProcessing());
        return MapsKt.plus((Map)MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), migrationRecipeInput.getMaxConcurrencyPerLoop());
    }

    @NotNull
    public final PbPCommonContext createCommonContext(@NotNull MigrationRecipeInput migrationRecipeInput) {
        Intrinsics.checkNotNullParameter((Object)migrationRecipeInput, (String)"migrationRecipeInput");
        MigrationId migrationId = migrationRecipeInput.getMigrationId();
        MigrationScopeId migrationScopeId2 = migrationRecipeInput.getMigrationScopeId();
        boolean bl = this.isSyntheticCheck(migrationRecipeInput.getPlan());
        Source source = this.getSource();
        Destination destination = this.getDestination(migrationRecipeInput.getPlan());
        String string = migrationRecipeInput.getUserKey();
        ExecutionType executionType = migrationRecipeInput.getDryRun() ? ExecutionType.DRY_RUN : ExecutionType.MIGRATION;
        MigrationChainId migrationChainId = migrationRecipeInput.getMigrationChainId();
        boolean bl2 = this.migrationFeatures.getEnableFetchingJQLErrorsFromMRC();
        Migration migrationContext = new Migration(migrationId, migrationScopeId2, "S2C_MIGRATION", executionType, bl, source, destination, string, migrationChainId, bl2);
        return new PbPCommonContext(migrationContext);
    }

    private final Source getSource() {
        return new Source(null, null, this.jiraMetadataService.getJiraServerId(), 3, null);
    }

    private final Destination getDestination(Plan plan2) {
        return new Destination(null, null, plan2.getCloudId(), 3, null);
    }

    private final boolean isSyntheticCheck(Plan plan2) {
        return this.jiraMetadataService.isTestSite(plan2.getCloudUrl()) || MigrationTag.TEST == plan2.getMigrationTag();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/lio/recipe/AbstractPbPRecipeService$Companion;", "", "()V", "APP_MIGRATIONS_OPTION", "", "ASSETS_DATA_MIGRATION_OPTION", "CROSS_PROJECT_DATA_MIGRATION_OPTION", "DASHBOARDS_MIGRATION_MODE", "ENABLE_APPS_PROCESSING", "IMPORT_MODE", "PROJECT_DATA_MIGRATION_MODE", "SHADOW", "USERS_GROUPS_MIGRATIONS_OPTION", "USER_PRE_MIGRATION", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

