/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.lio.recipe;

import com.atlassian.jira.migration.app.CloudMigrationRegistrar;
import com.atlassian.jira.migration.cloud.CloudProductManager;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteNotFoundException;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.execution.MigrationExecutionService;
import com.atlassian.jira.migration.execution.model.MigrationMetaData;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraMetadataService;
import com.atlassian.jira.migration.lio.model.DataEnrichmentRequest;
import com.atlassian.jira.migration.lio.model.EnrichedAppData;
import com.atlassian.jira.migration.lio.model.EnrichedMetaData;
import com.atlassian.jira.migration.lio.model.EnrichedProjectData;
import com.atlassian.jira.migration.lio.model.EnrichmentResponse;
import com.atlassian.jira.migration.lio.model.MigrationPlanSpecificData;
import com.atlassian.jira.migration.lio.model.ShadowMigrationProperties;
import com.atlassian.jira.migration.lio.util.LioUtil;
import com.atlassian.jira.migration.metadataaggregator.providers.JiraServerMetadataProvider;
import com.atlassian.jira.migration.plan.JiraDataMigrationOption;
import com.atlassian.jira.migration.plan.MigrationTag;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.prc.PrcCommandExecutor;
import com.atlassian.jira.migration.prc.client.PrcHttpClient;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationScopeId;
import com.atlassian.migration.prc.model.CommandName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u0000 92\u00020\u0001:\u00019Bg\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J \u0010,\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010-2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010-H\u0002J(\u00101\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010-2\u000e\u00103\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010-2\u0006\u00104\u001a\u000200H\u0002J\u0018\u00105\u001a\u0002062\u0006\u0010(\u001a\u00020#2\u0006\u00107\u001a\u000208H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/atlassian/jira/migration/lio/recipe/DataEnrichmentService;", "Lcom/atlassian/jira/migration/prc/PrcCommandExecutor;", "migrationExecutionService", "Lcom/atlassian/jira/migration/execution/MigrationExecutionService;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "cloudMigrationRegistrar", "Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;", "prcHttpClient", "Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;", "jiraServerMetadataProvider", "Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;", "jiraMetadataService", "Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;", "cloudProductManager", "Lcom/atlassian/jira/migration/cloud/CloudProductManager;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/execution/MigrationExecutionService;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;Lcom/atlassian/jira/migration/cloud/CloudProductManager;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "commandName", "Lcom/atlassian/migration/prc/model/CommandName;", "getCommandName", "()Lcom/atlassian/migration/prc/model/CommandName;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "payloadClassType", "Lkotlin/reflect/KClass;", "Lcom/atlassian/jira/migration/prc/model/PrcCommandPayload;", "getPayloadClassType", "()Lkotlin/reflect/KClass;", "enrich", "Lcom/fasterxml/jackson/databind/JsonNode;", "commandPayload", "Lcom/atlassian/jira/migration/lio/model/DataEnrichmentRequest;", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "enrichAppData", "", "Lcom/atlassian/jira/migration/lio/model/EnrichedAppData;", "appKeys", "", "enrichProjectData", "Lcom/atlassian/jira/migration/lio/model/EnrichedProjectData;", "projectIds", "cloudId", "executeTask", "", "prcCommandId", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDataEnrichmentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataEnrichmentService.kt\ncom/atlassian/jira/migration/lio/recipe/DataEnrichmentService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1#2:154\n1549#3:155\n1620#3,3:156\n1549#3:159\n1620#3,3:160\n1549#3:163\n1620#3,3:164\n*S KotlinDebug\n*F\n+ 1 DataEnrichmentService.kt\ncom/atlassian/jira/migration/lio/recipe/DataEnrichmentService\n*L\n133#1:155\n133#1:156,3\n135#1:159\n135#1:160,3\n145#1:163\n145#1:164,3\n*E\n"})
public final class DataEnrichmentService
implements PrcCommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationExecutionService migrationExecutionService;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final CloudMigrationRegistrar cloudMigrationRegistrar;
    @NotNull
    private final PrcHttpClient prcHttpClient;
    @NotNull
    private final JiraServerMetadataProvider jiraServerMetadataProvider;
    @NotNull
    private final JiraMetadataService jiraMetadataService;
    @NotNull
    private final CloudProductManager cloudProductManager;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final CommandName commandName;
    @NotNull
    private final KClass<? extends PrcCommandPayload> payloadClassType;
    private static final Logger log = LoggerFactory.getLogger(Companion.getClass());

    @Inject
    public DataEnrichmentService(@NotNull MigrationExecutionService migrationExecutionService, @NotNull PlanRepository planRepository, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull ProjectManager projectManager, @NotNull CloudMigrationRegistrar cloudMigrationRegistrar, @NotNull PrcHttpClient prcHttpClient, @NotNull JiraServerMetadataProvider jiraServerMetadataProvider, @NotNull JiraMetadataService jiraMetadataService, @NotNull CloudProductManager cloudProductManager, @NotNull MigrationScopeManager migrationScopeManager, @NotNull MigrationFeatures migrationFeatures, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)migrationExecutionService, (String)"migrationExecutionService");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)((Object)cloudMigrationRegistrar), (String)"cloudMigrationRegistrar");
        Intrinsics.checkNotNullParameter((Object)prcHttpClient, (String)"prcHttpClient");
        Intrinsics.checkNotNullParameter((Object)jiraServerMetadataProvider, (String)"jiraServerMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)jiraMetadataService, (String)"jiraMetadataService");
        Intrinsics.checkNotNullParameter((Object)cloudProductManager, (String)"cloudProductManager");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.migrationExecutionService = migrationExecutionService;
        this.planRepository = planRepository;
        this.cloudSiteRepository = cloudSiteRepository;
        this.projectManager = projectManager;
        this.cloudMigrationRegistrar = cloudMigrationRegistrar;
        this.prcHttpClient = prcHttpClient;
        this.jiraServerMetadataProvider = jiraServerMetadataProvider;
        this.jiraMetadataService = jiraMetadataService;
        this.cloudProductManager = cloudProductManager;
        this.migrationScopeManager = migrationScopeManager;
        this.migrationFeatures = migrationFeatures;
        this.objectMapper = objectMapperFactory.createObjectMapperHandlingUnknownFields();
        this.commandName = CommandName.ENRICH_MIGRATION_DATA;
        this.payloadClassType = Reflection.getOrCreateKotlinClass(DataEnrichmentRequest.class);
    }

    @Override
    @NotNull
    public CommandName getCommandName() {
        return this.commandName;
    }

    @Override
    @NotNull
    public KClass<? extends PrcCommandPayload> getPayloadClassType() {
        return this.payloadClassType;
    }

    @Override
    public void executeTask(@NotNull PrcCommandPayload commandPayload, long prcCommandId) {
        Object $this$executeTask_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)commandPayload, (String)"commandPayload");
        DataEnrichmentRequest cfr_ignored_0 = (DataEnrichmentRequest)commandPayload;
        String cloudId2 = ((DataEnrichmentRequest)commandPayload).getMigration().getDestination().getCloudId();
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        if (cloudSite2 == null) {
            throw new CloudSiteNotFoundException(cloudId2);
        }
        CloudSite cloudSite3 = cloudSite2;
        Object object = this;
        try {
            $this$executeTask_u24lambda_u240 = object;
            boolean bl = false;
            JsonNode enrichedData = super.enrich((DataEnrichmentRequest)commandPayload, cloudSite3);
            LioUtil.publishFinalStatusToPrc$default(LioUtil.INSTANCE, String.valueOf(prcCommandId), ((DataEnrichmentRequest)commandPayload).getSourceCommandId(), enrichedData, cloudSite3.getContainerToken(), false, ((DataEnrichmentService)$this$executeTask_u24lambda_u240).prcHttpClient, 16, null);
            $this$executeTask_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$executeTask_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$executeTask_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            log.error("Error while enriching the data for commandId = " + prcCommandId, it);
            LioUtil lioUtil = LioUtil.INSTANCE;
            String string = String.valueOf(prcCommandId);
            String string2 = ((DataEnrichmentRequest)commandPayload).getSourceCommandId();
            ObjectNode objectNode = this.objectMapper.createObjectNode().put("error", it.getMessage());
            String string3 = cloudSite3.getContainerToken();
            PrcHttpClient prcHttpClient = this.prcHttpClient;
            Intrinsics.checkNotNull((Object)objectNode);
            lioUtil.publishFinalStatusToPrc(string, string2, (JsonNode)objectNode, string3, true, prcHttpClient);
            throw it;
        }
    }

    private final JsonNode enrich(DataEnrichmentRequest commandPayload, CloudSite cloudSite2) {
        Set set;
        Set set2;
        List list;
        String string = commandPayload.getPayload().getPlanId();
        Intrinsics.checkNotNull((Object)string);
        Plan plan2 = LioUtil.INSTANCE.getPlanById(string, cloudSite2.getCloudId(), this.planRepository);
        MigrationScopeId migrationScopeId2 = new MigrationScopeId(this.migrationScopeManager.getMigrationScope(cloudSite2));
        ContainerToken containerToken = ContainerToken.of((String)cloudSite2.getContainerToken());
        Intrinsics.checkNotNullExpressionValue((Object)containerToken, (String)"of(...)");
        MigrationMetaData migrationMetadata2 = MigrationExecutionService.getMigrationMetaData$default(this.migrationExecutionService, plan2, migrationScopeId2, containerToken, false, 8, null);
        List list2 = this.enrichProjectData(commandPayload.getPayload().getProjectIds(), plan2.getCloudId());
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        if ((list = this.enrichAppData(commandPayload.getPayload().getAppKeys())) == null) {
            list = CollectionsKt.emptyList();
        }
        Map<String, Object> map = this.migrationExecutionService.getMigrationProperties(plan2, migrationMetadata2);
        String string2 = this.jiraServerMetadataProvider.getJcmaVersion();
        String string3 = this.jiraMetadataService.getServerUrl();
        Map<String, String> map2 = this.jiraMetadataService.getSens();
        boolean bl = plan2.getMigrationTag() == MigrationTag.TEST;
        boolean bl2 = this.jiraMetadataService.isTestSite(plan2.getCloudUrl());
        boolean bl3 = plan2.isCrossDataEnabled();
        boolean bl4 = plan2.isLiftAndShift();
        boolean bl5 = this.migrationFeatures.getDisableSinglePathWithoutAttachments();
        JiraDataMigrationOption jiraDataMigrationOption = plan2.getJiraDataMigrationOption();
        boolean bl6 = (jiraDataMigrationOption != null ? jiraDataMigrationOption.getAttachmentsMigrationMode() : null) == JiraDataMigrationOption.AttachmentsMigrationMode.ALL;
        Set<String> set3 = plan2.getAppsMigrationOption().getExcludedAppsRequested();
        Set set4 = plan2.getAppsMigrationOption().getIncludedCloudApps();
        if (set4 == null) {
            set4 = set2 = SetsKt.emptySet();
        }
        if ((set = plan2.getAppsMigrationOption().getPreloadableApps()) == null) {
            set = SetsKt.emptySet();
        }
        Set set5 = set;
        List<Long> list3 = plan2.getAdvancedRoadmapsPlanIds();
        long l = list3 != null ? (long)list3.size() : 0L;
        Boolean bl7 = plan2.isShadowPlan();
        Boolean bl8 = plan2.getCanBeShadowed();
        ShadowMigrationProperties shadowMigrationProperties = new ShadowMigrationProperties(bl7 != null ? bl7 : false, bl8 != null ? bl8 : false, plan2.getOriginalMigrationId());
        Boolean bl9 = plan2.getUserPreMigration();
        boolean bl10 = bl9 != null ? bl9 : false;
        Map<String, Object> map3 = migrationMetadata2.getWorkplanConfig();
        Map<String, Map<String, Object>> map4 = migrationMetadata2.getMaxConcurrencyPerLoop();
        MigrationPlanSpecificData migrationPlanSpecificData = new MigrationPlanSpecificData(l, shadowMigrationProperties, bl10, map4, map3);
        EnrichmentResponse it = new EnrichmentResponse(list2, list, map, new EnrichedMetaData(string2, string3, map2, bl, bl2, bl3, bl4, bl5, bl6, set3, set2, migrationPlanSpecificData, set5));
        boolean bl11 = false;
        JsonNode jsonNode = this.objectMapper.valueToTree((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"enrichedData", (Object)it)));
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"let(...)");
        return jsonNode;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EnrichedProjectData> enrichProjectData(List<String> projectIds, String cloudId2) {
        List list;
        List<String> list2 = projectIds;
        if (list2 != null) {
            Project projectKey;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.projectManager.getProjectByCurrentKey((String)projectKey));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void project;
                projectKey = (Project)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = String.valueOf(project.getId());
                String string2 = project.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
                String string3 = project.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                String string4 = project.getProjectTypeKey().getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getKey(...)");
                String string5 = project.getProjectTypeKey().getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getKey(...)");
                String string6 = this.cloudProductManager.getSubProductByProjectTypeForCloud(cloudId2, string5).getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getKey(...)");
                collection.add(new EnrichedProjectData(string, string2, string3, string4, string6));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EnrichedAppData> enrichAppData(List<String> appKeys) {
        List list;
        List<String> list2 = appKeys;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void serverKey;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new EnrichedAppData((String)serverKey, CollectionsKt.toList((Iterable)this.cloudMigrationRegistrar.getRegisteredCloudKeys((String)serverKey))));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/lio/recipe/DataEnrichmentService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

