/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.lio.recipe;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteNotFoundException;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.execution.MigrationExecutionService;
import com.atlassian.jira.migration.execution.cache.MigrationExecutionCache;
import com.atlassian.jira.migration.lio.model.MigrationInitializationRequest;
import com.atlassian.jira.migration.lio.util.LioUtil;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.prc.PrcCommandExecutor;
import com.atlassian.jira.migration.prc.client.PrcHttpClient;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.MigrationScopeId;
import com.atlassian.migration.prc.model.CommandName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/lio/recipe/MigrationInitializationService;", "Lcom/atlassian/jira/migration/prc/PrcCommandExecutor;", "migrationExecutionService", "Lcom/atlassian/jira/migration/execution/MigrationExecutionService;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "prcHttpClient", "Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;", "migrationExecutionCache", "Lcom/atlassian/jira/migration/execution/cache/MigrationExecutionCache;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/execution/MigrationExecutionService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;Lcom/atlassian/jira/migration/execution/cache/MigrationExecutionCache;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "commandName", "Lcom/atlassian/migration/prc/model/CommandName;", "getCommandName", "()Lcom/atlassian/migration/prc/model/CommandName;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "payloadClassType", "Lkotlin/reflect/KClass;", "Lcom/atlassian/jira/migration/prc/model/PrcCommandPayload;", "getPayloadClassType", "()Lkotlin/reflect/KClass;", "executeTask", "", "commandPayload", "prcCommandId", "", "Companion", "jira-migration-plugin"})
public final class MigrationInitializationService
implements PrcCommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationExecutionService migrationExecutionService;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final PrcHttpClient prcHttpClient;
    @NotNull
    private final MigrationExecutionCache migrationExecutionCache;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final CommandName commandName;
    @NotNull
    private final KClass<? extends PrcCommandPayload> payloadClassType;
    private static final Logger log = LoggerFactory.getLogger(Companion.getClass());

    @Inject
    public MigrationInitializationService(@NotNull MigrationExecutionService migrationExecutionService, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull PlanRepository planRepository, @NotNull PrcHttpClient prcHttpClient, @NotNull MigrationExecutionCache migrationExecutionCache, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)migrationExecutionService, (String)"migrationExecutionService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)prcHttpClient, (String)"prcHttpClient");
        Intrinsics.checkNotNullParameter((Object)migrationExecutionCache, (String)"migrationExecutionCache");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.migrationExecutionService = migrationExecutionService;
        this.cloudSiteRepository = cloudSiteRepository;
        this.planRepository = planRepository;
        this.prcHttpClient = prcHttpClient;
        this.migrationExecutionCache = migrationExecutionCache;
        this.mapper = objectMapperFactory.createObjectMapperHandlingUnknownFields();
        this.commandName = CommandName.INITIALIZE_MIGRATION;
        this.payloadClassType = Reflection.getOrCreateKotlinClass(MigrationInitializationRequest.class);
    }

    @Override
    @NotNull
    public CommandName getCommandName() {
        return this.commandName;
    }

    @Override
    @NotNull
    public KClass<? extends PrcCommandPayload> getPayloadClassType() {
        return this.payloadClassType;
    }

    @Override
    public void executeTask(@NotNull PrcCommandPayload commandPayload, long prcCommandId) {
        Object $this$executeTask_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)commandPayload, (String)"commandPayload");
        MigrationInitializationRequest cfr_ignored_0 = (MigrationInitializationRequest)commandPayload;
        String cloudId2 = ((MigrationInitializationRequest)commandPayload).getMigration().getDestination().getCloudId();
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        if (cloudSite2 == null) {
            throw new CloudSiteNotFoundException(cloudId2);
        }
        CloudSite cloudSite3 = cloudSite2;
        Object object = this;
        try {
            $this$executeTask_u24lambda_u240 = object;
            boolean bl = false;
            String string = ((MigrationInitializationRequest)commandPayload).getPayload().getPlanId();
            Intrinsics.checkNotNull((Object)string);
            Plan plan2 = LioUtil.INSTANCE.getPlanById(string, cloudId2, ((MigrationInitializationService)$this$executeTask_u24lambda_u240).planRepository);
            MigrationId migrationId = new MigrationId(((MigrationInitializationRequest)commandPayload).getMigrationDetails().getMigrationId());
            MigrationScopeId migrationScopeId2 = new MigrationScopeId(((MigrationInitializationRequest)commandPayload).getMigrationDetails().getMigrationScopeId());
            String userKey = ((MigrationInitializationService)$this$executeTask_u24lambda_u240).migrationExecutionCache.getUserKeyForPlanId(plan2.getId());
            MigrationExecutionService.performPostMigrationCreationTasks$default(((MigrationInitializationService)$this$executeTask_u24lambda_u240).migrationExecutionService, plan2, migrationId, cloudSite3, null, 8, null);
            MigrationExecutionService.saveMigrationAndStartTracking$default(((MigrationInitializationService)$this$executeTask_u24lambda_u240).migrationExecutionService, migrationId, plan2, userKey, new ContainerToken(cloudSite3.getContainerToken()), migrationScopeId2, null, MigrationProtocol.V4, 32, null);
            String string2 = String.valueOf(prcCommandId);
            String string3 = ((MigrationInitializationRequest)commandPayload).getSourceCommandId();
            ObjectNode objectNode = ((MigrationInitializationService)$this$executeTask_u24lambda_u240).mapper.createObjectNode();
            Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"createObjectNode(...)");
            LioUtil.publishFinalStatusToPrc$default(LioUtil.INSTANCE, string2, string3, (JsonNode)objectNode, cloudSite3.getContainerToken(), false, ((MigrationInitializationService)$this$executeTask_u24lambda_u240).prcHttpClient, 16, null);
            $this$executeTask_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$executeTask_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$executeTask_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            log.error("Error while initializing migration for commandId = " + prcCommandId, it);
            String string = String.valueOf(prcCommandId);
            String string4 = ((MigrationInitializationRequest)commandPayload).getSourceCommandId();
            ObjectNode objectNode = this.mapper.createObjectNode().put("error", it.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"put(...)");
            LioUtil.INSTANCE.publishFinalStatusToPrc(string, string4, (JsonNode)objectNode, cloudSite3.getContainerToken(), true, this.prcHttpClient);
            throw it;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/lio/recipe/MigrationInitializationService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

