/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.lio.recipe;

import com.atlassian.jira.migration.cloud.CloudProductManager;
import com.atlassian.jira.migration.execution.LithiumMigrationsHelper;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraMetadataService;
import com.atlassian.jira.migration.lio.model.Command;
import com.atlassian.jira.migration.lio.model.Item;
import com.atlassian.jira.migration.lio.model.JiraProject;
import com.atlassian.jira.migration.lio.model.LioRecipeCreationException;
import com.atlassian.jira.migration.lio.model.MigrationRecipeInput;
import com.atlassian.jira.migration.lio.model.PbPCommonContext;
import com.atlassian.jira.migration.lio.model.PbPRecipeContext;
import com.atlassian.jira.migration.lio.model.RecipeExecutionRequest;
import com.atlassian.jira.migration.lio.model.RecipeType;
import com.atlassian.jira.migration.lio.recipe.AbstractPbPRecipeService;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.ContainerType;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.utils.CloudUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Deprecated(message="This service is deprecated, please make your changes in Flow Adaptor - https://bitbucket.org/atlassian/migration-api/src/main/flow-adapter/")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/lio/recipe/PbPRecipeService;", "Lcom/atlassian/jira/migration/lio/recipe/AbstractPbPRecipeService;", "jiraMetadataService", "Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "cloudProductManager", "Lcom/atlassian/jira/migration/cloud/CloudProductManager;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "cloudUtil", "Lcom/atlassian/jira/migration/utils/CloudUtil;", "lithiumMigrationsHelper", "Lcom/atlassian/jira/migration/execution/LithiumMigrationsHelper;", "(Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/cloud/CloudProductManager;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/utils/CloudUtil;Lcom/atlassian/jira/migration/execution/LithiumMigrationsHelper;)V", "createRecipeContext", "Lcom/atlassian/jira/migration/lio/model/PbPRecipeContext;", "migrationRecipeInput", "Lcom/atlassian/jira/migration/lio/model/MigrationRecipeInput;", "createRecipeExecutionRequest", "Lcom/atlassian/jira/migration/lio/model/RecipeExecutionRequest;", "recipeInput", "getItems", "", "Lcom/atlassian/jira/migration/lio/model/Item;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "isDryRun", "", "getLioRecipeVersion", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPbPRecipeService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PbPRecipeService.kt\ncom/atlassian/jira/migration/lio/recipe/PbPRecipeService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1549#2:99\n1620#2,3:100\n*S KotlinDebug\n*F\n+ 1 PbPRecipeService.kt\ncom/atlassian/jira/migration/lio/recipe/PbPRecipeService\n*L\n71#1:99\n71#1:100,3\n*E\n"})
public class PbPRecipeService
extends AbstractPbPRecipeService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final CloudProductManager cloudProductManager;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final CloudUtil cloudUtil;
    @NotNull
    private final LithiumMigrationsHelper lithiumMigrationsHelper;
    private static final int S2C_RECIPE_VERSION = 7;
    private static final int S2C_DRY_RUN_RECIPE_VERSION = 1;
    @NotNull
    private static final String PROJECT_TYPE = "projectType";
    @NotNull
    private static final String ANALYTICS_SUB_PRODUCT = "analyticsSubproduct";
    private static final Logger log = LoggerFactory.getLogger(PbPRecipeService.class);

    @Inject
    public PbPRecipeService(@NotNull JiraMetadataService jiraMetadataService, @NotNull ProjectManager projectManager, @NotNull CloudProductManager cloudProductManager, @NotNull PlatformService platformService, @NotNull MigrationFeatures migrationFeatures, @NotNull CloudUtil cloudUtil, @NotNull LithiumMigrationsHelper lithiumMigrationsHelper) {
        Intrinsics.checkNotNullParameter((Object)jiraMetadataService, (String)"jiraMetadataService");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)cloudProductManager, (String)"cloudProductManager");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)cloudUtil, (String)"cloudUtil");
        Intrinsics.checkNotNullParameter((Object)lithiumMigrationsHelper, (String)"lithiumMigrationsHelper");
        super(jiraMetadataService, migrationFeatures, lithiumMigrationsHelper);
        this.projectManager = projectManager;
        this.cloudProductManager = cloudProductManager;
        this.platformService = platformService;
        this.migrationFeatures = migrationFeatures;
        this.cloudUtil = cloudUtil;
        this.lithiumMigrationsHelper = lithiumMigrationsHelper;
    }

    @Override
    @NotNull
    public RecipeExecutionRequest createRecipeExecutionRequest(@NotNull MigrationRecipeInput recipeInput) {
        Intrinsics.checkNotNullParameter((Object)recipeInput, (String)"recipeInput");
        try {
            String string = recipeInput.getDryRun() ? RecipeType.JIRA_S2C_DRY_RUN_MIGRATION.toString() : RecipeType.JIRA_S2C_MIGRATION.toString();
            int n = this.getLioRecipeVersion(recipeInput.getDryRun());
            Command command = Command.START;
            PbPCommonContext pbPCommonContext = this.createCommonContext(recipeInput);
            PbPRecipeContext pbPRecipeContext = this.createRecipeContext(recipeInput);
            String string2 = recipeInput.getMigrationId().toString();
            String string3 = recipeInput.getMigrationId().toString();
            ImmutableList<String> immutableList = this.getMigrationTags();
            Intrinsics.checkNotNull((Object)string2);
            return new RecipeExecutionRequest(string, string3, string2, pbPRecipeContext, pbPCommonContext, (List)immutableList, command, n);
        }
        catch (Exception e) {
            log.error("Error creating recipe execution request " + e);
            throw new LioRecipeCreationException("Error creating recipe execution request. Please check input", e);
        }
    }

    private final PbPRecipeContext createRecipeContext(MigrationRecipeInput migrationRecipeInput) {
        String string = migrationRecipeInput.getMigrationId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        List<Item> list = this.getItems(migrationRecipeInput.getPlan(), migrationRecipeInput.getDryRun());
        Map<String, Object> map = this.getMigrationProperties(migrationRecipeInput);
        Map<String, Object> map2 = migrationRecipeInput.getWorkplanConfig();
        String string2 = migrationRecipeInput.getPlan().getCloudRegion();
        if (string2 == null) {
            string2 = this.cloudUtil.getCloudSiteRegion(migrationRecipeInput.getPlan().getCloudId());
        }
        return new PbPRecipeContext(string, list, map, map2, string2, migrationRecipeInput.getPlan().getCloudId());
    }

    private final int getLioRecipeVersion(boolean isDryRun) {
        return isDryRun ? 1 : 7;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Item> getItems(Plan plan2, boolean isDryRun) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = plan2.getProjectKeys();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Project jiraProject = this.projectManager.getProjectByCurrentKey((String)it);
            ContainerType containerType = ContainerType.JiraProject;
            List<String> list = this.platformService.getJiraProjectContainerSelections(plan2, isDryRun);
            String string2 = String.valueOf(jiraProject.getId());
            Pair[] pairArray = new Pair[2];
            String string3 = plan2.getCloudId();
            String string4 = jiraProject.getProjectTypeKey().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getKey(...)");
            pairArray[0] = TuplesKt.to((Object)ANALYTICS_SUB_PRODUCT, (Object)this.cloudProductManager.getSubProductByProjectTypeForCloud(string3, string4).getKey());
            pairArray[1] = TuplesKt.to((Object)PROJECT_TYPE, (Object)jiraProject.getProjectTypeKey().getKey());
            Map map = MapsKt.mapOf((Pair[])pairArray);
            collection.add(new JiraProject(containerType, list, map, string2, (String)it));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/lio/recipe/PbPRecipeService$Companion;", "", "()V", "ANALYTICS_SUB_PRODUCT", "", "PROJECT_TYPE", "S2C_DRY_RUN_RECIPE_VERSION", "", "S2C_RECIPE_VERSION", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

