/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.lio.service;

import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricsExportTrigger;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.RecipeExecutionRequestFailedEvent;
import com.atlassian.jira.migration.events.RecipeExecutionStartedEvent;
import com.atlassian.jira.migration.execution.cache.MigrationExecutionCache;
import com.atlassian.jira.migration.lio.model.MigrationRecipeInput;
import com.atlassian.jira.migration.lio.model.RecipeExecutionRequest;
import com.atlassian.jira.migration.lio.model.RecipeInput;
import com.atlassian.jira.migration.lio.model.RecipeName;
import com.atlassian.jira.migration.lio.recipe.PbPRecipeService;
import com.atlassian.jira.migration.lio.service.RecipeExecutionService;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.publicapi.client.MigrationClient;
import com.atlassian.jira.migration.publicapi.model.LioExecutionId;
import com.atlassian.jira.migration.publicapi.model.MigrationDefinition;
import com.atlassian.jira.migration.publicapi.service.PlanTransformationService;
import com.atlassian.jira.migration.utils.CloudUtil;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"BI\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u0013\u001a)\u0012\u0004\u0012\u00020\u0015\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/lio/service/RecipeExecutionServiceImpl;", "Lcom/atlassian/jira/migration/lio/service/RecipeExecutionService;", "pbPRecipeService", "Lcom/atlassian/jira/migration/lio/recipe/PbPRecipeService;", "migrationClient", "Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "cloudUtil", "Lcom/atlassian/jira/migration/utils/CloudUtil;", "migrationExecutionCache", "Lcom/atlassian/jira/migration/execution/cache/MigrationExecutionCache;", "planTransformationService", "Lcom/atlassian/jira/migration/publicapi/service/PlanTransformationService;", "prometheusMetricsExportTrigger", "Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricsExportTrigger;", "(Lcom/atlassian/jira/migration/lio/recipe/PbPRecipeService;Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/utils/CloudUtil;Lcom/atlassian/jira/migration/execution/cache/MigrationExecutionCache;Lcom/atlassian/jira/migration/publicapi/service/PlanTransformationService;Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricsExportTrigger;)V", "recipeExecutionMap", "", "Lcom/atlassian/jira/migration/lio/model/RecipeName;", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/lio/model/RecipeInput;", "Lkotlin/ParameterName;", "name", "recipeInput", "", "executeMigrationCreation", "recipeInfo", "executeMigrationExecution", "migrationRecipeInput", "Lcom/atlassian/jira/migration/lio/model/MigrationRecipeInput;", "executeRecipe", "Companion", "jira-migration-plugin"})
public final class RecipeExecutionServiceImpl
implements RecipeExecutionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PbPRecipeService pbPRecipeService;
    @NotNull
    private final MigrationClient migrationClient;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final CloudUtil cloudUtil;
    @NotNull
    private final MigrationExecutionCache migrationExecutionCache;
    @NotNull
    private final PlanTransformationService planTransformationService;
    @NotNull
    private final PrometheusMetricsExportTrigger prometheusMetricsExportTrigger;
    @NotNull
    private final Map<RecipeName, Function1<RecipeInput, Unit>> recipeExecutionMap;
    private static final Logger log = LoggerFactory.getLogger(RecipeExecutionServiceImpl.class);

    @Inject
    public RecipeExecutionServiceImpl(@Qualifier(value="pbPRecipeService") @NotNull PbPRecipeService pbPRecipeService, @NotNull MigrationClient migrationClient, @NotNull MigrationServiceClient migrationServiceClient, @NotNull MigrationEventBus migrationEventBus, @NotNull CloudUtil cloudUtil, @NotNull MigrationExecutionCache migrationExecutionCache, @NotNull PlanTransformationService planTransformationService, @NotNull PrometheusMetricsExportTrigger prometheusMetricsExportTrigger) {
        Intrinsics.checkNotNullParameter((Object)pbPRecipeService, (String)"pbPRecipeService");
        Intrinsics.checkNotNullParameter((Object)migrationClient, (String)"migrationClient");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)cloudUtil, (String)"cloudUtil");
        Intrinsics.checkNotNullParameter((Object)migrationExecutionCache, (String)"migrationExecutionCache");
        Intrinsics.checkNotNullParameter((Object)planTransformationService, (String)"planTransformationService");
        Intrinsics.checkNotNullParameter((Object)prometheusMetricsExportTrigger, (String)"prometheusMetricsExportTrigger");
        this.pbPRecipeService = pbPRecipeService;
        this.migrationClient = migrationClient;
        this.migrationServiceClient = migrationServiceClient;
        this.migrationEventBus = migrationEventBus;
        this.cloudUtil = cloudUtil;
        this.migrationExecutionCache = migrationExecutionCache;
        this.planTransformationService = planTransformationService;
        this.prometheusMetricsExportTrigger = prometheusMetricsExportTrigger;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)RecipeName.MIGRATION_EXECUTION_RECIPE), (Object)new Function1<RecipeInput, Unit>(this){
            final /* synthetic */ RecipeExecutionServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RecipeInput recipeInput) {
                Intrinsics.checkNotNullParameter((Object)recipeInput, (String)"recipeInput");
                MigrationRecipeInput migrationRecipeInput = (MigrationRecipeInput)recipeInput;
                RecipeExecutionServiceImpl.access$executeMigrationExecution(this.this$0, migrationRecipeInput);
                RecipeExecutionServiceImpl.access$getPrometheusMetricsExportTrigger$p(this.this$0).start(migrationRecipeInput.getPlan().getCloudId(), ((MigrationRecipeInput)recipeInput).getMigrationId());
            }
        }), TuplesKt.to((Object)((Object)RecipeName.MIGRATION_CREATION_RECIPE), (Object)new Function1<RecipeInput, Unit>(this){
            final /* synthetic */ RecipeExecutionServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RecipeInput recipeInput) {
                Intrinsics.checkNotNullParameter((Object)recipeInput, (String)"recipeInput");
                RecipeExecutionServiceImpl.access$executeMigrationCreation(this.this$0, recipeInput);
            }
        })};
        this.recipeExecutionMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public void executeRecipe(@NotNull RecipeInput recipeInfo) {
        Intrinsics.checkNotNullParameter((Object)recipeInfo, (String)"recipeInfo");
        Function1<RecipeInput, Unit> function1 = this.recipeExecutionMap.get((Object)recipeInfo.getRecipeName());
        Intrinsics.checkNotNull(function1);
        function1.invoke((Object)recipeInfo);
    }

    private final void executeMigrationExecution(MigrationRecipeInput migrationRecipeInput) {
        RecipeExecutionRequest recipeExecutionRequest = this.pbPRecipeService.createRecipeExecutionRequest(migrationRecipeInput);
        String cloudRegion = migrationRecipeInput.getPlan().getCloudRegion();
        if (cloudRegion == null) {
            cloudRegion = this.cloudUtil.getCloudSiteRegion(migrationRecipeInput.getPlan().getCloudId());
        }
        try {
            log.info("Executing recipe for migration " + migrationRecipeInput.getMigrationId());
            String string = migrationRecipeInput.getContainerToken();
            String string2 = migrationRecipeInput.getMigrationId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = migrationRecipeInput.getMigrationScopeId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            this.migrationServiceClient.executeRecipe(string, string2, cloudRegion, string3, recipeExecutionRequest);
            String string4 = migrationRecipeInput.getMigrationId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            this.migrationEventBus.post(new RecipeExecutionStartedEvent(string4, recipeExecutionRequest.getExecutionId(), recipeExecutionRequest.getName(), cloudRegion, recipeExecutionRequest.getVersion()));
            log.info("Recipe execution started for migration " + migrationRecipeInput.getMigrationId() + " and recipeExecutionId: " + recipeExecutionRequest.getExecutionId());
        }
        catch (Exception e) {
            String string = migrationRecipeInput.getMigrationId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.migrationEventBus.post(new RecipeExecutionRequestFailedEvent(string, recipeExecutionRequest.getExecutionId(), recipeExecutionRequest.getName(), cloudRegion, recipeExecutionRequest.getVersion()));
            log.error("Recipe execution failed with error: " + e);
            throw e;
        }
    }

    private final void executeMigrationCreation(RecipeInput recipeInfo) {
        Object $this$executeMigrationCreation_u24lambda_u241;
        Object object = this;
        try {
            LioExecutionId lioExecutionId;
            $this$executeMigrationCreation_u24lambda_u241 = object;
            boolean bl = false;
            ((RecipeExecutionServiceImpl)$this$executeMigrationCreation_u24lambda_u241).migrationExecutionCache.addInFlightPlanKey(recipeInfo.getPlan().getId());
            MigrationDefinition mapiJobDefinition = ((RecipeExecutionServiceImpl)$this$executeMigrationCreation_u24lambda_u241).planTransformationService.transform(recipeInfo.getPlan());
            LioExecutionId it = lioExecutionId = ((RecipeExecutionServiceImpl)$this$executeMigrationCreation_u24lambda_u241).migrationClient.executeMigrationCreationRecipe(recipeInfo.getContainerToken(), recipeInfo.getPlan().getId(), mapiJobDefinition);
            boolean bl2 = false;
            log.info("LiO executionId for planId = " + recipeInfo.getPlan().getId() + " is executionId = " + it.getExecutionId());
            $this$executeMigrationCreation_u24lambda_u241 = Result.constructor-impl((Object)lioExecutionId);
        }
        catch (Throwable bl) {
            $this$executeMigrationCreation_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$executeMigrationCreation_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            log.error("Migration creation recipe execution failed with an error", it);
            throw it;
        }
    }

    public static final /* synthetic */ void access$executeMigrationExecution(RecipeExecutionServiceImpl $this, MigrationRecipeInput migrationRecipeInput) {
        $this.executeMigrationExecution(migrationRecipeInput);
    }

    public static final /* synthetic */ PrometheusMetricsExportTrigger access$getPrometheusMetricsExportTrigger$p(RecipeExecutionServiceImpl $this) {
        return $this.prometheusMetricsExportTrigger;
    }

    public static final /* synthetic */ void access$executeMigrationCreation(RecipeExecutionServiceImpl $this, RecipeInput recipeInfo) {
        $this.executeMigrationCreation(recipeInfo);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/lio/service/RecipeExecutionServiceImpl$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

