/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.lio.service;

import com.atlassian.jira.migration.export.db.core.JiraIssueReader;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jdmccservice.JdmccService;
import com.atlassian.jira.migration.jdmccservice.ProjectDetail;
import com.atlassian.jira.migration.lio.model.WorkplanConfigRequest;
import com.atlassian.jira.migration.lio.model.WorkplanConfigResponse;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.utils.CloudUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationScopeId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00010\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00010\u0019J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/lio/service/WorkplanConfigProviderService;", "", "jdmccService", "Lcom/atlassian/jira/migration/jdmccservice/JdmccService;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "jiraIssueReader", "Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;", "cloudUtil", "Lcom/atlassian/jira/migration/utils/CloudUtil;", "(Lcom/atlassian/jira/migration/jdmccservice/JdmccService;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;Lcom/atlassian/jira/migration/utils/CloudUtil;)V", "createWorkPlanConfigRequest", "Lcom/atlassian/jira/migration/lio/model/WorkplanConfigRequest;", "projectDetails", "", "Lcom/atlassian/jira/migration/jdmccservice/ProjectDetail;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "getDataMovementIdFromWorkplanConfig", "", "config", "", "getProjectConcurrencyFromWorkplanConfig", "", "getProjectDetails", "getWorkplanConfig", "migrationScopeId", "Lcom/atlassian/migration/api/MigrationScopeId;", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nWorkplanConfigProviderService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkplanConfigProviderService.kt\ncom/atlassian/jira/migration/lio/service/WorkplanConfigProviderService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1549#2:94\n1620#2,3:95\n*S KotlinDebug\n*F\n+ 1 WorkplanConfigProviderService.kt\ncom/atlassian/jira/migration/lio/service/WorkplanConfigProviderService\n*L\n55#1:94\n55#1:95,3\n*E\n"})
public final class WorkplanConfigProviderService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JdmccService jdmccService;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final JiraIssueReader jiraIssueReader;
    @NotNull
    private final CloudUtil cloudUtil;
    private static final Logger log = LoggerFactory.getLogger(WorkplanConfigProviderService.class);
    @NotNull
    public static final String MIN_WORKER = "minWorker";
    @NotNull
    public static final String MAX_WORKER = "maxWorker";
    @NotNull
    public static final String PROJECT_CONCURRENCY = "projectConcurrency";
    @NotNull
    public static final String DATA_MOVEMENT_ID = "dataMovementId";

    @Inject
    public WorkplanConfigProviderService(@NotNull JdmccService jdmccService, @NotNull ProjectManager projectManager, @NotNull MigrationFeatures migrationFeatures, @NotNull MigrationServiceClient migrationServiceClient, @NotNull JiraIssueReader jiraIssueReader, @NotNull CloudUtil cloudUtil) {
        Intrinsics.checkNotNullParameter((Object)jdmccService, (String)"jdmccService");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)jiraIssueReader, (String)"jiraIssueReader");
        Intrinsics.checkNotNullParameter((Object)cloudUtil, (String)"cloudUtil");
        this.jdmccService = jdmccService;
        this.projectManager = projectManager;
        this.migrationFeatures = migrationFeatures;
        this.migrationServiceClient = migrationServiceClient;
        this.jiraIssueReader = jiraIssueReader;
        this.cloudUtil = cloudUtil;
    }

    @NotNull
    public final Map<String, Object> getWorkplanConfig(@NotNull Plan plan2, @NotNull MigrationScopeId migrationScopeId2, @NotNull ContainerToken containerToken) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        if (plan2.isUsersOnly() || plan2.isV2AttachmentsOnly()) {
            return MapsKt.emptyMap();
        }
        List<ProjectDetail> projectDetails = this.getProjectDetails(plan2);
        String string = plan2.getCloudRegion();
        if (string == null) {
            string = this.cloudUtil.getCloudSiteRegion(plan2.getCloudId());
        }
        String cloudRegion = string;
        WorkplanConfigRequest workplanConfigRequest = this.createWorkPlanConfigRequest(projectDetails, plan2);
        String string2 = containerToken.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = migrationScopeId2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        WorkplanConfigResponse workplanConfigResponse = this.migrationServiceClient.createWorkplanConfig(workplanConfigRequest, string2, cloudRegion, string3);
        log.info("Successfully fetched workplan config from migration service: ", (Object)workplanConfigResponse.getWorkplanConfig().toString());
        boolean isScalingThresholdTimeoutOrFailure = this.jdmccService.awaitInfraScaling(workplanConfigResponse.getInfraScaling(), this.getDataMovementIdFromWorkplanConfig(workplanConfigResponse.getWorkplanConfig()), containerToken, plan2);
        if (isScalingThresholdTimeoutOrFailure) {
            workplanConfigResponse.getWorkplanConfig().put(PROJECT_CONCURRENCY, 8);
            log.warn("Unable to get successful response for project concurrency for cloudId: " + plan2.getCloudId() + ". Setting default project concurrency to 8");
        }
        return workplanConfigResponse.getWorkplanConfig();
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProjectDetail> getProjectDetails(Plan plan2) {
        List list;
        if (!((Collection)plan2.getProjectKeys()).isEmpty()) {
            Project it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = plan2.getProjectKeys();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.projectManager.getProjectByCurrentKey((String)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void project;
                it = (Project)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Long l = project.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                Boolean bl2 = plan2.getMigrateArchivedIssues();
                collection.add(new ProjectDetail(this.jiraIssueReader.getIssueCountForProject(((Number)l).longValue(), bl2 != null ? bl2 : false), project.getKey(), project.getProjectTypeKey().getKey()));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final int getProjectConcurrencyFromWorkplanConfig(@NotNull Map<String, ? extends Object> config2) {
        Intrinsics.checkNotNullParameter(config2, (String)"config");
        Object object = config2.get(PROJECT_CONCURRENCY);
        Integer n = object instanceof Integer ? (Integer)object : null;
        return n != null ? n : 2;
    }

    private final String getDataMovementIdFromWorkplanConfig(Map<String, ? extends Object> config2) {
        Object object = config2.get(DATA_MOVEMENT_ID);
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final WorkplanConfigRequest createWorkPlanConfigRequest(@NotNull List<ProjectDetail> projectDetails, @NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter(projectDetails, (String)"projectDetails");
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        if (this.migrationFeatures.getEnableScaleRDS()) {
            return new WorkplanConfigRequest(projectDetails, plan2.getCloudId(), String.valueOf((Object)plan2.getMigrationTag()), true);
        }
        return new WorkplanConfigRequest(projectDetails, plan2.getCloudId(), null, null, 12, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/lio/service/WorkplanConfigProviderService$Companion;", "", "()V", "DATA_MOVEMENT_ID", "", "MAX_WORKER", "MIN_WORKER", "PROJECT_CONCURRENCY", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

