/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.lio.util;

import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanCloudIdMismatchedException;
import com.atlassian.jira.migration.plan.PlanNotFoundException;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.prc.client.PrcHttpClient;
import com.atlassian.migration.prc.model.CommandSource;
import com.atlassian.migration.statusrouter.model.CommandStatus;
import com.atlassian.migration.statusrouter.model.CommandStatusRequest;
import com.fasterxml.jackson.databind.JsonNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/lio/util/LioUtil;", "", "()V", "getPlanById", "Lcom/atlassian/jira/migration/plan/Plan;", "planId", "", "prcDestinationId", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "publishFinalStatusToPrc", "", "prcCommandId", "sourceCommandId", "response", "Lcom/fasterxml/jackson/databind/JsonNode;", "containerToken", "isFailed", "", "prcHttpClient", "Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;", "jira-migration-plugin"})
public final class LioUtil {
    @NotNull
    public static final LioUtil INSTANCE = new LioUtil();

    private LioUtil() {
    }

    public final void publishFinalStatusToPrc(@NotNull String prcCommandId, @NotNull String sourceCommandId, @NotNull JsonNode response2, @NotNull String containerToken, boolean isFailed, @NotNull PrcHttpClient prcHttpClient) {
        Intrinsics.checkNotNullParameter((Object)prcCommandId, (String)"prcCommandId");
        Intrinsics.checkNotNullParameter((Object)sourceCommandId, (String)"sourceCommandId");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)prcHttpClient, (String)"prcHttpClient");
        prcHttpClient.publishFinalStatus(prcCommandId, new CommandStatusRequest(CommandSource.LIO, isFailed ? CommandStatus.FAILED : CommandStatus.SUCCESS, sourceCommandId, response2), containerToken);
    }

    public static /* synthetic */ void publishFinalStatusToPrc$default(LioUtil lioUtil, String string, String string2, JsonNode jsonNode, String string3, boolean bl, PrcHttpClient prcHttpClient, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        lioUtil.publishFinalStatusToPrc(string, string2, jsonNode, string3, bl, prcHttpClient);
    }

    @NotNull
    public final Plan getPlanById(@NotNull String planId, @NotNull String prcDestinationId, @NotNull PlanRepository planRepository) {
        Plan plan2;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)prcDestinationId, (String)"prcDestinationId");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Plan plan3 = planRepository.get(planId);
        if (plan3 != null) {
            Plan it = plan2 = plan3;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getCloudId(), (Object)prcDestinationId)) {
                throw new PlanCloudIdMismatchedException(prcDestinationId, it.getCloudId());
            }
        } else {
            throw new PlanNotFoundException();
        }
        return plan2;
    }
}

