/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.listeners;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.app.CloudMigrationRegistrar;
import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.jira.migration.listeners.AppListenerIssueType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.tracking.utils.TimeProvider;
import com.atlassian.jira.migration.version.JiraMigrationVersionService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.app.dto.MigrationPath;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/listeners/AppListenerIssueService;", "", "appMigrationRegistrar", "Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;", "aggregatorClient", "Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "jiraMigrationVersionService", "Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "timeProvider", "Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;", "(Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;Lcom/atlassian/plugin/PluginAccessor;Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "determineIssue", "Lcom/atlassian/jira/migration/listeners/AppListenerIssueType;", "appKey", "", "getProblemMessage", "issueType", "sendListenerIssueAnalytics", "", "warnAppsWithProblems", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppListenerIssueService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppListenerIssueService.kt\ncom/atlassian/jira/migration/listeners/AppListenerIssueService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1855#2,2:97\n*S KotlinDebug\n*F\n+ 1 AppListenerIssueService.kt\ncom/atlassian/jira/migration/listeners/AppListenerIssueService\n*L\n35#1:97,2\n*E\n"})
public final class AppListenerIssueService {
    @NotNull
    private final CloudMigrationRegistrar appMigrationRegistrar;
    @NotNull
    private final AppAggregatorClient aggregatorClient;
    @NotNull
    private final PluginAccessor pluginAccessor;
    @NotNull
    private final JiraMigrationVersionService jiraMigrationVersionService;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final TimeProvider timeProvider;
    private final Logger log;

    @Inject
    public AppListenerIssueService(@NotNull CloudMigrationRegistrar appMigrationRegistrar, @NotNull AppAggregatorClient aggregatorClient, @NotNull PluginAccessor pluginAccessor, @NotNull JiraMigrationVersionService jiraMigrationVersionService, @NotNull SENSupplier senSupplier, @NotNull AnalyticsEventService analyticsEventService, @NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)appMigrationRegistrar), (String)"appMigrationRegistrar");
        Intrinsics.checkNotNullParameter((Object)aggregatorClient, (String)"aggregatorClient");
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.appMigrationRegistrar = appMigrationRegistrar;
        this.aggregatorClient = aggregatorClient;
        this.pluginAccessor = pluginAccessor;
        this.jiraMigrationVersionService = jiraMigrationVersionService;
        this.senSupplier = senSupplier;
        this.analyticsEventService = analyticsEventService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.timeProvider = timeProvider;
        this.log = LoggerFactory.getLogger(AppListenerIssueService.class);
    }

    public final void warnAppsWithProblems(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Set set = plan2.getAppsMigrationOption().getIncludedApps();
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Set appKeys = set;
        Iterable $this$forEach$iv = appKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String appKey = (String)element$iv;
            boolean bl = false;
            AppListenerIssueType issueType = this.determineIssue(appKey);
            if (issueType == null) continue;
            String message = this.getProblemMessage(appKey, issueType);
            this.log.warn(message);
            this.sendListenerIssueAnalytics(appKey, issueType);
        }
    }

    @Nullable
    public final AppListenerIssueType determineIssue(@NotNull String appKey) {
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        boolean hasRegisteredListener = !((Collection)this.appMigrationRegistrar.getRegisteredCloudKeys(appKey)).isEmpty();
        MigrationPath migrationPath = this.aggregatorClient.getServerAppData(appKey).getMigrationPath();
        return migrationPath == MigrationPath.INSTALL_ONLY && hasRegisteredListener ? AppListenerIssueType.INSTALL_ONLY_WITH_SERVER_LISTENER : (migrationPath == MigrationPath.AUTOMATED && !hasRegisteredListener ? AppListenerIssueType.AUTOMATED_WITHOUT_SERVER_LISTENER : null);
    }

    private final String getProblemMessage(String appKey, AppListenerIssueType issueType) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[issueType.ordinal()]) {
            case 1: {
                string = appKey + " may not be install only because a server listener was found. This app will be ignored during production app migrations (i.e. with dev mode turned off). Contact Atlassian support to remove this app from install only list.";
                break;
            }
            case 2: {
                string = appKey + " has an automated path but missing a server listener. This app will be ignored during app migration.";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final void sendListenerIssueAnalytics(String appKey, AppListenerIssueType issueType) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"pluginVersion", (Object)this.jiraMigrationVersionService.getJiraServerVersion()), TuplesKt.to((Object)"appKey", (Object)appKey), TuplesKt.to((Object)"appVersion", (Object)this.pluginAccessor.getPlugin(appKey).getPluginInformation().getVersion()), TuplesKt.to((Object)"issueType", (Object)issueType.name())};
        GenericOperationalEvent event = ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.timeProvider.now().toEpochMilli()).source("startMigration")).actionSubject("appServerListenerIssue")).action("occurred")).sen(this.senSupplier.getFirstSen())).withAttributes(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNull((Object)event);
        ApplicationUser applicationUser = this.jiraAuthenticationContext.getLoggedInUser();
        this.analyticsEventService.saveAnalyticsEvent((EventDto)event, applicationUser != null ? applicationUser.getEmailAddress() : null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AppListenerIssueType.values().length];
            try {
                nArray[AppListenerIssueType.INSTALL_ONLY_WITH_SERVER_LISTENER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppListenerIssueType.AUTOMATED_WITHOUT_SERVER_LISTENER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

