/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.lock;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.migration.lock.ExecutionStatus;
import com.atlassian.jira.migration.lock.MigrationClusterLockServiceKt;
import com.atlassian.jira.migration.lock.MigrationLockContext;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00150\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J+\u0010\u001c\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u001d\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/lock/MigrationClusterLockService;", "", "clusterLockService", "Lcom/atlassian/beehive/ClusterLockService;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "(Lcom/atlassian/beehive/ClusterLockService;Lcom/atlassian/cache/CacheManager;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "migrationLockIdCache", "Lcom/atlassian/cache/Cache;", "", "Ljava/time/Instant;", "timeToWaitForCacheReplication", "Lkotlin/time/Duration;", "getTimeToWaitForCacheReplication-UwyO8pc", "()J", "J", "executeWithLock", "Lcom/atlassian/jira/migration/lock/ExecutionStatus;", "T", "migrationLockContext", "Lcom/atlassian/jira/migration/lock/MigrationLockContext;", "block", "Lkotlin/Function1;", "waitForCacheToReplicate", "", "withClusterLock", "lockContext", "Lkotlin/Function0;", "(Lcom/atlassian/jira/migration/lock/MigrationLockContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "jira-migration-plugin"})
public class MigrationClusterLockService {
    @NotNull
    private final ClusterLockService clusterLockService;
    private final long timeToWaitForCacheReplication;
    private final Logger log;
    @NotNull
    private final Cache<String, Instant> migrationLockIdCache;

    @Inject
    public MigrationClusterLockService(@NotNull ClusterLockService clusterLockService, @NotNull CacheManager cacheManager) {
        Intrinsics.checkNotNullParameter((Object)clusterLockService, (String)"clusterLockService");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        this.clusterLockService = clusterLockService;
        this.timeToWaitForCacheReplication = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
        this.log = LoggerFactory.getLogger(MigrationClusterLockService.class);
        Cache cache2 = cacheManager.getCache(MigrationClusterLockService.class.getName() + ".lock.id.processed", null, new CacheSettingsBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).maxEntries(20).replicateViaCopy().remote().replicateSynchronously().build());
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"getCache(...)");
        this.migrationLockIdCache = cache2;
    }

    public long getTimeToWaitForCacheReplication-UwyO8pc() {
        return this.timeToWaitForCacheReplication;
    }

    @NotNull
    public final <T> ExecutionStatus<T> executeWithLock(@NotNull MigrationLockContext migrationLockContext, @NotNull Function1<? super MigrationLockContext, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)migrationLockContext, (String)"migrationLockContext");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ExecutionStatus executionStatus = (ExecutionStatus)this.withClusterLock(migrationLockContext, (Function0)new Function0<ExecutionStatus<? extends T>>(this, migrationLockContext, block){
            final /* synthetic */ MigrationClusterLockService this$0;
            final /* synthetic */ MigrationLockContext $migrationLockContext;
            final /* synthetic */ Function1<MigrationLockContext, T> $block;
            {
                this.this$0 = $receiver;
                this.$migrationLockContext = $migrationLockContext;
                this.$block = $block;
                super(0);
            }

            @NotNull
            public final ExecutionStatus<T> invoke() {
                ExecutionStatus executionStatus;
                Instant timeMigrationIdWasProcessed = (Instant)MigrationClusterLockService.access$getMigrationLockIdCache$p(this.this$0).get((Object)MigrationClusterLockServiceKt.getLockId(this.$migrationLockContext));
                if (timeMigrationIdWasProcessed == null) {
                    Object object;
                    MigrationClusterLockService.access$getLog$p(this.this$0).info("Saving migration lockId " + MigrationClusterLockServiceKt.getLockId(this.$migrationLockContext) + " into cache");
                    MigrationClusterLockService.access$getMigrationLockIdCache$p(this.this$0).put((Object)MigrationClusterLockServiceKt.getLockId(this.$migrationLockContext), (Object)Instant.now());
                    MigrationClusterLockService migrationClusterLockService = this.this$0;
                    Function1<MigrationLockContext, T> function1 = this.$block;
                    MigrationLockContext migrationLockContext = this.$migrationLockContext;
                    try {
                        MigrationClusterLockService $this$invoke_u24lambda_u240 = migrationClusterLockService;
                        boolean bl = false;
                        object = Result.constructor-impl((Object)function1.invoke((Object)migrationLockContext));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    Object result2 = object;
                    MigrationClusterLockService.access$waitForCacheToReplicate(this.this$0);
                    executionStatus = new ExecutionStatus.Executed<T>(result2);
                } else {
                    MigrationClusterLockService.access$getLog$p(this.this$0).info("migrationId lockId " + MigrationClusterLockServiceKt.getLockId(this.$migrationLockContext) + ", was already processed at " + timeMigrationIdWasProcessed);
                    executionStatus = ExecutionStatus.SkippedAsDuplicated.INSTANCE;
                }
                return executionStatus;
            }
        });
        if (executionStatus == null) {
            executionStatus = ExecutionStatus.SkippedAsDuplicated.INSTANCE;
        }
        return executionStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withClusterLock(MigrationLockContext lockContext, Function0<? extends T> block) {
        ClusterLock lock = this.clusterLockService.getLockForName(lockContext.getLockName());
        if (lock.tryLock(lockContext.getWaitTime(), lockContext.getWaitTimeUnit())) {
            this.log.info("Obtained lock name: " + lockContext.getLockName() + " for migrationId: " + lockContext.getMigrationId());
            try {
                Object object = block.invoke();
                return (T)object;
            }
            finally {
                lock.unlock();
            }
        }
        this.log.warn("Lock name : " + lockContext.getLockName() + " was not obtained, migration lock: " + lockContext.getMigrationId());
        return null;
    }

    private final void waitForCacheToReplicate() {
        Thread.sleep(Duration.getInWholeMilliseconds-impl((long)this.getTimeToWaitForCacheReplication-UwyO8pc()));
    }

    public static final /* synthetic */ Cache access$getMigrationLockIdCache$p(MigrationClusterLockService $this) {
        return $this.migrationLockIdCache;
    }

    public static final /* synthetic */ Logger access$getLog$p(MigrationClusterLockService $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$waitForCacheToReplicate(MigrationClusterLockService $this) {
        $this.waitForCacheToReplicate();
    }
}

