/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.WithKey;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.migration.common.Identifiable;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.log.EntityIdentifierGeneratorKt;
import com.atlassian.jira.migration.log.EntityResolver;
import com.atlassian.jira.migration.log.MessageEntityIdentifier;
import com.atlassian.jira.migration.log.UserWrapper;
import com.atlassian.jira.migration.utils.StringUtils;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.project.ProjectConstant;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Named;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.migration.base.mri.MRI;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@javax.inject.Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u001a\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u0006H\u0002J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "", "entityResolver", "Lcom/atlassian/jira/migration/log/EntityResolver;", "(Lcom/atlassian/jira/migration/log/EntityResolver;)V", "determineIdentifier", "", "entity", "defaultVal", "determineJswIdentifier", "generate", "Lcom/atlassian/jira/migration/log/MessageEntityIdentifier;", "mri", "Lcom/atlassian/migration/base/mri/MRI;", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "type", "defaultIdentifier", "getAttachmentIdentifier", "attachment", "Lcom/atlassian/jira/issue/attachment/Attachment;", "getChangeHistoryIdentifier", "changeHistory", "Lcom/atlassian/jira/issue/changehistory/ChangeHistory;", "getCommentIdentifier", "comment", "Lcom/atlassian/jira/issue/comments/Comment;", "getIssueLinkIdentifier", "issueLink", "Lcom/atlassian/jira/issue/link/IssueLink;", "getOptionIdentifier", "option", "Lcom/atlassian/jira/issue/customfields/option/Option;", "getProjectPermissionKeyIdentifier", "projectPermissionKey", "Lcom/atlassian/jira/security/plugin/ProjectPermissionKey;", "sanitiseType", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEntityIdentifierGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityIdentifierGenerator.kt\ncom/atlassian/jira/migration/log/EntityIdentifierGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class EntityIdentifierGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityResolver entityResolver;
    private static final Logger log = LoggerFactory.getLogger(EntityIdentifierGenerator.class);

    @Inject
    public EntityIdentifierGenerator(@NotNull EntityResolver entityResolver) {
        Intrinsics.checkNotNullParameter((Object)entityResolver, (String)"entityResolver");
        this.entityResolver = entityResolver;
    }

    @NotNull
    public final MessageEntityIdentifier generate(@NotNull MRI mri, @Nullable Object entity, @Nullable ApplicationUser user) {
        Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
        Object object = entity;
        if (object == null) {
            object = this.entityResolver.resolve(mri, user);
        }
        Object resolvedEntity = object;
        return this.generate(mri.getEntityType(), resolvedEntity, mri.getEntityId());
    }

    public static /* synthetic */ MessageEntityIdentifier generate$default(EntityIdentifierGenerator entityIdentifierGenerator, MRI mRI, Object object, ApplicationUser applicationUser, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            applicationUser = null;
        }
        return entityIdentifierGenerator.generate(mRI, object, applicationUser);
    }

    @NotNull
    public final MessageEntityIdentifier generate(@NotNull String type, @Nullable Object entity, @NotNull String defaultIdentifier) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)defaultIdentifier, (String)"defaultIdentifier");
        return new MessageEntityIdentifier(EntityIdentifierGeneratorKt.pascalCaseToTitleCase(this.sanitiseType(StringUtils.INSTANCE.capitalise(type))), this.determineIdentifier(entity, defaultIdentifier));
    }

    private final String sanitiseType(String type) {
        return Intrinsics.areEqual((Object)type, (Object)"RapidView") ? "Board" : type;
    }

    private final String getProjectPermissionKeyIdentifier(ProjectPermissionKey projectPermissionKey) {
        StringBuilder stringBuilder = new StringBuilder().append('\'');
        String string = projectPermissionKey.permissionKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"permissionKey(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return stringBuilder.append(StringUtils.INSTANCE.capitalise(StringsKt.replace$default((String)string3, (String)"_", (String)" ", (boolean)false, (int)4, null))).append('\'').toString();
    }

    private final String getCommentIdentifier(Comment comment) {
        String string;
        block8: {
            block7: {
                Object object;
                String string2;
                Issue issue2 = comment.getIssue();
                String parentIssue = issue2 != null ? issue2.getKey() : null;
                string = parentIssue;
                if (string == null) break block7;
                String it = string;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append(" (on Issue ").append(it).append(" by '");
                Object object2 = comment.getAuthorFullName();
                String string3 = object2;
                if (string3 == null) {
                    string2 = "unknown";
                } else {
                    Intrinsics.checkNotNull((Object)string3);
                    string2 = object2;
                }
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append("' on ");
                Date date = comment.getCreated();
                Object object3 = object2 = date != null ? date.toInstant() : null;
                if (object3 == null) {
                    object = "an unknown date";
                } else {
                    Intrinsics.checkNotNull((Object)object3);
                    object = object2;
                }
                String string4 = stringBuilder2.append(object).append(')').toString();
                string = string4;
                if (string4 != null) break block8;
            }
            string = "";
        }
        String commentSuffix = string;
        return comment.getId() + commentSuffix;
    }

    private final String getIssueLinkIdentifier(IssueLink issueLink) {
        StringBuilder stringBuilder = new StringBuilder().append('\'').append(issueLink.getIssueLinkType().getName()).append("' (from ");
        Issue issue2 = issueLink.getSourceObject();
        String string = issue2 != null ? issue2.getKey() : null;
        if (string == null) {
            string = "unknown";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append(" to ");
        Issue issue3 = issueLink.getDestinationObject();
        String string2 = issue3 != null ? issue3.getKey() : null;
        if (string2 == null) {
            string2 = "unknown";
        }
        return stringBuilder2.append(string2).append(')').toString();
    }

    private final String getAttachmentIdentifier(Attachment attachment) {
        String string;
        block3: {
            block2: {
                Issue issue2 = attachment.getIssue();
                String parentIssue = issue2 != null ? issue2.getKey() : null;
                string = parentIssue;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = " (on Issue " + it + ')';
                string = string2;
                if (string2 != null) break block3;
            }
            string = "";
        }
        String attachSuffix = string;
        return '\'' + attachment.getFilename() + '\'' + attachSuffix;
    }

    private final String getChangeHistoryIdentifier(ChangeHistory changeHistory) {
        String string;
        block3: {
            block2: {
                Issue issue2 = changeHistory.getIssue();
                String parentIssue = issue2 != null ? issue2.getKey() : null;
                string = parentIssue;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = " (on Issue " + it + ')';
                string = string2;
                if (string2 != null) break block3;
            }
            string = "";
        }
        String historySuffix = string;
        return changeHistory.getId() + historySuffix;
    }

    private final String getOptionIdentifier(Option option) {
        Object object;
        block3: {
            block2: {
                FieldConfig fieldConfig = option.getRelatedCustomField();
                Object parentCustomField = fieldConfig != null ? fieldConfig.getCustomField() : null;
                object = parentCustomField;
                if (object == null) break block2;
                CustomField it = object;
                boolean bl = false;
                String string = " (on Field '" + it.getName() + "')";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        Object optionSuffix = object;
        return option.getOptionId() + (String)optionSuffix;
    }

    private final String determineIdentifier(Object entity, String defaultVal) {
        String string;
        String entityIdentifier;
        String string2;
        Object object = entity;
        if (object instanceof WithKey) {
            string2 = ((WithKey)entity).getKey();
        } else if (object instanceof IssueConstant) {
            string2 = '\'' + ((IssueConstant)entity).getName() + '\'';
        } else if (object instanceof ProjectConstant) {
            string2 = '\'' + ((ProjectConstant)entity).getName() + '\'';
        } else if (object instanceof Named) {
            string2 = '\'' + ((Named)entity).getName() + '\'';
        } else if (object instanceof SharedEntity) {
            string2 = '\'' + ((SharedEntity)entity).getName() + '\'';
        } else if (object instanceof ProjectRole) {
            string2 = '\'' + ((ProjectRole)entity).getName() + '\'';
        } else if (object instanceof RoleActor) {
            string2 = '\'' + ((RoleActor)entity).getDescriptor() + '\'';
        } else if (object instanceof JiraWorkflow) {
            string2 = '\'' + ((JiraWorkflow)entity).getName() + '\'';
        } else if (object instanceof WorkflowScheme) {
            string2 = '\'' + ((WorkflowScheme)entity).getName() + '\'';
        } else if (object instanceof CustomField) {
            string2 = '\'' + ((CustomField)entity).getName() + '\'';
        } else if (object instanceof FieldConfig) {
            string2 = '\'' + ((FieldConfig)entity).getName() + '\'';
        } else if (object instanceof FieldConfigScheme) {
            string2 = '\'' + ((FieldConfigScheme)entity).getName() + '\'';
        } else if (object instanceof FieldConfigurationScheme) {
            string2 = '\'' + ((FieldConfigurationScheme)entity).getName() + '\'';
        } else if (object instanceof IssueTypeScreenScheme) {
            string2 = '\'' + ((IssueTypeScreenScheme)entity).getName() + '\'';
        } else if (object instanceof FieldScreen) {
            string2 = '\'' + ((FieldScreen)entity).getName() + '\'';
        } else if (object instanceof FieldScreenScheme) {
            string2 = '\'' + ((FieldScreenScheme)entity).getName() + '\'';
        } else if (object instanceof FieldLayout) {
            string2 = '\'' + ((FieldLayout)entity).getName() + '\'';
        } else if (object instanceof IssueSecurityLevel) {
            string2 = '\'' + ((IssueSecurityLevel)entity).getName() + '\'';
        } else if (object instanceof IssueSecurityLevelScheme) {
            string2 = '\'' + ((IssueSecurityLevelScheme)entity).getName() + '\'';
        } else if (object instanceof IssueSecurityLevelPermission) {
            string2 = ((IssueSecurityLevelPermission)entity).getType() + ' ' + ((IssueSecurityLevelPermission)entity).getParameter();
        } else if (object instanceof ProjectPermissionKey) {
            string2 = this.getProjectPermissionKeyIdentifier((ProjectPermissionKey)entity);
        } else if (object instanceof Comment) {
            string2 = this.getCommentIdentifier((Comment)entity);
        } else if (object instanceof IssueLink) {
            string2 = this.getIssueLinkIdentifier((IssueLink)entity);
        } else if (object instanceof IssueLinkType) {
            string2 = '\'' + ((IssueLinkType)entity).getName() + '\'';
        } else if (object instanceof Attachment) {
            string2 = this.getAttachmentIdentifier((Attachment)entity);
        } else if (object instanceof ChangeHistory) {
            string2 = this.getChangeHistoryIdentifier((ChangeHistory)entity);
        } else if (object instanceof Group) {
            string2 = '\'' + ((Group)entity).getName() + '\'';
        } else if (object instanceof UserWrapper) {
            string2 = '\'' + ((UserWrapper)entity).getName() + '\'';
        } else if (object instanceof Option) {
            string2 = this.getOptionIdentifier((Option)entity);
        } else if (object instanceof WithId) {
            string2 = String.valueOf(((WithId)entity).getId());
        } else if (object instanceof Identifiable) {
            string2 = ((Identifiable)entity).getIdentifier();
        } else if (object instanceof PortalPage) {
            string2 = '\'' + ((PortalPage)entity).getName() + '\'';
        } else if (object instanceof PortletConfiguration) {
            string2 = JiraExtensionsKt.getGadgetName((PortletConfiguration)entity);
            if (string2 == null) {
                string2 = String.valueOf(((PortletConfiguration)entity).getId());
            }
        } else {
            string2 = entityIdentifier = object instanceof JiraServiceContainer ? '\'' + ((JiraServiceContainer)entity).getName() + '\'' : defaultVal;
        }
        if (Intrinsics.areEqual((Object)entityIdentifier, (Object)defaultVal)) {
            string = this.determineJswIdentifier(entity, defaultVal);
        } else {
            Intrinsics.checkNotNull((Object)entityIdentifier);
            string = entityIdentifier;
        }
        return string;
    }

    private final String determineJswIdentifier(Object entity, String defaultVal) {
        Object object;
        block2: {
            Object object2;
            object = this;
            try {
                EntityIdentifierGenerator $this$determineJswIdentifier_u24lambda_u244 = object;
                boolean bl = false;
                Object object3 = entity;
                object2 = Result.constructor-impl((Object)(object3 instanceof RapidView ? '\'' + ((RapidView)entity).getName() + '\'' : (object3 instanceof Sprint ? '\'' + ((Sprint)entity).getName() + '\'' : defaultVal)));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object t = object2 = throwable;
            boolean bl = false;
            log.warn("Error attempting to identify JSW entity [" + entity + "]. Error -  " + t, (Throwable)t);
        }
        return (String)(Result.isFailure-impl((Object)object) ? defaultVal : object);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

