/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.jira.migration.log.ExportMessage;
import com.atlassian.jira.migration.log.ExportMessageFormatter;
import com.atlassian.jira.migration.log.ExportMessageSeverity;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0002J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/log/ExportLog;", "Ljava/io/Closeable;", "logLocation", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "exportMessageWriter", "Ljava/io/PrintWriter;", "<set-?>", "getLogLocation", "()Ljava/nio/file/Path;", "close", "", "ensureFileOpen", "putExportMessage", "exportMessage", "Lcom/atlassian/jira/migration/log/ExportMessage;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nExportLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportLog.kt\ncom/atlassian/jira/migration/log/ExportLog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class ExportLog
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Path logLocation;
    @Nullable
    private PrintWriter exportMessageWriter;
    @NotNull
    private static final Logger log;

    public ExportLog(@NotNull Path logLocation) {
        Intrinsics.checkNotNullParameter((Object)logLocation, (String)"logLocation");
        this.logLocation = logLocation;
    }

    @NotNull
    public final Path getLogLocation() {
        return this.logLocation;
    }

    private final PrintWriter ensureFileOpen() {
        if (this.exportMessageWriter == null) {
            Files.createDirectories(this.logLocation.getParent(), new FileAttribute[0]);
            File exportMessageFile = this.logLocation.toFile();
            this.exportMessageWriter = new PrintWriter(new BufferedWriter(new FileWriter(exportMessageFile, true)));
        }
        PrintWriter printWriter = this.exportMessageWriter;
        Intrinsics.checkNotNull((Object)printWriter, (String)"null cannot be cast to non-null type java.io.PrintWriter");
        return printWriter;
    }

    public final void putExportMessage(@NotNull ExportMessage exportMessage) {
        Intrinsics.checkNotNullParameter((Object)exportMessage, (String)"exportMessage");
        switch (WhenMappings.$EnumSwitchMapping$0[exportMessage.getSeverity().ordinal()]) {
            case 1: {
                log.error(ExportMessageFormatter.INSTANCE.format(exportMessage));
                break;
            }
            case 2: {
                log.warn(ExportMessageFormatter.INSTANCE.format(exportMessage));
            }
        }
        this.ensureFileOpen().println(ExportMessageFormatter.INSTANCE.format(exportMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PrintWriter printWriter = this.exportMessageWriter;
        if (printWriter != null) {
            Closeable closeable = printWriter;
            Throwable throwable = null;
            try {
                PrintWriter it = (PrintWriter)closeable;
                boolean bl = false;
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        this.exportMessageWriter = null;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(ExportLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/log/ExportLog$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExportMessageSeverity.values().length];
            try {
                nArray[ExportMessageSeverity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExportMessageSeverity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

