/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.jira.migration.log.ExportMessage;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/log/ExportMessageFormatter;", "", "()V", "GUIDE_URL", "", "NAME_OF_ERROR_CODE", "endWithDot", "msg", "format", "message", "Lcom/atlassian/jira/migration/log/ExportMessage;", "getTroubleshootingExportErrorGuide", "jira-migration-plugin"})
public final class ExportMessageFormatter {
    @NotNull
    public static final ExportMessageFormatter INSTANCE = new ExportMessageFormatter();
    @NotNull
    private static final String NAME_OF_ERROR_CODE = "JCMA";
    @NotNull
    private static final String GUIDE_URL = "https://support.atlassian.com/migration/docs/troubleshoot-migration-with-jira-cloud-migration-assistant/#Data-preparation-errors";

    private ExportMessageFormatter() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String format(@NotNull ExportMessage message) {
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string2 = message.getExportMessageDetails().getDateTime().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String dateTimeString = StringsKt.removeSuffix((String)StringsKt.replace$default((String)string2, (char)'T', (char)' ', (boolean)false, (int)4, null), (CharSequence)"Z");
        String errorInfo = String.valueOf((Object)message.getSeverity());
        String errorDetails = message.getProjectKey() + ' ' + (Object)((Object)message.getPhase()) + ' ' + this.endWithDot(message.getExportMessageDetails().getReason());
        String errorCode = "[JCMA " + message.getExportMessageDetails().getErrorCode() + ']';
        String res = dateTimeString + ' ' + errorInfo + ' ' + errorDetails + ' ' + errorCode;
        String string3 = message.getExportMessageDetails().getResolution();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            String string4 = INSTANCE.endWithDot(it);
            if (string4 != null) {
                String it2 = string4;
                boolean bl2 = false;
                String string5 = res + ' ' + it2;
                if (string5 != null) {
                    string = string5;
                    return string;
                }
            }
        }
        string = res;
        return string;
    }

    @NotNull
    public final String getTroubleshootingExportErrorGuide() {
        StringBuilder stringBuilder = new StringBuilder().append("Use the troubleshooting page to fix this error. ");
        String string = "Open the troubleshooting page using the URL below and use the error code (starts with \u201c%s\u201d) from the error to locate the fix in the troubleshooting page.";
        Object[] objectArray = new Object[]{NAME_OF_ERROR_CODE};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return stringBuilder.append(string2).append("\nhttps://support.atlassian.com/migration/docs/troubleshoot-migration-with-jira-cloud-migration-assistant/#Data-preparation-errors").toString();
    }

    private final String endWithDot(String msg) {
        return StringsKt.endsWith$default((CharSequence)msg, (char)'.', (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)msg, (String)GUIDE_URL, (boolean)false, (int)2, null) ? msg : msg + '.';
    }
}

