/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0086\u0081\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001f\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/log/ImportErrorCode;", "", "errorCode", "", "pattern", "Lkotlin/text/Regex;", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/text/Regex;)V", "getErrorCode", "()Ljava/lang/String;", "getPattern", "()Lkotlin/text/Regex;", "WORKFLOW_SCHEME_ALREADY_EXISTS", "ISSUE_TYPE_ID_DOES_NOT_EXIST", "WORKFLOW_DOES_NOT_EXIST", "NOT_ALLOWED_TO_DELETE_DEFAULT_WORKFLOW_SCHEME", "WORKFLOW_SCHEME_MUST_HAVE_NAME", "CANNOT_MODIFY_SCHEME_WHILE_MIGRATING", "CANNOT_CHANGE_MAPPINGS_OF_ACTIVE_WORKFLOW_SCHEME", "NOT_ALLOWED_TO_DELETE_ACTIVE_WORKFLOW_SCHEME", "WORKFLOW_SCHEME_ALREADY_HAS_DRAFT", "WORKFLOW_SCHEME_IS_NOT_ACTIVE", "WORKFLOW_SCHEME_NAME_TOO_LONG", "WORKFLOW_SCHEME_NAME_BLANK", "FAILED_TO_IMPORT_PERSON", "MUST_HAVE_AT_LEAST_ONE_BOARD_ADMIN", "INVALID_ISSUE_TYPE_SELECTED", "DELETING_ALL_COLUMNS_NOT_ALLOWED", "COMPONENT_ALREADY_EXISTS", "INVALID_COMPONENT_ID", "INVALID_COMPONENT_NAME", "INVALID_ASSIGNEE_TYPE", "USER_DOES_NOT_EXIST", "Companion", "jira-migration-plugin"})
public final class ImportErrorCode
extends Enum<ImportErrorCode> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String errorCode;
    @NotNull
    private final Regex pattern;
    public static final /* enum */ ImportErrorCode WORKFLOW_SCHEME_ALREADY_EXISTS;
    public static final /* enum */ ImportErrorCode ISSUE_TYPE_ID_DOES_NOT_EXIST;
    public static final /* enum */ ImportErrorCode WORKFLOW_DOES_NOT_EXIST;
    public static final /* enum */ ImportErrorCode NOT_ALLOWED_TO_DELETE_DEFAULT_WORKFLOW_SCHEME;
    public static final /* enum */ ImportErrorCode WORKFLOW_SCHEME_MUST_HAVE_NAME;
    public static final /* enum */ ImportErrorCode CANNOT_MODIFY_SCHEME_WHILE_MIGRATING;
    public static final /* enum */ ImportErrorCode CANNOT_CHANGE_MAPPINGS_OF_ACTIVE_WORKFLOW_SCHEME;
    public static final /* enum */ ImportErrorCode NOT_ALLOWED_TO_DELETE_ACTIVE_WORKFLOW_SCHEME;
    public static final /* enum */ ImportErrorCode WORKFLOW_SCHEME_ALREADY_HAS_DRAFT;
    public static final /* enum */ ImportErrorCode WORKFLOW_SCHEME_IS_NOT_ACTIVE;
    public static final /* enum */ ImportErrorCode WORKFLOW_SCHEME_NAME_TOO_LONG;
    public static final /* enum */ ImportErrorCode WORKFLOW_SCHEME_NAME_BLANK;
    public static final /* enum */ ImportErrorCode FAILED_TO_IMPORT_PERSON;
    public static final /* enum */ ImportErrorCode MUST_HAVE_AT_LEAST_ONE_BOARD_ADMIN;
    public static final /* enum */ ImportErrorCode INVALID_ISSUE_TYPE_SELECTED;
    public static final /* enum */ ImportErrorCode DELETING_ALL_COLUMNS_NOT_ALLOWED;
    public static final /* enum */ ImportErrorCode COMPONENT_ALREADY_EXISTS;
    public static final /* enum */ ImportErrorCode INVALID_COMPONENT_ID;
    public static final /* enum */ ImportErrorCode INVALID_COMPONENT_NAME;
    public static final /* enum */ ImportErrorCode INVALID_ASSIGNEE_TYPE;
    public static final /* enum */ ImportErrorCode USER_DOES_NOT_EXIST;
    private static final /* synthetic */ ImportErrorCode[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private ImportErrorCode(String errorCode, Regex pattern) {
        this.errorCode = errorCode;
        this.pattern = pattern;
    }

    @NotNull
    public final String getErrorCode() {
        return this.errorCode;
    }

    @NotNull
    public final Regex getPattern() {
        return this.pattern;
    }

    public static ImportErrorCode[] values() {
        return (ImportErrorCode[])$VALUES.clone();
    }

    public static ImportErrorCode valueOf(String value) {
        return Enum.valueOf(ImportErrorCode.class, value);
    }

    @NotNull
    public static EnumEntries<ImportErrorCode> getEntries() {
        return $ENTRIES;
    }

    static {
        WORKFLOW_SCHEME_ALREADY_EXISTS = new ImportErrorCode("101", new Regex(".*A workflow scheme with the name '(.+?)' already exists.*"));
        ISSUE_TYPE_ID_DOES_NOT_EXIST = new ImportErrorCode("102", new Regex(".*A issue type with ID '(.+?)' does not exist.*"));
        WORKFLOW_DOES_NOT_EXIST = new ImportErrorCode("103", new Regex(".*A workflow called '(.+?)' does not exist.*"));
        NOT_ALLOWED_TO_DELETE_DEFAULT_WORKFLOW_SCHEME = new ImportErrorCode("104", new Regex(".*You are not allowed to delete the default workflow scheme.*"));
        WORKFLOW_SCHEME_MUST_HAVE_NAME = new ImportErrorCode("105", new Regex(".*A workflow scheme must have a name.*"));
        CANNOT_MODIFY_SCHEME_WHILE_MIGRATING = new ImportErrorCode("106", new Regex(".*Cannot modify the scheme while it is being migrated.*"));
        CANNOT_CHANGE_MAPPINGS_OF_ACTIVE_WORKFLOW_SCHEME = new ImportErrorCode("107", new Regex(".*The mappings of an active workflow scheme cannot be changed.*"));
        NOT_ALLOWED_TO_DELETE_ACTIVE_WORKFLOW_SCHEME = new ImportErrorCode("108", new Regex(".*Not allowed to delete active workflow scheme.*"));
        WORKFLOW_SCHEME_ALREADY_HAS_DRAFT = new ImportErrorCode("109", new Regex(".*This workflow scheme already has a draft.*"));
        WORKFLOW_SCHEME_IS_NOT_ACTIVE = new ImportErrorCode("110", new Regex(".*This workflow scheme is not active.*"));
        WORKFLOW_SCHEME_NAME_TOO_LONG = new ImportErrorCode("111", new Regex(".*A workflow scheme name must be less than 255 characters.*"));
        WORKFLOW_SCHEME_NAME_BLANK = new ImportErrorCode("112", new Regex(".*WorkflowScheme name must not be blank.*"));
        FAILED_TO_IMPORT_PERSON = new ImportErrorCode("113", new Regex(".*Failed to import person because user with account id '(.+?)' does not exist.*"));
        MUST_HAVE_AT_LEAST_ONE_BOARD_ADMIN = new ImportErrorCode("114", new Regex(".*You must have at least one Board Administrator.*"));
        INVALID_ISSUE_TYPE_SELECTED = new ImportErrorCode("115", new Regex(".*issuetype: the issue type selected is invalid.*"));
        DELETING_ALL_COLUMNS_NOT_ALLOWED = new ImportErrorCode("116", new Regex(".*deleting all columns on the board is not allowed.*"));
        COMPONENT_ALREADY_EXISTS = new ImportErrorCode("117", new Regex(".*A component with the name '(.+?)' already exists in this project.*"));
        INVALID_COMPONENT_ID = new ImportErrorCode("118", new Regex(".*Component id '(.+?)' is not valid.*"));
        INVALID_COMPONENT_NAME = new ImportErrorCode("119", new Regex(".*The component name specified is invalid - cannot be an empty string.*"));
        INVALID_ASSIGNEE_TYPE = new ImportErrorCode("120", new Regex(".*Specified assignee type is invalid.*"));
        USER_DOES_NOT_EXIST = new ImportErrorCode("121", new Regex(".*The user '(.+?)' does not exist.*"));
        $VALUES = importErrorCodeArray = new ImportErrorCode[]{ImportErrorCode.WORKFLOW_SCHEME_ALREADY_EXISTS, ImportErrorCode.ISSUE_TYPE_ID_DOES_NOT_EXIST, ImportErrorCode.WORKFLOW_DOES_NOT_EXIST, ImportErrorCode.NOT_ALLOWED_TO_DELETE_DEFAULT_WORKFLOW_SCHEME, ImportErrorCode.WORKFLOW_SCHEME_MUST_HAVE_NAME, ImportErrorCode.CANNOT_MODIFY_SCHEME_WHILE_MIGRATING, ImportErrorCode.CANNOT_CHANGE_MAPPINGS_OF_ACTIVE_WORKFLOW_SCHEME, ImportErrorCode.NOT_ALLOWED_TO_DELETE_ACTIVE_WORKFLOW_SCHEME, ImportErrorCode.WORKFLOW_SCHEME_ALREADY_HAS_DRAFT, ImportErrorCode.WORKFLOW_SCHEME_IS_NOT_ACTIVE, ImportErrorCode.WORKFLOW_SCHEME_NAME_TOO_LONG, ImportErrorCode.WORKFLOW_SCHEME_NAME_BLANK, ImportErrorCode.FAILED_TO_IMPORT_PERSON, ImportErrorCode.MUST_HAVE_AT_LEAST_ONE_BOARD_ADMIN, ImportErrorCode.INVALID_ISSUE_TYPE_SELECTED, ImportErrorCode.DELETING_ALL_COLUMNS_NOT_ALLOWED, ImportErrorCode.COMPONENT_ALREADY_EXISTS, ImportErrorCode.INVALID_COMPONENT_ID, ImportErrorCode.INVALID_COMPONENT_NAME, ImportErrorCode.INVALID_ASSIGNEE_TYPE, ImportErrorCode.USER_DOES_NOT_EXIST};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/log/ImportErrorCode$Companion;", "", "()V", "fromErrorMessage", "Lcom/atlassian/jira/migration/log/ImportErrorCode;", "logLine", "", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nImportErrorCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportErrorCode.kt\ncom/atlassian/jira/migration/log/ImportErrorCode$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ImportErrorCode fromErrorMessage(@NotNull String logLine) {
            ImportErrorCode importErrorCode;
            block1: {
                Intrinsics.checkNotNullParameter((Object)logLine, (String)"logLine");
                String errorMessage2 = StringsKt.substringAfter$default((String)logLine, (String)"project-import", null, (int)2, null);
                ImportErrorCode[] importErrorCodeArray = ImportErrorCode.values();
                int n = importErrorCodeArray.length;
                for (int i = 0; i < n; ++i) {
                    ImportErrorCode importErrorCode2;
                    ImportErrorCode it = importErrorCode2 = importErrorCodeArray[i];
                    boolean bl = false;
                    if (!it.getPattern().containsMatchIn((CharSequence)errorMessage2)) continue;
                    importErrorCode = importErrorCode2;
                    break block1;
                }
                importErrorCode = null;
            }
            return importErrorCode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

