/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.jira.migration.common.StringExtensionsKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/log/ImportMessageFormatter;", "", "()V", "GENERAL_MISSING_DEPENDENCY_ERROR_CODE_MESSAGE", "", "GUIDE_URL", "JIRA_CLOUD_ERROR_IDENTIFIER", "JMT_ERROR_IDENTIFIER", "REGEX_CLOUD_ERROR_CODE", "Lkotlin/text/Regex;", "REGEX_FOR_CLOUD_ERROR_CODE_WHICH_SHOULD_BE_SANITIZED", "REGEX_JMT_ERROR_MESSAGE", "formatImportError", "logLine", "getErrorCode", "getTroubleshootingImportErrorGuide", "jira-migration-plugin"})
public final class ImportMessageFormatter {
    @NotNull
    public static final ImportMessageFormatter INSTANCE = new ImportMessageFormatter();
    @NotNull
    private static final String GUIDE_URL = "https://support.atlassian.com/migration/docs/troubleshoot-migration-with-jira-cloud-migration-assistant/#After-you-run-the-migration";
    @NotNull
    private static final String JMT_ERROR_IDENTIFIER = "JMT";
    @NotNull
    private static final String JIRA_CLOUD_ERROR_IDENTIFIER = "JIRA CLOUD";
    @NotNull
    private static final String GENERAL_MISSING_DEPENDENCY_ERROR_CODE_MESSAGE = "[JMT 100]";
    @NotNull
    private static final Regex REGEX_JMT_ERROR_MESSAGE = new Regex("Check the reasons for the missing dependencies on your server site.");
    @NotNull
    private static final Regex REGEX_CLOUD_ERROR_CODE = new Regex("\\[\\d{3}\\]");
    @NotNull
    private static final Regex REGEX_FOR_CLOUD_ERROR_CODE_WHICH_SHOULD_BE_SANITIZED = new Regex(" \\[\\d{3}\\] ");

    private ImportMessageFormatter() {
    }

    @NotNull
    public final String formatImportError(@NotNull String logLine) {
        String string;
        Intrinsics.checkNotNullParameter((Object)logLine, (String)"logLine");
        if (REGEX_CLOUD_ERROR_CODE.containsMatchIn((CharSequence)logLine)) {
            CharSequence charSequence = logLine;
            Regex regex = REGEX_FOR_CLOUD_ERROR_CODE_WHICH_SHOULD_BE_SANITIZED;
            String string2 = " ";
            string = regex.replace(charSequence, string2);
        } else {
            string = logLine;
        }
        return string;
    }

    @NotNull
    public final String getTroubleshootingImportErrorGuide(@NotNull String logLine) {
        String string;
        Intrinsics.checkNotNullParameter((Object)logLine, (String)"logLine");
        if (REGEX_JMT_ERROR_MESSAGE.containsMatchIn((CharSequence)logLine)) {
            String string2 = "Open the troubleshooting page using the URL below and use the error code (starts with \u201c%s\u201d) from the error to locate the fix in the troubleshooting page.";
            Object[] objectArray = new Object[]{JMT_ERROR_IDENTIFIER};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            String guideDetails = string3;
            string = " [JMT 100] Use the troubleshooting page to fix this error. " + guideDetails + "\nhttps://support.atlassian.com/migration/docs/troubleshoot-migration-with-jira-cloud-migration-assistant/#After-you-run-the-migration";
        } else if (REGEX_CLOUD_ERROR_CODE.containsMatchIn((CharSequence)logLine)) {
            String string4 = "Open the troubleshooting page using the URL below and use the error code (starts with \u201c%s\u201d) from the error to locate the fix in the troubleshooting page.";
            Object[] objectArray = new Object[]{JIRA_CLOUD_ERROR_IDENTIFIER};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            String guideDetails = string5;
            String errorCode = this.getErrorCode(logLine);
            string = StringExtensionsKt.isNotNullOrBlank(errorCode) ? " [JIRA CLOUD " + errorCode + "] Use the troubleshooting page to fix this error. " + guideDetails + "\nhttps://support.atlassian.com/migration/docs/troubleshoot-migration-with-jira-cloud-migration-assistant/#After-you-run-the-migration" : "";
        } else {
            string = "";
        }
        return string;
    }

    private final String getErrorCode(String logLine) {
        Object object;
        Object object2 = this;
        try {
            String string;
            ImportMessageFormatter $this$getErrorCode_u24lambda_u241 = object2;
            boolean bl = false;
            MatchResult matchResult = Regex.find$default((Regex)REGEX_CLOUD_ERROR_CODE, (CharSequence)logLine, (int)0, (int)2, null);
            if (matchResult != null) {
                MatchResult it = matchResult;
                boolean bl2 = false;
                Object object3 = it.getGroups().get(0);
                string = object3 != null && (object3 = object3.getValue()) != null && (object3 = StringsKt.substringAfter$default((String)object3, (String)"[", null, (int)2, null)) != null ? StringsKt.substringBefore$default((String)object3, (String)"]", null, (int)2, null) : null;
            } else {
                string = null;
            }
            object = Result.constructor-impl(string);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (String)(Result.isFailure-impl((Object)object2) ? null : object2);
    }
}

