/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/log/JiraUserProjectManager;", "", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "(Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/project/ProjectManager;)V", "getProjectObjByKey", "Lcom/atlassian/jira/project/Project;", "projectKey", "", "getUserByKey", "Lcom/atlassian/jira/user/ApplicationUser;", "startedBy", "jira-migration-plugin"})
public final class JiraUserProjectManager {
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final ProjectManager projectManager;

    @Inject
    public JiraUserProjectManager(@NotNull UserManager userManager, @NotNull ProjectManager projectManager) {
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        this.userManager = userManager;
        this.projectManager = projectManager;
    }

    @NotNull
    public final Project getProjectObjByKey(@Nullable String projectKey) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProjectObjByKey(...)");
        return project;
    }

    @Nullable
    public final ApplicationUser getUserByKey(@Nullable String startedBy) {
        return this.userManager.getUserByKey(startedBy);
    }
}

