/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.migration.log.ImportErrorCode;
import com.atlassian.jira.migration.log.ImportMessageFormatter;
import com.atlassian.jira.migration.log.MRCLogReader;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.base.mri.MRI;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.supercsv.io.CsvBeanReader;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bJ(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J<\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J<\u0010\u0014\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J6\u0010\u0018\u001a\u00020\t2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0017\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J>\u0010\u001c\u001a\u00020\t2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/log/LogTagProcessor;", "", "entityIdentifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "mrcLogReader", "Lcom/atlassian/jira/migration/log/MRCLogReader;", "(Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/migration/log/MRCLogReader;)V", "createCache", "", "", "process", "", "reader", "Ljava/io/BufferedReader;", "writer", "Ljava/io/BufferedWriter;", "projectKey", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "cache", "processCsv", "Lorg/supercsv/io/CsvBeanReader;", "resolveErrorCode", "logLine", "resolveMriTags", "tagsReplaced", "Ljava/util/concurrent/atomic/AtomicLong;", "resolveProjectKeyTag", "resolveTags", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nLogTagProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogTagProcessor.kt\ncom/atlassian/jira/migration/log/LogTagProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,149:1\n1313#2,2:150\n*S KotlinDebug\n*F\n+ 1 LogTagProcessor.kt\ncom/atlassian/jira/migration/log/LogTagProcessor\n*L\n71#1:150,2\n*E\n"})
public final class LogTagProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityIdentifierGenerator entityIdentifierGenerator;
    @NotNull
    private final MRCLogReader mrcLogReader;
    @NotNull
    private static final Regex REGEX_MRI_TAG = new Regex("\\{\\{(mri:[^}]*)\\}\\}");
    @NotNull
    private static final Regex REGEX_PROJECT_KET_TAG = new Regex("\\{\\{projectKey\\}\\}");

    @Inject
    public LogTagProcessor(@NotNull EntityIdentifierGenerator entityIdentifierGenerator, @NotNull MRCLogReader mrcLogReader) {
        Intrinsics.checkNotNullParameter((Object)entityIdentifierGenerator, (String)"entityIdentifierGenerator");
        Intrinsics.checkNotNullParameter((Object)mrcLogReader, (String)"mrcLogReader");
        this.entityIdentifierGenerator = entityIdentifierGenerator;
        this.mrcLogReader = mrcLogReader;
    }

    public final long process(@NotNull BufferedReader reader, @NotNull BufferedWriter writer, @NotNull String projectKey, @Nullable ApplicationUser user) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Map<String, String> cache2 = this.createCache();
        long result2 = this.process(cache2, reader, writer, projectKey, user);
        cache2.clear();
        return result2;
    }

    public final long process(@NotNull Map<String, String> cache2, @NotNull BufferedReader reader, @NotNull BufferedWriter writer, @NotNull String projectKey, @Nullable ApplicationUser user) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        AtomicLong tagsReplaced = new AtomicLong(0L);
        AtomicBoolean isFirst = new AtomicBoolean(true);
        reader.lines().forEach(arg_0 -> LogTagProcessor.process$lambda$0((Function1)new Function1<String, Unit>(this, cache2, projectKey, user, tagsReplaced, isFirst, writer){
            final /* synthetic */ LogTagProcessor this$0;
            final /* synthetic */ Map<String, String> $cache;
            final /* synthetic */ String $projectKey;
            final /* synthetic */ ApplicationUser $user;
            final /* synthetic */ AtomicLong $tagsReplaced;
            final /* synthetic */ AtomicBoolean $isFirst;
            final /* synthetic */ BufferedWriter $writer;
            {
                this.this$0 = $receiver;
                this.$cache = $cache;
                this.$projectKey = $projectKey;
                this.$user = $user;
                this.$tagsReplaced = $tagsReplaced;
                this.$isFirst = $isFirst;
                this.$writer = $writer;
                super(1);
            }

            public final void invoke(String logLine) {
                Intrinsics.checkNotNull((Object)logLine);
                String replacedLine = LogTagProcessor.access$resolveTags(this.this$0, this.$cache, logLine, this.$projectKey, this.$user, this.$tagsReplaced);
                String resolveErrorCode = LogTagProcessor.access$resolveErrorCode(this.this$0, replacedLine);
                String prefix2 = this.$isFirst.compareAndSet(true, false) ? "" : "\n";
                this.$writer.append(prefix2 + resolveErrorCode);
            }
        }, arg_0));
        writer.flush();
        return tagsReplaced.get();
    }

    public final long processCsv(@NotNull Map<String, String> cache2, @NotNull CsvBeanReader reader, @NotNull BufferedWriter writer, @NotNull String projectKey, @Nullable ApplicationUser user) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        AtomicLong tagsReplaced = new AtomicLong(0L);
        AtomicBoolean isFirst = new AtomicBoolean(true);
        Sequence $this$forEach$iv = SequencesKt.generateSequence((Function0)((Function0)new Function0<String>(this, reader){
            final /* synthetic */ LogTagProcessor this$0;
            final /* synthetic */ CsvBeanReader $reader;
            {
                this.this$0 = $receiver;
                this.$reader = $reader;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return LogTagProcessor.access$getMrcLogReader$p(this.this$0).readImportLogCsvLine(this.$reader);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String replacedLine = this.resolveTags(cache2, it, projectKey, user, tagsReplaced);
            String resolveErrorCode = this.resolveErrorCode(replacedLine);
            String prefix2 = isFirst.compareAndSet(true, false) ? "" : "\n";
            writer.append(prefix2 + resolveErrorCode);
        }
        writer.flush();
        return tagsReplaced.get();
    }

    private final String resolveErrorCode(String logLine) {
        ImportErrorCode importErrorCode = ImportErrorCode.Companion.fromErrorMessage(logLine);
        if (importErrorCode == null) {
            return logLine;
        }
        ImportErrorCode fromErrorMessage = importErrorCode;
        String errorCodeView = '[' + fromErrorMessage.getErrorCode() + ']';
        String formattedLogLine = logLine + ' ' + errorCodeView;
        return logLine + ImportMessageFormatter.INSTANCE.getTroubleshootingImportErrorGuide(formattedLogLine);
    }

    @NotNull
    public final Map<String, String> createCache() {
        ConcurrentMap concurrentMap = CacheBuilder.newBuilder().maximumSize(10000L).build().asMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"asMap(...)");
        return concurrentMap;
    }

    private final String resolveTags(Map<String, String> cache2, String logLine, String projectKey, ApplicationUser user, AtomicLong tagsReplaced) {
        String replacedLine = this.resolveMriTags(cache2, logLine, user, tagsReplaced);
        return this.resolveProjectKeyTag(replacedLine, projectKey, tagsReplaced);
    }

    private final String resolveProjectKeyTag(String logLine, String projectKey, AtomicLong tagsReplaced) {
        return REGEX_PROJECT_KET_TAG.replace((CharSequence)logLine, (Function1)new Function1<MatchResult, CharSequence>(tagsReplaced, projectKey){
            final /* synthetic */ AtomicLong $tagsReplaced;
            final /* synthetic */ String $projectKey;
            {
                this.$tagsReplaced = $tagsReplaced;
                this.$projectKey = $projectKey;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$tagsReplaced.incrementAndGet();
                return this.$projectKey;
            }
        });
    }

    private final String resolveMriTags(Map<String, String> cache2, String logLine, ApplicationUser user, AtomicLong tagsReplaced) {
        return REGEX_MRI_TAG.replace((CharSequence)logLine, (Function1)new Function1<MatchResult, CharSequence>(tagsReplaced, cache2, this, user){
            final /* synthetic */ AtomicLong $tagsReplaced;
            final /* synthetic */ Map<String, String> $cache;
            final /* synthetic */ LogTagProcessor this$0;
            final /* synthetic */ ApplicationUser $user;
            {
                this.$tagsReplaced = $tagsReplaced;
                this.$cache = $cache;
                this.this$0 = $receiver;
                this.$user = $user;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CharSequence invoke(@NotNull MatchResult matchResult) {
                Object object;
                void $this$getOrPut$iv;
                Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
                this.$tagsReplaced.incrementAndGet();
                String matched = (String)matchResult.getGroupValues().get(1);
                Map<String, String> map = this.$cache;
                LogTagProcessor logTagProcessor = this.this$0;
                ApplicationUser applicationUser = this.$user;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(matched);
                if (value$iv == null) {
                    boolean bl = false;
                    MRI mri = MRI.Companion.create(matched);
                    String answer$iv = LogTagProcessor.access$getEntityIdentifierGenerator$p(logTagProcessor).generate(mri, null, applicationUser).toString();
                    $this$getOrPut$iv.put(matched, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                return (CharSequence)object;
            }
        });
    }

    private static final void process$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$resolveTags(LogTagProcessor $this, Map cache2, String logLine, String projectKey, ApplicationUser user, AtomicLong tagsReplaced) {
        return $this.resolveTags(cache2, logLine, projectKey, user, tagsReplaced);
    }

    public static final /* synthetic */ String access$resolveErrorCode(LogTagProcessor $this, String logLine) {
        return $this.resolveErrorCode(logLine);
    }

    public static final /* synthetic */ MRCLogReader access$getMrcLogReader$p(LogTagProcessor $this) {
        return $this.mrcLogReader;
    }

    public static final /* synthetic */ EntityIdentifierGenerator access$getEntityIdentifierGenerator$p(LogTagProcessor $this) {
        return $this.entityIdentifierGenerator;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/log/LogTagProcessor$Companion;", "", "()V", "REGEX_MRI_TAG", "Lkotlin/text/Regex;", "REGEX_PROJECT_KET_TAG", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

