/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.jira.migration.export.model.PMRAFailedEntityCSVRow;
import java.util.Arrays;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvBeanReader;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J#\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/log/MRCLogReader;", "", "()V", "readImportLogCsvLine", "", "reader", "Lorg/supercsv/io/CsvBeanReader;", "readPMRALogCsvLine", "Lcom/atlassian/jira/migration/export/model/PMRAFailedEntityCSVRow;", "header", "", "(Lorg/supercsv/io/CsvBeanReader;[Ljava/lang/String;)Lcom/atlassian/jira/migration/export/model/PMRAFailedEntityCSVRow;", "Companion", "MRCImportLogCsv", "jira-migration-plugin"})
public final class MRCLogReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(MRCLogReader.class);

    @Nullable
    public final String readImportLogCsvLine(@NotNull CsvBeanReader reader) {
        String string;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        try {
            String[] stringArray = new String[]{"log"};
            String[] nameMapping = stringArray;
            Optional[] optionalArray = new Optional[]{new Optional()};
            Optional[] processors = optionalArray;
            MRCImportLogCsv mRCImportLogCsv = (MRCImportLogCsv)reader.read(MRCImportLogCsv.class, nameMapping, (CellProcessor[])Arrays.copyOf(processors, processors.length));
            string = mRCImportLogCsv != null ? mRCImportLogCsv.getLog() : null;
        }
        catch (Exception ex) {
            log.warn("Failed to read CSV line: " + ex.getMessage());
            string = null;
        }
        return string;
    }

    @Nullable
    public final PMRAFailedEntityCSVRow readPMRALogCsvLine(@NotNull CsvBeanReader reader, @NotNull String[] header) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        try {
            object = new CellProcessor[]{new Optional(), new Optional(), new Optional(), new Optional(), new Optional(), new Optional(), new Optional()};
            object = (PMRAFailedEntityCSVRow)reader.read(PMRAFailedEntityCSVRow.class, header, object);
        }
        catch (Exception ex) {
            log.warn("Failed to read PMRA CSV line: " + ex.getMessage());
            object = null;
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/log/MRCLogReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/log/MRCLogReader$MRCImportLogCsv;", "", "log", "", "(Ljava/lang/String;)V", "getLog", "()Ljava/lang/String;", "setLog", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class MRCImportLogCsv {
        @NotNull
        private String log;

        public MRCImportLogCsv(@NotNull String log2) {
            Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
            this.log = log2;
        }

        public /* synthetic */ MRCImportLogCsv(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            this(string);
        }

        @NotNull
        public final String getLog() {
            return this.log;
        }

        public final void setLog(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.log = string;
        }

        @NotNull
        public final String component1() {
            return this.log;
        }

        @NotNull
        public final MRCImportLogCsv copy(@NotNull String log2) {
            Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
            return new MRCImportLogCsv(log2);
        }

        public static /* synthetic */ MRCImportLogCsv copy$default(MRCImportLogCsv mRCImportLogCsv, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = mRCImportLogCsv.log;
            }
            return mRCImportLogCsv.copy(string);
        }

        @NotNull
        public String toString() {
            return "MRCImportLogCsv(log=" + this.log + ')';
        }

        public int hashCode() {
            return this.log.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MRCImportLogCsv)) {
                return false;
            }
            MRCImportLogCsv mRCImportLogCsv = (MRCImportLogCsv)other;
            return Intrinsics.areEqual((Object)this.log, (Object)mRCImportLogCsv.log);
        }

        public MRCImportLogCsv() {
            this(null, 1, null);
        }
    }
}

