/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MigrationTaskCompletedEvent;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.log.InProgressPlanLogException;
import com.atlassian.jira.migration.log.JiraUserProjectManager;
import com.atlassian.jira.migration.log.LogTagProcessor;
import com.atlassian.jira.migration.log.MigrationDetails;
import com.atlassian.jira.migration.log.MigrationLogsClient;
import com.atlassian.jira.migration.log.MigrationLogsProvider;
import com.atlassian.jira.migration.log.MigrationReportCenterClient;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProjectTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.TaskCompletionStatus;
import com.atlassian.jira.migration.utils.ProjectKeysProcessor;
import com.atlassian.jira.migration.utils.SegregatedProjectKeys;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.api.ContainerId;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.udc.file.LocalFileDataOutput;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.prefs.CsvPreference;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000 \u007f2\u00020\u0001:\u0001\u007fBG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002JB\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u001e\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001a0!0\u001f2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u001dH\u0002J(\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002JB\u0010,\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u001d2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001d0.2\u001a\b\u0002\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0018000.2\b\b\u0002\u00101\u001a\u000202J\u0018\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020 H\u0002J\u001c\u00106\u001a\b\u0012\u0004\u0012\u0002070.2\f\u00108\u001a\b\u0012\u0004\u0012\u0002070.H\u0007J\u001c\u00109\u001a\b\u0012\u0004\u0012\u0002070.2\f\u00108\u001a\b\u0012\u0004\u0012\u0002070.H\u0002J>\u0010:\u001a\u00020\u00182\u0006\u0010;\u001a\u00020<2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001d2\b\u0010A\u001a\u0004\u0018\u00010BH\u0007J\u0016\u0010C\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J?\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020 2\u0006\u0010>\u001a\u00020?2\u0006\u0010K\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020MH\u0002\u00a2\u0006\u0002\u0010NJ \u0010O\u001a\u00020E2\u0006\u0010;\u001a\u00020<2\u0006\u0010>\u001a\u00020?2\u0006\u0010K\u001a\u00020\u001dH\u0002J4\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001d0.2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020 0.2\u0006\u0010R\u001a\u00020 2\u0006\u0010S\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020 H\u0002J@\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001d0.2\u0006\u0010V\u001a\u00020W2\u0006\u0010#\u001a\u00020\u001d2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002070.2\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020 00H\u0002J\u0010\u0010Z\u001a\u0004\u0018\u00010\u001d2\u0006\u0010R\u001a\u00020 J\"\u0010[\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u001d0!2\u0006\u0010Q\u001a\u00020 2\u0006\u0010R\u001a\u00020 J&\u0010\\\u001a\u00020\u001d2\u0006\u0010S\u001a\u00020\u001d2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u001d0.2\u0006\u0010^\u001a\u00020 H\u0002J\u001e\u0010_\u001a\u00020\u00182\u0006\u0010V\u001a\u00020W2\u0006\u0010S\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001dJ\"\u0010`\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u001d0!2\u0006\u0010a\u001a\u00020\u001d2\u0006\u0010b\u001a\u00020 J&\u0010c\u001a\u00020\u001d2\u0006\u0010S\u001a\u00020\u001d2\u0006\u0010d\u001a\u00020e2\u0006\u0010>\u001a\u00020?2\u0006\u0010\"\u001a\u00020 J&\u0010f\u001a\b\u0012\u0004\u0012\u00020\u001d0.2\u0006\u0010g\u001a\u00020h2\u0006\u0010R\u001a\u00020 2\u0006\u0010S\u001a\u00020\u001dH\u0002J\u0018\u0010i\u001a\u0004\u0018\u00010\u001d2\u0006\u0010Q\u001a\u00020 2\u0006\u0010R\u001a\u00020 J*\u0010j\u001a\u0004\u0018\u00010\u001d2\u0006\u0010V\u001a\u00020W2\u0006\u0010d\u001a\u00020e2\u0006\u0010>\u001a\u00020?2\u0006\u0010\"\u001a\u00020 H\u0002J\u0010\u0010k\u001a\u0004\u0018\u00010\u001d2\u0006\u0010V\u001a\u00020WJ\u0010\u0010l\u001a\u0004\u0018\u00010\u001d2\u0006\u0010m\u001a\u00020 J\u0012\u0010n\u001a\u0004\u0018\u00010\u001d2\u0006\u0010V\u001a\u00020WH\u0002J\u0018\u0010o\u001a\u00020p2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010q\u001a\u0002022\u0006\u0010V\u001a\u00020WH\u0002J&\u0010r\u001a\u00020\u001d2\u0006\u0010H\u001a\u00020 2\u0006\u0010d\u001a\u00020e2\u0006\u0010>\u001a\u00020?2\u0006\u00105\u001a\u00020 J&\u0010s\u001a\u00020\u001d2\u0006\u0010H\u001a\u00020 2\u0006\u0010d\u001a\u00020e2\u0006\u0010>\u001a\u00020?2\u0006\u00105\u001a\u00020 JN\u0010t\u001a\u00020\u00182\u0006\u0010u\u001a\u00020\u001a2\u0006\u0010v\u001a\u00020\u001d2\u0006\u0010w\u001a\u00020 2\u0006\u0010x\u001a\u00020y2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f2\u0006\u00105\u001a\u00020 2\b\u0010A\u001a\u0004\u0018\u00010BH\u0002JF\u0010z\u001a\u00020\u00182\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010{\u001a\u00020\u001d2\u0006\u0010|\u001a\u00020\u001d2\u0006\u00105\u001a\u00020 2\u0006\u0010L\u001a\u00020M2\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J\u0016\u0010}\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\f\u0010~\u001a\u00020\u001d*\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0080\u0001\u00b2\u0006\u000e\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001X\u008a\u0084\u0002\u00b2\u0006\u0016\u0010=\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001fX\u008a\u0084\u0002\u00b2\u0006\r\u0010\u0083\u0001\u001a\u0004\u0018\u00010BX\u008a\u0084\u0002"}, d2={"Lcom/atlassian/jira/migration/log/MigrationLogsProvider;", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "migrationLogsClient", "Lcom/atlassian/jira/migration/log/MigrationLogsClient;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "logTagProcessor", "Lcom/atlassian/jira/migration/log/LogTagProcessor;", "jiraUserProjectManager", "Lcom/atlassian/jira/migration/log/JiraUserProjectManager;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "migrationReportCenterClient", "Lcom/atlassian/jira/migration/log/MigrationReportCenterClient;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/log/MigrationLogsClient;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/log/LogTagProcessor;Lcom/atlassian/jira/migration/log/JiraUserProjectManager;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/config/util/JiraHome;Lcom/atlassian/jira/migration/log/MigrationReportCenterClient;)V", "statusesToFetchOrUploadLogs", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/TaskCompletionStatus;", "statusesToFetchOrUploadLogsForCrossProject", "addReadMe", "", "zip", "Ljava/util/zip/ZipOutputStream;", "addToCombinedPerProjectLog", "detailedLogLocation", "Ljava/nio/file/Path;", "combinedProjectLogData", "", "", "Lkotlin/Pair;", "prefix", "migLogDir", "buildAndUploadExportLogs", "logZip", "event", "Lcom/atlassian/jira/migration/events/MigrationTaskCompletedEvent;", "task", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProjectTask;", "logZipFile", "Ljava/io/File;", "buildZip", "filesToZipUp", "", "zipEnhancers", "Lkotlin/Function1;", "zipInsideZip", "", "combinedLogFileLocation", "migDir", "projectKey", "determineCrossProjectTasks", "Lcom/atlassian/jira/migration/orchestratorclient/GetTaskStatusResponse$TaskProgress;", "outcome", "determineFailedOrIncompleteProjectTasks", "doFetchMissingLogFile", "migrationDetails", "Lcom/atlassian/jira/migration/log/MigrationDetails;", "tagCache", "progressUnit", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;", "missingLogFile", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "downloadImportLogs", "downloadLogs", "", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "sourceId", "tmpDownloadFile", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "(Lcom/atlassian/migration/api/ContainerToken;Lcom/atlassian/migration/api/MigrationId;Ljava/lang/String;Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;Ljava/nio/file/Path;Lcom/atlassian/jira/migration/migration/MigrationProtocol;)Ljava/lang/Long;", "downloadRemoteLogs", "fetchAndCombineDebugErrorLogs", "projectKeys", "executionId", "migrationLogDir", "filePath", "fetchAndCombineErrorLogs", "migrationData", "Lcom/atlassian/jira/migration/migration/Migration;", "failedOrIncompleteTasks", "prefixProvider", "generateExportErrorLogsForBackgroundTask", "generateExportErrorLogsZip", "generateIndividualExportErrorLogsZip", "logs", "errorFilePath", "generateLogsForMigration", "generateMigrationIsolatedLogsZip", "isolatedLogZip", "isolatedLogId", "generateRelativeLogFileLocation", "taskType", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "getCrossProjectLogs", "segregatedProjectKeys", "Lcom/atlassian/jira/migration/utils/SegregatedProjectKeys;", "getErrorLogsZipPath", "getLogFile", "getLogsForMigration", "getLogsForPlan", "planId", "getMigrationLogs", "getUri", "Ljava/net/URI;", "isMigrationTasksInProgress", "legacyLogFileLocation", "logFileLocation", "processCsvFile", "pOut", "tmpLogFilePath", "fileName", "tagsReplaced", "Ljava/util/concurrent/atomic/AtomicLong;", "processTags", "processedLogFile", "tmpLogFile", "uploadExportLogs", "relativeParentPath", "Companion", "jira-migration-plugin", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "migrationStartedByUser"})
@SourceDebugExtension(value={"SMAP\nMigrationLogsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationLogsProvider.kt\ncom/atlassian/jira/migration/log/MigrationLogsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,797:1\n1#2:798\n1855#3,2:799\n1747#3,2:801\n1749#3:806\n1549#3:807\n1620#3,3:808\n766#3:822\n857#3,2:823\n1855#3,2:825\n1549#3:830\n1620#3,3:831\n1855#3,2:834\n1855#3:843\n1856#3:846\n1855#3,2:853\n1855#3,2:855\n187#4,3:803\n215#4,2:836\n125#4:838\n152#4,3:839\n215#4,2:844\n215#4,2:847\n125#4:849\n152#4,3:850\n483#5,11:811\n3792#6:827\n4307#6,2:828\n603#7:842\n*S KotlinDebug\n*F\n+ 1 MigrationLogsProvider.kt\ncom/atlassian/jira/migration/log/MigrationLogsProvider\n*L\n210#1:799,2\n217#1:801,2\n217#1:806\n246#1:807\n246#1:808,3\n300#1:822\n300#1:823,2\n319#1:825,2\n353#1:830\n353#1:831,3\n369#1:834,2\n443#1:843\n443#1:846\n708#1:853,2\n711#1:855,2\n217#1:803,3\n376#1:836,2\n382#1:838\n382#1:839,3\n444#1:844,2\n457#1:847,2\n464#1:849\n464#1:850,3\n253#1:811,11\n352#1:827\n352#1:828,2\n406#1:842\n*E\n"})
public final class MigrationLogsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final com.atlassian.jira.migration.common.LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final MigrationLogsClient migrationLogsClient;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final LogTagProcessor logTagProcessor;
    @NotNull
    private final JiraUserProjectManager jiraUserProjectManager;
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final JiraHome jiraHome;
    @NotNull
    private final MigrationReportCenterClient migrationReportCenterClient;
    @NotNull
    private final Set<TaskCompletionStatus> statusesToFetchOrUploadLogs;
    @NotNull
    private final Set<TaskCompletionStatus> statusesToFetchOrUploadLogsForCrossProject;
    private static final Logger log = LoggerFactory.getLogger(MigrationLogsProvider.class);
    @NotNull
    public static final String MIGRATION_ISOLATED_LOGS_FILENAME = "migration-isolated-logs.zip";
    @NotNull
    public static final String PROJECT_FILE_PATH = "project-export.log";
    @NotNull
    public static final String CROSS_PROJECT_FILE_PATH = "crossProjectEntity-export.log";
    @NotNull
    public static final String PROJECT_EXPORT_ERROR_FILENAME = "project-export-error-logs.zip";
    @NotNull
    public static final String CROSS_PROJECT_EXPORT_ERROR_FILENAME = "cross-project-export-error-logs.zip";
    @NotNull
    public static final String EXPORT = "export";
    @NotNull
    public static final String IMPORT = "import";
    @NotNull
    public static final String EXT_LOG = "log";
    @NotNull
    public static final String EXT_LOG_ZIP = "log.zip";
    @NotNull
    public static final String EXT_LOGS_ZIP = "logs.zip";
    @NotNull
    public static final String SUCCESS = "Success";
    @NotNull
    public static final String FAILED = "Failed";
    @NotNull
    public static final String SITE = "site";

    @Inject
    public MigrationLogsProvider(@NotNull com.atlassian.jira.migration.common.LocalFileDataOutput localFileDataOutput, @NotNull MigrationLogsClient migrationLogsClient, @NotNull DiscoveryService discoveryService, @NotNull LogTagProcessor logTagProcessor, @NotNull JiraUserProjectManager jiraUserProjectManager, @NotNull MetricsEventService metricsEventService, @NotNull JiraHome jiraHome, @NotNull MigrationReportCenterClient migrationReportCenterClient) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)migrationLogsClient, (String)"migrationLogsClient");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)logTagProcessor, (String)"logTagProcessor");
        Intrinsics.checkNotNullParameter((Object)jiraUserProjectManager, (String)"jiraUserProjectManager");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkNotNullParameter((Object)migrationReportCenterClient, (String)"migrationReportCenterClient");
        this.localFileDataOutput = localFileDataOutput;
        this.migrationLogsClient = migrationLogsClient;
        this.discoveryService = discoveryService;
        this.logTagProcessor = logTagProcessor;
        this.jiraUserProjectManager = jiraUserProjectManager;
        this.metricsEventService = metricsEventService;
        this.jiraHome = jiraHome;
        this.migrationReportCenterClient = migrationReportCenterClient;
        TaskCompletionStatus[] taskCompletionStatusArray = new TaskCompletionStatus[]{TaskCompletionStatus.INCOMPLETE, TaskCompletionStatus.FAILURE};
        this.statusesToFetchOrUploadLogs = SetsKt.setOf((Object[])taskCompletionStatusArray);
        taskCompletionStatusArray = new TaskCompletionStatus[]{TaskCompletionStatus.SUCCESS, TaskCompletionStatus.INCOMPLETE, TaskCompletionStatus.FAILURE};
        this.statusesToFetchOrUploadLogsForCrossProject = SetsKt.setOf((Object[])taskCompletionStatusArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void downloadImportLogs(@NotNull MigrationTaskCompletedEvent event, @NotNull ProjectTask task) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Path logLocation = this.logFileLocation(event.getMigrationId(), event.getTask().getMigrationTaskType(), event.getProgressItem().getUnit(), task.getProjectKey());
        if (logLocation.toFile().exists()) {
            return;
        }
        Migration migration = this.discoveryService.findByMigrationId(event.getMigrationId());
        if (migration != null) {
            Migration it = migration;
            boolean bl = false;
            log.info("Detected failed remote task completion [" + event.getTask().getTaskId() + "] for migration [" + event.getMigrationId() + "] and project [" + task.getProjectKey() + "], pre-fetching log");
            Map<String, String> tagCache2 = this.logTagProcessor.createCache();
            try {
                Files.createDirectories(logLocation.getParent(), new FileAttribute[0]);
                this.doFetchMissingLogFile(new MigrationDetails(event.getMigrationId(), it.getProtocol(), event.getCloudSite(), task.getProjectKey()), tagCache2, event.getProgressItem().getUnit(), logLocation, this.jiraUserProjectManager.getUserByKey(it.getStartedBy()));
            }
            finally {
                tagCache2.clear();
            }
        }
    }

    public final void uploadExportLogs(@NotNull MigrationTaskCompletedEvent event, @NotNull ProjectTask task) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (event.getTask().getMigrationTaskType() != MigrationTaskType.PROJECT_DATA_UPLOAD) {
            return;
        }
        Path migrationLogDir = this.localFileDataOutput.migrationLogDirectory(event.getMigrationId());
        Path logZip = migrationLogDir.resolve(EXPORT).resolve(task.getProjectKey() + "-project-export.zip");
        File logZipFile = logZip.toFile();
        if (logZipFile.exists()) {
            return;
        }
        log.info("Processing error logs");
        Intrinsics.checkNotNull((Object)logZip);
        Intrinsics.checkNotNull((Object)logZipFile);
        this.buildAndUploadExportLogs(logZip, event, task, logZipFile);
    }

    private final void buildAndUploadExportLogs(Path logZip, MigrationTaskCompletedEvent event, ProjectTask task, File logZipFile) {
        block3: {
            Path path = this.logFileLocation(event.getMigrationId(), event.getTask().getMigrationTaskType(), event.getProgressItem().getUnit(), task.getProjectKey());
            Object it = path;
            boolean bl = false;
            Path path2 = it.toFile().exists() ? path : null;
            if (path2 == null) {
                return;
            }
            Path existingLogFile = path2;
            log.info("Building export zip");
            MigrationLogsProvider.buildZip$default(this, logZip, CollectionsKt.listOf((Object)existingLogFile), null, false, 12, null);
            Migration migration = this.discoveryService.findByMigrationId(event.getMigrationId());
            if (migration == null) break block3;
            it = migration;
            boolean bl2 = false;
            log.info("Uploading " + (Object)((Object)((Migration)it).getProtocol()) + " export logs");
            URI uri = this.getUri(event, task);
            try {
                MigrationLogsClient.uploadFileToURL$default(this.migrationLogsClient, uri, logZipFile, null, 4, null);
            }
            catch (UnexpectedStatusCodeException ex) {
                log.warn("Error uploading export error file");
            }
        }
    }

    private final URI getUri(MigrationTaskCompletedEvent event, ProjectTask task) {
        return this.migrationLogsClient.fetchLogsUploadURL(new ContainerToken(event.getCloudSite().getContainerToken()), new MigrationId(event.getMigrationId()), task.getProjectKey());
    }

    @Nullable
    public final Path getLogsForPlan(@NotNull String planId) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Migration migration = this.discoveryService.findLatestByPlanId(planId);
        if (migration != null) {
            Migration it = migration;
            boolean bl = false;
            path = this.getLogsForMigration(it);
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public final Path getLogsForMigration(@NotNull Migration migrationData) {
        Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
        Path legacyLogZip = this.localFileDataOutput.legacyMigrationLogDirectory(migrationData.getMigrationId()).resolve(EXT_LOGS_ZIP);
        return legacyLogZip.toFile().exists() ? legacyLogZip : this.getMigrationLogs(migrationData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path getMigrationLogs(Migration migrationData) {
        Path migrationLogDir = this.localFileDataOutput.migrationLogDirectory(migrationData.getMigrationId());
        Path logZip = migrationLogDir.resolve(EXT_LOGS_ZIP);
        File logZipFile = logZip.toFile();
        if (!logZipFile.exists()) {
            String string = (migrationData.getMigrationId() + "-logs").intern();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
            String string2 = string;
            synchronized (string2) {
                boolean bl = false;
                if (!logZipFile.exists()) {
                    Intrinsics.checkNotNull((Object)logZip);
                    this.generateLogsForMigration(migrationData, migrationLogDir, logZip);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return logZipFile.exists() ? logZip : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateLogsForMigration(@NotNull Migration migrationData, @NotNull Path migrationLogDir, @NotNull Path logZip) {
        Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
        Intrinsics.checkNotNullParameter((Object)migrationLogDir, (String)"migrationLogDir");
        Intrinsics.checkNotNullParameter((Object)logZip, (String)"logZip");
        String migrationId = migrationData.getMigrationId();
        log.info("Generating logs zip for planId [" + migrationData.getPlanId() + "] migrationId [" + migrationId + ']');
        if (this.isMigrationTasksInProgress(migrationData)) {
            log.info("Migration still in progress or empty-plan, returning 400");
            throw new InProgressPlanLogException();
        }
        Files.createDirectories(migrationLogDir, new FileAttribute[0]);
        List<GetTaskStatusResponse.TaskProgress> list = migrationData.getOutcome();
        Intrinsics.checkNotNull(list);
        List<GetTaskStatusResponse.TaskProgress> failedOrIncompleteTasks = this.determineFailedOrIncompleteProjectTasks(list);
        log.info("Fetching and combining project logs");
        List<Path> projectLogs2 = this.fetchAndCombineErrorLogs(migrationData, migrationLogDir, failedOrIncompleteTasks, (Function1<? super GetTaskStatusResponse.TaskProgress, String>)((Function1)generateLogsForMigration.projectLogs.1.INSTANCE));
        log.info("Fetching and combining cross project logs");
        List<GetTaskStatusResponse.TaskProgress> crossProjectTasks = this.determineCrossProjectTasks(migrationData.getOutcome());
        List<Path> crossProjectLogs2 = this.fetchAndCombineErrorLogs(migrationData, migrationLogDir, crossProjectTasks, (Function1<? super GetTaskStatusResponse.TaskProgress, String>)((Function1)generateLogsForMigration.crossProjectLogs.1.INSTANCE));
        try {
            log.info("Building final zip");
            MigrationLogsProvider.buildZip$default(this, logZip, CollectionsKt.plus((Collection)projectLogs2, (Iterable)crossProjectLogs2), CollectionsKt.listOf((Object)new Function1<ZipOutputStream, Unit>((Object)this){

                public final void invoke(@NotNull ZipOutputStream p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    MigrationLogsProvider.access$addReadMe((MigrationLogsProvider)this.receiver, p0);
                }
            }), false, 8, null);
        }
        finally {
            Iterable $this$forEach$iv = projectLogs2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                com.atlassian.jira.migration.common.LocalFileDataOutput.deleteHandlingExceptions$default(this.localFileDataOutput, it, null, 2, null);
            }
        }
    }

    private final boolean isMigrationTasksInProgress(Migration migrationData) {
        boolean bl;
        boolean isMigrationHaveATask;
        block9: {
            Collection collection = migrationData.getOutcome();
            isMigrationHaveATask = collection == null || collection.isEmpty();
            List<GetTaskStatusResponse.TaskProgress> list = migrationData.getOutcome();
            if (list != null) {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block8: {
                            GetTaskStatusResponse.TaskProgress taskProgress = (GetTaskStatusResponse.TaskProgress)element$iv;
                            boolean bl3 = false;
                            Map<ProgressUnit, ProgressItem> $this$any$iv2 = taskProgress.getProgressItems();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2.isEmpty()) {
                                bl2 = false;
                            } else {
                                Iterator<Map.Entry<ProgressUnit, ProgressItem>> iterator2 = $this$any$iv2.entrySet().iterator();
                                while (iterator2.hasNext()) {
                                    Map.Entry<ProgressUnit, ProgressItem> element$iv2;
                                    Map.Entry<ProgressUnit, ProgressItem> it = element$iv2 = iterator2.next();
                                    boolean bl4 = false;
                                    if (!(!it.getValue().getCompleted())) continue;
                                    bl2 = true;
                                    break block8;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            } else {
                bl = true;
            }
        }
        boolean isNoneTaskCompleted = bl;
        return isMigrationHaveATask || isNoneTaskCompleted;
    }

    @Nullable
    public final Path getErrorLogsZipPath(@NotNull String projectKeys, @NotNull String executionId) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)projectKeys, (String)"projectKeys");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Pair<File, Path> pair = this.generateExportErrorLogsZip(projectKeys, executionId);
        File errorLogZipFile = (File)pair.component1();
        Path errorLogZip = (Path)pair.component2();
        if (errorLogZipFile.exists()) {
            MetricsEventService.sendEventForPreflightProjectErrorDownload$default(this.metricsEventService, SUCCESS, 0.0, 2, null);
            path = errorLogZip;
        } else {
            MetricsEventService.sendEventForPreflightProjectErrorDownload$default(this.metricsEventService, FAILED, 0.0, 2, null);
            path = null;
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Path generateExportErrorLogsForBackgroundTask(@NotNull String executionId) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        CharSequence $this$mapTo$iv$iv;
        String $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Path backgroundExportDir = this.localFileDataOutput.migrationLogDirectory(executionId).resolve(EXPORT);
        Intrinsics.checkNotNull((Object)backgroundExportDir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(backgroundExportDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            log.error("Directory " + backgroundExportDir + " doesn't exist.");
            return null;
        }
        Pair<File, Path> pair = (Pair<File, Path>)PathsKt.listDirectoryEntries((Path)backgroundExportDir, (String)"*-project-export.log");
        StringBuilder stringBuilder = new StringBuilder();
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv = iterator2.next();
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"-"};
            collection.add((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)PathsKt.getName((Path)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
        }
        $this$map$iv = stringBuilder.append(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)((List)destination$iv$iv).toString(), (CharSequence)"["), (CharSequence)"]")).append('$').toString();
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = (CharSequence)$this$filterNot$iv;
        destination$iv$iv = new StringBuilder();
        boolean $i$f$filterNotTo = false;
        for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
            boolean bl = false;
            if (CharsKt.isWhitespace((char)it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String projectKeys = string;
        pair = this.generateExportErrorLogsZip(projectKeys, executionId);
        File errorLogZipFile = (File)pair.component1();
        Path errorLogZip = (Path)pair.component2();
        return errorLogZipFile.exists() ? errorLogZip : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<File, Path> generateExportErrorLogsZip(@NotNull String projectKeys, @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)projectKeys, (String)"projectKeys");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Path migrationLogDir = this.localFileDataOutput.migrationLogDirectory(executionId);
        Path errorLogZip = migrationLogDir.resolve("error-logs.zip");
        File errorLogZipFile = errorLogZip.toFile();
        if (errorLogZipFile.exists()) {
            errorLogZipFile.delete();
        }
        String string = (executionId + "-logs").intern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
        String string2 = string;
        synchronized (string2) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            SegregatedProjectKeys segregatedProjectKeys = ProjectKeysProcessor.INSTANCE.splitKeys(projectKeys);
            List<Path> projectLogs2 = this.fetchAndCombineDebugErrorLogs(segregatedProjectKeys.getProjectKeys(), executionId, migrationLogDir, PROJECT_FILE_PATH);
            List<Path> crossProjectLogs2 = this.getCrossProjectLogs(segregatedProjectKeys, executionId, migrationLogDir);
            Path projectErrorsZip = this.generateIndividualExportErrorLogsZip(migrationLogDir, projectLogs2, PROJECT_EXPORT_ERROR_FILENAME);
            Path crossProjectErrorsZip = this.generateIndividualExportErrorLogsZip(migrationLogDir, crossProjectLogs2, CROSS_PROJECT_EXPORT_ERROR_FILENAME);
            Object[] objectArray = new Path[]{projectErrorsZip, crossProjectErrorsZip};
            Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it = (Path)element$iv$iv;
                boolean bl2 = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List combinedZipPath = (List)destination$iv$iv;
            if (!((Collection)combinedZipPath).isEmpty()) {
                log.info("Building final zip in the path " + migrationLogDir);
                Intrinsics.checkNotNull((Object)errorLogZip);
                MigrationLogsProvider.buildZip$default(this, errorLogZip, combinedZipPath, null, true, 4, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        return new Pair((Object)errorLogZipFile, (Object)errorLogZip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path generateIndividualExportErrorLogsZip(Path migrationLogDir, List<? extends Path> logs, String errorFilePath) {
        Path errorLogZip = migrationLogDir.resolve(errorFilePath);
        File errorLogZipFile = errorLogZip.toFile();
        if (errorLogZipFile.exists()) {
            errorLogZipFile.delete();
        }
        try {
            log.info("Building " + errorFilePath);
            Intrinsics.checkNotNull((Object)errorLogZip);
            MigrationLogsProvider.buildZip$default(this, errorLogZip, logs, null, false, 12, null);
        }
        finally {
            Iterable $this$forEach$iv = logs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                com.atlassian.jira.migration.common.LocalFileDataOutput.deleteHandlingExceptions$default(this.localFileDataOutput, it, null, 2, null);
            }
        }
        return errorLogZip;
    }

    private final List<Path> getCrossProjectLogs(SegregatedProjectKeys segregatedProjectKeys, String executionId, Path migrationLogDir) {
        List<Path> crossProjectLogs2 = this.fetchAndCombineDebugErrorLogs(segregatedProjectKeys.getCrossProjectKey(), executionId, migrationLogDir, CROSS_PROJECT_FILE_PATH);
        List<Path> arPlanProjectLogs = this.fetchAndCombineDebugErrorLogs(segregatedProjectKeys.getArPlanProjectKeys(), executionId, migrationLogDir, PROJECT_FILE_PATH);
        return CollectionsKt.plus((Collection)crossProjectLogs2, (Iterable)arPlanProjectLogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public final Pair<File, Path> generateMigrationIsolatedLogsZip(@NotNull Path isolatedLogZip, @NotNull String isolatedLogId) {
        Intrinsics.checkNotNullParameter((Object)isolatedLogZip, (String)"isolatedLogZip");
        Intrinsics.checkNotNullParameter((Object)isolatedLogId, (String)"isolatedLogId");
        isolatedLogZipFile = isolatedLogZip.toFile();
        if (isolatedLogZipFile.exists()) {
            isolatedLogZipFile.delete();
        }
        v0 = (isolatedLogId + "-logs").intern();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"intern(...)");
        var4_4 = v0;
        synchronized (var4_4) {
            block11: {
                block10: {
                    $i$a$-synchronized-MigrationLogsProvider$generateMigrationIsolatedLogsZip$1 = false;
                    MigrationLogsProvider.log.info("Building migration isolated logs final zip");
                    var6_8 = this.jiraHome.getLogDirectory().listFiles();
                    if (var6_8 == null) break block10;
                    var7_9 = var6_8;
                    $i$f$filter = false;
                    var9_12 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (File element$iv$iv : $this$filterTo$iv$iv) {
                        it = element$iv$iv;
                        $i$a$-filter-MigrationLogsProvider$generateMigrationIsolatedLogsZip$1$isolatedMigrationLogs$1 = false;
                        if (!it.isFile()) ** GOTO lbl-1000
                        v1 = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
                        if (StringsKt.contains$default((CharSequence)v1, (CharSequence)"atlassian-jira-migration", (boolean)false, (int)2, null)) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        element$iv$iv = (File)item$iv$iv;
                        var18_23 = destination$iv$iv;
                        $i$a$-map-MigrationLogsProvider$generateMigrationIsolatedLogsZip$1$isolatedMigrationLogs$2 = false;
                        var18_23.add(it.toPath());
                    }
                    v3 = (List)destination$iv$iv;
                    break block11;
                }
                v3 = null;
            }
            v4 = isolatedMigrationLogs = v3;
            if (v4 != null) {
                it = v4;
                $i$a$-let-MigrationLogsProvider$generateMigrationIsolatedLogsZip$1$1 = false;
                MigrationLogsProvider.buildZip$default(this, isolatedLogZip, it, null, false, 12, null);
                v5 = Unit.INSTANCE;
            } else {
                v5 = null;
            }
            var5_6 = v5;
        }
        return new Pair((Object)isolatedLogZipFile, (Object)isolatedLogZip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Path> fetchAndCombineDebugErrorLogs(List<String> projectKeys, String executionId, Path migrationLogDir, String filePath) {
        void $this$mapTo$iv$iv;
        log.info("Generating logs zip for projectKeys [" + projectKeys + "] executionId [" + executionId + ']');
        Map combinedProjectErrorLogs = new LinkedHashMap();
        try {
            Path debugExportLogDirectory = this.localFileDataOutput.preFlightExecutionLogDirectory(executionId);
            Iterable $this$forEach$iv = projectKeys;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                String projectKey = (String)element$iv2;
                boolean bl = false;
                Path logLocation = debugExportLogDirectory.resolve(projectKey + '-' + filePath);
                this.addToCombinedPerProjectLog(logLocation, combinedProjectErrorLogs, projectKey, migrationLogDir);
            }
        }
        catch (Exception e) {
            log.error("Error while fetching and combining project error log files: " + e, (Throwable)e);
        }
        finally {
            Map $this$forEach$iv = combinedProjectErrorLogs;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                Object element$iv2;
                element$iv2 = element$iv;
                boolean bl = false;
                Pair zipData = (Pair)element$iv2.getValue();
                ((ZipOutputStream)zipData.getSecond()).closeEntry();
                ((ZipOutputStream)zipData.getSecond()).close();
            }
        }
        Map $this$map$iv = combinedProjectErrorLogs;
        boolean $i$f$map = false;
        Map $i$f$forEach = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry zipData = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Path)((Pair)it.getValue()).getFirst());
        }
        return (List)destination$iv$iv;
    }

    private final List<GetTaskStatusResponse.TaskProgress> determineFailedOrIncompleteProjectTasks(List<GetTaskStatusResponse.TaskProgress> outcome) {
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)outcome), (Function1)determineFailedOrIncompleteProjectTasks.1.INSTANCE), (Function1)determineFailedOrIncompleteProjectTasks.2.INSTANCE), (Function1)((Function1)new Function1<GetTaskStatusResponse.TaskProgress, GetTaskStatusResponse.TaskProgress>(this){
            final /* synthetic */ MigrationLogsProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final GetTaskStatusResponse.TaskProgress invoke(@NotNull GetTaskStatusResponse.TaskProgress taskProgress) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)taskProgress, (String)"taskProgress");
                Map<ProgressUnit, ProgressItem> map = taskProgress.getProgressItems();
                MigrationLogsProvider migrationLogsProvider = this.this$0;
                MigrationTask migrationTask = taskProgress.getTask();
                boolean $i$f$filter = false;
                void var5_6 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> it = element$iv$iv = iterator2.next();
                    boolean bl = false;
                    if (!CollectionsKt.contains((Iterable)MigrationLogsProvider.access$getStatusesToFetchOrUploadLogs$p(migrationLogsProvider), (Object)((Object)((ProgressItem)it.getValue()).getCompletionStatus()))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map map2 = destination$iv$iv;
                MigrationTask migrationTask2 = migrationTask;
                return new GetTaskStatusResponse.TaskProgress(migrationTask2, map2);
            }
        })), (Function1)determineFailedOrIncompleteProjectTasks.4.INSTANCE);
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GetTaskStatusResponse.TaskProgress it = (GetTaskStatusResponse.TaskProgress)a;
                boolean bl = false;
                MigrationTask migrationTask = it.getTask();
                Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.ProjectTask");
                it = (GetTaskStatusResponse.TaskProgress)b;
                Comparable comparable = (Comparable)((Object)((ProjectTask)migrationTask).getProjectKey());
                bl = false;
                MigrationTask migrationTask2 = it.getTask();
                Intrinsics.checkNotNull((Object)migrationTask2, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.ProjectTask");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)((ProjectTask)migrationTask2).getProjectKey())));
            }
        }));
    }

    @VisibleForTesting
    @NotNull
    public final List<GetTaskStatusResponse.TaskProgress> determineCrossProjectTasks(@NotNull List<GetTaskStatusResponse.TaskProgress> outcome) {
        Intrinsics.checkNotNullParameter(outcome, (String)"outcome");
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)outcome), (Function1)determineCrossProjectTasks.1.INSTANCE), (Function1)determineCrossProjectTasks.2.INSTANCE), (Function1)((Function1)new Function1<GetTaskStatusResponse.TaskProgress, GetTaskStatusResponse.TaskProgress>(this){
            final /* synthetic */ MigrationLogsProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final GetTaskStatusResponse.TaskProgress invoke(@NotNull GetTaskStatusResponse.TaskProgress taskProgress) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)taskProgress, (String)"taskProgress");
                Map<ProgressUnit, ProgressItem> map = taskProgress.getProgressItems();
                MigrationLogsProvider migrationLogsProvider = this.this$0;
                MigrationTask migrationTask = taskProgress.getTask();
                boolean $i$f$filter = false;
                void var5_6 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> it = element$iv$iv = iterator2.next();
                    boolean bl = false;
                    if (!CollectionsKt.contains((Iterable)MigrationLogsProvider.access$getStatusesToFetchOrUploadLogsForCrossProject$p(migrationLogsProvider), (Object)((Object)((ProgressItem)it.getValue()).getCompletionStatus()))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map map2 = destination$iv$iv;
                MigrationTask migrationTask2 = migrationTask;
                return new GetTaskStatusResponse.TaskProgress(migrationTask2, map2);
            }
        })), (Function1)determineCrossProjectTasks.4.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Path> fetchAndCombineErrorLogs(Migration migrationData, Path migLogDir, List<GetTaskStatusResponse.TaskProgress> failedOrIncompleteTasks, Function1<? super GetTaskStatusResponse.TaskProgress, String> prefixProvider) {
        void $this$mapTo$iv$iv;
        boolean bl;
        Object taskProgress;
        Map combinedLogDataByPrefix = new LinkedHashMap();
        try {
            Object $this$forEach$iv = failedOrIncompleteTasks;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                taskProgress = (GetTaskStatusResponse.TaskProgress)t;
                bl = false;
                Map<ProgressUnit, ProgressItem> $this$forEach$iv2 = ((GetTaskStatusResponse.TaskProgress)taskProgress).getProgressItems();
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<ProgressUnit, ProgressItem>> iterator3 = $this$forEach$iv2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry<ProgressUnit, ProgressItem> element$iv2;
                    Map.Entry<ProgressUnit, ProgressItem> entry = element$iv2 = iterator3.next();
                    boolean bl2 = false;
                    ProgressUnit progressUnit = entry.getKey();
                    String prefix2 = (String)prefixProvider.invoke(taskProgress);
                    MigrationTaskType taskType = ((GetTaskStatusResponse.TaskProgress)taskProgress).getTask().getMigrationTaskType();
                    Path detailedLogLocation = this.getLogFile(migrationData, taskType, progressUnit, prefix2);
                    this.addToCombinedPerProjectLog(detailedLogLocation, combinedLogDataByPrefix, prefix2, migLogDir);
                }
            }
            $this$forEach$iv = combinedLogDataByPrefix;
            $i$f$forEach = false;
        }
        catch (Throwable $this$forEach$iv) {
            Map $this$forEach$iv3 = combinedLogDataByPrefix;
            boolean $i$f$forEach = false;
            Iterator iterator4 = $this$forEach$iv3.entrySet().iterator();
            while (iterator4.hasNext()) {
                Map.Entry element$iv3;
                Map.Entry entry = element$iv3 = iterator4.next();
                boolean bl2 = false;
                Pair zipData = (Pair)entry.getValue();
                ((ZipOutputStream)zipData.getSecond()).closeEntry();
                ((ZipOutputStream)zipData.getSecond()).close();
            }
            throw $this$forEach$iv;
        }
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            taskProgress = entry;
            bl = false;
            Pair zipData = (Pair)taskProgress.getValue();
            ((ZipOutputStream)zipData.getSecond()).closeEntry();
            ((ZipOutputStream)zipData.getSecond()).close();
        }
        Map $this$map$iv = combinedLogDataByPrefix;
        boolean $i$f$map = false;
        Map $i$f$forEach = $this$map$iv;
        Collection collection = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator5 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator5.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry zipData = item$iv$iv = iterator5.next();
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add((Path)((Pair)it.getValue()).getFirst());
        }
        return (List)collection;
    }

    private final Path getLogFile(Migration migrationData, MigrationTaskType taskType, ProgressUnit progressUnit, String prefix2) {
        Path path;
        Lazy cloudSite$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CloudSite>(this, migrationData){
            final /* synthetic */ MigrationLogsProvider this$0;
            final /* synthetic */ Migration $migrationData;
            {
                this.this$0 = $receiver;
                this.$migrationData = $migrationData;
                super(0);
            }

            @Nullable
            public final CloudSite invoke() {
                return DiscoveryService.retrieveCloudSiteFor$default(MigrationLogsProvider.access$getDiscoveryService$p(this.this$0), this.$migrationData.getMigrationId(), false, 2, null);
            }
        }));
        Lazy tagCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, String>>(this){
            final /* synthetic */ MigrationLogsProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, String> invoke() {
                return MigrationLogsProvider.access$getLogTagProcessor$p(this.this$0).createCache();
            }
        }));
        Lazy migrationStartedByUser$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ApplicationUser>(this, migrationData){
            final /* synthetic */ MigrationLogsProvider this$0;
            final /* synthetic */ Migration $migrationData;
            {
                this.this$0 = $receiver;
                this.$migrationData = $migrationData;
                super(0);
            }

            @Nullable
            public final ApplicationUser invoke() {
                return MigrationLogsProvider.access$getJiraUserProjectManager$p(this.this$0).getUserByKey(this.$migrationData.getStartedBy());
            }
        }));
        Path existingLegacyLogFile = this.legacyLogFileLocation(migrationData.getMigrationId(), taskType, progressUnit, prefix2);
        Path existingLogFile = this.logFileLocation(migrationData.getMigrationId(), taskType, progressUnit, prefix2);
        if (existingLegacyLogFile.toFile().exists()) {
            path = existingLegacyLogFile;
        } else if (existingLogFile.toFile().exists()) {
            path = existingLogFile;
        } else if (!taskType.isLocal()) {
            CloudSite cloudSite2 = MigrationLogsProvider.getLogFile$lambda$25((Lazy<? extends CloudSite>)cloudSite$delegate);
            if (cloudSite2 != null) {
                Path path2;
                CloudSite it = cloudSite2;
                boolean bl = false;
                this.doFetchMissingLogFile(new MigrationDetails(migrationData.getMigrationId(), migrationData.getProtocol(), it, prefix2), MigrationLogsProvider.getLogFile$lambda$26((Lazy<? extends Map<String, String>>)tagCache$delegate), progressUnit, existingLogFile, MigrationLogsProvider.getLogFile$lambda$27((Lazy<? extends ApplicationUser>)migrationStartedByUser$delegate));
                MigrationLogsProvider.getLogFile$lambda$26((Lazy<? extends Map<String, String>>)tagCache$delegate).clear();
                Path elf = path2 = existingLogFile;
                boolean bl2 = false;
                path = elf.toFile().exists() ? path2 : null;
            } else {
                path = null;
            }
        } else {
            path = null;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addToCombinedPerProjectLog(Path detailedLogLocation, Map<String, Pair<Path, ZipOutputStream>> combinedProjectLogData, String prefix2, Path migLogDir) {
        block8: {
            File file2;
            File file3;
            File detailedLogLocationFile;
            Path path = detailedLogLocation;
            File file4 = detailedLogLocationFile = path != null ? path.toFile() : null;
            if (detailedLogLocationFile == null) break block8;
            File it = file3 = detailedLogLocationFile;
            boolean bl = false;
            File file5 = file2 = it.exists() ? file3 : null;
            if (file2 != null) {
                File $this$addToCombinedPerProjectLog_u24lambda_u2433 = file3 = file2;
                boolean bl2 = false;
                Pair pair = combinedProjectLogData.computeIfAbsent(prefix2, arg_0 -> MigrationLogsProvider.addToCombinedPerProjectLog$lambda$33$lambda$31((Function1)new Function1<String, Pair<? extends Path, ? extends ZipOutputStream>>(this, migLogDir, prefix2){
                    final /* synthetic */ MigrationLogsProvider this$0;
                    final /* synthetic */ Path $migLogDir;
                    final /* synthetic */ String $prefix;
                    {
                        this.this$0 = $receiver;
                        this.$migLogDir = $migLogDir;
                        this.$prefix = $prefix;
                        super(1);
                    }

                    @NotNull
                    public final Pair<Path, ZipOutputStream> invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Path tmpLogFileLocation = MigrationLogsProvider.access$combinedLogFileLocation(this.this$0, this.$migLogDir, this.$prefix);
                        ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmpLogFileLocation.toFile())));
                        zipOut.putNextEntry(new ZipEntry(this.$prefix + ".log"));
                        return TuplesKt.to((Object)tmpLogFileLocation, (Object)zipOut);
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"computeIfAbsent(...)");
                Pair combinedLogData2 = pair;
                log.info("Merging " + this.relativeParentPath(detailedLogLocation) + " into " + this.relativeParentPath((Path)combinedLogData2.getFirst()));
                String string = $this$addToCombinedPerProjectLog_u24lambda_u2433.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) {
                    ZipInputStream dlZipIn = new ZipInputStream(new BufferedInputStream(new FileInputStream($this$addToCombinedPerProjectLog_u24lambda_u2433)));
                    Closeable closeable = dlZipIn;
                    Throwable throwable = null;
                    try {
                        ZipInputStream it2 = (ZipInputStream)closeable;
                        boolean bl3 = false;
                        it2.getNextEntry();
                        long l = ByteStreamsKt.copyTo$default((InputStream)it2, (OutputStream)((OutputStream)combinedLogData2.getSecond()), (int)0, (int)2, null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    Files.copy(detailedLogLocation, (OutputStream)combinedLogData2.getSecond());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void doFetchMissingLogFile(@NotNull MigrationDetails migrationDetails, @NotNull Map<String, String> tagCache2, @NotNull ProgressUnit progressUnit, @NotNull Path missingLogFile, @Nullable ApplicationUser user) {
        block7: {
            Path path;
            Intrinsics.checkNotNullParameter((Object)migrationDetails, (String)"migrationDetails");
            Intrinsics.checkNotNullParameter(tagCache2, (String)"tagCache");
            Intrinsics.checkNotNullParameter((Object)((Object)progressUnit), (String)"progressUnit");
            Intrinsics.checkNotNullParameter((Object)missingLogFile, (String)"missingLogFile");
            Files.createDirectories(missingLogFile.getParent(), new FileAttribute[0]);
            UUID fileNameUUID = UUID.randomUUID();
            Path it = path = missingLogFile.resolveSibling(missingLogFile.getFileName() + '-' + fileNameUUID + ".tmp");
            boolean bl = false;
            it.toFile().deleteOnExit();
            Path tmpDownloadFile = path;
            Path it2 = it = missingLogFile.resolveSibling(missingLogFile.getFileName() + '-' + fileNameUUID + ".proc");
            boolean bl2 = false;
            it2.toFile().deleteOnExit();
            Path tmpProcessedLogFile = it;
            try {
                StringBuilder stringBuilder = new StringBuilder().append("Downloading remote ").append(migrationDetails).append(".migrationProtocol ").append((Object)progressUnit).append(" log for ").append(migrationDetails).append(".projectKey to: ");
                Intrinsics.checkNotNull((Object)tmpDownloadFile);
                log.info(stringBuilder.append(this.relativeParentPath(tmpDownloadFile)).toString());
                long downloadedBytes = this.downloadRemoteLogs(migrationDetails, progressUnit, tmpDownloadFile);
                if (downloadedBytes > 0L) {
                    StringBuilder stringBuilder2 = new StringBuilder().append("Finished downloading to: ").append(this.relativeParentPath(tmpDownloadFile)).append(", size ");
                    String string = "%.3f";
                    Object[] objectArray = new Object[]{(double)downloadedBytes / 1024.0};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    log.info(stringBuilder2.append(string2).append(" KB").toString());
                    Intrinsics.checkNotNull((Object)tmpProcessedLogFile);
                    this.processTags(tagCache2, tmpProcessedLogFile, tmpDownloadFile, migrationDetails.getProjectKey(), migrationDetails.getMigrationProtocol(), user);
                    this.localFileDataOutput.atomicMove(tmpProcessedLogFile, missingLogFile);
                } else {
                    log.info("No " + (Object)((Object)progressUnit) + " log available for " + migrationDetails + ".projectKey");
                }
                Intrinsics.checkNotNull((Object)tmpProcessedLogFile);
            }
            catch (Exception e) {
                log.error("Error downloading remote " + (Object)((Object)progressUnit) + " log for " + migrationDetails + ".projectKey: " + e, (Throwable)e);
                break block7;
            }
            finally {
                Intrinsics.checkNotNull((Object)tmpProcessedLogFile);
                com.atlassian.jira.migration.common.LocalFileDataOutput.deleteHandlingExceptions$default(this.localFileDataOutput, tmpProcessedLogFile, null, 2, null);
                Intrinsics.checkNotNull((Object)tmpDownloadFile);
                com.atlassian.jira.migration.common.LocalFileDataOutput.deleteHandlingExceptions$default(this.localFileDataOutput, tmpDownloadFile, null, 2, null);
            }
            com.atlassian.jira.migration.common.LocalFileDataOutput.deleteHandlingExceptions$default(this.localFileDataOutput, tmpProcessedLogFile, null, 2, null);
            com.atlassian.jira.migration.common.LocalFileDataOutput.deleteHandlingExceptions$default(this.localFileDataOutput, tmpDownloadFile, null, 2, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final long downloadRemoteLogs(MigrationDetails migrationDetails, ProgressUnit progressUnit, Path tmpDownloadFile) {
        long l;
        if (Intrinsics.areEqual((Object)migrationDetails.getProjectKey(), (Object)"CROSS-PROJECT-DATA")) {
            ContainerToken containerToken = ContainerToken.of((String)migrationDetails.getCloudSite().getContainerToken());
            Intrinsics.checkNotNullExpressionValue((Object)containerToken, (String)"of(...)");
            Long l2 = this.downloadLogs(containerToken, new MigrationId(migrationDetails.getMigrationId()), migrationDetails.getProjectKey(), ProgressUnit.PROJECT, tmpDownloadFile, migrationDetails.getMigrationProtocol());
            if (l2 == null) return 0L;
            l = l2;
            return l;
        } else {
            Project project = this.jiraUserProjectManager.getProjectObjByKey(migrationDetails.getProjectKey());
            Object object = project;
            if (project == null) return 0L;
            Project project2 = object;
            boolean bl = false;
            ContainerToken containerToken = ContainerToken.of((String)migrationDetails.getCloudSite().getContainerToken());
            Intrinsics.checkNotNullExpressionValue((Object)containerToken, (String)"of(...)");
            Long l3 = this.downloadLogs(containerToken, new MigrationId(migrationDetails.getMigrationId()), String.valueOf(project2.getId()), progressUnit, tmpDownloadFile, migrationDetails.getMigrationProtocol());
            object = l3;
            if (l3 == null) return 0L;
            l = (Long)object;
        }
        return l;
    }

    private final Long downloadLogs(ContainerToken containerToken, MigrationId migrationId, String sourceId, ProgressUnit progressUnit, Path tmpDownloadFile, MigrationProtocol migrationProtocol) {
        Long l;
        if (migrationProtocol == MigrationProtocol.V4) {
            String string;
            if (Intrinsics.areEqual((Object)sourceId, (Object)"CROSS-PROJECT-DATA")) {
                string = SITE;
            } else {
                String string2 = ContainerId.forJiraContainer((MigrationId)migrationId, (String)sourceId).toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            String mrcSourceId = string;
            l = this.migrationReportCenterClient.downloadLogs(containerToken, migrationId, mrcSourceId, tmpDownloadFile);
        } else {
            l = this.migrationLogsClient.downloadLogs(containerToken, migrationId, sourceId, progressUnit, tmpDownloadFile);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processCsvFile(ZipOutputStream pOut, Path tmpLogFilePath, String fileName, AtomicLong tagsReplaced, Map<String, String> tagCache2, String projectKey, ApplicationUser user) {
        CsvBeanReader csvBeanReader = new CsvBeanReader((Reader)new InputStreamReader(new FileInputStream(tmpLogFilePath.toFile())), CsvPreference.STANDARD_PREFERENCE);
        Closeable closeable = (Closeable)csvBeanReader;
        Throwable throwable = null;
        try {
            CsvBeanReader reader = (CsvBeanReader)closeable;
            boolean bl = false;
            reader.getHeader(true);
            pOut.putNextEntry(new ZipEntry(fileName));
            OutputStream outputStream = pOut;
            Charset charset = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter(outputStream, charset);
            int n = 8192;
            long l = tagsReplaced.addAndGet(this.logTagProcessor.processCsv(tagCache2, reader, writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n), projectKey, user));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        csvBeanReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processTags(Map<String, String> tagCache2, Path processedLogFile, Path tmpLogFile, String projectKey, MigrationProtocol migrationProtocol, ApplicationUser user) {
        long processTagsStartTime = System.currentTimeMillis();
        log.info("Processing any tags into: " + this.relativeParentPath(processedLogFile));
        AtomicLong tagsReplaced = new AtomicLong(0L);
        ZipOutputStream processedOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(processedLogFile.toFile())));
        Object object = new MigrationProtocol[]{MigrationProtocol.V4, MigrationProtocol.V3_5};
        if (CollectionsKt.listOf((Object[])object).contains((Object)migrationProtocol)) {
            String fileName = null;
            if (Intrinsics.areEqual((Object)projectKey, (Object)"CROSS-PROJECT-DATA")) {
                fileName = projectKey + ".log";
            } else {
                String projectId = String.valueOf(this.jiraUserProjectManager.getProjectObjByKey(projectKey).getId());
                fileName = projectId + "-project-errors.log";
            }
            Closeable closeable = processedOut;
            Throwable throwable = null;
            try {
                ZipOutputStream pOut = (ZipOutputStream)closeable;
                boolean bl = false;
                this.processCsvFile(pOut, tmpLogFile, fileName, tagsReplaced, tagCache2, projectKey, user);
                pOut.closeEntry();
                pOut = Unit.INSTANCE;
            }
            catch (Throwable pOut) {
                throwable = pOut;
                throw pOut;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        object = processedOut;
        Throwable throwable = null;
        try {
            ZipOutputStream pOut = (ZipOutputStream)object;
            boolean bl = false;
            ZipInputStream downloadedIn = new ZipInputStream(new BufferedInputStream(new FileInputStream(tmpLogFile.toFile())));
            ZipEntry zipEntry = downloadedIn.getNextEntry();
            String dInEntryName = zipEntry != null ? zipEntry.getName() : null;
            Closeable closeable = downloadedIn;
            Throwable throwable2 = null;
            try {
                ZipInputStream dIn = (ZipInputStream)closeable;
                boolean bl2 = false;
                pOut.putNextEntry(new ZipEntry(dInEntryName));
                Closeable closeable2 = dIn;
                Charset charset = Charsets.UTF_8;
                Closeable closeable3 = new InputStreamReader((InputStream)closeable2, charset);
                int n = 8192;
                BufferedReader bufferedReader = closeable3 instanceof BufferedReader ? (BufferedReader)closeable3 : new BufferedReader((Reader)closeable3, n);
                closeable2 = pOut;
                charset = Charsets.UTF_8;
                closeable3 = new OutputStreamWriter((OutputStream)closeable2, charset);
                n = 8192;
                tagsReplaced.addAndGet(this.logTagProcessor.process(tagCache2, bufferedReader, closeable3 instanceof BufferedWriter ? (BufferedWriter)closeable3 : new BufferedWriter((Writer)closeable3, n), projectKey, user));
                pOut.closeEntry();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        log.info("Finished processing " + tagsReplaced.get() + " tags in " + (System.currentTimeMillis() - processTagsStartTime) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void buildZip(@NotNull Path logZip, @NotNull List<? extends Path> filesToZipUp, @NotNull List<? extends Function1<? super ZipOutputStream, Unit>> zipEnhancers, boolean zipInsideZip) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)logZip, (String)"logZip");
        Intrinsics.checkNotNullParameter(filesToZipUp, (String)"filesToZipUp");
        Intrinsics.checkNotNullParameter(zipEnhancers, (String)"zipEnhancers");
        Path tmpZip = logZip.resolveSibling(logZip.getFileName() + '-' + UUID.randomUUID() + ".tmp");
        File it = file2 = tmpZip.toFile();
        boolean bl = false;
        it.deleteOnExit();
        File tmpZipFile = file2;
        try {
            AtomicBoolean addedLogs = new AtomicBoolean(false);
            ZipOutputStream tmpZipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmpZipFile)));
            Closeable closeable = tmpZipOut;
            Throwable throwable = null;
            try {
                ZipOutputStream zip = (ZipOutputStream)closeable;
                boolean bl2 = false;
                Iterable $this$forEach$iv = zipEnhancers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function1 it2 = (Function1)element$iv;
                    boolean bl3 = false;
                    it2.invoke((Object)zip);
                }
                $this$forEach$iv = filesToZipUp;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path f = (Path)element$iv;
                    boolean bl4 = false;
                    log.info("Adding " + this.relativeParentPath(f) + " to zip");
                    if (zipInsideZip) {
                        this.localFileDataOutput.addToZip(zip, ((Object)f.getFileName()).toString(), new BufferedInputStream(new FileInputStream(f.toFile())));
                    } else {
                        LocalFileDataOutput.addToZip$default((LocalFileDataOutput)this.localFileDataOutput, (ZipOutputStream)zip, (Path)f, null, (int)4, null);
                    }
                    addedLogs.set(true);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (tmpZipFile.exists() && addedLogs.get()) {
                log.info("Finalize zip");
                Intrinsics.checkNotNull((Object)tmpZip);
                this.localFileDataOutput.atomicMove(tmpZip, logZip);
            }
        }
        catch (Exception e) {
            log.warn("Error building zip file: " + e, (Throwable)e);
        }
        finally {
            Intrinsics.checkNotNull((Object)tmpZip);
            com.atlassian.jira.migration.common.LocalFileDataOutput.deleteHandlingExceptions$default(this.localFileDataOutput, tmpZip, null, 2, null);
        }
    }

    public static /* synthetic */ void buildZip$default(MigrationLogsProvider migrationLogsProvider, Path path, List list, List list2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        migrationLogsProvider.buildZip(path, list, list2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addReadMe(ZipOutputStream zip) {
        log.info("Adding readme to final zip");
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("log-readme.txt");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                zip.putNextEntry(new ZipEntry("readme.txt"));
                ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)zip, (int)0, (int)2, null);
                zip.closeEntry();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    private final Path combinedLogFileLocation(Path migDir, String projectKey) {
        Path path = migDir.resolve(projectKey + '-' + UUID.randomUUID() + ".log.zip");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path relativeParentPath(Path $this$relativeParentPath) {
        Path path = $this$relativeParentPath.subpath($this$relativeParentPath.getNameCount() - 2, $this$relativeParentPath.getNameCount());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"subpath(...)");
        return path;
    }

    @NotNull
    public final Path logFileLocation(@NotNull String migrationId, @NotNull MigrationTaskType taskType, @NotNull ProgressUnit progressUnit, @NotNull String projectKey) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)((Object)taskType), (String)"taskType");
        Intrinsics.checkNotNullParameter((Object)((Object)progressUnit), (String)"progressUnit");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Path migrationLogDir = this.localFileDataOutput.migrationLogDirectory(migrationId);
        return this.generateRelativeLogFileLocation(migrationLogDir, taskType, progressUnit, projectKey);
    }

    @NotNull
    public final Path legacyLogFileLocation(@NotNull String migrationId, @NotNull MigrationTaskType taskType, @NotNull ProgressUnit progressUnit, @NotNull String projectKey) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)((Object)taskType), (String)"taskType");
        Intrinsics.checkNotNullParameter((Object)((Object)progressUnit), (String)"progressUnit");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Path migrationLogDir = this.localFileDataOutput.legacyMigrationLogDirectory(migrationId);
        return this.generateRelativeLogFileLocation(migrationLogDir, taskType, progressUnit, projectKey);
    }

    @NotNull
    public final Path generateRelativeLogFileLocation(@NotNull Path migrationLogDir, @NotNull MigrationTaskType taskType, @NotNull ProgressUnit progressUnit, @NotNull String prefix2) {
        Intrinsics.checkNotNullParameter((Object)migrationLogDir, (String)"migrationLogDir");
        Intrinsics.checkNotNullParameter((Object)((Object)taskType), (String)"taskType");
        Intrinsics.checkNotNullParameter((Object)((Object)progressUnit), (String)"progressUnit");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Path parentDir = taskType.isLocal() ? migrationLogDir.resolve(EXPORT) : migrationLogDir.resolve(IMPORT);
        String fileNameSuffix = taskType.isLocal() ? EXPORT : IMPORT;
        String fileNameExt = taskType.isLocal() ? EXT_LOG : EXT_LOG_ZIP;
        Path path = parentDir.resolve(prefix2 + '-' + (Object)((Object)progressUnit) + '-' + fileNameSuffix + '.' + fileNameExt);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final CloudSite getLogFile$lambda$25(Lazy<? extends CloudSite> $cloudSite$delegate) {
        Lazy<? extends CloudSite> lazy = $cloudSite$delegate;
        return (CloudSite)lazy.getValue();
    }

    private static final Map<String, String> getLogFile$lambda$26(Lazy<? extends Map<String, String>> $tagCache$delegate) {
        Lazy<? extends Map<String, String>> lazy = $tagCache$delegate;
        return (Map)lazy.getValue();
    }

    private static final ApplicationUser getLogFile$lambda$27(Lazy<? extends ApplicationUser> $migrationStartedByUser$delegate) {
        Lazy<? extends ApplicationUser> lazy = $migrationStartedByUser$delegate;
        return (ApplicationUser)lazy.getValue();
    }

    private static final Pair addToCombinedPerProjectLog$lambda$33$lambda$31(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$addReadMe(MigrationLogsProvider $this, ZipOutputStream zip) {
        $this.addReadMe(zip);
    }

    public static final /* synthetic */ Set access$getStatusesToFetchOrUploadLogs$p(MigrationLogsProvider $this) {
        return $this.statusesToFetchOrUploadLogs;
    }

    public static final /* synthetic */ Set access$getStatusesToFetchOrUploadLogsForCrossProject$p(MigrationLogsProvider $this) {
        return $this.statusesToFetchOrUploadLogsForCrossProject;
    }

    public static final /* synthetic */ DiscoveryService access$getDiscoveryService$p(MigrationLogsProvider $this) {
        return $this.discoveryService;
    }

    public static final /* synthetic */ LogTagProcessor access$getLogTagProcessor$p(MigrationLogsProvider $this) {
        return $this.logTagProcessor;
    }

    public static final /* synthetic */ JiraUserProjectManager access$getJiraUserProjectManager$p(MigrationLogsProvider $this) {
        return $this.jiraUserProjectManager;
    }

    public static final /* synthetic */ Path access$combinedLogFileLocation(MigrationLogsProvider $this, Path migDir, String projectKey) {
        return $this.combinedLogFileLocation(migDir, projectKey);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/log/MigrationLogsProvider$Companion;", "", "()V", "CROSS_PROJECT_EXPORT_ERROR_FILENAME", "", "CROSS_PROJECT_FILE_PATH", "EXPORT", "EXT_LOG", "EXT_LOGS_ZIP", "EXT_LOG_ZIP", "FAILED", "IMPORT", "MIGRATION_ISOLATED_LOGS_FILENAME", "PROJECT_EXPORT_ERROR_FILENAME", "PROJECT_FILE_PATH", "SITE", "SUCCESS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

