/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationStatusUpdatedEvent;
import com.atlassian.jira.migration.events.MigrationTaskCompletedEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.log.MigrationLogsProvider;
import com.atlassian.jira.migration.log.MigrationLogsService;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProjectTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.TaskCompletionStatus;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.PlatformUploadServiceInterface;
import com.atlassian.jira.migration.publicapi.service.ArtifactService;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 X2\u00020\u0001:\u0001XBO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0016\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bJ\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u001bH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020\u001bJ \u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u0019H\u0007J\b\u00103\u001a\u00020\u001bH\u0002J\u0018\u00104\u001a\u0004\u0018\u00010\u00192\u0006\u00105\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bJ\u0010\u00106\u001a\u0004\u0018\u00010\u00192\u0006\u00107\u001a\u00020\u001bJ\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J \u0010=\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020;2\u0006\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u001bH\u0002J&\u0010@\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u001bJ\u0010\u0010F\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020;H\u0007J\u0010\u0010G\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020HH\u0007J\b\u0010I\u001a\u00020\u001dH\u0007J\b\u0010J\u001a\u00020\u001dH\u0007J\u0012\u0010K\u001a\u0004\u0018\u00010\u001b2\u0006\u0010L\u001a\u00020,H\u0002J\u0012\u0010M\u001a\u0004\u0018\u00010\u001b2\u0006\u0010L\u001a\u00020,H\u0002J\u0016\u0010N\u001a\u00020\u001d2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001d0PH\u0002J\u0016\u0010Q\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020\u001bJ\u0016\u0010S\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020\u001bJ,\u0010T\u001a\u0004\u0018\u00010\u001b2\b\u0010U\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020\u001bH\u0002J,\u0010W\u001a\u0004\u0018\u00010\u001b2\b\u0010U\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020\u001bH\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/atlassian/jira/migration/log/MigrationLogsService;", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "eventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "migrationLogsProvider", "Lcom/atlassian/jira/migration/log/MigrationLogsProvider;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "publicApiArtifactService", "Lcom/atlassian/jira/migration/publicapi/service/ArtifactService;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/log/MigrationLogsProvider;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/cluster/ClusterManager;Lcom/atlassian/jira/migration/publicapi/service/ArtifactService;)V", "statusesToFetchOrUploadLogs", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/TaskCompletionStatus;", "createScopeDir", "Ljava/nio/file/Path;", "migrationId", "", "deleteAllCustomersExportFile", "", "allCustomersPath", "deleteExistingPreflightExecutionLogs", "executionId", "filePath", "extractDateTimeFromLogLine", "Ljava/time/LocalDateTime;", "log", "findLastLogEntry", "raf", "Ljava/io/RandomAccessFile;", "dateTimePattern", "Ljava/util/regex/Pattern;", "generateIntervalMigrationLogFilename", "logFile", "Ljava/io/File;", "generateLogsForBackgroundTask", "generateLogsForMigration", "migrationData", "Lcom/atlassian/jira/migration/migration/Migration;", "migrationLogDir", "logZip", "generateMigrationIsolatedLogsFileName", "getGeneratedErrorLogsZipForProjects", "projectKeys", "getLogsForPlan", "planId", "isFinishedMigrationHasErrors", "", "event", "Lcom/atlassian/jira/migration/events/MigrationStatusUpdatedEvent;", "isMigrationHasUnsuccessfulTasks", "linkErrorLogFileToTask", "fileId", "fileName", "logFileLocation", "taskType", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "progressUnit", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;", "projectKey", "onMigrationCompleted", "onTaskCompleted", "Lcom/atlassian/jira/migration/events/MigrationTaskCompletedEvent;", "postConstruct", "preDestroy", "readFirstLogLineWithTimestamp", "file", "readLastLogLineWithTimestamp", "runWithJiraThreadLocalUtil", "block", "Lkotlin/Function0;", "uploadIntervalMigrationLogs", "cloudId", "uploadMigrationIsolatedLogs", "uploadMigrationLogsToMCS", "path", "filename", "uploadMigrationLogsToMCSWithClusterLock", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationLogsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationLogsService.kt\ncom/atlassian/jira/migration/log/MigrationLogsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,460:1\n1549#2:461\n1620#2,3:462\n1747#2,2:465\n1747#2,3:467\n1749#2:470\n1#3:471\n*S KotlinDebug\n*F\n+ 1 MigrationLogsService.kt\ncom/atlassian/jira/migration/log/MigrationLogsService\n*L\n161#1:461\n161#1:462,3\n161#1:465,2\n162#1:467,3\n161#1:470\n*E\n"})
public final class MigrationLogsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationEventBus eventBus;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final MigrationLogsProvider migrationLogsProvider;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final ArtifactService publicApiArtifactService;
    @NotNull
    private final Set<TaskCompletionStatus> statusesToFetchOrUploadLogs;
    private static final Logger log = LoggerFactory.getLogger(MigrationLogsService.class);
    @NotNull
    public static final String MIGRATION_LOGS_SEND_LOCK = "jcma.migration.logs.send";
    @NotNull
    public static final String LOG_TIMESTAMP_REGEX = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3}";
    @NotNull
    public static final String LOG_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss,SSS";

    @VisibleForTesting
    @Inject
    public MigrationLogsService(@NotNull LocalFileDataOutput localFileDataOutput, @NotNull DiscoveryService discoveryService, @NotNull MigrationEventBus eventBus, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull MigrationLogsProvider migrationLogsProvider, @NotNull PlatformService platformService, @NotNull MigrationFeatures migrationFeatures, @NotNull ClusterManager clusterManager, @NotNull ArtifactService publicApiArtifactService) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)migrationLogsProvider, (String)"migrationLogsProvider");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter((Object)publicApiArtifactService, (String)"publicApiArtifactService");
        this.localFileDataOutput = localFileDataOutput;
        this.discoveryService = discoveryService;
        this.eventBus = eventBus;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.migrationLogsProvider = migrationLogsProvider;
        this.platformService = platformService;
        this.migrationFeatures = migrationFeatures;
        this.clusterManager = clusterManager;
        this.publicApiArtifactService = publicApiArtifactService;
        TaskCompletionStatus[] taskCompletionStatusArray = new TaskCompletionStatus[]{TaskCompletionStatus.INCOMPLETE, TaskCompletionStatus.FAILURE};
        this.statusesToFetchOrUploadLogs = SetsKt.setOf((Object[])taskCompletionStatusArray);
    }

    @PostConstruct
    public final void postConstruct() {
        this.eventBus.register(this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public final void onMigrationCompleted(@NotNull MigrationStatusUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.migrationFeatures.getEnableAlwaysUploadMigrationLogsToMCS() || event.getStatus() == MigrationStatusUpdatedEvent.Status.ERRORED || this.isFinishedMigrationHasErrors(event)) {
            this.runWithJiraThreadLocalUtil((Function0<Unit>)((Function0)new Function0<Unit>(this, event){
                final /* synthetic */ MigrationLogsService this$0;
                final /* synthetic */ MigrationStatusUpdatedEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(0);
                }

                public final void invoke() {
                    block9: {
                        Object $this$invoke_u24lambda_u242;
                        Object object = this.this$0;
                        Object object2 = this.$event;
                        try {
                            Path path;
                            Path path2;
                            $this$invoke_u24lambda_u242 = object;
                            boolean bl = false;
                            MigrationLogsService.access$getLog$cp().info("Generating zip for migration [" + ((MigrationStatusUpdatedEvent)object2).getMigrationId() + ']');
                            Migration migration = MigrationLogsService.access$getDiscoveryService$p((MigrationLogsService)$this$invoke_u24lambda_u242).findByMigrationId(((MigrationStatusUpdatedEvent)object2).getMigrationId());
                            if (migration != null) {
                                Migration it = migration;
                                boolean bl2 = false;
                                path2 = MigrationLogsService.access$getMigrationLogsProvider$p((MigrationLogsService)$this$invoke_u24lambda_u242).getLogsForMigration(it);
                            } else {
                                path2 = path = null;
                            }
                            if (path != null) {
                                String fileName = "migration-error-logs.zip";
                                String string = MigrationLogsService.access$uploadMigrationLogsToMCSWithClusterLock((MigrationLogsService)$this$invoke_u24lambda_u242, path, ((MigrationStatusUpdatedEvent)object2).getMigrationId(), ((MigrationStatusUpdatedEvent)object2).getCloudId(), fileName);
                                if (string != null) {
                                    String string2;
                                    String fileId = string2 = string;
                                    boolean bl3 = false;
                                    MigrationLogsService.access$linkErrorLogFileToTask((MigrationLogsService)$this$invoke_u24lambda_u242, (MigrationStatusUpdatedEvent)object2, fileId, fileName);
                                }
                            } else {
                                MigrationLogsService.access$getLog$cp().info("Failed to find migration error logs.");
                            }
                            ((MigrationLogsService)$this$invoke_u24lambda_u242).uploadMigrationIsolatedLogs(((MigrationStatusUpdatedEvent)object2).getMigrationId(), ((MigrationStatusUpdatedEvent)object2).getCloudId());
                            Path allCustomersPath = MigrationLogsService.access$getLocalFileDataOutput$p((MigrationLogsService)$this$invoke_u24lambda_u242).exportDirectory().resolve("customers-export-before-email-fixes-only-for-troubleshooting.json");
                            Intrinsics.checkNotNull((Object)allCustomersPath);
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (Files.exists(allCustomersPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                                if (Files.isRegularFile(allCustomersPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                                    MigrationLogsService.access$getLog$cp().info("Uploading all customers export (before email fixes) file " + allCustomersPath);
                                    MigrationLogsService.access$uploadMigrationLogsToMCSWithClusterLock((MigrationLogsService)$this$invoke_u24lambda_u242, allCustomersPath, ((MigrationStatusUpdatedEvent)object2).getMigrationId(), ((MigrationStatusUpdatedEvent)object2).getCloudId(), "customers-export-before-email-fixes-only-for-troubleshooting.json");
                                    MigrationLogsService.access$deleteAllCustomersExportFile((MigrationLogsService)$this$invoke_u24lambda_u242, allCustomersPath);
                                }
                            }
                            $this$invoke_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable bl) {
                            $this$invoke_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                        }
                        object = $this$invoke_u24lambda_u242;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                        if (throwable == null) break block9;
                        Object it = object2 = throwable;
                        boolean bl = false;
                        MigrationLogsService.access$getLog$cp().warn("Error executing migration log processing", (Throwable)it);
                    }
                }
            }));
        }
    }

    private final void linkErrorLogFileToTask(MigrationStatusUpdatedEvent event, String fileId, String fileName) {
        block2: {
            Object object;
            Object object2 = this;
            try {
                MigrationLogsService $this$linkErrorLogFileToTask_u24lambda_u240 = object2;
                boolean bl = false;
                $this$linkErrorLogFileToTask_u24lambda_u240.publicApiArtifactService.linkMcsArtifact(event.getMigrationId(), event.getCloudId(), fileId, fileName);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            log.error("Error linking log file to mapi artifact. ", (Throwable)it);
        }
    }

    private final void deleteAllCustomersExportFile(Path allCustomersPath) {
        log.info("Deleting the temporary customers export (before e-mail fixes) data file: customers-export-before-email-fixes-only-for-troubleshooting.json");
        try {
            Files.delete(allCustomersPath);
        }
        catch (Exception e) {
            log.warn("Error deleting the temporary customers export (before e-mail fixes) data file: " + allCustomersPath + '.', (Throwable)e);
        }
    }

    private final boolean isFinishedMigrationHasErrors(MigrationStatusUpdatedEvent event) {
        return event.getStatus() == MigrationStatusUpdatedEvent.Status.FINISHED && (((CharSequence)event.getDetails()).length() > 0 || this.isMigrationHasUnsuccessfulTasks(event));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMigrationHasUnsuccessfulTasks(MigrationStatusUpdatedEvent event) {
        boolean bl;
        block9: {
            void $this$any$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Migration migration;
            Migration migration2 = migration = this.discoveryService.findByMigrationId(event.getMigrationId());
            if ((migration2 != null ? migration2.getOutcome() : null) == null) {
                return false;
            }
            Iterable iterable = migration.getOutcome();
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GetTaskStatusResponse.TaskProgress taskProgress = (GetTaskStatusResponse.TaskProgress)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getProgressItems());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block8: {
                        Map it = (Map)element$iv;
                        boolean bl4 = false;
                        Iterable $this$any$iv2 = it.values();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ProgressItem progressItem = (ProgressItem)element$iv2;
                                boolean bl5 = false;
                                if (!(progressItem.getCompletionStatus() != TaskCompletionStatus.SUCCESS)) continue;
                                bl3 = true;
                                break block8;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        boolean isNotSuccessfulTasks = bl;
        return isNotSuccessfulTasks;
    }

    public final void uploadMigrationIsolatedLogs(@NotNull String migrationId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        this.runWithJiraThreadLocalUtil((Function0<Unit>)((Function0)new Function0<Unit>(this, migrationId, cloudId2){
            final /* synthetic */ MigrationLogsService this$0;
            final /* synthetic */ String $migrationId;
            final /* synthetic */ String $cloudId;
            {
                this.this$0 = $receiver;
                this.$migrationId = $migrationId;
                this.$cloudId = $cloudId;
                super(0);
            }

            public final void invoke() {
                block2: {
                    Object $this$invoke_u24lambda_u240;
                    Object object = this.this$0;
                    Object object2 = this.$migrationId;
                    String string = this.$cloudId;
                    try {
                        $this$invoke_u24lambda_u240 = object;
                        boolean bl = false;
                        MigrationLogsService.access$getLog$cp().info("Uploading isolated migration [" + (String)object2 + "] logs zip.");
                        Path migrationLogDir = MigrationLogsService.access$createScopeDir((MigrationLogsService)$this$invoke_u24lambda_u240, (String)object2);
                        Path isolatedLogZip = migrationLogDir.resolve("migration-isolated-logs.zip");
                        MigrationLogsProvider migrationLogsProvider = MigrationLogsService.access$getMigrationLogsProvider$p((MigrationLogsService)$this$invoke_u24lambda_u240);
                        Intrinsics.checkNotNull((Object)isolatedLogZip);
                        Path path = (Path)migrationLogsProvider.generateMigrationIsolatedLogsZip(isolatedLogZip, (String)object2).component2();
                        String fileName = MigrationLogsService.access$generateMigrationIsolatedLogsFileName((MigrationLogsService)$this$invoke_u24lambda_u240);
                        $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)MigrationLogsService.access$uploadMigrationLogsToMCSWithClusterLock((MigrationLogsService)$this$invoke_u24lambda_u240, path, (String)object2, string, fileName));
                    }
                    catch (Throwable throwable) {
                        $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object = $this$invoke_u24lambda_u240;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable == null) break block2;
                    Object it = object2 = throwable;
                    boolean bl = false;
                    MigrationLogsService.access$getLog$cp().warn("Error executing migration log processing", (Throwable)it);
                }
            }
        }));
    }

    public final void uploadIntervalMigrationLogs(@NotNull String migrationId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        this.runWithJiraThreadLocalUtil((Function0<Unit>)((Function0)new Function0<Unit>(this, migrationId, cloudId2){
            final /* synthetic */ MigrationLogsService this$0;
            final /* synthetic */ String $migrationId;
            final /* synthetic */ String $cloudId;
            {
                this.this$0 = $receiver;
                this.$migrationId = $migrationId;
                this.$cloudId = $cloudId;
                super(0);
            }

            public final void invoke() {
                block3: {
                    Object $this$invoke_u24lambda_u240;
                    Object object = this.this$0;
                    Object object2 = this.$migrationId;
                    String string = this.$cloudId;
                    try {
                        $this$invoke_u24lambda_u240 = object;
                        boolean bl = false;
                        MigrationLogsService.access$getLog$cp().info("Uploading interval migration [" + (String)object2 + "] logs.");
                        Path logDirectory = MigrationLogsService.access$getLocalFileDataOutput$p((MigrationLogsService)$this$invoke_u24lambda_u240).localLogDirectory();
                        Path logPath = logDirectory.resolve("atlassian-jira-migration.log");
                        Path newLogPath = logDirectory.resolve("migration-interval-logs_" + (String)object2 + ".log");
                        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        Files.copy(logPath, newLogPath, copyOptionArray);
                        File file2 = newLogPath.toFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                        String fileName = MigrationLogsService.access$generateIntervalMigrationLogFilename((MigrationLogsService)$this$invoke_u24lambda_u240, file2);
                        if (!Intrinsics.areEqual((Object)fileName, (Object)"")) {
                            MigrationLogsService.access$uploadMigrationLogsToMCS((MigrationLogsService)$this$invoke_u24lambda_u240, newLogPath, (String)object2, string, fileName);
                        }
                        $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object = $this$invoke_u24lambda_u240;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable == null) break block3;
                    Object it = object2 = throwable;
                    boolean bl = false;
                    MigrationLogsService.access$getLog$cp().warn("Error executing upload migration log on interval", (Throwable)it);
                }
            }
        }));
    }

    private final String generateIntervalMigrationLogFilename(File logFile) {
        LocalDateTime endTime;
        LocalDateTime localDateTime;
        LocalDateTime localDateTime2;
        String nodeId = this.clusterManager.getNodeId();
        if (nodeId == null) {
            log.warn("Could not generate interval migration log filename as node id is null.");
            return "";
        }
        String firstLine = this.readFirstLogLineWithTimestamp(logFile);
        String lastLine = this.readLastLogLineWithTimestamp(logFile);
        String string = firstLine;
        if (string != null) {
            String it = string;
            boolean bl = false;
            localDateTime2 = this.extractDateTimeFromLogLine(it);
        } else {
            localDateTime2 = null;
        }
        LocalDateTime startTime = localDateTime2;
        String string2 = lastLine;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            localDateTime = this.extractDateTimeFromLogLine(it);
        } else {
            localDateTime = endTime = null;
        }
        if (startTime == null || endTime == null) {
            log.warn("Could not extract start or end time from log file.");
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
        String formattedStartTime = startTime.format(formatter);
        String formattedEndTime = endTime.format(formatter);
        String string3 = nodeId;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string4 = UUID.nameUUIDFromBytes(byArray).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String encodedNodeId = string4;
        return "migration-interval-logs_" + encodedNodeId + '_' + formattedStartTime + '_' + formattedEndTime + ".log";
    }

    private final LocalDateTime extractDateTimeFromLogLine(String log2) {
        LocalDateTime localDateTime;
        Pattern pattern = Pattern.compile(LOG_TIMESTAMP_REGEX);
        Matcher matcher = pattern.matcher(log2);
        if (matcher.find()) {
            String dateTimeString = matcher.group();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(LOG_TIMESTAMP_FORMAT);
            localDateTime = LocalDateTime.parse(dateTimeString, formatter).atZone(ZoneOffset.UTC).toLocalDateTime();
        } else {
            localDateTime = null;
        }
        return localDateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readFirstLogLineWithTimestamp(File file2) {
        String firstLogEntry = null;
        Object object = file2;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object = (object3 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2)) instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
        object2 = null;
        try {
            BufferedReader reader = (BufferedReader)object;
            boolean bl = false;
            firstLogEntry = reader.readLine();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return firstLogEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readLastLogLineWithTimestamp(File file2) {
        String string;
        Pattern dateTimePattern = Pattern.compile(LOG_TIMESTAMP_REGEX);
        Closeable closeable = new RandomAccessFile(file2, "r");
        Throwable throwable = null;
        try {
            RandomAccessFile raf = (RandomAccessFile)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)dateTimePattern);
            string = this.findLastLogEntry(raf, dateTimePattern);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    private final String findLastLogEntry(RandomAccessFile raf, Pattern dateTimePattern) {
        long length = raf.length() - 1L;
        StringBuilder sb = new StringBuilder();
        while (length >= 0L) {
            raf.seek(length);
            char c = (char)raf.read();
            if (c == '\n' && ((CharSequence)sb).length() > 0) {
                String line;
                Intrinsics.checkNotNullExpressionValue((Object)sb.toString(), (String)"toString(...)");
                if (dateTimePattern.matcher(line).find()) {
                    return line;
                }
                sb.setLength(0);
            }
            sb.insert(0, c);
            long l = length;
            length = l + -1L;
        }
        return null;
    }

    private final String generateMigrationIsolatedLogsFileName() {
        Object object;
        String formattedDateTime;
        block5: {
            block4: {
                if (!this.migrationFeatures.getEnableAlwaysUploadMigrationLogsToMCS()) {
                    return "migration-isolated-logs.zip";
                }
                LocalDateTime currentDateTime = LocalDateTime.now();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
                formattedDateTime = currentDateTime.format(formatter);
                object = this.clusterManager.getNodeId();
                if (object == null) break block4;
                String string = object;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                object = byArray;
                if (byArray != null) break block5;
            }
            object = new byte[0];
        }
        String string = UUID.nameUUIDFromBytes((byte[])object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String encodedNodeId = string;
        return "migration-isolated-logs_" + encodedNodeId + '_' + formattedDateTime + ".zip";
    }

    private final Path createScopeDir(String migrationId) {
        Path migrationLogDir = this.localFileDataOutput.migrationLogDirectory(migrationId);
        Files.createDirectories(migrationLogDir, new FileAttribute[0]);
        return migrationLogDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String uploadMigrationLogsToMCSWithClusterLock(Path path, String migrationId, String cloudId2, String filename) {
        ClusterLock lock = this.discoveryService.getLockForName(MIGRATION_LOGS_SEND_LOCK);
        if (lock.tryLock()) {
            log.debug("Obtained a cluster lock for uploading migration logs.");
            try {
                String string = this.uploadMigrationLogsToMCS(path, migrationId, cloudId2, filename);
                return string;
            }
            catch (Exception e) {
                log.error("Exception during uploading migration logs with cluster lock.", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    private final String uploadMigrationLogsToMCS(Path path, String migrationId, String cloudId2, String filename) {
        String string;
        if (!this.discoveryService.isUserAgreedCollectErrors()) {
            log.info("User has not agreed with sending errors to MCS.");
            return null;
        }
        Path path2 = path;
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            log.info("Uploading migration [" + migrationId + "] error logs to MCS.");
            CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteForCloudId(cloudId2);
            if (cloudSite2 != null) {
                String string2;
                CloudSite cloudSite3 = cloudSite2;
                boolean bl2 = false;
                PlatformUploadServiceInterface platformUploadServiceInterface = this.platformService;
                ContainerToken containerToken = new ContainerToken(cloudSite3.getContainerToken());
                MigrationId migrationId2 = new MigrationId(migrationId);
                File file2 = it.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                String it2 = string2 = PlatformUploadServiceInterface.DefaultImpls.uploadMultiPart$default(platformUploadServiceInterface, containerToken, migrationId2, filename, "logs", file2, 0, null, 96, null);
                boolean bl3 = false;
                log.info("File uploaded to MCS fileId: " + it2 + '.');
                string = string2;
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    @Subscribe
    public final void onTaskCompleted(@NotNull MigrationTaskCompletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (CollectionsKt.contains((Iterable)this.statusesToFetchOrUploadLogs, (Object)((Object)event.getProgressItem().getCompletionStatus())) && event.getTask().getMigrationTaskType().getHasLogs() && event.getTask() instanceof ProjectTask) {
            if (event.getTask().getMigrationTaskType().isLocal()) {
                this.runWithJiraThreadLocalUtil((Function0<Unit>)((Function0)new Function0<Unit>(this, event){
                    final /* synthetic */ MigrationLogsService this$0;
                    final /* synthetic */ MigrationTaskCompletedEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        block5: {
                            Object $this$invoke_u24lambda_u241;
                            Object object = this.this$0;
                            Object object2 = this.$event;
                            try {
                                $this$invoke_u24lambda_u241 = object;
                                boolean bl = false;
                                String string = (((MigrationTaskCompletedEvent)object2).getTask().getTaskId() + "-logs").intern();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
                                String string2 = string;
                                synchronized (string2) {
                                    boolean bl2 = false;
                                    MigrationLogsService.access$getMigrationLogsProvider$p((MigrationLogsService)$this$invoke_u24lambda_u241).uploadExportLogs((MigrationTaskCompletedEvent)object2, (ProjectTask)((MigrationTaskCompletedEvent)object2).getTask());
                                    Unit unit = Unit.INSTANCE;
                                }
                                $this$invoke_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable bl) {
                                $this$invoke_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                            }
                            object = $this$invoke_u24lambda_u241;
                            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                            if (throwable == null) break block5;
                            Object it = object2 = throwable;
                            boolean bl = false;
                            MigrationLogsService.access$getLog$cp().warn("Error executing upload for export logs", (Throwable)it);
                        }
                    }
                }));
            } else {
                this.runWithJiraThreadLocalUtil((Function0<Unit>)((Function0)new Function0<Unit>(this, event){
                    final /* synthetic */ MigrationLogsService this$0;
                    final /* synthetic */ MigrationTaskCompletedEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        block5: {
                            Object $this$invoke_u24lambda_u241;
                            Object object = this.this$0;
                            Object object2 = this.$event;
                            try {
                                $this$invoke_u24lambda_u241 = object;
                                boolean bl = false;
                                String string = (((MigrationTaskCompletedEvent)object2).getTask().getTaskId() + "-logs").intern();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
                                String string2 = string;
                                synchronized (string2) {
                                    boolean bl2 = false;
                                    MigrationLogsService.access$getMigrationLogsProvider$p((MigrationLogsService)$this$invoke_u24lambda_u241).downloadImportLogs((MigrationTaskCompletedEvent)object2, (ProjectTask)((MigrationTaskCompletedEvent)object2).getTask());
                                    Unit unit = Unit.INSTANCE;
                                }
                                $this$invoke_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable bl) {
                                $this$invoke_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                            }
                            object = $this$invoke_u24lambda_u241;
                            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                            if (throwable == null) break block5;
                            Object it = object2 = throwable;
                            boolean bl = false;
                            MigrationLogsService.access$getLog$cp().warn("Error executing download for import logs", (Throwable)it);
                        }
                    }
                }));
            }
        }
    }

    @NotNull
    public final Path logFileLocation(@NotNull String migrationId, @NotNull MigrationTaskType taskType, @NotNull ProgressUnit progressUnit, @NotNull String projectKey) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)((Object)taskType), (String)"taskType");
        Intrinsics.checkNotNullParameter((Object)((Object)progressUnit), (String)"progressUnit");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Path migrationLogDir = this.localFileDataOutput.migrationLogDirectory(migrationId);
        return this.migrationLogsProvider.generateRelativeLogFileLocation(migrationLogDir, taskType, progressUnit, projectKey);
    }

    @Nullable
    public final Path getLogsForPlan(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        return this.migrationLogsProvider.getLogsForPlan(planId);
    }

    @VisibleForTesting
    public final void generateLogsForMigration(@NotNull Migration migrationData, @NotNull Path migrationLogDir, @NotNull Path logZip) {
        Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
        Intrinsics.checkNotNullParameter((Object)migrationLogDir, (String)"migrationLogDir");
        Intrinsics.checkNotNullParameter((Object)logZip, (String)"logZip");
        this.migrationLogsProvider.generateLogsForMigration(migrationData, migrationLogDir, logZip);
    }

    @Nullable
    public final Path getGeneratedErrorLogsZipForProjects(@NotNull String projectKeys, @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)projectKeys, (String)"projectKeys");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        return this.migrationLogsProvider.getErrorLogsZipPath(projectKeys, executionId);
    }

    @Nullable
    public final Path generateLogsForBackgroundTask(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        log.info("Generating background task log files.");
        return this.migrationLogsProvider.generateExportErrorLogsForBackgroundTask(executionId);
    }

    public final void deleteExistingPreflightExecutionLogs(@NotNull String executionId, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Path preFlightExecutionLogDirectory = this.localFileDataOutput.preFlightExecutionLogDirectory(executionId);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(preFlightExecutionLogDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathsKt.listDirectoryEntries((Path)preFlightExecutionLogDirectory, (String)filePath).parallelStream().filter(arg_0 -> MigrationLogsService.deleteExistingPreflightExecutionLogs$lambda$12(deleteExistingPreflightExecutionLogs.1.INSTANCE, arg_0)).forEach(arg_0 -> MigrationLogsService.deleteExistingPreflightExecutionLogs$lambda$13((Function1)new Function1<Path, Unit>(this, executionId){
                final /* synthetic */ MigrationLogsService this$0;
                final /* synthetic */ String $executionId;
                {
                    this.this$0 = $receiver;
                    this.$executionId = $executionId;
                    super(1);
                }

                public final void invoke(Path it) {
                    try {
                        LocalFileDataOutput localFileDataOutput = MigrationLogsService.access$getLocalFileDataOutput$p(this.this$0);
                        Intrinsics.checkNotNull((Object)it);
                        LocalFileDataOutput.cleanHandlingExceptions$default(localFileDataOutput, it, null, 2, null);
                    }
                    catch (Exception exception) {
                        MigrationLogsService.access$getLog$cp().error("Error while deleting existing log file " + it + " before PreFlight check for Execution ID " + this.$executionId + ": " + exception, (Throwable)exception);
                    }
                }
            }, arg_0));
        } else {
            log.warn("Preflight execution logs folder does not exists, Execution ID " + executionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runWithJiraThreadLocalUtil(Function0<Unit> block) {
        this.jiraThreadLocalUtil.preCall();
        try {
            block.invoke();
        }
        finally {
            this.jiraThreadLocalUtil.postCall(org.apache.log4j.Logger.getLogger(MigrationLogsService.class));
        }
    }

    private static final boolean deleteExistingPreflightExecutionLogs$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void deleteExistingPreflightExecutionLogs$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ MigrationLogsProvider access$getMigrationLogsProvider$p(MigrationLogsService $this) {
        return $this.migrationLogsProvider;
    }

    public static final /* synthetic */ void access$linkErrorLogFileToTask(MigrationLogsService $this, MigrationStatusUpdatedEvent event, String fileId, String fileName) {
        $this.linkErrorLogFileToTask(event, fileId, fileName);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ DiscoveryService access$getDiscoveryService$p(MigrationLogsService $this) {
        return $this.discoveryService;
    }

    public static final /* synthetic */ String access$uploadMigrationLogsToMCSWithClusterLock(MigrationLogsService $this, Path path, String migrationId, String cloudId2, String filename) {
        return $this.uploadMigrationLogsToMCSWithClusterLock(path, migrationId, cloudId2, filename);
    }

    public static final /* synthetic */ LocalFileDataOutput access$getLocalFileDataOutput$p(MigrationLogsService $this) {
        return $this.localFileDataOutput;
    }

    public static final /* synthetic */ void access$deleteAllCustomersExportFile(MigrationLogsService $this, Path allCustomersPath) {
        $this.deleteAllCustomersExportFile(allCustomersPath);
    }

    public static final /* synthetic */ Path access$createScopeDir(MigrationLogsService $this, String migrationId) {
        return $this.createScopeDir(migrationId);
    }

    public static final /* synthetic */ String access$generateMigrationIsolatedLogsFileName(MigrationLogsService $this) {
        return $this.generateMigrationIsolatedLogsFileName();
    }

    public static final /* synthetic */ String access$generateIntervalMigrationLogFilename(MigrationLogsService $this, File logFile) {
        return $this.generateIntervalMigrationLogFilename(logFile);
    }

    public static final /* synthetic */ String access$uploadMigrationLogsToMCS(MigrationLogsService $this, Path path, String migrationId, String cloudId2, String filename) {
        return $this.uploadMigrationLogsToMCS(path, migrationId, cloudId2, filename);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/log/MigrationLogsService$Companion;", "", "()V", "LOG_TIMESTAMP_FORMAT", "", "LOG_TIMESTAMP_REGEX", "MIGRATION_LOGS_SEND_LOCK", "getMIGRATION_LOGS_SEND_LOCK$annotations", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMIGRATION_LOGS_SEND_LOCK$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

