/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.log.MigrationLogsService;
import com.atlassian.jira.migration.tracking.polling.InProgressMigration;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/log/MigrationLogsUploadScheduler;", "Lcom/atlassian/scheduler/JobRunner;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationLogsService", "Lcom/atlassian/jira/migration/log/MigrationLogsService;", "inProgressMigrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/log/MigrationLogsService;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/cluster/ClusterManager;)V", "checkStart", "", "checkStop", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "jobRunnerRequest", "Lcom/atlassian/scheduler/JobRunnerRequest;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationLogsUploadScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationLogsUploadScheduler.kt\ncom/atlassian/jira/migration/log/MigrationLogsUploadScheduler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1313#2:88\n1314#2:90\n1#3:89\n*S KotlinDebug\n*F\n+ 1 MigrationLogsUploadScheduler.kt\ncom/atlassian/jira/migration/log/MigrationLogsUploadScheduler\n*L\n62#1:88\n62#1:90\n*E\n"})
public final class MigrationLogsUploadScheduler
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationLogsService migrationLogsService;
    @NotNull
    private final InProgressMigrationIds inProgressMigrationIds;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;
    private static final Logger log;

    @Inject
    public MigrationLogsUploadScheduler(@NotNull MigrationFeatures migrationFeatures, @NotNull MigrationLogsService migrationLogsService, @NotNull InProgressMigrationIds inProgressMigrationIds, @NotNull DiscoveryService discoveryService, @NotNull SchedulerService schedulerService, @NotNull ClusterManager clusterManager) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migrationLogsService, (String)"migrationLogsService");
        Intrinsics.checkNotNullParameter((Object)inProgressMigrationIds, (String)"inProgressMigrationIds");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        this.migrationFeatures = migrationFeatures;
        this.migrationLogsService = migrationLogsService;
        this.inProgressMigrationIds = inProgressMigrationIds;
        this.discoveryService = discoveryService;
        this.schedulerService = schedulerService;
        this.clusterManager = clusterManager;
    }

    public final void checkStart() {
        if (!this.migrationFeatures.getEnableUploadMigrationLogsToMCSAtIntervals() || this.schedulerService.getRegisteredJobRunnerKeys().contains(JOB_RUNNER_KEY)) {
            return;
        }
        long uploadInterval = (long)this.migrationFeatures.getMigrationLogsUploadIntervalInMins();
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)TimeUnit.MINUTES.toMillis(uploadInterval), (Date)Date.from(Instant.now().plus(Duration.ofMinutes(uploadInterval))))));
        log.info("Successfully registered migration logs upload job " + JOB_RUNNER_KEY + " nodeId=" + this.clusterManager.getNodeId());
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest jobRunnerRequest) {
        Intrinsics.checkNotNullParameter((Object)jobRunnerRequest, (String)"jobRunnerRequest");
        log.info("Migration logs upload job started at " + Instant.now() + " jobId=" + jobRunnerRequest.getJobId() + " nodeId=" + this.clusterManager.getNodeId());
        Sequence<InProgressMigration> $this$forEach$iv = this.inProgressMigrationIds.sequence();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InProgressMigration inProgressMigration = (InProgressMigration)element$iv;
            boolean bl = false;
            String migrationId = inProgressMigration.component1();
            CloudSite cloudSite2 = DiscoveryService.retrieveCloudSiteFor$default(this.discoveryService, migrationId, false, 2, null);
            if (cloudSite2 == null) continue;
            CloudSite cloudSite3 = cloudSite2;
            boolean bl2 = false;
            this.migrationLogsService.uploadIntervalMigrationLogs(migrationId, cloudSite3.getCloudId());
        }
        log.info("Migration logs upload job completed at  " + Instant.now() + " jobId=" + jobRunnerRequest.getJobId() + " nodeId=" + this.clusterManager.getNodeId());
        return JobRunnerResponse.success((String)"Migration logs upload job completed successfully");
    }

    public final void checkStop() {
        if (SequencesKt.count(this.inProgressMigrationIds.sequence()) != 0) {
            return;
        }
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        log.info("Successfully unregistered migration logs upload scheduler job " + JOB_RUNNER_KEY + " nodeId=" + this.clusterManager.getNodeId());
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-migration-logs-upload-scheduler-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"jira-migration-logs-upload-scheduler-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
        log = LoggerFactory.getLogger(MigrationLogsUploadScheduler.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/log/MigrationLogsUploadScheduler$Companion;", "", "()V", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

