/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MRCLogsFailedEvent;
import com.atlassian.jira.migration.events.MRCLogsSuccessEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.log.LogsException;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.utils.CloudUtil;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import java.net.URI;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 &2\u00020\u0001:\u0002&'BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ \u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#J/\u0010$\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ \u0010%\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/log/MigrationReportCenterClient;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "cloudUtil", "Lcom/atlassian/jira/migration/utils/CloudUtil;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/utils/CloudUtil;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "migrationReportCenterBaseURI", "Ljava/net/URI;", "downloadLogs", "", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "sourceId", "", "file", "Ljava/nio/file/Path;", "(Lcom/atlassian/migration/api/ContainerToken;Lcom/atlassian/migration/api/MigrationId;Ljava/lang/String;Ljava/nio/file/Path;)Ljava/lang/Long;", "downloadPMRAEventLogs", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "getDownloadLogsSignedUrlViaMS", "getPMRALogsViaMS", "Companion", "MRCResponse", "jira-migration-plugin"})
public final class MigrationReportCenterClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final CloudUtil cloudUtil;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final URI migrationReportCenterBaseURI;
    private static final Logger log = LoggerFactory.getLogger(MigrationReportCenterClient.class);
    @NotNull
    private static final String S2C_PROJECT_IMPORT_ERROR_DEPENDENCY_ANALYSIS = "S2C_PROJECT_IMPORT_ERROR_DEPENDENCY_ANALYSIS";
    @NotNull
    private static final String POST_MIGRATION_REQUIRES_ATTENTION = "PostMigrationRequiresAttention";
    @NotNull
    private static final String S2C_PMRA_FAILED_ENTITY_DEPENDENCY_ANALYSIS = "S2C_PMRA_FAILED_ENTITY_DEPENDENCY_ANALYSIS";

    @Inject
    public MigrationReportCenterClient(@NotNull MigrationEventBus migrationEventBus, @NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull DiscoveryService discoveryService, @NotNull MigrationScopeManager migrationScopeManager, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationServiceClient migrationServiceClient, @NotNull CloudUtil cloudUtil, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)cloudUtil, (String)"cloudUtil");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationEventBus = migrationEventBus;
        this.discoveryService = discoveryService;
        this.migrationScopeManager = migrationScopeManager;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationServiceClient = migrationServiceClient;
        this.cloudUtil = cloudUtil;
        this.migrationFeatures = migrationFeatures;
        this.migrationReportCenterBaseURI = this.migrationFeatures.getEnableUseMcsV2Endpoint() ? migrationServicesConfiguration.getEnterpriseGatewayV2BaseURI() : migrationServicesConfiguration.getEnterpriseGatewayBaseURI();
        log.info("migration report center base url : " + this.migrationReportCenterBaseURI);
    }

    private final Long getDownloadLogsSignedUrlViaMS(ContainerToken containerToken, MigrationId migrationId, String sourceId, Path file2) {
        String string = migrationId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, string, false, 2, null);
        if (plan2 == null) {
            String string2 = migrationId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            throw LogsException.INSTANCE.missingPlanException(string2);
        }
        Plan plan3 = plan2;
        String string3 = plan3.getCloudRegion();
        if (string3 == null) {
            string3 = this.cloudUtil.getCloudSiteRegion(plan3.getCloudId());
        }
        String cloudRegion = string3;
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(plan3.getCloudId());
        if (cloudSite2 == null) {
            throw LogsException.INSTANCE.missingCloudInfoException(plan3.getCloudId());
        }
        CloudSite cloudSite3 = cloudSite2;
        String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(cloudSite3);
        return this.migrationServiceClient.getDownloadLogsSignedUrlViaMS(containerToken, migrationId, sourceId, file2, migrationScopeId2, cloudRegion);
    }

    private final CloseableHttpResponse getPMRALogsViaMS(ContainerToken containerToken, MigrationId migrationId, Plan plan2) {
        String string = plan2.getCloudRegion();
        if (string == null) {
            string = this.cloudUtil.getCloudSiteRegion(plan2.getCloudId());
        }
        String cloudRegion = string;
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(plan2.getCloudId());
        if (cloudSite2 == null) {
            throw LogsException.INSTANCE.missingCloudInfoException(plan2.getCloudId());
        }
        CloudSite cloudSite3 = cloudSite2;
        String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(cloudSite3);
        return this.migrationServiceClient.downloadPMRALogsViaMS(containerToken, migrationId, migrationScopeId2, cloudRegion);
    }

    @Nullable
    public final Long downloadLogs(@NotNull ContainerToken containerToken, @NotNull MigrationId migrationId, @NotNull String sourceId, @NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        long startTime = System.currentTimeMillis();
        long totalTime = 0L;
        try {
            long l;
            Long l2 = this.getDownloadLogsSignedUrlViaMS(containerToken, migrationId, sourceId, file2);
            long it = l = l2 != null ? l2 : 0L;
            boolean bl = false;
            totalTime = System.currentTimeMillis() - startTime;
            long downloadedBytes = l;
            String string = migrationId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.migrationEventBus.post(new MRCLogsSuccessEvent(string, sourceId, POST_MIGRATION_REQUIRES_ATTENTION, S2C_PROJECT_IMPORT_ERROR_DEPENDENCY_ANALYSIS, downloadedBytes, totalTime));
            return downloadedBytes;
        }
        catch (Exception clientErr) {
            long totalTime2 = System.currentTimeMillis() - startTime;
            String string = migrationId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = clientErr.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            this.migrationEventBus.post(new MRCLogsFailedEvent(string, sourceId, POST_MIGRATION_REQUIRES_ATTENTION, S2C_PROJECT_IMPORT_ERROR_DEPENDENCY_ANALYSIS, string2, totalTime2));
            if (clientErr instanceof UnexpectedStatusCodeException && ((UnexpectedStatusCodeException)clientErr).getStatusCode() == 404) {
                log.debug("No logs found for migrationId: " + migrationId + ", sourceId: " + sourceId);
                return null;
            }
            log.debug("Detected unexpected error: " + clientErr);
            throw clientErr;
        }
    }

    @Nullable
    public final CloseableHttpResponse downloadPMRAEventLogs(@NotNull ContainerToken containerToken, @NotNull MigrationId migrationId, @NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        long startTime = System.currentTimeMillis();
        long totalTime = 0L;
        try {
            CloseableHttpResponse closeableHttpResponse;
            CloseableHttpResponse it = closeableHttpResponse = this.getPMRALogsViaMS(containerToken, migrationId, plan2);
            boolean bl = false;
            totalTime = System.currentTimeMillis() - startTime;
            CloseableHttpResponse response2 = closeableHttpResponse;
            String string = migrationId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.migrationEventBus.post(new MRCLogsSuccessEvent(string, "", POST_MIGRATION_REQUIRES_ATTENTION, S2C_PMRA_FAILED_ENTITY_DEPENDENCY_ANALYSIS, response2.getEntity().getContentLength(), totalTime));
            return response2;
        }
        catch (Exception clientErr) {
            totalTime = System.currentTimeMillis() - startTime;
            String string = migrationId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = migrationId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = clientErr.getMessage();
            if (string3 == null) {
                string3 = "Error while fetching PMRA event logs";
            }
            this.migrationEventBus.post(new MRCLogsFailedEvent(string, string2, POST_MIGRATION_REQUIRES_ATTENTION, S2C_PMRA_FAILED_ENTITY_DEPENDENCY_ANALYSIS, string3, totalTime));
            if (clientErr instanceof UnexpectedStatusCodeException && ((UnexpectedStatusCodeException)clientErr).getStatusCode() == 404) {
                log.debug("No logs found for migrationId: " + migrationId);
                return null;
            }
            log.debug("Detected unexpected error: " + clientErr);
            throw clientErr;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/log/MigrationReportCenterClient$Companion;", "", "()V", "POST_MIGRATION_REQUIRES_ATTENTION", "", "S2C_PMRA_FAILED_ENTITY_DEPENDENCY_ANALYSIS", "S2C_PROJECT_IMPORT_ERROR_DEPENDENCY_ANALYSIS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/log/MigrationReportCenterClient$MRCResponse;", "", "downloadUrl", "", "created", "(Ljava/lang/String;Ljava/lang/String;)V", "getCreated", "()Ljava/lang/String;", "getDownloadUrl", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class MRCResponse {
        @NotNull
        private final String downloadUrl;
        @NotNull
        private final String created;

        public MRCResponse(@NotNull String downloadUrl, @NotNull String created) {
            Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
            Intrinsics.checkNotNullParameter((Object)created, (String)"created");
            this.downloadUrl = downloadUrl;
            this.created = created;
        }

        @NotNull
        public final String getDownloadUrl() {
            return this.downloadUrl;
        }

        @NotNull
        public final String getCreated() {
            return this.created;
        }

        @NotNull
        public final String component1() {
            return this.downloadUrl;
        }

        @NotNull
        public final String component2() {
            return this.created;
        }

        @NotNull
        public final MRCResponse copy(@NotNull String downloadUrl, @NotNull String created) {
            Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
            Intrinsics.checkNotNullParameter((Object)created, (String)"created");
            return new MRCResponse(downloadUrl, created);
        }

        public static /* synthetic */ MRCResponse copy$default(MRCResponse mRCResponse, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = mRCResponse.downloadUrl;
            }
            if ((n & 2) != 0) {
                string2 = mRCResponse.created;
            }
            return mRCResponse.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "MRCResponse(downloadUrl=" + this.downloadUrl + ", created=" + this.created + ')';
        }

        public int hashCode() {
            int result2 = this.downloadUrl.hashCode();
            result2 = result2 * 31 + this.created.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MRCResponse)) {
                return false;
            }
            MRCResponse mRCResponse = (MRCResponse)other;
            if (!Intrinsics.areEqual((Object)this.downloadUrl, (Object)mRCResponse.downloadUrl)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.created, (Object)mRCResponse.created);
        }
    }
}

