/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.jira.migration.events.AssetDataUploadStarted;
import com.atlassian.jira.migration.events.CrossProjectDataUploadStarted;
import com.atlassian.jira.migration.events.CustomersUploadStarted;
import com.atlassian.jira.migration.events.GenerateCsvLinkingStarted;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationStatusUpdatedEvent;
import com.atlassian.jira.migration.events.PlanStartedEvent;
import com.atlassian.jira.migration.events.ProjectAttachmentUploadStarted;
import com.atlassian.jira.migration.events.ProjectDataUploadStarted;
import com.atlassian.jira.migration.events.UsersAndGroupsUploadStarted;
import com.atlassian.jira.migration.log.MigrationLogsUploadScheduler;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001aH\u0007J\b\u0010\u001b\u001a\u00020\bH\u0007J\b\u0010\u001c\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/log/MigrationTaskListener;", "", "eventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "migrationLogsUploadScheduler", "Lcom/atlassian/jira/migration/log/MigrationLogsUploadScheduler;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/log/MigrationLogsUploadScheduler;)V", "onAssetDataUploadStarted", "", "event", "Lcom/atlassian/jira/migration/events/AssetDataUploadStarted;", "onCrossProjectDataUploadStarted", "Lcom/atlassian/jira/migration/events/CrossProjectDataUploadStarted;", "onCustomersUploadStarted", "Lcom/atlassian/jira/migration/events/CustomersUploadStarted;", "onGenerateCsvLinkingStarted", "Lcom/atlassian/jira/migration/events/GenerateCsvLinkingStarted;", "onMigrationTaskStatusUpdated", "Lcom/atlassian/jira/migration/events/MigrationStatusUpdatedEvent;", "onPlanStarted", "Lcom/atlassian/jira/migration/events/PlanStartedEvent;", "onProjectAttachmentUploadStarted", "Lcom/atlassian/jira/migration/events/ProjectAttachmentUploadStarted;", "onProjectDataUploadStarted", "Lcom/atlassian/jira/migration/events/ProjectDataUploadStarted;", "onUsersAndGroupsUploadStarted", "Lcom/atlassian/jira/migration/events/UsersAndGroupsUploadStarted;", "postConstruct", "preDestroy", "Companion", "jira-migration-plugin"})
public final class MigrationTaskListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus eventBus;
    @NotNull
    private final MigrationLogsUploadScheduler migrationLogsUploadScheduler;
    private static final Logger log = LoggerFactory.getLogger(MigrationTaskListener.class);

    @Inject
    public MigrationTaskListener(@NotNull MigrationEventBus eventBus, @NotNull MigrationLogsUploadScheduler migrationLogsUploadScheduler) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)migrationLogsUploadScheduler, (String)"migrationLogsUploadScheduler");
        this.eventBus = eventBus;
        this.migrationLogsUploadScheduler = migrationLogsUploadScheduler;
    }

    @PostConstruct
    public final void postConstruct() {
        this.eventBus.register(this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public final void onPlanStarted(@NotNull PlanStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        log.info("On Plan started event planId=" + event.getPlanId() + " cloudId=" + event.getCloudId());
        this.migrationLogsUploadScheduler.checkStart();
    }

    @Subscribe
    public final void onGenerateCsvLinkingStarted(@NotNull GenerateCsvLinkingStarted event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        log.info("On Generate CSV linking started event migrationId=" + event.getMigrationId() + " cloudId=" + event.getCloudId());
        this.migrationLogsUploadScheduler.checkStart();
    }

    @Subscribe
    public final void onUsersAndGroupsUploadStarted(@NotNull UsersAndGroupsUploadStarted event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        log.info("On Users and Groups upload started event migrationId=" + event.getMigrationId() + " cloudId=" + event.getCloudId());
        this.migrationLogsUploadScheduler.checkStart();
    }

    @Subscribe
    public final void onCustomersUploadStarted(@NotNull CustomersUploadStarted event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        log.info("On Customers upload started event migrationId=" + event.getMigrationId() + " cloudId=" + event.getCloudId());
        this.migrationLogsUploadScheduler.checkStart();
    }

    @Subscribe
    public final void onProjectDataUploadStarted(@NotNull ProjectDataUploadStarted event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        log.info("On Project data upload started event projectId=" + event.getProjectId() + " projectKey=" + event.getProjectKey());
        this.migrationLogsUploadScheduler.checkStart();
    }

    @Subscribe
    public final void onProjectAttachmentUploadStarted(@NotNull ProjectAttachmentUploadStarted event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        log.info("On Project attachment upload started event projectId=" + event.getProjectId() + " projectKey=" + event.getProjectKey());
        this.migrationLogsUploadScheduler.checkStart();
    }

    @Subscribe
    public final void onCrossProjectDataUploadStarted(@NotNull CrossProjectDataUploadStarted event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        log.info("On Cross project data upload started event migrationId=" + event.getMigrationId() + " cloudId=" + event.getCloudId());
        this.migrationLogsUploadScheduler.checkStart();
    }

    @Subscribe
    public final void onAssetDataUploadStarted(@NotNull AssetDataUploadStarted event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        log.info("On Asset data upload started event migrationId=" + event.getMigrationId() + " cloudId=" + event.getCloudId());
        this.migrationLogsUploadScheduler.checkStart();
    }

    @Subscribe
    public final void onMigrationTaskStatusUpdated(@NotNull MigrationStatusUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isMigrationNotFinished()) {
            return;
        }
        log.info("On Migration status updated event planId=" + event.getMigrationId() + " cloudId=" + event.getCloudId() + " status=" + (Object)((Object)event.getStatus()));
        this.migrationLogsUploadScheduler.checkStop();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/log/MigrationTaskListener$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

