/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.export.model.PMRAFailedEntityCSVRow;
import com.atlassian.jira.migration.export.model.PMRAFailedEntityKt;
import com.atlassian.jira.migration.log.MRCLogReader;
import com.atlassian.jira.migration.log.MigrationReportCenterClient;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.preflight.reports.PMRAFailedEntitiesRepository;
import com.atlassian.jira.migration.serverdataextractors.ProjectsReader;
import com.atlassian.jira.project.Project;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.jetbrains.annotations.NotNull;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.prefs.CsvPreference;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/log/PMRAFailedEntityLogService;", "", "pmraFailedEntitiesRepository", "Lcom/atlassian/jira/migration/preflight/reports/PMRAFailedEntitiesRepository;", "migrationReportCenterClient", "Lcom/atlassian/jira/migration/log/MigrationReportCenterClient;", "projectsReader", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;", "mrcLogReader", "Lcom/atlassian/jira/migration/log/MRCLogReader;", "(Lcom/atlassian/jira/migration/preflight/reports/PMRAFailedEntitiesRepository;Lcom/atlassian/jira/migration/log/MigrationReportCenterClient;Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;Lcom/atlassian/jira/migration/log/MRCLogReader;)V", "buildProjectIdToKeyMapForPlan", "", "", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "fetchPMRAEventsAndSaveToDB", "", "executionId", "migrationId", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "getProjectKeyForId", "projectId", "projectIdToKeyCache", "sanitiseEntityType", "type", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPMRAFailedEntityLogService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PMRAFailedEntityLogService.kt\ncom/atlassian/jira/migration/log/PMRAFailedEntityLogService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1#2:76\n1549#3:77\n1620#3,3:78\n1179#3,2:81\n1253#3,4:83\n*S KotlinDebug\n*F\n+ 1 PMRAFailedEntityLogService.kt\ncom/atlassian/jira/migration/log/PMRAFailedEntityLogService\n*L\n68#1:77\n68#1:78,3\n68#1:81,2\n68#1:83,4\n*E\n"})
public final class PMRAFailedEntityLogService {
    @NotNull
    private final PMRAFailedEntitiesRepository pmraFailedEntitiesRepository;
    @NotNull
    private final MigrationReportCenterClient migrationReportCenterClient;
    @NotNull
    private final ProjectsReader projectsReader;
    @NotNull
    private final MRCLogReader mrcLogReader;

    @Inject
    public PMRAFailedEntityLogService(@NotNull PMRAFailedEntitiesRepository pmraFailedEntitiesRepository, @NotNull MigrationReportCenterClient migrationReportCenterClient, @NotNull ProjectsReader projectsReader, @NotNull MRCLogReader mrcLogReader) {
        Intrinsics.checkNotNullParameter((Object)pmraFailedEntitiesRepository, (String)"pmraFailedEntitiesRepository");
        Intrinsics.checkNotNullParameter((Object)migrationReportCenterClient, (String)"migrationReportCenterClient");
        Intrinsics.checkNotNullParameter((Object)projectsReader, (String)"projectsReader");
        Intrinsics.checkNotNullParameter((Object)mrcLogReader, (String)"mrcLogReader");
        this.pmraFailedEntitiesRepository = pmraFailedEntitiesRepository;
        this.migrationReportCenterClient = migrationReportCenterClient;
        this.projectsReader = projectsReader;
        this.mrcLogReader = mrcLogReader;
    }

    public final void fetchPMRAEventsAndSaveToDB(@NotNull String executionId, @NotNull String migrationId, @NotNull CloudSite cloudSite2, @NotNull Plan plan2) {
        block2: {
            InputStream inputStream;
            Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
            Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
            Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
            Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
            CloseableHttpResponse response2 = this.migrationReportCenterClient.downloadPMRAEventLogs(new ContainerToken(cloudSite2.getContainerToken()), new MigrationId(migrationId), plan2);
            CloseableHttpResponse closeableHttpResponse = response2;
            InputStream inputStream2 = inputStream = closeableHttpResponse != null && (closeableHttpResponse = closeableHttpResponse.getEntity()) != null ? closeableHttpResponse.getContent() : null;
            if (inputStream2 == null) break block2;
            InputStream it = inputStream2;
            boolean bl = false;
            Map<String, String> projectIdToKeyCache = this.buildProjectIdToKeyMapForPlan(plan2);
            InputStreamReader reader = new InputStreamReader(it);
            CsvBeanReader csvReader = new CsvBeanReader((Reader)reader, CsvPreference.STANDARD_PREFERENCE);
            List jqlErrorList = new ArrayList();
            PMRAFailedEntityCSVRow row = null;
            String[] header = csvReader.getHeader(true);
            while (true) {
                PMRAFailedEntityCSVRow it2;
                PMRAFailedEntityCSVRow pMRAFailedEntityCSVRow;
                Intrinsics.checkNotNull((Object)header);
                PMRAFailedEntityCSVRow it3 = pMRAFailedEntityCSVRow = this.mrcLogReader.readPMRALogCsvLine(csvReader, header);
                boolean bl2 = false;
                row = it3;
                if (pMRAFailedEntityCSVRow == null) break;
                if (row == null) continue;
                boolean bl3 = false;
                String projectKey = this.getProjectKeyForId(it2.getProjectId(), projectIdToKeyCache);
                jqlErrorList.add(PMRAFailedEntityKt.toEntity(it2, projectKey, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)this){

                    @NotNull
                    public final String invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return PMRAFailedEntityLogService.access$sanitiseEntityType((PMRAFailedEntityLogService)this.receiver, p0);
                    }
                })));
            }
            if (!((Collection)jqlErrorList).isEmpty()) {
                this.pmraFailedEntitiesRepository.saveOrReplaceAll(executionId, jqlErrorList);
            }
        }
    }

    private final String getProjectKeyForId(String projectId, Map<String, String> projectIdToKeyCache) {
        String string;
        String string2;
        String string3 = projectId;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string2 = projectIdToKeyCache.get(projectId);
            if (string2 == null) {
                string2 = projectId;
            }
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> buildProjectIdToKeyMapForPlan(Plan plan2) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = plan2.getProjectKeys();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.projectsReader.getProject((String)it));
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Project it = (Project)element$iv$iv;
            boolean bl = false;
            Long l = it.getId();
            Intrinsics.checkNotNull((Object)l);
            String string = String.valueOf(l);
            String string2 = it.getKey();
            Intrinsics.checkNotNull((Object)string2);
            Pair pair = TuplesKt.to((Object)string, (Object)string2);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private final String sanitiseEntityType(String type) {
        return Intrinsics.areEqual((Object)type, (Object)"rapidView") ? "board" : type;
    }

    public static final /* synthetic */ String access$sanitiseEntityType(PMRAFailedEntityLogService $this, String type) {
        return $this.sanitiseEntityType(type);
    }
}

