/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PreflightCheckCompletionEvent;
import com.atlassian.jira.migration.log.MigrationLogsProvider;
import com.atlassian.jira.migration.log.ThreadDumpProvider;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.PlatformUploadServiceInterface;
import com.atlassian.jira.migration.utils.FileNameUtils;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.MigrationScopeId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J*\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\b\u0010\u001e\u001a\u00020\u001bH\u0007J\b\u0010\u001f\u001a\u00020\u001bH\u0007J\u0016\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"H\u0002J0\u0010#\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)J4\u0010*\u001a\u0004\u0018\u00010\u00142\u0006\u0010+\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J4\u0010,\u001a\u0004\u0018\u00010\u00142\u0006\u0010+\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u00010)H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/atlassian/jira/migration/log/PreflightLogsService;", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "eventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "migrationLogsProvider", "Lcom/atlassian/jira/migration/log/MigrationLogsProvider;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "dumper", "Lcom/atlassian/jira/migration/log/ThreadDumpProvider;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/log/MigrationLogsProvider;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/log/ThreadDumpProvider;)V", "createScopeDir", "Ljava/nio/file/Path;", "migrationScopeId", "", "generateMigrationIsolatedLogsZip", "Lkotlin/Pair;", "Ljava/io/File;", "migrationScopeLogDir", "filename", "onPreflightCompletionEvent", "", "event", "Lcom/atlassian/jira/migration/events/PreflightCheckCompletionEvent;", "postConstruct", "preDestroy", "runWithJiraThreadLocalUtil", "block", "Lkotlin/Function0;", "uploadPreflightLogs", "cloudId", "preflightCheckExecutionId", "time", "Ljava/time/Instant;", "preflightId", "Lcom/atlassian/migration/api/MigrationId;", "uploadPreflightLogsToMCS", "path", "uploadPreflightLogsToMCSWithClusterLock", "Companion", "jira-migration-plugin"})
public final class PreflightLogsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationEventBus eventBus;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final MigrationLogsProvider migrationLogsProvider;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final ThreadDumpProvider dumper;
    private static final Logger log = LoggerFactory.getLogger(PreflightLogsService.class);
    @NotNull
    public static final String PREFLIGHT_LOGS_SEND_LOCK = "jcma.preflight.logs.send";

    @Inject
    public PreflightLogsService(@NotNull LocalFileDataOutput localFileDataOutput, @NotNull DiscoveryService discoveryService, @NotNull MigrationEventBus eventBus, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull MigrationLogsProvider migrationLogsProvider, @NotNull PlatformService platformService, @NotNull ThreadDumpProvider dumper) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)migrationLogsProvider, (String)"migrationLogsProvider");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)dumper, (String)"dumper");
        this.localFileDataOutput = localFileDataOutput;
        this.discoveryService = discoveryService;
        this.eventBus = eventBus;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.migrationLogsProvider = migrationLogsProvider;
        this.platformService = platformService;
        this.dumper = dumper;
    }

    @PostConstruct
    public final void postConstruct() {
        this.eventBus.register(this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public final void onPreflightCompletionEvent(@NotNull PreflightCheckCompletionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.discoveryService.isUserAgreedCollectErrors()) {
            log.info("Sharing logs with MCS is disabled. Skipping preflight logs upload.");
            return;
        }
        this.runWithJiraThreadLocalUtil((Function0<Unit>)((Function0)new Function0<Unit>(this, event){
            final /* synthetic */ PreflightLogsService this$0;
            final /* synthetic */ PreflightCheckCompletionEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(0);
            }

            public final void invoke() {
                this.this$0.uploadPreflightLogs(this.$event.getMigrationScopeId(), this.$event.getCloudId(), this.$event.getPreflightCheckExecutionId(), this.$event.getEndInstant(), this.$event.getPreflightId());
            }
        }));
    }

    public final void uploadPreflightLogs(@NotNull String migrationScopeId2, @NotNull String cloudId2, @NotNull String preflightCheckExecutionId, @NotNull Instant time, @Nullable MigrationId preflightId) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
            Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
            Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            Object object2 = this;
            try {
                PreflightLogsService $this$uploadPreflightLogs_u24lambda_u240 = object2;
                boolean bl = false;
                $this$uploadPreflightLogs_u24lambda_u240.dumper.generateThreadDump(preflightCheckExecutionId);
                log.info("Uploading isolated preflight [" + migrationScopeId2 + "] logs zip.");
                Path migrationScopeLogDir = $this$uploadPreflightLogs_u24lambda_u240.createScopeDir(migrationScopeId2);
                String filename = FileNameUtils.makeFilenameCrossPlatformCompatible((String)("preflight-isolated-logs-" + preflightCheckExecutionId + '-' + time + ".zip"));
                Path path = (Path)$this$uploadPreflightLogs_u24lambda_u240.generateMigrationIsolatedLogsZip(migrationScopeLogDir, filename, migrationScopeId2).component2();
                object = Result.constructor-impl((Object)$this$uploadPreflightLogs_u24lambda_u240.uploadPreflightLogsToMCSWithClusterLock(path, filename, cloudId2, migrationScopeId2, preflightId));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            log.warn("Error executing preflight log processing", (Throwable)it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String uploadPreflightLogsToMCSWithClusterLock(Path path, String filename, String cloudId2, String migrationScopeId2, MigrationId preflightId) {
        ClusterLock lock = this.discoveryService.getLockForName(PREFLIGHT_LOGS_SEND_LOCK);
        if (lock.tryLock()) {
            log.debug("Obtained a cluster lock for uploading preflight logs.");
            try {
                String string = this.uploadPreflightLogsToMCS(path, filename, cloudId2, migrationScopeId2, preflightId);
                return string;
            }
            catch (Exception e) {
                log.error("Exception during uploading preflight logs with cluster lock.", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.debug("Failed to obtain a cluster lock for uploading preflight logs.");
        }
        return null;
    }

    private final String uploadPreflightLogsToMCS(Path path, String filename, String cloudId2, String migrationScopeId2, MigrationId preflightId) {
        CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteForCloudId(cloudId2);
        if (cloudSite2 != null) {
            String string;
            String it;
            String string2;
            CloudSite cloudSite3 = cloudSite2;
            boolean bl = false;
            if (preflightId != null) {
                PlatformUploadServiceInterface platformUploadServiceInterface = this.platformService;
                ContainerToken containerToken = new ContainerToken(cloudSite3.getContainerToken());
                File file2 = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                it = string2 = PlatformUploadServiceInterface.DefaultImpls.uploadMultiPart$default(platformUploadServiceInterface, containerToken, preflightId, filename, "preflight-isolated-logs", file2, 0, null, 96, null);
                boolean bl2 = false;
                log.info("File uploaded to MCS fileId: " + it + " by preflightMigrationId " + preflightId);
                string = string2;
            } else {
                PlatformUploadServiceInterface platformUploadServiceInterface = this.platformService;
                ContainerToken containerToken = new ContainerToken(cloudSite3.getContainerToken());
                MigrationScopeId migrationScopeId3 = new MigrationScopeId(migrationScopeId2);
                File file3 = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
                it = string2 = PlatformUploadServiceInterface.DefaultImpls.uploadMultiPartFileByMigrationScopeId$default(platformUploadServiceInterface, containerToken, migrationScopeId3, filename, "preflight-isolated-logs", file3, null, 32, null);
                boolean bl3 = false;
                log.info("File uploaded to MCS fileId: " + it + " by migrationScopeId " + migrationScopeId2);
                string = string2;
            }
            String result2 = string;
            return result2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runWithJiraThreadLocalUtil(Function0<Unit> block) {
        this.jiraThreadLocalUtil.preCall();
        try {
            block.invoke();
        }
        finally {
            this.jiraThreadLocalUtil.postCall(org.apache.log4j.Logger.getLogger(PreflightLogsService.class));
        }
    }

    private final Path createScopeDir(String migrationScopeId2) {
        Path migrationScopeLogDir = this.localFileDataOutput.migrationScopeLogDirectory(migrationScopeId2);
        Files.createDirectories(migrationScopeLogDir, new FileAttribute[0]);
        return migrationScopeLogDir;
    }

    @NotNull
    public final Pair<File, Path> generateMigrationIsolatedLogsZip(@NotNull Path migrationScopeLogDir, @NotNull String filename, @NotNull String migrationScopeId2) {
        Intrinsics.checkNotNullParameter((Object)migrationScopeLogDir, (String)"migrationScopeLogDir");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Path isolatedLogZip = migrationScopeLogDir.resolve(filename);
        Intrinsics.checkNotNull((Object)isolatedLogZip);
        return this.migrationLogsProvider.generateMigrationIsolatedLogsZip(isolatedLogZip, migrationScopeId2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/log/PreflightLogsService$Companion;", "", "()V", "PREFLIGHT_LOGS_SEND_LOCK", "", "getPREFLIGHT_LOGS_SEND_LOCK$annotations", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPREFLIGHT_LOGS_SEND_LOCK$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

