/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.log;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.log.ThreadDumpProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.Charset;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/log/ThreadDumpProvider;", "", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "(Lcom/atlassian/jira/config/util/JiraHome;)V", "generateThreadDump", "", "executionId", "", "getDumpFile", "Ljava/io/File;", "fileName", "Companion", "jira-migration-plugin"})
public final class ThreadDumpProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraHome jiraHome;
    private static final Logger logger = LoggerFactory.getLogger(ThreadDumpProvider.class);

    @Inject
    public ThreadDumpProvider(@NotNull JiraHome jiraHome) {
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        this.jiraHome = jiraHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateThreadDump(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        logger.info("Generating thread dump for " + executionId);
        try {
            String fileName = "atlassian-jira-migration-threaddump.tdump";
            File dumpFile = this.getDumpFile(fileName);
            ThreadMXBean threads = ManagementFactory.getThreadMXBean();
            Object object = dumpFile;
            Object object2 = Charsets.UTF_8;
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                OutputStreamWriter writer = (OutputStreamWriter)object;
                boolean bl = false;
                ThreadInfo[] threadInfoArray = threads.dumpAllThreads(threads.isObjectMonitorUsageSupported(), threads.isSynchronizerUsageSupported());
                Intrinsics.checkNotNullExpressionValue((Object)threadInfoArray, (String)"dumpAllThreads(...)");
                writer.write(ArraysKt.joinToString$default((Object[])threadInfoArray, (CharSequence)"\n", null, null, (int)0, null, (Function1)generateThreadDump.1.1.INSTANCE, (int)30, null));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            logger.info("Thread dump saved to " + dumpFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error("Error encountered while trying to write thread dump", (Throwable)e);
        }
    }

    @VisibleForTesting
    @NotNull
    public final File getDumpFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return new File(this.jiraHome.getLogDirectory(), fileName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/log/ThreadDumpProvider$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

