/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.mediaclient;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.context.RequestContextBuilder;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.exceptions.HttpCommunicationException;
import com.atlassian.jira.migration.httpclient.exceptions.HttpProtocolException;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.mediaclient.CreateWithFilesRequest;
import com.atlassian.jira.migration.mediaclient.CreateWithFilesRequestItem;
import com.atlassian.jira.migration.mediaclient.CreateWithFilesResponse;
import com.atlassian.jira.migration.mediaclient.CreateWithFilesResponseItem;
import com.atlassian.jira.migration.mediaclient.ETag;
import com.atlassian.jira.migration.mediaclient.MediaClientErrorException;
import com.atlassian.jira.migration.mediaclient.MediaClientKt;
import com.atlassian.jira.migration.mediaclient.MediaFile;
import com.atlassian.jira.migration.mediaclient.MediaHttpClient;
import com.atlassian.jira.migration.mediaclient.MediaResponse;
import com.atlassian.jira.migration.mediaclient.MediaServerErrorException;
import com.atlassian.jira.migration.mediaclient.MediaTokenSupplier;
import com.atlassian.jira.migration.mediaclient.Upload;
import com.atlassian.jira.migration.migrationservice.MediaToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.UriBuilder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0012J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0015\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cJ)\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H!0%H\u0002\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J,\u0010(\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001cJ&\u0010.\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020+J\u0014\u00103\u001a\u00020#*\u00020#2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/atlassian/jira/migration/mediaclient/MediaClient;", "", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "mediaTokenSupplier", "Lcom/atlassian/jira/migration/mediaclient/MediaTokenSupplier;", "requestContextBuilder", "Lcom/atlassian/jira/migration/context/RequestContextBuilder;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/mediaclient/MediaTokenSupplier;Lcom/atlassian/jira/migration/context/RequestContextBuilder;)V", "httpClient", "Lcom/atlassian/jira/migration/mediaclient/MediaHttpClient;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/mediaclient/MediaHttpClient;Lcom/atlassian/jira/migration/mediaclient/MediaTokenSupplier;Lcom/atlassian/jira/migration/context/RequestContextBuilder;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "userAgentHeader", "", "createFileFromUpload", "Lcom/atlassian/jira/migration/mediaclient/MediaFile;", "containerToken", "upload", "Lcom/atlassian/jira/migration/mediaclient/Upload;", "filename", "fileId", "createUpload", "createUploadWithFiles", "", "Lcom/atlassian/jira/migration/mediaclient/CreateWithFilesResponseItem;", "requestItems", "Lcom/atlassian/jira/migration/mediaclient/CreateWithFilesRequestItem;", "execute", "T", "request", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "responseType", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "getMediaClientId", "updateUpload", "", "offset", "", "chunks", "Lcom/atlassian/jira/migration/mediaclient/ETag;", "uploadChunk", "data", "", "uploadId", "index", "withDefaultHeaders", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMediaClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaClient.kt\ncom/atlassian/jira/migration/mediaclient/MediaClient\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,235:1\n51#2:236\n51#2:237\n51#2:238\n51#2:239\n51#2:240\n*S KotlinDebug\n*F\n+ 1 MediaClient.kt\ncom/atlassian/jira/migration/mediaclient/MediaClient\n*L\n103#1:236\n123#1:237\n141#1:238\n158#1:239\n179#1:240\n*E\n"})
public final class MediaClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log;
    @NotNull
    private final MediaHttpClient httpClient;
    @NotNull
    private final MediaTokenSupplier mediaTokenSupplier;
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    private final String userAgentHeader;
    @NotNull
    public static final String UPLOAD_ID = "uploadId";
    @NotNull
    public static final String PART_NUMBER = "partNumber";
    @NotNull
    public static final String CREATE_UPTO = "createUpTo";
    @NotNull
    public static final String REPLACE_FILE_ID = "replaceFileId";
    @NotNull
    public static final String HASH_ALGORITHM_KEY = "hashAlgorithm";
    @NotNull
    public static final String HASH_ALGORITHM = "sha256";

    @Inject
    public MediaClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull MediaTokenSupplier mediaTokenSupplier, @NotNull RequestContextBuilder requestContextBuilder) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)mediaTokenSupplier, (String)"mediaTokenSupplier");
        Intrinsics.checkNotNullParameter((Object)requestContextBuilder, (String)"requestContextBuilder");
        this(migrationServicesConfiguration, new MediaHttpClient(objectMapperFactory.createObjectMapper()), mediaTokenSupplier, requestContextBuilder);
    }

    @VisibleForTesting
    public MediaClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MediaHttpClient httpClient, @NotNull MediaTokenSupplier mediaTokenSupplier, @NotNull RequestContextBuilder requestContextBuilder) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)mediaTokenSupplier, (String)"mediaTokenSupplier");
        Intrinsics.checkNotNullParameter((Object)requestContextBuilder, (String)"requestContextBuilder");
        this.log = LoggerFactory.getLogger(MediaClient.class);
        URI mediaBaseURI = migrationServicesConfiguration.getMediaURI();
        this.httpClient = httpClient;
        this.mediaTokenSupplier = mediaTokenSupplier;
        this.userAgentHeader = requestContextBuilder.getUserAgent();
        this.migrationServicesConfiguration = migrationServicesConfiguration;
        this.log.info("media base url: " + mediaBaseURI);
    }

    @NotNull
    public final Upload createUpload(@NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Object[] objectArray = new Object[]{1};
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.migrationServicesConfiguration.getMediaURI()).path("/upload").queryParam(CREATE_UPTO, objectArray);
        objectArray = new Object[]{HASH_ALGORITHM};
        URI uRI = uriBuilder.queryParam(HASH_ALGORITHM_KEY, objectArray).build(new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
        boolean $i$f$jacksonTypeRef = false;
        return (Upload)ArraysKt.single((Object[])((Object[])((MediaResponse)this.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", uRI, SetsKt.setOf((Object)201), null, null, null, 56, null), containerToken), (TypeReference)new TypeReference<MediaResponse<Upload[]>>(){})).getData()));
    }

    @NotNull
    public final List<CreateWithFilesResponseItem> createUploadWithFiles(@NotNull String containerToken, @NotNull List<CreateWithFilesRequestItem> requestItems) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter(requestItems, (String)"requestItems");
        Object[] objectArray = new Object[]{HASH_ALGORITHM};
        URI uRI = UriBuilder.fromUri((URI)this.migrationServicesConfiguration.getMediaURI()).path("/upload/createWithFiles").queryParam(HASH_ALGORITHM_KEY, objectArray).build(new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
        boolean $i$f$jacksonTypeRef = false;
        return ((CreateWithFilesResponse)((MediaResponse)this.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", uRI, SetsKt.setOf((Object)201), new CreateWithFilesRequest(requestItems), null, null, 48, null).contentTypeJson(), containerToken), (TypeReference)new TypeReference<MediaResponse<CreateWithFilesResponse>>(){})).getData()).getCreated();
    }

    @NotNull
    public final ETag uploadChunk(@NotNull String containerToken, @NotNull byte[] data2, @NotNull String uploadId, int index) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)UPLOAD_ID);
        ETag etag = new ETag(MediaClientKt.access$sha256Hex(data2), data2.length);
        Object object = new Object[]{uploadId};
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.migrationServicesConfiguration.getMediaURI()).path("/chunk/{etag}").queryParam(UPLOAD_ID, object);
        object = new Object[]{index};
        UriBuilder uriBuilder2 = uriBuilder.queryParam(PART_NUMBER, object);
        object = new Object[]{etag};
        URI uRI = uriBuilder2.build(object);
        Object[] objectArray = new Integer[]{200, 201};
        object = SetsKt.setOf((Object[])objectArray);
        Intrinsics.checkNotNull((Object)uRI);
        boolean $i$f$jacksonTypeRef = false;
        this.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("PUT", uRI, (Set)object, data2, null, null, 48, null).contentTypeOctetStream(), containerToken), (TypeReference)new TypeReference<Void>(){});
        return etag;
    }

    public final void updateUpload(@NotNull String containerToken, @NotNull Upload upload, int offset, @NotNull List<ETag> chunks) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)upload, (String)"upload");
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        Object object = new Object[]{upload.getId()};
        URI uRI = UriBuilder.fromUri((URI)this.migrationServicesConfiguration.getMediaURI()).path("/upload/{uploadId}/chunks").build(object);
        Object object2 = new Pair[]{TuplesKt.to((Object)"offset", (Object)offset), TuplesKt.to((Object)"chunks", chunks)};
        object = MapsKt.mapOf((Pair[])object2);
        Object[] objectArray = new Integer[]{200, 409};
        object2 = SetsKt.setOf((Object[])objectArray);
        Intrinsics.checkNotNull((Object)uRI);
        boolean $i$f$jacksonTypeRef = false;
        this.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("PUT", uRI, (Set)object2, object, null, null, 48, null).contentTypeJson(), containerToken), (TypeReference)new TypeReference<Void>(){});
    }

    @NotNull
    public final MediaFile createFileFromUpload(@NotNull String containerToken, @NotNull Upload upload, @Nullable String filename, @Nullable String fileId) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)upload, (String)"upload");
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.migrationServicesConfiguration.getMediaURI()).path("/file/upload");
        String string = fileId;
        if (string != null) {
            String it = string;
            boolean bl = false;
            Object[] objectArray = new Object[]{it};
            uriBuilder.queryParam(REPLACE_FILE_ID, objectArray);
        }
        URI uRI = uriBuilder.build(new Object[0]);
        Object object = new Pair[]{TuplesKt.to((Object)UPLOAD_ID, (Object)upload.getId()), TuplesKt.to((Object)"name", (Object)filename)};
        Map map = MapsKt.mapOf((Pair[])object);
        object = SetsKt.setOf((Object)201);
        Intrinsics.checkNotNull((Object)uRI);
        boolean $i$f$jacksonTypeRef = false;
        return (MediaFile)((MediaResponse)this.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", uRI, (Set)object, map, null, null, 48, null).contentTypeJson(), containerToken), (TypeReference)new TypeReference<MediaResponse<MediaFile>>(){})).getData();
    }

    public static /* synthetic */ MediaFile createFileFromUpload$default(MediaClient mediaClient, String string, Upload upload, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        return mediaClient.createFileFromUpload(string, upload, string2, string3);
    }

    @NotNull
    public final String getMediaClientId(@NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        return this.mediaTokenSupplier.getMediaToken(containerToken).getClientId();
    }

    private final MigrationPluginHttpRequest withDefaultHeaders(MigrationPluginHttpRequest $this$withDefaultHeaders, String containerToken) {
        this.log.debug("requesting: " + $this$withDefaultHeaders.getUri());
        MediaToken mediaToken = this.mediaTokenSupplier.getMediaToken(containerToken);
        String mediaClientId = mediaToken.component1();
        String mediaToken2 = mediaToken.component2();
        return $this$withDefaultHeaders.acceptsJson().addHeader("X-Client-Id", mediaClientId).addUserAgent(this.userAgentHeader).authorization("Bearer " + mediaToken2);
    }

    private final <T> T execute(MigrationPluginHttpRequest request, TypeReference<T> responseType) {
        try {
            return this.httpClient.execute(request, responseType);
        }
        catch (UnexpectedStatusCodeException e) {
            if (e.getStatusCode() >= 500) {
                throw new MediaServerErrorException("request to Media failed", e);
            }
            throw new MediaClientErrorException("request to Media failed", e);
        }
        catch (HttpProtocolException e) {
            throw new MediaClientErrorException("protocol violation error", e);
        }
        catch (HttpCommunicationException e) {
            throw new MediaServerErrorException("failed to send a request to Media", e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/mediaclient/MediaClient$Companion;", "", "()V", "CREATE_UPTO", "", "HASH_ALGORITHM", "HASH_ALGORITHM_KEY", "PART_NUMBER", "REPLACE_FILE_ID", "UPLOAD_ID", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

