/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.mediaclient;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.mediaclient.MediaServerErrorException;
import com.atlassian.jira.migration.mediaclient.MediaTokenSupplierKt;
import com.atlassian.jira.migration.migrationservice.MediaToken;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.platform.EnterpriseGatewayClient;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0010J\u0012\u0010\u0017\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0007R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/mediaclient/MediaTokenSupplier;", "", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "enterpriseGatewayClient", "Lcom/atlassian/jira/migration/platform/EnterpriseGatewayClient;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/platform/EnterpriseGatewayClient;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "ticker", "Lcom/google/common/base/Ticker;", "(Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/platform/EnterpriseGatewayClient;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/google/common/base/Ticker;)V", "cache", "Lcom/google/common/cache/LoadingCache;", "", "Lcom/atlassian/jira/migration/migrationservice/MediaToken;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getMediaToken", "containerToken", "getMediaTokenImpl", "jira-migration-plugin"})
public final class MediaTokenSupplier {
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final EnterpriseGatewayClient enterpriseGatewayClient;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private final Logger log;
    @NotNull
    private final LoadingCache<String, MediaToken> cache;

    public MediaTokenSupplier(@NotNull MigrationServiceClient migrationServiceClient, @NotNull EnterpriseGatewayClient enterpriseGatewayClient, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull Ticker ticker) {
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)enterpriseGatewayClient, (String)"enterpriseGatewayClient");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        this.migrationServiceClient = migrationServiceClient;
        this.enterpriseGatewayClient = enterpriseGatewayClient;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationFeatures = migrationFeatures;
        this.log = LoggerFactory.getLogger(MediaTokenSupplier.class);
        LoadingCache loadingCache = CacheBuilder.newBuilder().ticker(ticker).expireAfterWrite(MediaTokenSupplierKt.access$getDEFAULT_TOKEN_TTL$p().toMillis(), TimeUnit.MILLISECONDS).build(CacheLoader.from(this::getMediaTokenImpl));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.cache = loadingCache;
    }

    @Inject
    public MediaTokenSupplier(@NotNull MigrationServiceClient migrationServiceClient, @NotNull EnterpriseGatewayClient enterpriseGatewayClient, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)enterpriseGatewayClient, (String)"enterpriseGatewayClient");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Ticker ticker = Ticker.systemTicker();
        Intrinsics.checkNotNullExpressionValue((Object)ticker, (String)"systemTicker(...)");
        this(migrationServiceClient, enterpriseGatewayClient, cloudSiteRepository, migrationFeatures, ticker);
    }

    @NotNull
    public final MediaToken getMediaToken(@NotNull String containerToken) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        try {
            object = this.cache.get((Object)containerToken);
            Intrinsics.checkNotNull((Object)object);
            object = (MediaToken)object;
        }
        catch (UncheckedExecutionException e) {
            this.log.warn("Failed to request Media token", (Throwable)e);
            Throwable throwable = e.getCause();
            Intrinsics.checkNotNull((Object)throwable);
            throw new MediaServerErrorException("Failed to request Media token", throwable);
        }
        return object;
    }

    @VisibleForTesting
    @NotNull
    public final MediaToken getMediaTokenImpl(@Nullable String containerToken) {
        MediaToken mediaToken;
        if (this.migrationFeatures.getProxyMediaTokenRequestsViaMs()) {
            this.log.info("Requesting mediaToken via MS");
            mediaToken = this.migrationServiceClient.requestMediaToken(containerToken);
        } else {
            MediaToken mediaToken2;
            try {
                CloudSite cloudSite2 = this.cloudSiteRepository.getSiteByContainerToken(containerToken);
                if (cloudSite2 == null) {
                    throw new Exception("Unable to determine cloudId for container token " + containerToken);
                }
                CloudSite cloudSite3 = cloudSite2;
                mediaToken2 = this.enterpriseGatewayClient.requestMediaToken(containerToken, cloudSite3.getCloudId());
            }
            catch (Exception e) {
                this.log.warn("Failed to request mediaToken via EG, requesting via MS", (Throwable)e);
                mediaToken2 = this.migrationServiceClient.requestMediaToken(containerToken);
            }
            mediaToken = mediaToken2;
        }
        return mediaToken;
    }
}

