/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.metadataaggregator;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.common.ObjectMapperFactoryKt;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.metadataaggregator.MetadataAggregatorHttpClient;
import com.atlassian.jira.migration.metadataaggregator.apimodels.AppMetadataRequest;
import com.atlassian.jira.migration.metadataaggregator.apimodels.AppMetadataResponseItem;
import com.atlassian.jira.migration.metadataaggregator.apimodels.MetadataRefreshStateRequest;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ProjectMetadata;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ProjectMetadataRequest;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ProjectMetadataResponseItem;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ServerInstanceCreateRequest;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ServerInstanceResponseItem;
import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u001e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ&\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fJ$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J&\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cJ$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#J$\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'J\u0014\u0010(\u001a\u00020)*\u00020)2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/atlassian/jira/migration/metadataaggregator/MigrationMetadataAggregatorClient;", "", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "(Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;)V", "httpClient", "Lcom/atlassian/jira/migration/metadataaggregator/MetadataAggregatorHttpClient;", "(Lcom/atlassian/jira/migration/metadataaggregator/MetadataAggregatorHttpClient;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;)V", "deleteAppMetadata", "", "containerToken", "", "cloudId", "serverId", "deleteProjectMetadata", "deleteProjectMetadataForSingleEntity", "projectId", "sendAppMetadata", "", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/AppMetadataResponseItem;", "appMetadataRequest", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/AppMetadataRequest;", "sendMetadataRefreshStatus", "metadataRefreshStateRequest", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/MetadataRefreshStateRequest;", "sendProjectMetadata", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/ProjectMetadataResponseItem;", "projectMetadataRequest", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/ProjectMetadataRequest;", "sendProjectMetadataForSingleEntity", "projectMetadata", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/ProjectMetadata;", "sendServerInstanceMetadata", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/ServerInstanceResponseItem;", "serverInstanceCreateRequest", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/ServerInstanceCreateRequest;", "withDefaultMetadataRequestHeaders", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationMetadataAggregatorClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationMetadataAggregatorClient.kt\ncom/atlassian/jira/migration/metadataaggregator/MigrationMetadataAggregatorClient\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,222:1\n26#2:223\n26#2:224\n26#2:225\n26#2:226\n26#2:227\n26#2:228\n26#2:229\n26#2:230\n*S KotlinDebug\n*F\n+ 1 MigrationMetadataAggregatorClient.kt\ncom/atlassian/jira/migration/metadataaggregator/MigrationMetadataAggregatorClient\n*L\n59#1:223\n80#1:224\n98#1:225\n117#1:226\n136#1:227\n157#1:228\n177#1:229\n196#1:230\n*E\n"})
public final class MigrationMetadataAggregatorClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetadataAggregatorHttpClient httpClient;
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    public static final String MIGRATION_METADATA_AGGREGATOR_BASE_URI = "/migrations/metadata/v1";
    @NotNull
    public static final String SERVER_METADATA_PATH = "/server";
    @NotNull
    public static final String PROJECT_METADATA_PATH = "/projects";
    @NotNull
    public static final String APP_METADATA_PATH = "/apps";
    @NotNull
    public static final String SINGLE_ENTITY_DELETE_PATH = "/cloudSite/%s/server/%s/jira/project/%s";
    @NotNull
    public static final String SINGLE_PROJECT_METADATA_PATH = "/migrations/metadata/v1/cloudSite/%s/server/%s/jira/project";
    @NotNull
    public static final String REFRESH_STATE_PATH = "/cloudSite/%s/server/%s/refreshstate";

    @VisibleForTesting
    public MigrationMetadataAggregatorClient(@NotNull MetadataAggregatorHttpClient httpClient, @NotNull MigrationServicesConfiguration migrationServicesConfiguration) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        this.httpClient = httpClient;
        this.migrationServicesConfiguration = migrationServicesConfiguration;
    }

    @Inject
    public MigrationMetadataAggregatorClient(@NotNull MigrationUserAgentProvider userAgentProvider, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull MigrationServicesConfiguration migrationServicesConfiguration) {
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        this(new MetadataAggregatorHttpClient(userAgentProvider, ObjectMapperFactoryKt.safeEnums(ObjectMapperFactoryKt.handleUnknownFields(objectMapperFactory.createObjectMapper()))), migrationServicesConfiguration);
    }

    @NotNull
    public final List<ServerInstanceResponseItem> sendServerInstanceMetadata(@NotNull String containerToken, @NotNull String cloudId2, @NotNull ServerInstanceCreateRequest serverInstanceCreateRequest) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)serverInstanceCreateRequest, (String)"serverInstanceCreateRequest");
        Set set = SetsKt.setOf((Object)200);
        boolean $i$f$emptyArray = false;
        String[] stringArray = new String[]{};
        URI uRI = AbstractPluginHttpClientKt.buildURI(this.migrationServicesConfiguration.getMigrationAPIBaseURI(), "/migrations/metadata/v1/server", Arrays.copyOf(stringArray, stringArray.length), CollectionsKt.listOf((Object)new Pair((Object)"cloudId", (Object)cloudId2)));
        return (List)this.httpClient.execute(this.withDefaultMetadataRequestHeaders(new MigrationPluginHttpRequest("POST", uRI, set, serverInstanceCreateRequest, null, null, 48, null), containerToken), (TypeReference)new TypeReference<List<? extends ServerInstanceResponseItem>>(){});
    }

    @NotNull
    public final List<ProjectMetadataResponseItem> sendProjectMetadata(@NotNull String containerToken, @NotNull String cloudId2, @NotNull ProjectMetadataRequest projectMetadataRequest) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)projectMetadataRequest, (String)"projectMetadataRequest");
        Set set = SetsKt.setOf((Object)200);
        boolean $i$f$emptyArray = false;
        String[] stringArray = new String[]{};
        URI uRI = AbstractPluginHttpClientKt.buildURI(this.migrationServicesConfiguration.getMigrationAPIBaseURI(), "/migrations/metadata/v1/projects", Arrays.copyOf(stringArray, stringArray.length), CollectionsKt.listOf((Object)new Pair((Object)"cloudId", (Object)cloudId2)));
        return (List)this.httpClient.execute(this.withDefaultMetadataRequestHeaders(new MigrationPluginHttpRequest("POST", uRI, set, projectMetadataRequest, null, null, 48, null), containerToken), (TypeReference)new TypeReference<List<? extends ProjectMetadataResponseItem>>(){});
    }

    public final void sendProjectMetadataForSingleEntity(@NotNull String containerToken, @NotNull ProjectMetadata projectMetadata) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)projectMetadata, (String)"projectMetadata");
        Set set = SetsKt.setOf((Object)200);
        URI uRI = this.migrationServicesConfiguration.getMigrationAPIBaseURI();
        String string = SINGLE_PROJECT_METADATA_PATH;
        Object[] objectArray = new Object[]{projectMetadata.getCloudId(), projectMetadata.getServerId()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        boolean $i$f$emptyArray = false;
        String[] stringArray = new String[]{};
        URI uRI2 = AbstractPluginHttpClientKt.buildURI$default(uRI, string2, Arrays.copyOf(stringArray, stringArray.length), null, 8, null);
        this.httpClient.execute(this.withDefaultMetadataRequestHeaders(new MigrationPluginHttpRequest("POST", uRI2, set, projectMetadata, null, null, 48, null), containerToken));
    }

    public final void deleteProjectMetadata(@NotNull String containerToken, @NotNull String cloudId2, @NotNull String serverId) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        Set set = SetsKt.setOf((Object)200);
        boolean $i$f$emptyArray = false;
        Object[] objectArray = new String[]{};
        objectArray = new Pair[]{new Pair((Object)"serverId", (Object)serverId), new Pair((Object)"cloudId", (Object)cloudId2)};
        URI uRI = AbstractPluginHttpClientKt.buildURI(this.migrationServicesConfiguration.getMigrationAPIBaseURI(), "/migrations/metadata/v1/projects", Arrays.copyOf(objectArray, objectArray.length), CollectionsKt.listOf((Object[])objectArray));
        this.httpClient.execute(this.withDefaultMetadataRequestHeaders(new MigrationPluginHttpRequest("DELETE", uRI, set, null, null, null, 56, null), containerToken));
    }

    @NotNull
    public final List<AppMetadataResponseItem> sendAppMetadata(@NotNull String containerToken, @NotNull String cloudId2, @NotNull AppMetadataRequest appMetadataRequest) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)appMetadataRequest, (String)"appMetadataRequest");
        Set set = SetsKt.setOf((Object)200);
        boolean $i$f$emptyArray = false;
        String[] stringArray = new String[]{};
        URI uRI = AbstractPluginHttpClientKt.buildURI(this.migrationServicesConfiguration.getMigrationAPIBaseURI(), "/migrations/metadata/v1/apps", Arrays.copyOf(stringArray, stringArray.length), CollectionsKt.listOf((Object)new Pair((Object)"cloudId", (Object)cloudId2)));
        return (List)this.httpClient.execute(this.withDefaultMetadataRequestHeaders(new MigrationPluginHttpRequest("POST", uRI, set, appMetadataRequest, null, null, 48, null), containerToken), (TypeReference)new TypeReference<List<? extends AppMetadataResponseItem>>(){});
    }

    public final void deleteAppMetadata(@NotNull String containerToken, @NotNull String cloudId2, @NotNull String serverId) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        Set set = SetsKt.setOf((Object)200);
        boolean $i$f$emptyArray = false;
        Object[] objectArray = new String[]{};
        objectArray = new Pair[]{new Pair((Object)"serverId", (Object)serverId), new Pair((Object)"cloudId", (Object)cloudId2)};
        URI uRI = AbstractPluginHttpClientKt.buildURI(this.migrationServicesConfiguration.getMigrationAPIBaseURI(), "/migrations/metadata/v1/apps", Arrays.copyOf(objectArray, objectArray.length), CollectionsKt.listOf((Object[])objectArray));
        this.httpClient.execute(this.withDefaultMetadataRequestHeaders(new MigrationPluginHttpRequest("DELETE", uRI, set, null, null, null, 56, null), containerToken));
    }

    public final void deleteProjectMetadataForSingleEntity(@NotNull String containerToken, @NotNull String cloudId2, @NotNull String serverId, @NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Set set = SetsKt.setOf((Object)200);
        URI uRI = this.migrationServicesConfiguration.getMigrationAPIBaseURI();
        StringBuilder stringBuilder = new StringBuilder().append(MIGRATION_METADATA_AGGREGATOR_BASE_URI);
        String string = SINGLE_ENTITY_DELETE_PATH;
        Object[] objectArray = new Object[]{cloudId2, serverId, projectId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        boolean $i$f$emptyArray = false;
        String[] stringArray = new String[]{};
        URI uRI2 = AbstractPluginHttpClientKt.buildURI$default(uRI, stringBuilder.append(string2).toString(), Arrays.copyOf(stringArray, stringArray.length), null, 8, null);
        this.httpClient.execute(this.withDefaultMetadataRequestHeaders(new MigrationPluginHttpRequest("DELETE", uRI2, set, null, null, null, 56, null), containerToken));
    }

    public final void sendMetadataRefreshStatus(@NotNull String containerToken, @NotNull String cloudId2, @NotNull String serverId, @NotNull MetadataRefreshStateRequest metadataRefreshStateRequest) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        Intrinsics.checkNotNullParameter((Object)metadataRefreshStateRequest, (String)"metadataRefreshStateRequest");
        Set set = SetsKt.setOf((Object)200);
        URI uRI = this.migrationServicesConfiguration.getMigrationAPIBaseURI();
        StringBuilder stringBuilder = new StringBuilder().append(MIGRATION_METADATA_AGGREGATOR_BASE_URI);
        String string = REFRESH_STATE_PATH;
        Object[] objectArray = new Object[]{cloudId2, serverId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        boolean $i$f$emptyArray = false;
        String[] stringArray = new String[]{};
        URI uRI2 = AbstractPluginHttpClientKt.buildURI$default(uRI, stringBuilder.append(string2).toString(), Arrays.copyOf(stringArray, stringArray.length), null, 8, null);
        this.httpClient.execute(this.withDefaultMetadataRequestHeaders(new MigrationPluginHttpRequest("POST", uRI2, set, metadataRefreshStateRequest, null, null, 48, null), containerToken));
    }

    private final MigrationPluginHttpRequest withDefaultMetadataRequestHeaders(MigrationPluginHttpRequest $this$withDefaultMetadataRequestHeaders, String containerToken) {
        MigrationPluginHttpRequest migrationPluginHttpRequest;
        MigrationPluginHttpRequest $this$withDefaultMetadataRequestHeaders_u24lambda_u240 = migrationPluginHttpRequest = $this$withDefaultMetadataRequestHeaders;
        boolean bl = false;
        $this$withDefaultMetadataRequestHeaders_u24lambda_u240.authorization("Bearer " + containerToken);
        $this$withDefaultMetadataRequestHeaders_u24lambda_u240.contentTypeJson();
        $this$withDefaultMetadataRequestHeaders_u24lambda_u240.acceptsJson();
        return migrationPluginHttpRequest;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/metadataaggregator/MigrationMetadataAggregatorClient$Companion;", "", "()V", "APP_METADATA_PATH", "", "MIGRATION_METADATA_AGGREGATOR_BASE_URI", "PROJECT_METADATA_PATH", "REFRESH_STATE_PATH", "SERVER_METADATA_PATH", "SINGLE_ENTITY_DELETE_PATH", "SINGLE_PROJECT_METADATA_PATH", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

