/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.metadataaggregator;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ProjectCreatedEvent;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.ProjectUpdatedEvent;
import com.atlassian.jira.migration.api.metadataaggregator.MetadataAggregatorService;
import com.atlassian.jira.migration.assessment.AppAssessmentService;
import com.atlassian.jira.migration.assessment.AppAssessmentStatus;
import com.atlassian.jira.migration.assessment.AppSummary;
import com.atlassian.jira.migration.common.PluginAccessorExtensionsKt;
import com.atlassian.jira.migration.containerToken.ContainerTokenValidator;
import com.atlassian.jira.migration.events.AppAssessmentUpdatedEvent;
import com.atlassian.jira.migration.export.db.advancedroadmaps.PlanDataReader;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.metadataaggregator.MMAResponseContainsErrorException;
import com.atlassian.jira.migration.metadataaggregator.MetadataAggregatorAnalyticService;
import com.atlassian.jira.migration.metadataaggregator.MetadataThreadFactory;
import com.atlassian.jira.migration.metadataaggregator.MigrationMetadataAggregatorClient;
import com.atlassian.jira.migration.metadataaggregator.MigrationMetadataAggregatorServiceKt;
import com.atlassian.jira.migration.metadataaggregator.apimodels.AppMetadata;
import com.atlassian.jira.migration.metadataaggregator.apimodels.AppMetadataRequest;
import com.atlassian.jira.migration.metadataaggregator.apimodels.MetadataEntityResult;
import com.atlassian.jira.migration.metadataaggregator.apimodels.MetadataEntityType;
import com.atlassian.jira.migration.metadataaggregator.apimodels.MetadataRefreshStateRequest;
import com.atlassian.jira.migration.metadataaggregator.apimodels.MetadataRefreshStatus;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ProjectMetadata;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ProjectMetadataRequest;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ProjectMetadataResponseItem;
import com.atlassian.jira.migration.metadataaggregator.apimodels.RetryCMAState;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ServerInstanceCreateRequest;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ServerInstanceMetadata;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ServerInstanceResponseItem;
import com.atlassian.jira.migration.metadataaggregator.providers.JiraServerMetadataProvider;
import com.atlassian.jira.migration.metadataaggregator.providers.ProjectMetadataProvider;
import com.atlassian.jira.migration.serverdataextractors.JiraServerStatsReader;
import com.atlassian.jira.migration.serverdataextractors.RelatedEntitiesDataReader;
import com.atlassian.jira.migration.serverdataextractors.ServerProjectDto;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.plugin.PluginAccessor;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 `2\u00020\u0001:\u0001`Bo\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cBw\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007J,\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0'2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002JD\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u00100\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020'2\f\u00103\u001a\b\u0012\u0004\u0012\u00020204H\u0002J\u0010\u00105\u001a\u0002062\u0006\u0010+\u001a\u00020,H\u0002J\b\u00107\u001a\u00020#H\u0007J\b\u00108\u001a\u00020#H\u0016J \u00108\u001a\u00020#2\u0006\u00109\u001a\u00020,2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J\b\u0010:\u001a\u00020#H\u0016J \u0010:\u001a\u00020#2\u0006\u00109\u001a\u00020,2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0007J\u0018\u0010;\u001a\u00020<2\u0006\u00109\u001a\u00020,2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010=\u001a\u00020#H\u0016J \u0010>\u001a\u00020?2\u0006\u00109\u001a\u00020,2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J&\u0010@\u001a\u00020#2\u0006\u00109\u001a\u00020,2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010A\u001a\u00020,J \u0010B\u001a\u00020?2\u0006\u00109\u001a\u00020,2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0007J\u000e\u0010C\u001a\u00020#2\u0006\u0010$\u001a\u00020DJ\u000e\u0010E\u001a\u00020#2\u0006\u0010$\u001a\u00020FJ\u000e\u0010G\u001a\u00020#2\u0006\u0010$\u001a\u00020HJ\b\u0010I\u001a\u00020#H\u0007J\u0018\u0010J\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010K\u001a\u00020LH\u0002J4\u0010J\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020O0M2\u0006\u0010+\u001a\u00020,2\u0006\u0010P\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010K\u001a\u00020LH\u0002J\u0010\u0010Q\u001a\u00020#2\u0006\u0010$\u001a\u00020DH\u0007J\u0010\u0010R\u001a\u00020#2\u0006\u0010$\u001a\u00020FH\u0007J\u0010\u0010S\u001a\u00020#2\u0006\u0010$\u001a\u00020HH\u0007J\u0010\u0010T\u001a\u00020#2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010T\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010K\u001a\u00020LH\u0016J*\u0010U\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020O0V2\u0006\u0010W\u001a\u00020N2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020#0YH\u0002J&\u0010Z\u001a\u00020#2\u0006\u00109\u001a\u00020,2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010+\u001a\u00020,H\u0002J(\u0010\\\u001a\u00020#2\u0006\u0010]\u001a\u00020 2\u0006\u00109\u001a\u00020,2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J4\u0010^\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u00109\u001a\u00020,2\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020O0MH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/atlassian/jira/migration/metadataaggregator/MigrationMetadataAggregatorService;", "Lcom/atlassian/jira/migration/api/metadataaggregator/MetadataAggregatorService;", "jiraServerMetadataProvider", "Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;", "projectMetadataProvider", "Lcom/atlassian/jira/migration/metadataaggregator/providers/ProjectMetadataProvider;", "migrationMetadataAggregatorClient", "Lcom/atlassian/jira/migration/metadataaggregator/MigrationMetadataAggregatorClient;", "containerTokenValidator", "Lcom/atlassian/jira/migration/containerToken/ContainerTokenValidator;", "metadataAggregatorAnalyticService", "Lcom/atlassian/jira/migration/metadataaggregator/MetadataAggregatorAnalyticService;", "appAssessmentService", "Lcom/atlassian/jira/migration/assessment/AppAssessmentService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "jiraServerStatsReader", "Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;", "planDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader;", "relatedEntitiesDataReader", "Lcom/atlassian/jira/migration/serverdataextractors/RelatedEntitiesDataReader;", "threadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "(Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;Lcom/atlassian/jira/migration/metadataaggregator/providers/ProjectMetadataProvider;Lcom/atlassian/jira/migration/metadataaggregator/MigrationMetadataAggregatorClient;Lcom/atlassian/jira/migration/containerToken/ContainerTokenValidator;Lcom/atlassian/jira/migration/metadataaggregator/MetadataAggregatorAnalyticService;Lcom/atlassian/jira/migration/assessment/AppAssessmentService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader;Lcom/atlassian/jira/migration/serverdataextractors/RelatedEntitiesDataReader;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/plugin/PluginAccessor;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "batchSize", "", "(Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;Lcom/atlassian/jira/migration/metadataaggregator/providers/ProjectMetadataProvider;Lcom/atlassian/jira/migration/metadataaggregator/MigrationMetadataAggregatorClient;Lcom/atlassian/jira/migration/containerToken/ContainerTokenValidator;Lcom/atlassian/jira/migration/metadataaggregator/MetadataAggregatorAnalyticService;Lcom/atlassian/jira/migration/assessment/AppAssessmentService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader;Lcom/atlassian/jira/migration/serverdataextractors/RelatedEntitiesDataReader;Ljava/util/concurrent/ExecutorService;Lcom/atlassian/plugin/PluginAccessor;I)V", "appAssessmentEventHandler", "", "event", "Lcom/atlassian/jira/migration/events/AppAssessmentUpdatedEvent;", "buildAppMetadata", "", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/AppMetadata;", "appSummaries", "Lcom/atlassian/jira/migration/assessment/AppSummary;", "cloudId", "", "serverId", "buildProjectMetadata", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/ProjectMetadataRequest;", "startIndex", "projectsFromPlans", "", "projectsWithCrossProjectBoardsOrFilters", "", "buildServerInstanceMetadata", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/ServerInstanceMetadata;", "cleanup", "createAppMetadataInMMA", "containerToken", "createProjectMetadataInMMA", "createServerInstanceCloudSitePairInMMA", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/MetadataRefreshStatus;", "createServerMetadataInMMA", "deleteAppMetadata", "", "deleteMetadataInMMAForSingleEntity", "projectId", "deleteProjectMetadata", "handleProjectCreationEvent", "Lcom/atlassian/jira/event/ProjectCreatedEvent;", "handleProjectDeletionEvent", "Lcom/atlassian/jira/event/ProjectDeletedEvent;", "handleProjectUpdatedEvent", "Lcom/atlassian/jira/event/ProjectUpdatedEvent;", "init", "performMetadataRefresh", "retryCMAState", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/RetryCMAState;", "", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/MetadataEntityType;", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/MetadataEntityResult;", "validToken", "projectCreationEventHandler", "projectDeletionEventHandler", "projectUpdateEventHandler", "replaceAllMetadata", "runWithStatus", "Lkotlin/Pair;", "entityType", "action", "Lkotlin/Function0;", "sendAppMetadata", "appMetadata", "sendCompleteProjectMetadata", "totalProjects", "updateMetadataRefreshState", "entityStatuses", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationMetadataAggregatorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationMetadataAggregatorService.kt\ncom/atlassian/jira/migration/metadataaggregator/MigrationMetadataAggregatorService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,650:1\n215#2,2:651\n215#2,2:656\n215#2,2:667\n215#2,2:694\n215#2,2:696\n215#2,2:698\n1747#3,3:653\n1726#3,3:664\n1747#3,3:674\n1855#3,2:683\n1549#3:686\n1620#3,3:687\n1549#3:690\n1620#3,3:691\n17#4,6:658\n17#4,5:669\n22#4:677\n17#4,5:678\n22#4:685\n*S KotlinDebug\n*F\n+ 1 MigrationMetadataAggregatorService.kt\ncom/atlassian/jira/migration/metadataaggregator/MigrationMetadataAggregatorService\n*L\n118#1:651,2\n149#1:656,2\n267#1:667,2\n476#1:694,2\n521#1:696,2\n579#1:698,2\n136#1:653,3\n244#1:664,3\n328#1:674,3\n376#1:683,2\n430#1:686\n430#1:687,3\n447#1:690\n447#1:691,3\n181#1:658,6\n315#1:669,5\n315#1:677\n375#1:678,5\n375#1:685\n*E\n"})
public final class MigrationMetadataAggregatorService
implements MetadataAggregatorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraServerMetadataProvider jiraServerMetadataProvider;
    @NotNull
    private final ProjectMetadataProvider projectMetadataProvider;
    @NotNull
    private final MigrationMetadataAggregatorClient migrationMetadataAggregatorClient;
    @NotNull
    private final ContainerTokenValidator containerTokenValidator;
    @NotNull
    private final MetadataAggregatorAnalyticService metadataAggregatorAnalyticService;
    @NotNull
    private final AppAssessmentService appAssessmentService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final JiraServerStatsReader jiraServerStatsReader;
    @NotNull
    private final PlanDataReader planDataReader;
    @NotNull
    private final RelatedEntitiesDataReader relatedEntitiesDataReader;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final PluginAccessor pluginAccessor;
    private final int batchSize;
    public static final int BATCH_SIZE = 100;
    @NotNull
    private static final Logger log;
    public static final long DEFAULT_TOTAL_ISSUES = 0L;

    @VisibleForTesting
    public MigrationMetadataAggregatorService(@NotNull JiraServerMetadataProvider jiraServerMetadataProvider, @NotNull ProjectMetadataProvider projectMetadataProvider, @NotNull MigrationMetadataAggregatorClient migrationMetadataAggregatorClient, @NotNull ContainerTokenValidator containerTokenValidator, @NotNull MetadataAggregatorAnalyticService metadataAggregatorAnalyticService, @NotNull AppAssessmentService appAssessmentService, @NotNull MigrationFeatures migrationFeatures, @NotNull EventPublisher eventPublisher, @NotNull JiraServerStatsReader jiraServerStatsReader, @NotNull PlanDataReader planDataReader, @NotNull RelatedEntitiesDataReader relatedEntitiesDataReader, @NotNull ExecutorService executorService, @NotNull PluginAccessor pluginAccessor, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)jiraServerMetadataProvider, (String)"jiraServerMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)projectMetadataProvider, (String)"projectMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)migrationMetadataAggregatorClient, (String)"migrationMetadataAggregatorClient");
        Intrinsics.checkNotNullParameter((Object)containerTokenValidator, (String)"containerTokenValidator");
        Intrinsics.checkNotNullParameter((Object)metadataAggregatorAnalyticService, (String)"metadataAggregatorAnalyticService");
        Intrinsics.checkNotNullParameter((Object)appAssessmentService, (String)"appAssessmentService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)jiraServerStatsReader, (String)"jiraServerStatsReader");
        Intrinsics.checkNotNullParameter((Object)planDataReader, (String)"planDataReader");
        Intrinsics.checkNotNullParameter((Object)relatedEntitiesDataReader, (String)"relatedEntitiesDataReader");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        this.jiraServerMetadataProvider = jiraServerMetadataProvider;
        this.projectMetadataProvider = projectMetadataProvider;
        this.migrationMetadataAggregatorClient = migrationMetadataAggregatorClient;
        this.containerTokenValidator = containerTokenValidator;
        this.metadataAggregatorAnalyticService = metadataAggregatorAnalyticService;
        this.appAssessmentService = appAssessmentService;
        this.migrationFeatures = migrationFeatures;
        this.eventPublisher = eventPublisher;
        this.jiraServerStatsReader = jiraServerStatsReader;
        this.planDataReader = planDataReader;
        this.relatedEntitiesDataReader = relatedEntitiesDataReader;
        this.executorService = executorService;
        this.pluginAccessor = pluginAccessor;
        this.batchSize = batchSize;
    }

    @Inject
    public MigrationMetadataAggregatorService(@NotNull JiraServerMetadataProvider jiraServerMetadataProvider, @NotNull ProjectMetadataProvider projectMetadataProvider, @NotNull MigrationMetadataAggregatorClient migrationMetadataAggregatorClient, @NotNull ContainerTokenValidator containerTokenValidator, @NotNull MetadataAggregatorAnalyticService metadataAggregatorAnalyticService, @NotNull AppAssessmentService appAssessmentService, @NotNull MigrationFeatures migrationFeatures, @NotNull EventPublisher eventPublisher, @NotNull JiraServerStatsReader jiraServerStatsReader, @NotNull PlanDataReader planDataReader, @NotNull RelatedEntitiesDataReader relatedEntitiesDataReader, @NotNull JiraThreadLocalUtil threadLocalUtil, @NotNull PluginAccessor pluginAccessor) {
        Intrinsics.checkNotNullParameter((Object)jiraServerMetadataProvider, (String)"jiraServerMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)projectMetadataProvider, (String)"projectMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)migrationMetadataAggregatorClient, (String)"migrationMetadataAggregatorClient");
        Intrinsics.checkNotNullParameter((Object)containerTokenValidator, (String)"containerTokenValidator");
        Intrinsics.checkNotNullParameter((Object)metadataAggregatorAnalyticService, (String)"metadataAggregatorAnalyticService");
        Intrinsics.checkNotNullParameter((Object)appAssessmentService, (String)"appAssessmentService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)jiraServerStatsReader, (String)"jiraServerStatsReader");
        Intrinsics.checkNotNullParameter((Object)planDataReader, (String)"planDataReader");
        Intrinsics.checkNotNullParameter((Object)relatedEntitiesDataReader, (String)"relatedEntitiesDataReader");
        Intrinsics.checkNotNullParameter((Object)threadLocalUtil, (String)"threadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        ExecutorService executorService = Executors.newSingleThreadExecutor(new MetadataThreadFactory("MetadataAggregatorService", log, threadLocalUtil));
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this(jiraServerMetadataProvider, projectMetadataProvider, migrationMetadataAggregatorClient, containerTokenValidator, metadataAggregatorAnalyticService, appAssessmentService, migrationFeatures, eventPublisher, jiraServerStatsReader, planDataReader, relatedEntitiesDataReader, executorService, pluginAccessor, 100);
    }

    @PostConstruct
    public final void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public final void cleanup() {
        this.eventPublisher.unregister((Object)this);
        this.executorService.shutdown();
    }

    @Override
    public void createServerMetadataInMMA() {
        Map<String, String> $this$forEach$iv = this.containerTokenValidator.getCloudIdsWithValidContainerToken();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            String cloudId2 = entry.getKey();
            String containerToken = entry.getValue();
            MetadataRefreshStatus metadataRefreshStatus = this.createServerInstanceCloudSitePairInMMA(containerToken, cloudId2);
            if (metadataRefreshStatus != MetadataRefreshStatus.FAILURE) continue;
            log.error("Failed to send server instance metadata for cloud {}", (Object)cloudId2);
        }
    }

    @Override
    @NotNull
    public MetadataRefreshStatus createServerInstanceCloudSitePairInMMA(@NotNull String containerToken, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        long startTime = System.currentTimeMillis();
        try {
            boolean bl;
            block5: {
                List<ServerInstanceResponseItem> result2 = this.migrationMetadataAggregatorClient.sendServerInstanceMetadata(containerToken, cloudId2, new ServerInstanceCreateRequest(CollectionsKt.listOf((Object)this.buildServerInstanceMetadata(cloudId2))));
                Iterable $this$any$iv = result2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ServerInstanceResponseItem it = (ServerInstanceResponseItem)element$iv;
                        boolean bl2 = false;
                        if (!(!it.getSuccess())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            MMAResponseContainsErrorException exception = bl ? new MMAResponseContainsErrorException("server metadata could not be processed by MMA") : null;
            this.metadataAggregatorAnalyticService.buildAndStoreServerInstanceMetadataEvent(cloudId2, exception, System.currentTimeMillis() - startTime);
            return MetadataRefreshStatus.SUCCESS;
        }
        catch (RuntimeException e) {
            log.warn("Could not send server metadata. ", (Throwable)e);
            this.metadataAggregatorAnalyticService.buildAndStoreServerInstanceMetadataEvent(cloudId2, e, System.currentTimeMillis() - startTime);
            return MetadataRefreshStatus.FAILURE;
        }
    }

    @Override
    public void createProjectMetadataInMMA() {
        if (this.migrationFeatures.isCloudFirstMigrationEnabled()) {
            String serverId = this.jiraServerMetadataProvider.getServerId();
            Map<String, String> $this$forEach$iv = this.containerTokenValidator.getCloudIdsWithValidContainerToken();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator2.next();
                boolean bl = false;
                String cloudId2 = entry.getKey();
                String containerToken = entry.getValue();
                this.createProjectMetadataInMMA(containerToken, cloudId2, serverId);
            }
        }
    }

    private final Pair<MetadataEntityType, MetadataEntityResult> runWithStatus(MetadataEntityType entityType, Function0<Unit> action) {
        Pair pair;
        try {
            action.invoke();
            pair = TuplesKt.to((Object)((Object)entityType), (Object)new MetadataEntityResult(MetadataRefreshStatus.SUCCESS));
        }
        catch (Exception e) {
            log.error("Failed to refresh metadata of type {}.", (Object)entityType, (Object)e);
            pair = TuplesKt.to((Object)((Object)entityType), (Object)new MetadataEntityResult(MetadataRefreshStatus.FAILURE));
        }
        return pair;
    }

    @Override
    public void replaceAllMetadata(@NotNull String cloudId2, @NotNull RetryCMAState retryCMAState) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)retryCMAState, (String)"retryCMAState");
        this.performMetadataRefresh(cloudId2, retryCMAState);
    }

    @Override
    public void replaceAllMetadata(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        this.performMetadataRefresh(cloudId2, RetryCMAState.Companion.createRetryCMAStateForJira());
    }

    private final void performMetadataRefresh(String cloudId2, RetryCMAState retryCMAState) {
        if (this.migrationFeatures.isCloudFirstMigrationEnabled()) {
            String string = this.containerTokenValidator.getValidContainerToken(cloudId2);
            if (string == null) {
                return;
            }
            String validToken = string;
            String serverId = this.jiraServerMetadataProvider.getServerId();
            RuntimeException ex = null;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            try {
                Map<MetadataEntityType, MetadataEntityResult> entityStatuses = this.performMetadataRefresh(cloudId2, validToken, serverId, retryCMAState);
                this.updateMetadataRefreshState(cloudId2, serverId, validToken, entityStatuses);
            }
            catch (RuntimeException e) {
                log.error("Failed to refresh metadata in cloud.", (Throwable)e);
                ex = e;
            }
            long timeTaken2 = System.currentTimeMillis() - start$iv;
            this.metadataAggregatorAnalyticService.buildAndStoreServerMetadataRefreshEvent(cloudId2, timeTaken2, ex);
        }
    }

    private final Map<MetadataEntityType, MetadataEntityResult> performMetadataRefresh(String cloudId2, String validToken, String serverId, RetryCMAState retryCMAState) {
        Pair<MetadataEntityType, MetadataEntityResult> pair;
        Map map;
        Map entityStatuses = new LinkedHashMap();
        if (retryCMAState.getShouldRetryServerInstance()) {
            map = entityStatuses;
            pair = TuplesKt.to((Object)((Object)MetadataEntityType.SERVER_INSTANCE), (Object)new MetadataEntityResult(this.createServerInstanceCloudSitePairInMMA(validToken, cloudId2)));
            map.put(pair.getFirst(), pair.getSecond());
        } else {
            map = entityStatuses;
            pair = TuplesKt.to((Object)((Object)MetadataEntityType.SERVER_INSTANCE), (Object)new MetadataEntityResult(MetadataRefreshStatus.NO_REFRESH_REQUESTED));
            map.put(pair.getFirst(), pair.getSecond());
        }
        map = entityStatuses;
        pair = MigrationMetadataAggregatorService.performMetadataRefresh$getStatus(this, validToken, cloudId2, serverId, retryCMAState.getShouldRetryProjects(), MetadataEntityType.PROJECTS, (Function3<? super String, ? super String, ? super String, Unit>)((Function3)new Function3<String, String, String, Unit>((Object)this){

            public final void invoke(@NotNull String p0, @NotNull String p1, @NotNull String p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                ((MigrationMetadataAggregatorService)this.receiver).createProjectMetadataInMMA(p0, p1, p2);
            }
        }));
        map.put(pair.getFirst(), pair.getSecond());
        map = entityStatuses;
        pair = MigrationMetadataAggregatorService.performMetadataRefresh$getStatus(this, validToken, cloudId2, serverId, retryCMAState.getShouldRetryApps(), MetadataEntityType.APPS, (Function3<? super String, ? super String, ? super String, Unit>)((Function3)new Function3<String, String, String, Unit>((Object)this){

            public final void invoke(@NotNull String p0, @NotNull String p1, @NotNull String p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                MigrationMetadataAggregatorService.access$createAppMetadataInMMA((MigrationMetadataAggregatorService)this.receiver, p0, p1, p2);
            }
        }));
        map.put(pair.getFirst(), pair.getSecond());
        return entityStatuses;
    }

    private final void updateMetadataRefreshState(String cloudId2, String serverId, String containerToken, Map<MetadataEntityType, MetadataEntityResult> entityStatuses) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = entityStatuses.values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    MetadataEntityResult it = (MetadataEntityResult)element$iv;
                    boolean bl2 = false;
                    if (it.getStatus() == MetadataRefreshStatus.SUCCESS || it.getStatus() == MetadataRefreshStatus.NO_REFRESH_REQUESTED) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        MetadataRefreshStatus overallStatus = bl ? MetadataRefreshStatus.SUCCESS : MetadataRefreshStatus.FAILURE;
        this.migrationMetadataAggregatorClient.sendMetadataRefreshStatus(containerToken, cloudId2, serverId, new MetadataRefreshStateRequest(overallStatus, entityStatuses));
    }

    @VisibleForTesting
    public final void createProjectMetadataInMMA(@NotNull String containerToken, @NotNull String cloudId2, @NotNull String serverId) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        int totalProjects = this.projectMetadataProvider.getTotalCountOfProjects();
        if (this.deleteProjectMetadata(containerToken, cloudId2, serverId)) {
            this.sendCompleteProjectMetadata(totalProjects, containerToken, cloudId2, serverId);
        }
    }

    @Override
    public void createAppMetadataInMMA() {
        String serverId = this.jiraServerMetadataProvider.getServerId();
        Map<String, String> $this$forEach$iv = this.containerTokenValidator.getCloudIdsWithValidContainerToken();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            String cloudId2 = entry.getKey();
            String containerToken = entry.getValue();
            this.createAppMetadataInMMA(containerToken, cloudId2, serverId);
        }
    }

    private final void createAppMetadataInMMA(String containerToken, String cloudId2, String serverId) {
        if (this.deleteAppMetadata(containerToken, cloudId2, serverId)) {
            List<AppMetadata> appMetadata = this.buildAppMetadata(this.appAssessmentService.buildAppSummariesWithoutAnalytics(), cloudId2, serverId);
            this.sendAppMetadata(containerToken, appMetadata, cloudId2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final boolean deleteProjectMetadata(@NotNull String containerToken, @NotNull String cloudId2, @NotNull String serverId) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        Exception ex = null;
        long startTime = System.currentTimeMillis();
        try {
            this.migrationMetadataAggregatorClient.deleteProjectMetadata(containerToken, cloudId2, serverId);
        }
        catch (RuntimeException e) {
            ex = e;
            log.warn("Could not delete project metadata for cloudId: {}", (Object)cloudId2);
        }
        finally {
            MetadataAggregatorAnalyticService.buildAndStoreJiraMetadataEvent$default(this.metadataAggregatorAnalyticService, cloudId2, MetadataAggregatorAnalyticService.ActionType.DELETED, MetadataAggregatorAnalyticService.ActionSubject.PROJECTS, System.currentTimeMillis() - startTime, ex, null, 32, null);
        }
        return ex == null;
    }

    private final void sendCompleteProjectMetadata(int totalProjects, String containerToken, String cloudId2, String serverId) {
        List errors = new ArrayList();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        List<Long> projectsWithPlans = PluginAccessorExtensionsKt.hasArjInstalled(this.pluginAccessor) ? this.relatedEntitiesDataReader.getProjectIDsFromPlans(this.planDataReader.getAllAdvancedRoadmapIds()) : Collections.emptyList();
        Set<Long> projectsWithCrossProjectBoardsOrFilters = this.projectMetadataProvider.getProjectsWithCrossProjectBoardsOrFilters();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)totalProjects)), (int)this.batchSize);
        int offset = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && offset <= n || n2 < 0 && n <= offset) {
            while (true) {
                try {
                    boolean bl2;
                    block8: {
                        Intrinsics.checkNotNull(projectsWithPlans);
                        List<ProjectMetadataResponseItem> result2 = this.migrationMetadataAggregatorClient.sendProjectMetadata(containerToken, cloudId2, this.buildProjectMetadata(cloudId2, serverId, offset, this.batchSize, projectsWithPlans, projectsWithCrossProjectBoardsOrFilters));
                        Iterable $this$any$iv = result2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                ProjectMetadataResponseItem it = (ProjectMetadataResponseItem)element$iv;
                                boolean bl3 = false;
                                if (!(!it.getSuccess())) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        errors.add(new MMAResponseContainsErrorException("some projects could not be processed by MMA"));
                    }
                }
                catch (RuntimeException e) {
                    log.warn("could not send project metadata", (Throwable)e);
                    errors.add(e);
                }
                if (offset == n) break;
                offset += n2;
            }
        }
        long runTime = System.currentTimeMillis() - start$iv;
        this.metadataAggregatorAnalyticService.buildAndStoreJiraMetadataEvent(cloudId2, MetadataAggregatorAnalyticService.ActionType.UPDATED, MetadataAggregatorAnalyticService.ActionSubject.PROJECTS, 100, totalProjects, runTime, errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean deleteAppMetadata(String containerToken, String cloudId2, String serverId) {
        Exception ex = null;
        long startTime = System.currentTimeMillis();
        try {
            this.migrationMetadataAggregatorClient.deleteAppMetadata(containerToken, cloudId2, serverId);
        }
        catch (RuntimeException e) {
            ex = e;
            log.warn("Could not delete app metadata for cloudId: {}", (Object)cloudId2);
        }
        finally {
            MetadataAggregatorAnalyticService.buildAndStoreJiraMetadataEvent$default(this.metadataAggregatorAnalyticService, cloudId2, MetadataAggregatorAnalyticService.ActionType.DELETED, MetadataAggregatorAnalyticService.ActionSubject.APPS, System.currentTimeMillis() - startTime, ex, null, 32, null);
        }
        return ex == null;
    }

    private final void sendAppMetadata(String containerToken, List<AppMetadata> appMetadata, String cloudId2) {
        List errors = new ArrayList();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)appMetadata, (int)this.batchSize);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List metadataBatch = (List)element$iv;
            boolean bl2 = false;
            try {
                this.migrationMetadataAggregatorClient.sendAppMetadata(containerToken, cloudId2, new AppMetadataRequest(metadataBatch));
            }
            catch (RuntimeException e) {
                log.warn("could not send project metadata", (Throwable)e);
                errors.add(e);
            }
        }
        long runTime = System.currentTimeMillis() - start$iv;
        this.metadataAggregatorAnalyticService.buildAndStoreJiraMetadataEvent(cloudId2, MetadataAggregatorAnalyticService.ActionType.UPDATED, MetadataAggregatorAnalyticService.ActionSubject.APPS, 100, appMetadata.size(), runTime, errors);
    }

    private final ServerInstanceMetadata buildServerInstanceMetadata(String cloudId2) {
        return new ServerInstanceMetadata(this.jiraServerMetadataProvider.getServerId(), cloudId2, this.jiraServerMetadataProvider.getSen(), this.jiraServerMetadataProvider.getProductKey(), this.jiraServerMetadataProvider.getProductVersion(), this.jiraServerMetadataProvider.getJcmaVersion(), this.jiraServerMetadataProvider.getOrganisationName(), null, this.jiraServerMetadataProvider.getServerBaseUrl(), this.jiraServerMetadataProvider.getUserCount(), this.jiraServerMetadataProvider.getLicenseDetails(), PluginAccessorExtensionsKt.hasArjInstalled(this.pluginAccessor) ? this.jiraServerMetadataProvider.getTotalAdvancedRoadmapPlansCount() : 0L, this.jiraServerMetadataProvider.getDashboardsCount());
    }

    /*
     * WARNING - void declaration
     */
    private final ProjectMetadataRequest buildProjectMetadata(String cloudId2, String serverId, int startIndex, int batchSize, List<Long> projectsFromPlans, Set<Long> projectsWithCrossProjectBoardsOrFilters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.projectMetadataProvider.getProjects(startIndex, batchSize);
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServerProjectDto serverProjectDto = (ServerProjectDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            it.getId();
            collection.add(MigrationMetadataAggregatorServiceKt.toProjectMetadata((ServerProjectDto)it, cloudId2, serverId, projectsFromPlans.contains(it.getId()), projectsWithCrossProjectBoardsOrFilters.contains(it.getId())));
        }
        List list = (List)destination$iv$iv;
        return new ProjectMetadataRequest(list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AppMetadata> buildAppMetadata(List<AppSummary> appSummaries, String cloudId2, String serverId) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = appSummaries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void appSummary;
            AppSummary appSummary2 = (AppSummary)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AppMetadata(serverId, cloudId2, "jira-server", appSummary.getName(), appSummary.getKey(), appSummary.getMigrationStatus() == AppAssessmentStatus.Needed, appSummary.getPreloadable()));
        }
        return (List)destination$iv$iv;
    }

    @EventListener
    public final void projectDeletionEventHandler(@NotNull ProjectDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.migrationFeatures.isCloudFirstMigrationEnabled()) {
            return;
        }
        try {
            this.executorService.submit(() -> MigrationMetadataAggregatorService.projectDeletionEventHandler$lambda$12(this, event));
        }
        catch (Exception e) {
            log.warn("Could not delete project metadata in MMA for project {}: {}", (Object)event.getProject().getId(), (Object)e.getMessage());
        }
    }

    public final void handleProjectDeletionEvent(@NotNull ProjectDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String projectId = String.valueOf(event.getId());
        Map<String, String> $this$forEach$iv = this.containerTokenValidator.getCloudIdsWithValidContainerToken();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            String cloudId2 = entry.getKey();
            String containerToken = entry.getValue();
            this.deleteMetadataInMMAForSingleEntity(containerToken, cloudId2, this.jiraServerMetadataProvider.getServerId(), projectId);
        }
    }

    public final void deleteMetadataInMMAForSingleEntity(@NotNull String containerToken, @NotNull String cloudId2, @NotNull String serverId, @NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        try {
            this.migrationMetadataAggregatorClient.deleteProjectMetadataForSingleEntity(containerToken, cloudId2, serverId, projectId);
        }
        catch (RuntimeException e) {
            log.warn("Could not delete project metadata for cloudId: {}", (Object)cloudId2);
        }
    }

    @EventListener
    public final void projectCreationEventHandler(@NotNull ProjectCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.migrationFeatures.isCloudFirstMigrationEnabled()) {
            return;
        }
        try {
            this.executorService.submit(() -> MigrationMetadataAggregatorService.projectCreationEventHandler$lambda$14(this, event));
        }
        catch (Exception e) {
            log.warn("Could not create project metadata in MMA for project {}: {}", (Object)event.getProject().getId(), (Object)e.getMessage());
        }
    }

    @EventListener
    public final void appAssessmentEventHandler(@NotNull AppAssessmentUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.migrationFeatures.isCloudFirstMigrationEnabled()) {
            return;
        }
        try {
            this.executorService.submit(() -> MigrationMetadataAggregatorService.appAssessmentEventHandler$lambda$15(this));
        }
        catch (Exception e) {
            log.warn("Could not update app assessments in MMA for project {}", (Object)e.getMessage());
        }
    }

    public final void handleProjectCreationEvent(@NotNull ProjectCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        long startTime = System.currentTimeMillis();
        Map<String, String> $this$forEach$iv = this.containerTokenValidator.getCloudIdsWithValidContainerToken();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            String cloudId2 = entry.getKey();
            String containerToken = entry.getValue();
            String string = this.jiraServerMetadataProvider.getServerId();
            Long l = event.getProject().getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            long l2 = ((Number)l).longValue();
            String string2 = event.getProject().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
            String string3 = event.getProject().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            Instant instant = Instant.now();
            long l3 = JiraServerStatsReader.estimatedMigrationTimeSeconds$default(this.jiraServerStatsReader, 0L, null, 0L, 0L, false, 30, null);
            String string4 = event.getProject().getProjectTypeKey().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getKey(...)");
            ProjectMetadata projectMetadata = new ProjectMetadata(string, cloudId2, l2, string2, string3, 0L, instant, 0L, 0L, l3, string4, null, event.getProject().getLeadUserKey(), event.getProject().isArchived(), false, false, 384, null);
            Exception ex = null;
            try {
                this.migrationMetadataAggregatorClient.sendProjectMetadataForSingleEntity(containerToken, projectMetadata);
            }
            catch (RuntimeException e) {
                log.warn("could not send project metadata", (Throwable)e);
                ex = e;
            }
            this.metadataAggregatorAnalyticService.buildAndStoreJiraMetadataEvent(cloudId2, MetadataAggregatorAnalyticService.ActionType.CREATED, MetadataAggregatorAnalyticService.ActionSubject.PROJECTS, System.currentTimeMillis() - startTime, ex, 1);
        }
    }

    @EventListener
    public final void projectUpdateEventHandler(@NotNull ProjectUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.migrationFeatures.isCloudFirstMigrationEnabled()) {
            try {
                this.executorService.submit(() -> MigrationMetadataAggregatorService.projectUpdateEventHandler$lambda$17(this, event));
            }
            catch (Exception e) {
                log.warn("Could not update project metadata in MMA for project {}: {}", (Object)event.getProject().getId(), (Object)e.getMessage());
            }
        }
    }

    public final void handleProjectUpdatedEvent(@NotNull ProjectUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getOldProject().getName(), (Object)event.getProject().getName())) {
            boolean hasAdvancedRoadmapRelation = PluginAccessorExtensionsKt.hasArjInstalled(this.pluginAccessor) ? this.relatedEntitiesDataReader.getProjectIDsFromPlans(this.planDataReader.getAllAdvancedRoadmapIds()).contains(event.getProject().getId()) : false;
            String string = event.getOldProject().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            boolean hasCrossProjectBoardsOrFilters = this.projectMetadataProvider.doesProjectHaveCrossProjectBoardsOrFilters(string);
            String string2 = event.getOldProject().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
            ServerProjectDto serverProjectDto = this.projectMetadataProvider.getSingleProjectMetadata(string2);
            if (serverProjectDto == null) {
                serverProjectDto = this.jiraServerStatsReader.computeProjectStats(event.getProject().getId()).get(0);
            }
            ServerProjectDto metadataToSend = serverProjectDto;
            Map<String, String> $this$forEach$iv = this.containerTokenValidator.getCloudIdsWithValidContainerToken();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator2.next();
                boolean bl = false;
                String cloudId2 = entry.getKey();
                String containerToken = entry.getValue();
                long startTime = System.currentTimeMillis();
                String string3 = this.jiraServerMetadataProvider.getServerId();
                Long l = event.getProject().getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                long l2 = ((Number)l).longValue();
                String string4 = event.getProject().getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getKey(...)");
                String string5 = event.getProject().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                long l3 = metadataToSend.getTotalIssues();
                Instant instant = Instant.now();
                long l4 = metadataToSend.getAttachments().getTotalSizeBytes();
                long l5 = metadataToSend.getAttachments().getTotalAttachments();
                long l6 = metadataToSend.getMigrationEstimateSeconds();
                String string6 = event.getProject().getProjectTypeKey().getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getKey(...)");
                ProjectMetadata metadataToSendMMA = new ProjectMetadata(string3, cloudId2, l2, string4, string5, l3, instant, l4, l5, l6, string6, metadataToSend.getCategory(), event.getProject().getLeadUserKey(), event.getProject().isArchived(), hasAdvancedRoadmapRelation, hasCrossProjectBoardsOrFilters);
                Exception ex = null;
                try {
                    this.migrationMetadataAggregatorClient.sendProjectMetadataForSingleEntity(containerToken, metadataToSendMMA);
                }
                catch (RuntimeException e) {
                    log.warn("could not send project metadata", (Throwable)e);
                    ex = e;
                }
                this.metadataAggregatorAnalyticService.buildAndStoreJiraMetadataEvent(cloudId2, MetadataAggregatorAnalyticService.ActionType.UPDATED, MetadataAggregatorAnalyticService.ActionSubject.PROJECTS, System.currentTimeMillis() - startTime, ex, 1);
            }
        }
    }

    private static final Pair<MetadataEntityType, MetadataEntityResult> performMetadataRefresh$getStatus(MigrationMetadataAggregatorService this$0, String $validToken, String $cloudId, String $serverId, boolean shouldRetry, MetadataEntityType metadataEntityType, Function3<? super String, ? super String, ? super String, Unit> action) {
        return shouldRetry ? this$0.runWithStatus(metadataEntityType, (Function0<Unit>)((Function0)new Function0<Unit>(action, $validToken, $cloudId, $serverId){
            final /* synthetic */ Function3<String, String, String, Unit> $action;
            final /* synthetic */ String $validToken;
            final /* synthetic */ String $cloudId;
            final /* synthetic */ String $serverId;
            {
                this.$action = $action;
                this.$validToken = $validToken;
                this.$cloudId = $cloudId;
                this.$serverId = $serverId;
                super(0);
            }

            public final void invoke() {
                this.$action.invoke((Object)this.$validToken, (Object)this.$cloudId, (Object)this.$serverId);
            }
        })) : TuplesKt.to((Object)((Object)metadataEntityType), (Object)new MetadataEntityResult(MetadataRefreshStatus.NO_REFRESH_REQUESTED));
    }

    private static final void projectDeletionEventHandler$lambda$12(MigrationMetadataAggregatorService this$0, ProjectDeletedEvent $event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        this$0.handleProjectDeletionEvent($event);
    }

    private static final void projectCreationEventHandler$lambda$14(MigrationMetadataAggregatorService this$0, ProjectCreatedEvent $event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        this$0.handleProjectCreationEvent($event);
    }

    private static final void appAssessmentEventHandler$lambda$15(MigrationMetadataAggregatorService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.createAppMetadataInMMA();
    }

    private static final void projectUpdateEventHandler$lambda$17(MigrationMetadataAggregatorService this$0, ProjectUpdatedEvent $event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        this$0.handleProjectUpdatedEvent($event);
    }

    public static final /* synthetic */ void access$createAppMetadataInMMA(MigrationMetadataAggregatorService $this, String containerToken, String cloudId2, String serverId) {
        $this.createAppMetadataInMMA(containerToken, cloudId2, serverId);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(MigrationMetadataAggregatorService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/metadataaggregator/MigrationMetadataAggregatorService$Companion;", "", "()V", "BATCH_SIZE", "", "DEFAULT_TOTAL_ISSUES", "", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

