/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.metadataaggregator.providers;

import com.atlassian.jira.migration.export.db.advancedroadmaps.PlanDataReader;
import com.atlassian.jira.migration.metadataaggregator.apimodels.ProductLicense;
import com.atlassian.jira.migration.metadataaggregator.providers.JiraServerMetadataProvider;
import com.atlassian.jira.migration.sen.JiraLicenseInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.serverdataextractors.JiraServerStatsReader;
import com.atlassian.jira.migration.version.JiraMigrationVersionService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.license.LicenseHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u001b\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u0019J\u0006\u0010\u001e\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0019J\u0006\u0010 \u001a\u00020\u0019J\u0006\u0010!\u001a\u00020\u0017J\u0006\u0010\"\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;", "", "jiraMigrationVersionService", "Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;", "jiraApplicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "jiraConfigApplicationProperties", "Lcom/atlassian/jira/config/properties/ApplicationProperties;", "licenceHandler", "Lcom/atlassian/sal/api/license/LicenseHandler;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "jiraServerStatsReader", "Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;", "planDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader;", "(Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;Lcom/atlassian/sal/api/ApplicationProperties;Lcom/atlassian/jira/config/properties/ApplicationProperties;Lcom/atlassian/sal/api/license/LicenseHandler;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader;)V", "convertToProductLicense", "", "Lcom/atlassian/jira/migration/metadataaggregator/apimodels/ProductLicense;", "jiraLicenseInfo", "Lcom/atlassian/jira/migration/sen/JiraLicenseInfo;", "getDashboardsCount", "", "getJcmaVersion", "", "getLicenseDetails", "getOrganisationName", "getProductKey", "getProductVersion", "getSen", "getServerBaseUrl", "getServerId", "getTotalAdvancedRoadmapPlansCount", "getUserCount", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJiraServerMetadataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraServerMetadataProvider.kt\ncom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n766#2:59\n857#2,2:60\n*S KotlinDebug\n*F\n+ 1 JiraServerMetadataProvider.kt\ncom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider\n*L\n51#1:59\n51#1:60,2\n*E\n"})
public final class JiraServerMetadataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraMigrationVersionService jiraMigrationVersionService;
    @NotNull
    private final ApplicationProperties jiraApplicationProperties;
    @NotNull
    private final com.atlassian.jira.config.properties.ApplicationProperties jiraConfigApplicationProperties;
    @NotNull
    private final LicenseHandler licenceHandler;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final JiraServerStatsReader jiraServerStatsReader;
    @NotNull
    private final PlanDataReader planDataReader;
    @NotNull
    public static final String JIRA_SERVER_PRODUCT_KEY = "jira-server";

    @Inject
    public JiraServerMetadataProvider(@NotNull JiraMigrationVersionService jiraMigrationVersionService, @NotNull ApplicationProperties jiraApplicationProperties, @NotNull com.atlassian.jira.config.properties.ApplicationProperties jiraConfigApplicationProperties, @NotNull LicenseHandler licenceHandler, @NotNull SENSupplier senSupplier, @NotNull JiraServerStatsReader jiraServerStatsReader, @NotNull PlanDataReader planDataReader) {
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Intrinsics.checkNotNullParameter((Object)jiraApplicationProperties, (String)"jiraApplicationProperties");
        Intrinsics.checkNotNullParameter((Object)jiraConfigApplicationProperties, (String)"jiraConfigApplicationProperties");
        Intrinsics.checkNotNullParameter((Object)licenceHandler, (String)"licenceHandler");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)jiraServerStatsReader, (String)"jiraServerStatsReader");
        Intrinsics.checkNotNullParameter((Object)planDataReader, (String)"planDataReader");
        this.jiraMigrationVersionService = jiraMigrationVersionService;
        this.jiraApplicationProperties = jiraApplicationProperties;
        this.jiraConfigApplicationProperties = jiraConfigApplicationProperties;
        this.licenceHandler = licenceHandler;
        this.senSupplier = senSupplier;
        this.jiraServerStatsReader = jiraServerStatsReader;
        this.planDataReader = planDataReader;
    }

    @NotNull
    public final String getServerId() {
        String string = this.jiraConfigApplicationProperties.getText("com.atlassian.analytics.client.configuration.serverid");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final String getSen() {
        return String.valueOf(this.senSupplier.getFirstSen());
    }

    @NotNull
    public final String getProductKey() {
        return JIRA_SERVER_PRODUCT_KEY;
    }

    @NotNull
    public final String getOrganisationName() {
        String string = this.licenceHandler.getAllProductLicenses().stream().map(arg_0 -> JiraServerMetadataProvider.getOrganisationName$lambda$0(getOrganisationName.1.INSTANCE, arg_0)).findAny().get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return string;
    }

    @NotNull
    public final String getServerBaseUrl() {
        String string = this.jiraApplicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseUrl(...)");
        return string;
    }

    @NotNull
    public final String getProductVersion() {
        String string = this.jiraApplicationProperties.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
        return string;
    }

    @NotNull
    public final String getJcmaVersion() {
        return this.jiraMigrationVersionService.getPluginVersion();
    }

    public final long getUserCount() {
        return JiraServerStatsReader.getAllUsersCount$default(this.jiraServerStatsReader, null, 1, null);
    }

    @NotNull
    public final List<ProductLicense> getLicenseDetails() {
        return this.convertToProductLicense(this.senSupplier.getLicenses());
    }

    public final long getDashboardsCount() {
        return this.jiraServerStatsReader.calculateNumberOfPortalPage();
    }

    public final long getTotalAdvancedRoadmapPlansCount() {
        return this.planDataReader.totalPlansCount();
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProductLicense> convertToProductLicense(JiraLicenseInfo jiraLicenseInfo) {
        void $this$filterTo$iv$iv;
        Object[] objectArray = new ProductLicense[3];
        String string = "jira-core";
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        objectArray[0] = new ProductLicense(string2, jiraLicenseInfo.getJiraCoreLicense());
        string = "jira-servicedesk";
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
        String string3 = string.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        objectArray[1] = new ProductLicense(string3, jiraLicenseInfo.getJiraServicedeskLicense());
        string = "jira-software";
        Locale locale3 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
        String string4 = string.toUpperCase(locale3);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
        objectArray[2] = new ProductLicense(string4, jiraLicenseInfo.getJiraSoftwareLicense());
        Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProductLicense it = (ProductLicense)element$iv$iv;
            boolean bl = false;
            if (!(it.getCount() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final String getOrganisationName$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider$Companion;", "", "()V", "JIRA_SERVER_PRODUCT_KEY", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

