/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.metadataaggregator.providers;

import com.atlassian.jira.migration.export.core.filter.service.jql.FilterJqlService;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.preflight.CrossProjectEntityMissingProjectSelectionService;
import com.atlassian.jira.migration.serverdataextractors.ServerDataAggregator;
import com.atlassian.jira.migration.serverdataextractors.ServerProjectDto;
import com.atlassian.jira.migration.serverdataextractors.SortOptions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\tJ%\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\u0011J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/metadataaggregator/providers/ProjectMetadataProvider;", "", "serverDataAggregator", "Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;", "cpEntitySelectionService", "Lcom/atlassian/jira/migration/preflight/CrossProjectEntityMissingProjectSelectionService;", "(Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;Lcom/atlassian/jira/migration/preflight/CrossProjectEntityMissingProjectSelectionService;)V", "crossBoardProjectFilterCache", "Lcom/google/common/cache/LoadingCache;", "", "", "doesProjectHaveCrossProjectBoardsOrFilters", "projectKey", "getProjects", "", "Lcom/atlassian/jira/migration/serverdataextractors/ServerProjectDto;", "offset", "", "limit", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/util/List;", "getProjectsWithCrossProjectBoardsOrFilters", "", "", "getSingleProjectMetadata", "getTotalCountOfProjects", "loadProjectHasCrossProjectBoardOrFilters", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectMetadataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectMetadataProvider.kt\ncom/atlassian/jira/migration/metadataaggregator/providers/ProjectMetadataProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1655#2,8:97\n1360#2:105\n1446#2,5:106\n*S KotlinDebug\n*F\n+ 1 ProjectMetadataProvider.kt\ncom/atlassian/jira/migration/metadataaggregator/providers/ProjectMetadataProvider\n*L\n71#1:97,8\n72#1:105\n72#1:106,5\n*E\n"})
public final class ProjectMetadataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerDataAggregator serverDataAggregator;
    @NotNull
    private final CrossProjectEntityMissingProjectSelectionService cpEntitySelectionService;
    @NotNull
    private final LoadingCache<String, Boolean> crossBoardProjectFilterCache;
    private static final long CACHE_TTL = 24L;
    @NotNull
    private static final TimeUnit CACHE_TTL_UNIT = TimeUnit.HOURS;

    @Inject
    public ProjectMetadataProvider(@NotNull ServerDataAggregator serverDataAggregator, @NotNull CrossProjectEntityMissingProjectSelectionService cpEntitySelectionService) {
        Intrinsics.checkNotNullParameter((Object)serverDataAggregator, (String)"serverDataAggregator");
        Intrinsics.checkNotNullParameter((Object)cpEntitySelectionService, (String)"cpEntitySelectionService");
        this.serverDataAggregator = serverDataAggregator;
        this.cpEntitySelectionService = cpEntitySelectionService;
        LoadingCache loadingCache = CacheBuilder.newBuilder().expireAfterWrite(24L, CACHE_TTL_UNIT).build((CacheLoader)new CacheLoader<String, Boolean>(this){
            final /* synthetic */ ProjectMetadataProvider this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Boolean load(@NotNull String projectKey) {
                Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
                return ProjectMetadataProvider.access$loadProjectHasCrossProjectBoardOrFilters(this.this$0, projectKey);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.crossBoardProjectFilterCache = loadingCache;
    }

    public final int getTotalCountOfProjects() {
        return ServerDataAggregator.getServerStats$default(this.serverDataAggregator, null, null, 3, null).getTotalProjects();
    }

    @NotNull
    public final List<ServerProjectDto> getProjects(@Nullable Integer offset, @Nullable Integer limit) {
        return ServerDataAggregator.searchProjects$default(this.serverDataAggregator, null, offset, limit, new SortOptions(null, null), null, null, null, 64, null).getProjects();
    }

    @Nullable
    public final ServerProjectDto getSingleProjectMetadata(@NotNull String projectKey) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        List<ServerProjectDto> serverProjectDto = this.serverDataAggregator.getProjects(CollectionsKt.listOf((Object)projectKey));
        if (serverProjectDto.isEmpty()) {
            return null;
        }
        return serverProjectDto.get(0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Long> getProjectsWithCrossProjectBoardsOrFilters() {
        void $this$flatMapTo$iv$iv;
        Set<FilterJqlService.JqlProjectReferenceInfo> crossProjectEntities = this.cpEntitySelectionService.getProjectRefInfoSetFromEligibleCrossProjectBoardsAndFilters(CrossProjectBoardAndFiltersMigrationMode.ALL, CollectionsKt.emptyList());
        Iterable $this$distinctBy$iv = crossProjectEntities;
        boolean $i$f$distinctBy = false;
        Iterable<Long> set$iv = new HashSet();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            FilterJqlService.JqlProjectReferenceInfo it = (FilterJqlService.JqlProjectReferenceInfo)e$iv;
            boolean bl = false;
            Long key$iv = it.getFilter().getId();
            if (!((HashSet)set$iv).add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Iterable $this$flatMap$iv = list$iv;
        boolean $i$f$flatMap = false;
        set$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FilterJqlService.JqlProjectReferenceInfo it = (FilterJqlService.JqlProjectReferenceInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getReferringProjectIds();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final boolean doesProjectHaveCrossProjectBoardsOrFilters(@NotNull String projectKey) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Object object = this.crossBoardProjectFilterCache.get((Object)projectKey);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final boolean loadProjectHasCrossProjectBoardOrFilters(String projectKey) {
        Set<FilterJqlService.JqlProjectReferenceInfo> cpMetadata = this.cpEntitySelectionService.getProjectRefInfoSetFromEligibleCrossProjectBoardsAndFilters(CrossProjectBoardAndFiltersMigrationMode.SELECTED_PROJECTS, CollectionsKt.listOf((Object)projectKey));
        return !((Collection)cpMetadata).isEmpty();
    }

    public static final /* synthetic */ boolean access$loadProjectHasCrossProjectBoardOrFilters(ProjectMetadataProvider $this, String projectKey) {
        return $this.loadProjectHasCrossProjectBoardOrFilters(projectKey);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/metadataaggregator/providers/ProjectMetadataProvider$Companion;", "", "()V", "CACHE_TTL", "", "CACHE_TTL_UNIT", "Ljava/util/concurrent/TimeUnit;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

